/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbLinksHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.StringRenderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.AlphanumComparator;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportObjectsDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportObjectsDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportObjectsDialog.class);
    private static final String TABLE_ID = "AgencyExportObjectsDialog.Table";
    private final Map<Long, Map<Long, TableRow>> exportEntries = new HashMap<Long, Map<Long, TableRow>>();
    private final Map<Long, ExportSetting> exportSettings = new HashMap<Long, ExportSetting>();
    private long currentExportId = 0L;
    private AbstractDbDriver dbDriver = null;
    private DbAgencyExtension dbExtension = null;
    private DbUser dbUser = null;
    private File tempDir = null;
    private JPanel mainPanel;
    private Table table;
    private JScrollPane tableScroller;
    private JXBusyLabel loadDialogLabel;
    private JComboBox<DbAgencyExport> exportField;
    private JToggleButton selectAllButton;
    private SubmitAction submitAction;
    private CancelAction cancelAction;
    private AbstractI18nAction helpAction;

    private AgencyExportObjectsDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(frame);
    }

    private AgencyExportObjectsDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.cancelAction = new CancelAction();
        this.helpAction = this.createDefaultHelpAction();
        this.selectAllButton = new JToggleButton((Action)((Object)new SelectAllAction()));
        this.exportField = new JComboBox();
        this.exportField.setRenderer((ListCellRenderer<DbAgencyExport>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<DbAgencyExport>(){

            public void render(DbAgencyExport dbAgencyExport, JLabel jLabel) {
                if (dbAgencyExport != null) {
                    jLabel.setText(StringUtils.abbreviate((String)dbAgencyExport.name, (int)50));
                } else {
                    jLabel.setText("???");
                }
            }
        }));
        this.exportField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyExportObjectsDialog.this.exportField.isEnabled()) {
                    return;
                }
                AgencyExportObjectsDialog.this.showSelectedExport();
            }
        });
        buttonBarBuilder.addFixed(this.exportField);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.selectAllButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.submitAction)));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.cancelAction)));
    }

    protected JComponent buildMainComponent() {
        this.loadDialogLabel = new JXBusyLabel();
        this.loadDialogLabel.setOpaque(false);
        this.loadDialogLabel.setBusy(false);
        this.loadDialogLabel.setVisible(false);
        this.table = new Table();
        this.tableScroller = this.table.createScrollPane();
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.mainPanel.add((Component)this.loadDialogLabel, "North");
        this.mainPanel.add((Component)this.tableScroller, "Center");
        return this.mainPanel;
    }

    private void doSelectAll() {
        boolean bl = this.selectAllButton.isSelected();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            ExportStatus exportStatus = this.table.getStatusAt(i);
            if (ExportStatus.IS_NOT_EDITABLE.equals((Object)exportStatus)) continue;
            this.table.setActionAt(i, bl ? ExportAction.EXPORT_ENABLED : ExportAction.EXPORT_DISABLED);
        }
    }

    private void doSubmit() {
        this.saveCurrentModifications();
        this.submitAction.setEnabled(false);
        this.cancelAction.setEnabled(false);
        this.selectAllButton.setEnabled(false);
        this.tableScroller.setVisible(false);
        this.loadDialogLabel.setBusy(true);
        this.loadDialogLabel.setVisible(true);
        this.loadDialogLabel.setText(I18N.tr("Saving modifications into database."));
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask());
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("manage exportable properties"));
    }

    protected Icon getHeaderIcon() {
        return AgencyPlugin.getResourceIcon("agent_estates.png", 32);
    }

    protected String getHeaderTitle() {
        DbAgencyExport dbAgencyExport = this.exportField != null ? (DbAgencyExport)this.exportField.getSelectedItem() : null;
        return dbAgencyExport == null ? StringUtils.capitalize((String)I18N.tr("exportable properties")) : StringUtils.capitalize((String)I18N.tr("exportable properties for {0}", (Object)StringUtils.abbreviate((String)dbAgencyExport.name, (int)30)));
    }

    private void load(long l, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser, File file) {
        this.currentExportId = 0L;
        this.exportEntries.clear();
        this.exportSettings.clear();
        this.dbDriver = abstractDbDriver;
        this.dbExtension = dbAgencyExtension;
        this.dbUser = dbUser;
        this.tempDir = new File(file, "export-objects");
        this.loadDialogLabel.setBusy(true);
        this.loadDialogLabel.setVisible(true);
        this.loadDialogLabel.setText(I18N.tr("Loading interfaces."));
        this.submitAction.setEnabled(false);
        this.exportField.removeAllItems();
        this.exportField.setEnabled(false);
        this.tableScroller.setVisible(false);
        this.selectAllButton.setEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new LoadInBackgroundTask(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EstateImpl lookupObject(long l, Connection connection, Map<Long, String> map, Map<Long, DbGeo> map2) throws IOException, DocumentException, SQLException {
        DbAgencyObjectsHandler dbAgencyObjectsHandler = this.dbExtension.getObjectsHandler();
        DbFilesHandler dbFilesHandler = this.dbExtension.getFilesHandler();
        DbLinksHandler dbLinksHandler = this.dbExtension.getLinksHandler();
        DbGeoHandler dbGeoHandler = this.dbExtension.getGeoHandler();
        Class<AgencyExportObjectsDialog> clazz = AgencyExportObjectsDialog.class;
        synchronized (AgencyExportObjectsDialog.class) {
            Object object;
            File file = new File(this.tempDir, l + ".xml");
            if (file.isFile()) {
                if (file.length() < 1L) {
                    // ** MonitorExit[var10_9] (shouldn't be in output)
                    return null;
                }
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    Document document = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
                    EstateImpl estateImpl = new EstateImpl(document);
                    // ** MonitorExit[var10_9] (shouldn't be in output)
                    return estateImpl;
                }
            }
            DbAgencyObject dbAgencyObject = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, l);
            if (dbAgencyObject == null) {
                FileUtils.touch((File)file);
                // ** MonitorExit[var10_9] (shouldn't be in output)
                return null;
            }
            dbAgencyObjectsHandler.loadObjectAttribs(connection, dbAgencyObject, map);
            dbAgencyObjectsHandler.loadObjectTranslations(connection, dbAgencyObject, map);
            dbAgencyObjectsHandler.loadObjectExportIds(connection, dbAgencyObject);
            dbAgencyObjectsHandler.loadObjectGeoDbAreas(connection, dbAgencyObject, dbGeoHandler);
            dbAgencyObject.writeGeoDbAreasIntoCustomValues(map2);
            FileWriterWithEncoding fileWriterWithEncoding = dbFilesHandler.getFiles(connection, dbAgencyObject.id, null, null);
            dbFilesHandler.loadFileTranslations(connection, (DbFile[])fileWriterWithEncoding, map);
            for (DbFile dbFile : fileWriterWithEncoding) {
                EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
                estateAttachmentImpl.setFile(StringUtils.trimToNull((String)dbFile.name));
                estateAttachmentImpl.setHash(StringUtils.trimToNull((String)dbFile.hash));
                estateAttachmentImpl.setMimeType(StringUtils.trimToNull((String)dbFile.mimeType));
                estateAttachmentImpl.setPublished(Boolean.valueOf(dbFile.published));
                estateAttachmentImpl.setType(dbFile.type);
                if (dbFile.translations != null && !dbFile.translations.isEmpty()) {
                    for (Map.Entry entry : dbFile.translations.entrySet()) {
                        String string = (String)entry.getKey();
                        object = (DbFile.Translation)entry.getValue();
                        if (StringUtils.isBlank((CharSequence)object.title)) continue;
                        estateAttachmentImpl.setTitle(object.title, string);
                    }
                }
                dbAgencyObject.item.getAttachments().add(estateAttachmentImpl);
            }
            FileWriterWithEncoding fileWriterWithEncoding2 = dbLinksHandler.getLinks(connection, dbAgencyObject.id, null, null);
            dbLinksHandler.loadLinkTranslations(connection, (DbLink[])fileWriterWithEncoding2, map);
            for (EstateAttachmentImpl estateAttachmentImpl : fileWriterWithEncoding2) {
                EstateLinkImpl estateLinkImpl = new EstateLinkImpl();
                estateLinkImpl.setPublished(Boolean.valueOf(estateAttachmentImpl.published));
                if (estateAttachmentImpl.webLinkUrl != null) {
                    estateLinkImpl.setWebLink(estateAttachmentImpl.webLinkUrl);
                } else if (estateAttachmentImpl.provider != null && estateAttachmentImpl.providerLinkId != null) {
                    estateLinkImpl.setProviderLink(new EstateLinkImpl.ProviderLink(estateAttachmentImpl.providerLinkId, estateAttachmentImpl.provider));
                }
                if (estateAttachmentImpl.translations != null && !estateAttachmentImpl.translations.isEmpty()) {
                    for (Map.Entry entry : estateAttachmentImpl.translations.entrySet()) {
                        object = (String)entry.getKey();
                        DbLink.Translation translation = (DbLink.Translation)entry.getValue();
                        if (StringUtils.isBlank((CharSequence)translation.title)) continue;
                        estateAttachmentImpl.setTitle(translation.title, (String)object);
                    }
                }
                dbAgencyObject.item.getLinks().add(estateLinkImpl);
            }
            try (FileWriterWithEncoding fileWriterWithEncoding3 = new FileWriterWithEncoding(file, "UTF-8");){
                OpenEstateUtils.serializeToXML((SerializableXmlElement)dbAgencyObject.item, (Writer)fileWriterWithEncoding3, (boolean)true, (String)"UTF-8");
            }
            if (!this.exportSettings.containsKey(l)) {
                boolean bl = AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT) && dbAgencyObject.permission.canWrite(this.dbUser, dbAgencyObject.ownerUserId, dbAgencyObject.ownerGroupId);
                this.exportSettings.put(l, new ExportSetting(l, bl, dbAgencyObject.exportIds, dbAgencyObject.exportMode));
            }
            // ** MonitorExit[var10_9] (shouldn't be in output)
            return dbAgencyObject.item;
        }
    }

    private void saveCurrentModifications() {
        if (this.currentExportId > 0L) {
            if (!this.exportEntries.containsKey(this.currentExportId)) {
                this.exportEntries.put(this.currentExportId, new HashMap());
            }
            Map<Long, TableRow> map = this.exportEntries.get(this.currentExportId);
            map.clear();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                TableRow tableRow = (TableRow)this.table.getRow(i);
                if (tableRow == null) continue;
                map.put(tableRow.getObjectId(), tableRow);
            }
        }
    }

    public static void showDialog(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser, File file, Window window) {
        AgencyExportObjectsDialog.showDialog(0L, abstractDbDriver, dbAgencyExtension, dbUser, file, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(long l, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser, File file, Window window) {
        AgencyExportObjectsDialog agencyExportObjectsDialog = null;
        try {
            agencyExportObjectsDialog = window instanceof Dialog ? new AgencyExportObjectsDialog((Dialog)window) : (window instanceof Frame ? new AgencyExportObjectsDialog((Frame)window) : new AgencyExportObjectsDialog((Frame)null));
            agencyExportObjectsDialog.load(l, abstractDbDriver, dbAgencyExtension, dbUser, file);
            agencyExportObjectsDialog.setVisible(true);
        }
        finally {
            if (agencyExportObjectsDialog != null) {
                FileUtils.deleteQuietly((File)agencyExportObjectsDialog.tempDir);
                SwingUtils.disposeRecursively((Component)((Object)agencyExportObjectsDialog));
            }
        }
    }

    private void showSelectedExport() {
        DbAgencyExport dbAgencyExport = (DbAgencyExport)this.exportField.getSelectedItem();
        if (dbAgencyExport != null && dbAgencyExport.id == this.currentExportId) {
            return;
        }
        this.saveCurrentModifications();
        this.table.clearRows();
        if (dbAgencyExport == null || dbAgencyExport.id < 1L) {
            this.currentExportId = 0L;
            return;
        }
        this.currentExportId = dbAgencyExport.id;
        this.tableScroller.setVisible(false);
        this.loadDialogLabel.setBusy(true);
        this.loadDialogLabel.setVisible(true);
        this.loadDialogLabel.setText(I18N.tr("Loading exportable properties."));
        this.submitAction.setEnabled(false);
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.setSelected(false);
        this.updateLocalization();
        ImmoToolUtils.executeTask((ImmoToolTask)new LoadExportableObjectsTask(dbAgencyExport));
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private class SubmitTask
    extends ImmoToolTask<Boolean, Void> {
        private SubmitTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyExportObjectsDialog.this.dbExtension.getObjectsHandler();
            Map map = AgencyExportObjectsDialog.this.exportEntries;
            Connection connection = null;
            try {
                connection = AgencyExportObjectsDialog.this.dbDriver.getConnection();
                HashMap<Long, DbAgencyObject> hashMap = new HashMap<Long, DbAgencyObject>();
                for (Object object : map.entrySet()) {
                    long l = (Long)object.getKey();
                    for (TableRow tableRow : ((Map)object.getValue()).values()) {
                        long l2 = tableRow.objectId;
                        DbAgencyObject dbAgencyObject = (DbAgencyObject)((Object)hashMap.get(l2));
                        if (dbAgencyObject == null) {
                            dbAgencyObject = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, l2);
                            if (dbAgencyObject == null) {
                                LOGGER.warn("Can't load property #" + l2 + "!");
                                continue;
                            }
                            dbAgencyObjectsHandler.loadObjectExportIds(connection, dbAgencyObject);
                            hashMap.put(l2, dbAgencyObject);
                        }
                        if (ExportAction.EXPORT_ENABLED.equals((Object)tableRow.action)) {
                            if (DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)dbAgencyObject.exportMode)) {
                                if (dbAgencyObject.exportIds.contains(l)) continue;
                                dbAgencyObject.exportIds.add(l);
                                continue;
                            }
                            if (DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)dbAgencyObject.exportMode)) {
                                dbAgencyObject.exportIds.remove(l);
                                continue;
                            }
                            if (DbAgencyObject.ExportMode.NEVER.equals((Object)dbAgencyObject.exportMode)) {
                                dbAgencyObject.exportMode = DbAgencyObject.ExportMode.SELECTED_EXPORTS;
                                dbAgencyObject.exportIds.clear();
                                dbAgencyObject.exportIds.add(l);
                                continue;
                            }
                            if (DbAgencyObject.ExportMode.ALL.equals((Object)dbAgencyObject.exportMode)) continue;
                            LOGGER.warn("Unsupported export mode '" + (Object)((Object)dbAgencyObject.exportMode) + "' for property #" + l2 + "!");
                            dbAgencyObject.exportMode = DbAgencyObject.ExportMode.SELECTED_EXPORTS;
                            dbAgencyObject.exportIds.clear();
                            dbAgencyObject.exportIds.add(l);
                            continue;
                        }
                        if (ExportAction.EXPORT_DISABLED.equals((Object)tableRow.action)) {
                            if (DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)dbAgencyObject.exportMode)) {
                                dbAgencyObject.exportIds.remove(l);
                                continue;
                            }
                            if (DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)dbAgencyObject.exportMode)) {
                                if (dbAgencyObject.exportIds.contains(l)) continue;
                                dbAgencyObject.exportIds.add(l);
                                continue;
                            }
                            if (DbAgencyObject.ExportMode.ALL.equals((Object)dbAgencyObject.exportMode)) {
                                dbAgencyObject.exportMode = DbAgencyObject.ExportMode.UNSELECTED_EXPORTS;
                                dbAgencyObject.exportIds.clear();
                                dbAgencyObject.exportIds.add(l);
                                continue;
                            }
                            if (DbAgencyObject.ExportMode.NEVER.equals((Object)dbAgencyObject.exportMode)) continue;
                            LOGGER.warn("Unsupported export mode '" + (Object)((Object)dbAgencyObject.exportMode) + "' for property #" + l2 + "!");
                            dbAgencyObject.exportMode = DbAgencyObject.ExportMode.UNSELECTED_EXPORTS;
                            dbAgencyObject.exportIds.clear();
                            dbAgencyObject.exportIds.add(l);
                            continue;
                        }
                        LOGGER.warn("Unknown export action '" + (Object)((Object)tableRow.action) + "' for property #" + l2 + "!");
                    }
                }
                for (Object object : hashMap.values()) {
                    boolean bl;
                    boolean bl2 = bl = AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT) && ((DbAgencyObject)((Object)object)).permission.canWrite(AgencyExportObjectsDialog.this.dbUser, ((DbAgencyObject)((Object)object)).ownerUserId, ((DbAgencyObject)((Object)object)).ownerGroupId);
                    if (!bl) {
                        LOGGER.warn("No write permission for property #" + ((DbAgencyObject)((Object)object)).id + "!");
                        continue;
                    }
                    dbAgencyObjectsHandler.saveObject(connection, (DbObject)object);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyExportObjectsDialog.this.selectAllButton.setEnabled(true);
            AgencyExportObjectsDialog.this.tableScroller.setVisible(true);
            AgencyExportObjectsDialog.this.loadDialogLabel.setText(I18N.tr("Can't save modifications!"));
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't save modifications!"), (Throwable)throwable, (Window)((Object)AgencyExportObjectsDialog.this));
        }

        protected void finished() {
            super.finished();
            AgencyExportObjectsDialog.this.submitAction.setEnabled(true);
            AgencyExportObjectsDialog.this.cancelAction.setEnabled(true);
            AgencyExportObjectsDialog.this.loadDialogLabel.setBusy(false);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            AgencyExportObjectsDialog.this.loadDialogLabel.setVisible(false);
            AgencyExportObjectsDialog.this.doClose();
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportObjectsDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save the modified settings permanently."));
        }
    }

    private static class SetExportAction
    extends AbstractI18nAction {
        private final ExportAction action;
        private final Table table;

        private SetExportAction(ExportAction exportAction, Table table) {
            this.action = exportAction;
            this.table = table;
            this.updateLocalization();
            this.setEnabled(false);
            for (int n : this.table.getSelectedRows()) {
                int n2 = this.table.convertRowIndexToModel(n);
                ExportStatus exportStatus = this.table.getStatusAt(n2);
                if (exportStatus == null) continue;
                this.setEnabled(true);
                break;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int n : this.table.getSelectedRows()) {
                int n2 = this.table.convertRowIndexToModel(n);
                ExportStatus exportStatus = this.table.getStatusAt(n2);
                if (exportStatus == null) continue;
                this.table.setActionAt(n2, this.action);
            }
        }

        protected void updateLocalization() {
            this.setName(this.action.getTranslation());
        }
    }

    private class SelectAllAction
    extends AbstractI18nAction {
        private SelectAllAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportObjectsDialog.this.doSelectAll();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("enable all")));
            this.setShortDescription(I18N.tr("Enable or disable all properties for the interface."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportObjectsDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }

    private static enum ExportStatus implements Translatable
    {
        IS_EXPORTABLE(I18n.marktr((String)"is exportable"), ExportAction.EXPORT_ENABLED, ExportAction.EXPORT_DISABLED),
        IS_NOT_EXPORTABLE(I18n.marktr((String)"is not exportable"), ExportAction.EXPORT_ENABLED, ExportAction.EXPORT_DISABLED),
        IS_NOT_EDITABLE(I18n.marktr((String)"no permission for update"), new ExportAction[0]);

        private final String i18nKey;
        private final ExportAction[] actions;

        private ExportStatus(String string2, ExportAction ... exportActionArray) {
            this.i18nKey = string2;
            this.actions = exportActionArray;
        }

        public ExportAction[] getActions() {
            return (ExportAction[])ArrayUtils.clone((Object[])this.actions);
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ExportStatus.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ExportStatus.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    private static class ExportSetting {
        private final long objectId;
        private final boolean mayEdit;
        private final List<Long> exportIds;
        private final DbAgencyObject.ExportMode exportMode;

        private ExportSetting(long l, boolean bl, List<Long> list, DbAgencyObject.ExportMode exportMode) {
            this.objectId = l;
            this.mayEdit = bl;
            this.exportMode = exportMode;
            this.exportIds = new ArrayList<Long>();
            if (list != null) {
                this.exportIds.addAll(list);
            }
        }
    }

    private static class ExportActionTableEditor
    extends JComboBox<ExportAction>
    implements TableCellEditor {
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

        private ExportActionTableEditor() {
            this.setRenderer(new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExportActionTableEditor.this.isEnabled()) {
                        ExportActionTableEditor.this.stopCellEditing();
                    }
                }
            });
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        @Override
        public void cancelCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[0])) {
                cellEditorListener.editingCanceled(new ChangeEvent(this));
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (!(jTable instanceof Table)) {
                return null;
            }
            Table table = (Table)((Object)jTable);
            int n3 = table.convertRowIndexToModel(n);
            ExportStatus exportStatus = table.getStatusAt(n3);
            ExportAction exportAction = table.getActionAt(n3);
            DefaultComboBoxModel<ExportAction> defaultComboBoxModel = new DefaultComboBoxModel<ExportAction>();
            for (ExportAction exportAction2 : exportStatus.getActions()) {
                defaultComboBoxModel.addElement(exportAction2);
            }
            this.setEnabled(false);
            this.setSelectedIndex(-1);
            this.setModel(defaultComboBoxModel);
            this.setSelectedItem((Object)exportAction);
            this.setEnabled(true);
            return this;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[0])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
            return true;
        }
    }

    private static enum ExportAction implements Translatable
    {
        EXPORT_ENABLED(I18n.marktr((String)"enabled for export")),
        EXPORT_DISABLED(I18n.marktr((String)"disabled for export"));

        private final String i18nKey;

        private ExportAction(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ExportAction.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ExportAction.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    private static class TableRow
    extends AbstractTable.Row {
        private final long objectId;
        private final String publicId;
        private final EstateImpl object;
        private final String notice;
        private ExportAction action;
        private ExportStatus status;

        private TableRow(long l, EstateImpl estateImpl, ExportAction exportAction, ExportStatus exportStatus, String string) {
            this.objectId = l;
            this.publicId = estateImpl != null ? StringUtils.trimToNull((String)estateImpl.getPublicId()) : null;
            this.object = estateImpl;
            this.status = exportStatus;
            this.notice = string;
            this.action = exportAction;
        }

        public ExportAction getAction() {
            return this.action;
        }

        public String getNotice() {
            return this.notice;
        }

        public EstateImpl getObject() {
            return this.object;
        }

        public long getObjectId() {
            return this.objectId;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public ExportStatus getStatus() {
            return this.status;
        }

        public String getToolTipText(AbstractTable.Column column) {
            String string;
            Object object;
            OpenEstateAction openEstateAction = this.object != null ? this.object.getAction() : null;
            OpenEstateType openEstateType = this.object != null ? this.object.getType() : null;
            EstateAddressImpl estateAddressImpl = this.object != null ? this.object.getAddress() : null;
            String string2 = "<html><div style=\"padding:3px;\">";
            string2 = string2 + "<b style=\"font-size:1.1em;\">";
            string2 = string2 + StringUtils.capitalize((String)I18N.tr("property")) + " #" + this.objectId;
            if (StringUtils.isNotBlank((CharSequence)this.publicId)) {
                string2 = string2 + " / " + StringEscapeUtils.escapeXml11((String)this.publicId);
            }
            string2 = string2 + "</b>";
            if (openEstateType != null || openEstateAction != null) {
                string2 = string2 + "<br>";
                if (openEstateType != null) {
                    string2 = string2 + openEstateType.getTranslation();
                }
                if (openEstateType != null && openEstateAction != null) {
                    string2 = string2 + " / ";
                }
                if (openEstateAction != null) {
                    string2 = string2 + openEstateAction.getTranslation();
                }
            }
            if (estateAddressImpl != null) {
                object = estateAddressImpl.writePostal();
                if (StringUtils.isNotBlank((CharSequence)object)) {
                    string2 = string2 + "<br>" + StringEscapeUtils.escapeXml11((String)object);
                }
                if (StringUtils.isNotBlank((CharSequence)(string = estateAddressImpl.writeStreet(true)))) {
                    string2 = string2 + "<br>" + StringEscapeUtils.escapeXml11((String)string);
                }
            }
            if (openEstateType != null && openEstateAction != null) {
                object = new ArrayList();
                string = this.object.getTypeSpec();
                for (OpenEstateAttrib openEstateAttrib : string.getAttribs()) {
                    String string3;
                    AbstractAttribImpl abstractAttribImpl;
                    if (!string.isAttribRequired(openEstateAttrib) || (abstractAttribImpl = this.object.getAttribute(openEstateAttrib)) == null || (string3 = StringUtils.trimToNull((String)abstractAttribImpl.getFormattedValue())) == null) continue;
                    object.add(StringEscapeUtils.escapeXml11((String)openEstateAttrib.getTranslation()) + ": " + StringEscapeUtils.escapeXml11((String)string3));
                }
                if (!object.isEmpty()) {
                    string2 = string2 + "<hr>" + StringUtils.join((Iterable)object, (String)"<br>");
                }
            }
            string2 = string2 + "<hr>";
            string2 = string2 + "<b>" + (this.status != null ? StringEscapeUtils.escapeXml11((String)this.status.getTranslation()) : "???") + "</b>";
            if (this.action != null) {
                string2 = string2 + "<br>";
                string2 = string2 + "<i>" + StringEscapeUtils.escapeXml11((String)this.action.getTranslation()) + "</i>";
            }
            if (StringUtils.isNotBlank((CharSequence)this.notice)) {
                string2 = string2 + "<hr>";
                string2 = string2 + StringEscapeUtils.escapeXml11((String)this.notice);
            }
            string2 = string2 + "</div></html>";
            return string2;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForExport((TableColumn)column);
            }
            return null;
        }

        private Object getValueForExport(TableColumn tableColumn) {
            OpenEstateAction openEstateAction = this.object != null ? this.object.getAction() : null;
            OpenEstateType openEstateType = this.object != null ? this.object.getType() : null;
            EstateAddressImpl estateAddressImpl = this.object != null ? this.object.getAddress() : null;
            switch (tableColumn) {
                case ID: {
                    return "<html><div>#" + this.objectId + (StringUtils.isNotBlank((CharSequence)this.publicId) ? "<br>" + this.publicId : "") + "</div></html>";
                }
                case TYPE: {
                    if (openEstateType == null && openEstateAction == null) {
                        return "";
                    }
                    return "<html><div>" + (openEstateType != null ? openEstateType.getTranslation() : "???") + "<br>" + (openEstateAction != null ? openEstateAction.getTranslation() : "???") + "</div></html>";
                }
                case ADDRESS: {
                    if (estateAddressImpl == null) {
                        return "";
                    }
                    return "<html><div>" + estateAddressImpl.writeStreet(true) + "<br>" + estateAddressImpl.writePostal() + "</div></html>";
                }
                case NOTICE: {
                    return "<html><div>" + (this.status != null ? this.status.getTranslation() : "") + (this.status != null && StringUtils.isNotBlank((CharSequence)this.notice) ? "<br>" : "") + (StringUtils.isNotBlank((CharSequence)this.notice) ? this.notice : "") + "</div></html>";
                }
                case ACTION: {
                    return this.action;
                }
            }
            return null;
        }

        public boolean isEditable(AbstractTable.Column column) {
            return super.isEditable(column) && TableColumn.ACTION.equals(column) && this.status != null && ArrayUtils.isNotEmpty((Object[])this.status.getActions());
        }

        public void setAction(ExportAction exportAction) {
            this.action = exportAction;
        }

        public void setStatus(ExportStatus exportStatus) {
            this.status = exportStatus;
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (TableColumn.ACTION.equals(column)) {
                this.action = (ExportAction)((Object)object);
            }
        }
    }

    private static enum TableColumn implements AbstractTable.Column
    {
        ID,
        TYPE,
        ADDRESS,
        NOTICE,
        ACTION;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case ACTION: {
                    return new DefaultTableCellRenderer<ExportAction>(){

                        protected void init() {
                            super.init();
                            this.setVerticalAlignment(1);
                        }

                        public Component getRenderedComponent(JTable jTable, ExportAction exportAction, boolean bl, boolean bl2, int n, int n2) {
                            JLabel jLabel = (JLabel)super.getRenderedComponent(jTable, (Object)exportAction, bl, bl2, n, n2);
                            ExportStatus exportStatus = ((Table)((Object)jTable)).getStatusAt(n);
                            if (exportAction != null) {
                                if (ExportStatus.IS_NOT_EDITABLE.equals((Object)exportStatus)) {
                                    jLabel.setText("<html><b>" + exportAction.getTranslation() + "</b></html>");
                                } else if (ExportAction.EXPORT_ENABLED.equals((Object)exportAction)) {
                                    jLabel.setText("<html><a href=\"#\" style=\"font-weight:bold; color:#008000;\">" + exportAction.getTranslation() + "</a></html>");
                                } else if (ExportAction.EXPORT_DISABLED.equals((Object)exportAction)) {
                                    jLabel.setText("<html><a href=\"#\" style=\"font-weight:bold; color:#FF0000;\">" + exportAction.getTranslation() + "</a></html>");
                                } else {
                                    jLabel.setText("<html><a href=\"#\">" + exportAction.getTranslation() + "</a></html>");
                                }
                            } else {
                                jLabel.setText("");
                            }
                            return jLabel;
                        }
                    };
                }
                case NOTICE: {
                    return new DefaultTableCellRenderer<String>((Renderer)new StringRenderer()){
                        private final Icon okIcon;
                        private final Icon warningIcon;
                        {
                            this.okIcon = ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16);
                            this.warningIcon = ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)16);
                        }

                        protected void init() {
                            super.init();
                            this.setVerticalAlignment(1);
                            this.setVerticalTextPosition(1);
                        }

                        public Component getRenderedComponent(JTable jTable, String string, boolean bl, boolean bl2, int n, int n2) {
                            JLabel jLabel = (JLabel)super.getRenderedComponent(jTable, (Object)string, bl, bl2, n, n2);
                            if (string != null) {
                                ExportStatus exportStatus = ((Table)((Object)jTable)).getStatusAt(n);
                                if (ExportStatus.IS_NOT_EDITABLE.equals((Object)exportStatus) || ExportStatus.IS_NOT_EXPORTABLE.equals((Object)exportStatus)) {
                                    jLabel.setIcon(this.warningIcon);
                                } else {
                                    jLabel.setIcon(this.okIcon);
                                }
                            } else {
                                jLabel.setIcon(null);
                            }
                            return jLabel;
                        }
                    };
                }
            }
            return new DefaultTableCellRenderer<String>((Renderer)new StringRenderer()){

                protected void init() {
                    super.init();
                    this.setVerticalAlignment(1);
                    this.setVerticalTextPosition(1);
                }
            };
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return String.class;
                }
                case TYPE: {
                    return String.class;
                }
                case ADDRESS: {
                    return String.class;
                }
                case NOTICE: {
                    return String.class;
                }
                case ACTION: {
                    return ExportAction.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case TYPE: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
                case ADDRESS: {
                    return StringUtils.capitalize((String)I18N.tr("address"));
                }
                case NOTICE: {
                    return StringUtils.capitalize((String)I18N.tr("notice"));
                }
                case ACTION: {
                    return StringUtils.capitalize((String)I18N.tr("action"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                case NOTICE: 
                case ID: 
                case TYPE: 
                case ADDRESS: {
                    return new AlphanumComparator();
                }
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case ACTION: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private static class Table
    extends AbstractTable<TableRow, AbstractTable.Model<TableRow>> {
        public Table() {
            super(AgencyExportObjectsDialog.TABLE_ID);
        }

        protected void doShowActions(int n, int n2) {
            if (this.getSelectedRowCount() < 1) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.capitalize((String)I18N.tr("select action")), (int)5));
            for (ExportAction exportAction : ExportAction.values()) {
                jPopupMenu.add((Action)((Object)new SetExportAction(exportAction, this)));
            }
            jPopupMenu.show((Component)((Object)this), n, n2);
        }

        private ExportAction getActionAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getAction() : null;
        }

        private EstateImpl getObjectAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getObject() : null;
        }

        private long getObjectIdAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getObjectId() : 0L;
        }

        private String getPublicIdAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getPublicId() : null;
        }

        private ExportStatus getStatusAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getStatus() : null;
        }

        protected void init() {
            this.setMultipleIntervalSelection();
            this.setSortable(true);
            this.setColumnControlVisible(false);
            this.setRowHeight(this.getRowHeight() * 2 - 2);
            super.init();
            this.getColumnById(TableColumn.ACTION.getColumnId()).setCellEditor((TableCellEditor)new ExportActionTableEditor());
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(TableColumn.values()));
        }

        private void setActionAt(int n, ExportAction exportAction) {
            TableRow tableRow = (TableRow)this.getRow(n);
            if (tableRow != null) {
                tableRow.setAction(exportAction);
            }
        }

        private void setStatusAt(int n, ExportStatus exportStatus) {
            TableRow tableRow = (TableRow)this.getRow(n);
            if (tableRow != null) {
                tableRow.setStatus(exportStatus);
            }
        }
    }

    private class LoadInBackgroundTask
    extends ImmoToolTask<DbAgencyExport[], Void> {
        private final long selectedExportId;

        private LoadInBackgroundTask(long l) {
            this.selectedExportId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyExport[] doInBackground() throws Exception {
            DbAgencyExport[] dbAgencyExportArray;
            if (AgencyExportObjectsDialog.this.tempDir.exists()) {
                if (!AgencyExportObjectsDialog.this.tempDir.isDirectory()) {
                    throw new IOException("Temp directory is invalid!");
                }
                FileUtils.deleteDirectory((File)AgencyExportObjectsDialog.this.tempDir);
            }
            if (!AgencyExportObjectsDialog.this.tempDir.mkdirs()) {
                throw new IOException("Can't create temp directory!");
            }
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyExportObjectsDialog.this.dbExtension.getExportsHandler();
            Connection connection = null;
            try {
                connection = AgencyExportObjectsDialog.this.dbDriver.getConnection();
                DbAgencyExport[] dbAgencyExportArray2 = dbAgencyExportsHandler.getExports(connection);
                dbAgencyExportsHandler.loadExportSettings(connection, dbAgencyExportArray2);
                dbAgencyExportArray = dbAgencyExportArray2;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return dbAgencyExportArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyExportObjectsDialog.this.loadDialogLabel.setText(I18N.tr("Can't load interfaces!"));
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't load interfaces!"), (Throwable)throwable, (Window)((Object)AgencyExportObjectsDialog.this));
        }

        protected void finished() {
            super.finished();
        }

        protected void succeeded(DbAgencyExport[] dbAgencyExportArray) {
            super.succeeded((Object)dbAgencyExportArray);
            AgencyExportObjectsDialog.this.loadDialogLabel.setVisible(false);
            if (!ArrayUtils.isEmpty((Object[])dbAgencyExportArray)) {
                for (DbAgencyExport dbAgencyExport : dbAgencyExportArray) {
                    AgencyExportObjectsDialog.this.exportField.addItem(dbAgencyExport);
                    if (this.selectedExportId <= 0L || dbAgencyExport.id != this.selectedExportId) continue;
                    AgencyExportObjectsDialog.this.exportField.setSelectedItem(dbAgencyExport);
                }
            }
            AgencyExportObjectsDialog.this.exportField.setEnabled(AgencyExportObjectsDialog.this.exportField.getItemCount() > 0);
            AgencyExportObjectsDialog.this.showSelectedExport();
        }
    }

    private class LoadExportableObjectsTask
    extends ImmoToolTask<Boolean, Void> {
        private final DbAgencyExport export;

        private LoadExportableObjectsTask(DbAgencyExport dbAgencyExport) {
            super(I18N.tr("Loading exportable properties."));
            this.export = dbAgencyExport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            Object object;
            long[] lArray;
            Connection connection;
            DbGeoHandler dbGeoHandler;
            DbLanguagesHandler dbLanguagesHandler;
            Map map;
            long l;
            block14: {
                l = this.export.id;
                long l2 = this.export.searchId;
                map = (Map)AgencyExportObjectsDialog.this.exportEntries.get(l);
                DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyExportObjectsDialog.this.dbExtension.getObjectsHandler();
                DbAgencySearchesHandler dbAgencySearchesHandler = AgencyExportObjectsDialog.this.dbExtension.getSearchesHandler();
                dbLanguagesHandler = AgencyExportObjectsDialog.this.dbExtension.getLanguagesHandler();
                dbGeoHandler = AgencyExportObjectsDialog.this.dbExtension.getGeoHandler();
                connection = null;
                connection = AgencyExportObjectsDialog.this.dbDriver.getConnection();
                if (map != null) {
                    lArray = ArrayUtils.toPrimitive((Long[])map.keySet().toArray(new Long[0]));
                } else {
                    if (l2 < 1L) {
                        object = new DbAgencySearch();
                        object.item = new SearchImpl();
                        object.status.add(DbAgencyObject.Status.PUBLISHED);
                    } else {
                        object = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, l2);
                        dbAgencySearchesHandler.loadAttribConditions(connection, (DbSearch)object);
                        dbAgencySearchesHandler.loadParameters(connection, (DbSearch)object);
                        dbAgencySearchesHandler.loadValueConditions(connection, (DbSearch)object);
                    }
                    lArray = dbAgencyObjectsHandler.getObjectIds(connection, (DbSearch)object);
                }
                if (!ArrayUtils.isEmpty((long[])lArray)) break block14;
                object = true;
                JdbcUtils.closeQuietly((Connection)connection);
                return object;
            }
            try {
                object = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
                HashMap<Long, DbGeo> hashMap = new HashMap<Long, DbGeo>();
                for (DbGeo dbGeo : dbGeoHandler.getGeoDbs(connection)) {
                    hashMap.put(dbGeo.id, dbGeo);
                }
                for (long l2 : lArray) {
                    TableRow tableRow;
                    EstateImpl estateImpl = AgencyExportObjectsDialog.this.lookupObject(l2, connection, (Map)object, hashMap);
                    if (estateImpl == null) {
                        LOGGER.warn("Can't load property #" + l2 + "!");
                        continue;
                    }
                    TableRow tableRow2 = tableRow = map != null ? (TableRow)((Object)map.get(l2)) : null;
                    if (tableRow == null) {
                        ExportStatus exportStatus;
                        Object notExportableException;
                        String string = null;
                        try {
                            notExportableException = this.export.format.calculateHashForObject(l2, estateImpl);
                            exportStatus = notExportableException != null ? ExportStatus.IS_EXPORTABLE : ExportStatus.IS_NOT_EXPORTABLE;
                        }
                        catch (AbstractFormat.NotExportableException hashCalculationException) {
                            LOGGER.warn("Can't export property #" + l2 + " into format '" + this.export.getFormatName() + "'!");
                            LOGGER.warn("> " + hashCalculationException.getLocalizedMessage(), (Throwable)hashCalculationException);
                            exportStatus = ExportStatus.IS_NOT_EXPORTABLE;
                            string = StringUtils.trimToNull((String)hashCalculationException.getLocalizedMessage());
                        }
                        catch (AbstractFormat.HashCalculationException hashCalculationException) {
                            LOGGER.warn("Can't calculate hash value for property #" + l2 + " in format '" + this.export.getFormatName() + "'!");
                            LOGGER.warn("> " + hashCalculationException.getLocalizedMessage(), (Throwable)hashCalculationException);
                            exportStatus = ExportStatus.IS_NOT_EXPORTABLE;
                            string = I18N.tr("Can't generate hash value!");
                        }
                        notExportableException = (ExportSetting)AgencyExportObjectsDialog.this.exportSettings.get(l2);
                        ExportAction exportAction = notExportableException == null ? ExportAction.EXPORT_ENABLED : (DbAgencyObject.ExportMode.ALL.equals((Object)((ExportSetting)notExportableException).exportMode) ? ExportAction.EXPORT_ENABLED : (DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)((ExportSetting)notExportableException).exportMode) && ((ExportSetting)notExportableException).exportIds.contains(l) ? ExportAction.EXPORT_ENABLED : (DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)((ExportSetting)notExportableException).exportMode) && !((ExportSetting)notExportableException).exportIds.contains(l) ? ExportAction.EXPORT_ENABLED : ExportAction.EXPORT_DISABLED)));
                        tableRow = new TableRow(l2, estateImpl, exportAction, exportStatus, string);
                    }
                    AgencyExportObjectsDialog.this.table.addRow(tableRow);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyExportObjectsDialog.this.loadDialogLabel.setText(I18N.tr("Can't load exportable properties!"));
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't load exportable properties!"), (Component)((Object)AgencyExportObjectsDialog.this));
        }

        protected void finished() {
            super.finished();
            AgencyExportObjectsDialog.this.loadDialogLabel.setBusy(false);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            AgencyExportObjectsDialog.this.loadDialogLabel.setVisible(false);
            AgencyExportObjectsDialog.this.tableScroller.setVisible(true);
            AgencyExportObjectsDialog.this.selectAllButton.setEnabled(true);
            AgencyExportObjectsDialog.this.submitAction.setEnabled(true);
            AgencyExportObjectsDialog.this.table.packAll();
        }
    }
}

