/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySearchCriteriaPanel;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.SwingUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencySearchDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencySearchDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencySearchDialog.class);
    private DbAgencySearch currentSearch = null;
    private boolean submitted = false;
    private ValidationHandler validationHandler;
    private JLabel nameLabel;
    private JTextField nameField;
    private JTabbedPane tabPanel;
    private CriteriaTab criteriaTab;
    private PermissionsTab permissionsTab;
    private JCheckBox saveBox;

    private AgencySearchDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.setSize(new Dimension(700, 550));
        this.setLocationRelativeTo(frame);
    }

    private AgencySearchDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.setSize(new Dimension(700, 550));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.saveBox = new JCheckBox();
        this.saveBox.setOpaque(false);
        this.saveBox.setFont(this.saveBox.getFont().deriveFont(1));
        buttonBarBuilder.addFixed((JComponent)this.saveBox);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{new SubmitAction()});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.nameField.setText(StringUtils.capitalize((String)I18N.tr("new search")));
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.validationHandler.putRule((JComponent)this.nameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.init();
        this.tabPanel = new JTabbedPane();
        this.criteriaTab = (CriteriaTab)ImmoToolUtils.addTab((AbstractTab)new CriteriaTab(), (JTabbedPane)this.tabPanel);
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionsTab = (PermissionsTab)ImmoToolUtils.addTab((AbstractTab)new PermissionsTab(), (JTabbedPane)this.tabPanel);
        }
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 100dlu:grow");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add((Component)this.nameLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.nameField).xy(3, defaultFormBuilder.row());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)this.tabPanel, "Center");
        return jPanel;
    }

    private void doSubmit() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)((Object)this));
            return;
        }
        this.submitted = true;
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("edit search request"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("edit search request"));
    }

    private DbAgencySearch getSearch() {
        if (this.currentSearch == null) {
            this.currentSearch = new DbAgencySearch();
        }
        if (this.currentSearch.item == null) {
            this.currentSearch.item = new SearchImpl();
        }
        this.currentSearch.item.setEnabled(true);
        this.currentSearch.item.setName(this.nameField.getText().trim());
        this.criteriaTab.form.save(this.currentSearch);
        if (this.permissionsTab != null) {
            this.permissionsTab.save(this.currentSearch);
        }
        return this.currentSearch;
    }

    protected void init() {
        super.init();
        if (this.permissionsTab != null) {
            this.tabPanel.setEnabledAt(this.tabPanel.indexOfComponent((Component)((Object)this.permissionsTab)), this.saveBox.isSelected());
            this.saveBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = itemEvent.getStateChange() == 1;
                    int n = AgencySearchDialog.this.tabPanel.indexOfComponent((Component)((Object)AgencySearchDialog.this.permissionsTab));
                    AgencySearchDialog.this.tabPanel.setEnabledAt(n, bl);
                    if (!bl && AgencySearchDialog.this.tabPanel.getSelectedIndex() == n) {
                        AgencySearchDialog.this.tabPanel.setSelectedIndex(0);
                    }
                }
            });
        }
    }

    private void load(ImmoToolProject immoToolProject) throws SQLException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.load(connection, immoToolProject);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    private void load(Connection connection, ImmoToolProject immoToolProject) throws SQLException {
        DbExtension dbExtension = immoToolProject.getDbExtension();
        this.criteriaTab.form.loadTemplates(connection, AgencyPlugin.getDbAgencyExtension().getSearchesHandler());
        if (this.permissionsTab != null) {
            this.permissionsTab.load(connection, dbExtension, this.currentSearch, immoToolProject.getUser());
            this.tabPanel.setEnabledAt(this.tabPanel.indexOfComponent((Component)((Object)this.permissionsTab)), this.saveBox.isSelected());
        }
    }

    private boolean isSaveBoxSelected() {
        return this.saveBox.isSelected();
    }

    private boolean isSaveBoxVisible() {
        return this.saveBox.isVisible();
    }

    private void setSaveBoxSelected(boolean bl) {
        this.saveBox.setSelected(bl);
    }

    private void setSaveBoxVisible(boolean bl) {
        this.saveBox.setVisible(bl);
    }

    private void setSearch(DbAgencySearch dbAgencySearch) {
        DbAgencySearch dbAgencySearch2 = this.currentSearch = dbAgencySearch != null ? dbAgencySearch : new DbAgencySearch();
        if (this.currentSearch.item == null) {
            this.currentSearch.item = new SearchImpl();
        }
        if (this.currentSearch.id > 0L) {
            this.criteriaTab.form.setCurrentSearch(this.currentSearch);
        } else {
            this.criteriaTab.form.setDefaultSearch();
        }
        String string = StringUtils.trimToEmpty((String)this.currentSearch.item.getName());
        this.nameField.setText(!StringUtils.isBlank((CharSequence)string) ? string : StringUtils.capitalize((String)I18N.tr("new search")));
    }

    public static DbAgencySearch showDialog(ImmoToolProject immoToolProject, Window window) throws SQLException {
        return AgencySearchDialog.showDialog(immoToolProject, DbAgencySearch.Type.TEMP, true, false, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbAgencySearch showDialog(ImmoToolProject immoToolProject, DbAgencySearch.Type type, boolean bl, boolean bl2, Window window) throws SQLException {
        Object object;
        AgencySearchDialog agencySearchDialog;
        DbAgencySearchesHandler dbAgencySearchesHandler;
        block7: {
            DbAgencySearch dbAgencySearch;
            dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            agencySearchDialog = null;
            try {
                agencySearchDialog = window instanceof Dialog ? new AgencySearchDialog((Dialog)window) : (window instanceof Frame ? new AgencySearchDialog((Frame)window) : new AgencySearchDialog((Frame)null));
                agencySearchDialog.setSaveBoxSelected(bl);
                agencySearchDialog.setSaveBoxVisible(bl2);
                agencySearchDialog.setSearch(new DbAgencySearch());
                agencySearchDialog.load(immoToolProject);
                agencySearchDialog.setVisible(true);
                if (agencySearchDialog.submitted) break block7;
                dbAgencySearch = null;
            }
            catch (Throwable throwable) {
                SwingUtils.disposeRecursively(agencySearchDialog);
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)agencySearchDialog));
            return dbAgencySearch;
        }
        DbAgencySearch dbAgencySearch = agencySearchDialog.getSearch();
        DbAgencySearch.Type type2 = type != null ? type : (dbAgencySearch.type = bl2 ? DbAgencySearch.Type.SIDEBAR : DbAgencySearch.Type.TEMP);
        if (agencySearchDialog.isSaveBoxSelected()) {
            object = null;
            try {
                object = immoToolProject.getDbConnection();
                dbAgencySearchesHandler.saveSearch((Connection)object, dbAgencySearch, false, true);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)object);
            }
        }
        object = dbAgencySearch;
        SwingUtils.disposeRecursively((Component)((Object)agencySearchDialog));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbAgencySearch showDialog(long l, ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbAgencySearch dbAgencySearch;
        Connection connection;
        AgencySearchDialog agencySearchDialog;
        DbAgencySearchesHandler dbAgencySearchesHandler;
        block13: {
            DbAgencySearch dbAgencySearch2;
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid export-id was provided!");
            }
            dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            agencySearchDialog = null;
            try {
                agencySearchDialog = window instanceof Dialog ? new AgencySearchDialog((Dialog)window) : (window instanceof Frame ? new AgencySearchDialog((Frame)window) : new AgencySearchDialog((Frame)null));
                connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    dbAgencySearch = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, l);
                    if (dbAgencySearch == null) {
                        throw new SQLException("Can't find search #" + l + "!");
                    }
                    dbAgencySearchesHandler.loadAttribConditions(connection, dbAgencySearch);
                    dbAgencySearchesHandler.loadValueConditions(connection, dbAgencySearch);
                    agencySearchDialog.setSaveBoxSelected(true);
                    agencySearchDialog.setSaveBoxVisible(false);
                    agencySearchDialog.setSearch(dbAgencySearch);
                    agencySearchDialog.load(connection, immoToolProject);
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                agencySearchDialog.setVisible(true);
                if (agencySearchDialog.submitted) break block13;
                dbAgencySearch2 = null;
            }
            catch (Throwable throwable) {
                SwingUtils.disposeRecursively(agencySearchDialog);
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)agencySearchDialog));
            return dbAgencySearch2;
        }
        dbAgencySearch = agencySearchDialog.getSearch();
        if (agencySearchDialog.isSaveBoxSelected()) {
            try {
                connection = immoToolProject.getDbConnection();
                dbAgencySearchesHandler.saveSearch(connection, dbAgencySearch, false, true);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        DbAgencySearch dbAgencySearch3 = dbAgencySearch;
        SwingUtils.disposeRecursively((Component)((Object)agencySearchDialog));
        return dbAgencySearch3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showDialog(DbAgencySearch dbAgencySearch, ImmoToolProject immoToolProject, Window window) throws SQLException {
        Connection connection;
        AgencySearchDialog agencySearchDialog;
        DbAgencySearchesHandler dbAgencySearchesHandler;
        block13: {
            boolean bl;
            if (dbAgencySearch == null) {
                throw new IllegalArgumentException("No search was provided!");
            }
            dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            agencySearchDialog = null;
            try {
                agencySearchDialog = window instanceof Dialog ? new AgencySearchDialog((Dialog)window) : (window instanceof Frame ? new AgencySearchDialog((Frame)window) : new AgencySearchDialog((Frame)null));
                connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    if (dbAgencySearch.id > 0L) {
                        dbAgencySearchesHandler.loadAttribConditions(connection, dbAgencySearch);
                        dbAgencySearchesHandler.loadValueConditions(connection, dbAgencySearch);
                    }
                    agencySearchDialog.setSaveBoxSelected(true);
                    agencySearchDialog.setSaveBoxVisible(dbAgencySearch.id == 0L);
                    agencySearchDialog.setSearch(dbAgencySearch);
                    agencySearchDialog.load(connection, immoToolProject);
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                agencySearchDialog.setVisible(true);
                if (agencySearchDialog.submitted) break block13;
                bl = false;
            }
            catch (Throwable throwable) {
                SwingUtils.disposeRecursively(agencySearchDialog);
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)agencySearchDialog));
            return bl;
        }
        dbAgencySearch = agencySearchDialog.getSearch();
        if (agencySearchDialog.isSaveBoxSelected()) {
            try {
                connection = immoToolProject.getDbConnection();
                dbAgencySearchesHandler.saveSearch(connection, dbAgencySearch, false, true);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        boolean bl = true;
        SwingUtils.disposeRecursively((Component)((Object)agencySearchDialog));
        return bl;
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.nameLabel.setText(StringUtils.capitalize((String)I18N.tr("name")) + ":");
        this.nameField.setToolTipText(I18N.tr("Select a name for the search request."));
        this.saveBox.setText(I18N.tr("Save search request permanently."));
    }

    private static final class PermissionsTab
    extends AbstractTab {
        private ImmoToolPermissionPanel form;

        private PermissionsTab() {
            this.build();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel(true);
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        public void load(Connection connection, DbExtension dbExtension, DbAgencySearch dbAgencySearch, DbUser dbUser) throws SQLException {
            if (dbAgencySearch != null && dbAgencySearch.id > 0L) {
                this.form.setPermission(dbAgencySearch.ownerUserId, dbAgencySearch.ownerGroupId, dbAgencySearch.permission);
            } else {
                this.form.setPermission(dbUser.id, 0L, null);
            }
            this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
        }

        public void save(DbAgencySearch dbAgencySearch) {
            DbGroup dbGroup;
            dbAgencySearch.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbAgencySearch.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbAgencySearch.ownerGroupId = dbGroup.id;
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private final class CriteriaTab
    extends AbstractTab
    implements AgencySearchCriteriaPanel.TemplateListener {
        private AgencySearchCriteriaPanel form;
        private String lastName;

        private CriteriaTab() {
            this.build();
        }

        private void build() {
            this.lastName = AgencySearchDialog.this.nameField.getText();
            this.form = new AgencySearchCriteriaPanel();
            this.form.setBorder((Border)Paddings.DIALOG);
            this.form.doCriteriaAdd();
            this.form.addTemplateListener(this);
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.form));
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("criteria"));
        }

        @Override
        public void templateSelected(DbSearch dbSearch) {
            String string;
            if (dbSearch == null || dbSearch.item == null) {
                return;
            }
            String string2 = AgencySearchDialog.this.nameField.getText().trim();
            if (string2.equalsIgnoreCase(this.lastName) && !StringUtils.isBlank((CharSequence)(string = StringUtils.trimToEmpty((String)dbSearch.item.getName())))) {
                this.lastName = string;
                AgencySearchDialog.this.nameField.setText(string);
                AgencySearchDialog.this.nameField.setCaretPosition(0);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save the modified settings permanently."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }
}

