/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.daft_ie.DaftIeWriter;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.DaftIeXmlFormatPanel;
import com.openindex.openestate.tool.agency.export.ExportContext;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.daft_ie.DaftIeDocument;
import org.openestate.io.daft_ie.DaftIeUtils;
import org.openestate.io.daft_ie.xml.Daft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DaftIeXmlFormat
extends AbstractXmlFormat<Daft> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DaftIeXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(DaftIeXmlFormat.class);
    private static final String NAME = "daft_ie";
    private static final String DAFT_BASE_URL = "daft_ie.baseUrl";

    protected DaftIeWriter buildWriter() {
        Writer writer = new Writer(this.getLanguage());
        writer.setXmlLineSeparator("<br/>");
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        URI uRI = this.getDaftBaseUrl();
        writer.setBaseUrl(uRI != null ? uRI.toString() : "http://localhost");
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        Daft daft;
        Object object;
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object = this.buildWriter();
            object.setXmlLineSeparator("<br/>");
            daft = (Daft)object.writeToObject(agencyImpl);
            string = object.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (daft == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        daft.setVersion(null);
        try {
            object = new StringWriter();
            Throwable throwable = null;
            try {
                DaftIeUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)daft, (java.io.Writer)object);
                String string2 = ((StringWriter)object).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                String string3 = DigestUtils.sha1Hex((String)string2);
                return string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((StringWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((StringWriter)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    protected Daft convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        DaftIeWriter daftIeWriter = this.buildWriter();
        Daft daft = (Daft)daftIeWriter.writeToObject(transferImpl);
        if (daft == null) {
            return null;
        }
        exportContext.addErrorMessages(daftIeWriter.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return daft;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new DaftIeXmlFormatPanel();
    }

    public URI getDaftBaseUrl() {
        String string = StringUtils.trimToNull((String)((String)this.get(DAFT_BASE_URL)));
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read url: " + string);
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public String getTitle() {
        return "Daft-XML";
    }

    @Override
    public String getVersion() {
        return DaftIeUtils.VERSION.toReadableVersion();
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        return "daft.xml";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setLanguages(new Locale[]{Locale.ENGLISH});
    }

    @Override
    public boolean isFullTransportWarningShown() {
        return false;
    }

    public void setDaftBaseUrl(URI uRI) {
        if (uRI == null) {
            this.remove(DAFT_BASE_URL);
        } else {
            this.put(DAFT_BASE_URL, uRI.toString());
        }
    }

    @Override
    protected void writeXmlObject(Daft daft, java.io.Writer writer) throws IOException, JAXBException {
        try {
            DaftIeDocument daftIeDocument = DaftIeDocument.newDocument((Daft)daft);
            daftIeDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends DaftIeWriter {
        public Writer(Locale locale) {
            super(locale);
            AgencyPluginUtils.initJAXB(DaftIeUtils.class);
        }
    }
}

