/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.FtpTransportPanel;
import com.openindex.openestate.tool.utils.FtpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.IDN;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FtpTransport
extends AbstractTransport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpTransport.class);
    private static final I18n I18N = I18nFactory.getI18n(FtpTransport.class);
    private static final String NAME = "ftp";
    private static final String FTP_HOST = "ftp.host";
    private static final String FTP_LOGIN = "ftp.login";
    private static final String FTP_LOGIN_PASS = "ftp.login.pass";
    private static final String FTP_LOGIN_USER = "ftp.login.user";
    private static final String FTP_PASSIVE = "ftp.passive";
    private static final String FTP_PATH = "ftp.path";
    private static final String FTP_PORT = "ftp.port";
    private static final String FTP_CRYPT_METHOD = "ftp.crypt.method";
    private static final String FTP_CRYPT_SSL_SESSION_REUSED = "ftp.crypt.sslSessionReused";

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new FtpTransportPanel();
    }

    public FtpUtils.CryptMethod getFtpCryptMethod() {
        return this.containsKey(FTP_CRYPT_METHOD) ? FtpUtils.CryptMethod.valueOf((String)((String)this.get(FTP_CRYPT_METHOD))) : null;
    }

    public String getFtpHost() {
        return StringUtils.trimToNull((String)((String)this.get(FTP_HOST)));
    }

    public String getFtpLoginPass() {
        return StringUtils.trimToNull((String)((String)this.get(FTP_LOGIN_PASS)));
    }

    public String getFtpLoginUser() {
        return StringUtils.trimToNull((String)((String)this.get(FTP_LOGIN_USER)));
    }

    public String getFtpPath() {
        return StringUtils.trimToNull((String)((String)this.get(FTP_PATH)));
    }

    public int getFtpPort() {
        String string = StringUtils.trimToNull((String)((String)this.get(FTP_PORT)));
        return string != null ? Integer.parseInt(string) : 21;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return I18N.tr("Transport to a FTP server.");
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setFtpLogin(true);
        this.setFtpPassive(true);
        this.setFtpPath("/");
        this.setFtpPort(21);
        this.setFtpCryptMethod(FtpUtils.CryptMethod.NO_ENCRYPTION);
        this.setFtpCryptSslSessionReused(false);
    }

    public boolean isFtpCryptSslSessionReused() {
        String string = StringUtils.trimToNull((String)((String)this.get(FTP_CRYPT_SSL_SESSION_REUSED)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFtpLogin() {
        String string = StringUtils.trimToNull((String)((String)this.get(FTP_LOGIN)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFtpPassive() {
        String string = StringUtils.trimToNull((String)((String)this.get(FTP_PASSIVE)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Override
    protected boolean isUpdatingMessage() {
        return true;
    }

    @Override
    protected boolean isUpdatingProgress() {
        return true;
    }

    public void setFtpCryptMethod(FtpUtils.CryptMethod cryptMethod) {
        if (cryptMethod == null) {
            this.remove(FTP_CRYPT_METHOD);
        } else {
            this.put(FTP_CRYPT_METHOD, cryptMethod.name());
        }
    }

    public void setFtpCryptSslSessionReused(boolean bl) {
        this.put(FTP_CRYPT_SSL_SESSION_REUSED, String.valueOf(bl));
    }

    public void setFtpHost(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(FTP_HOST);
        } else {
            this.put(FTP_HOST, string);
        }
    }

    public void setFtpLogin(boolean bl) {
        this.put(FTP_LOGIN, String.valueOf(bl));
    }

    public void setFtpLoginPass(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(FTP_LOGIN_PASS);
        } else {
            this.put(FTP_LOGIN_PASS, string);
        }
    }

    public void setFtpLoginUser(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(FTP_LOGIN_USER);
        } else {
            this.put(FTP_LOGIN_USER, string);
        }
    }

    public void setFtpPassive(boolean bl) {
        this.put(FTP_PASSIVE, String.valueOf(bl));
    }

    public void setFtpPath(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(FTP_PATH);
        } else {
            this.put(FTP_PATH, string);
        }
    }

    public void setFtpPort(int n) {
        if (n < 1) {
            this.remove(FTP_PORT);
        } else {
            this.put(FTP_PORT, String.valueOf(n));
        }
    }

    private static final class TransferListener
    implements CopyStreamListener {
        private final NumberFormat floatFormat;
        private final ImmoToolTask.Callback callback;
        private long totalSize;
        private long copiedSize = 0L;
        private long startTime = -1L;
        private long permille = -1L;
        private String currentSpeed = null;

        public TransferListener(long l, ImmoToolTask.Callback callback) {
            this.totalSize = l;
            this.callback = callback;
            this.floatFormat = NumberFormat.getNumberInstance();
            this.floatFormat.setMaximumFractionDigits(1);
        }

        public void bytesTransferred(CopyStreamEvent copyStreamEvent) {
        }

        public void bytesTransferred(long l, int n, long l2) {
            this.copiedSize += (long)n;
            if (this.copiedSize > this.totalSize) {
                this.totalSize = this.copiedSize;
            }
            long l3 = Math.round((double)this.copiedSize / (double)this.totalSize * 1000.0);
            if (this.permille < 0L || this.permille != l3) {
                this.permille = l3;
                String string = ImmoToolUtils.getHumanReadableByteCount((long)this.copiedSize, (NumberFormat)this.floatFormat);
                String string2 = ImmoToolUtils.getHumanReadableByteCount((long)this.totalSize, (NumberFormat)this.floatFormat);
                if (this.currentSpeed == null || this.permille % 10L == 0L) {
                    long l4 = 0L;
                    if (this.startTime < 0L) {
                        this.startTime = System.currentTimeMillis() / 1000L;
                    } else {
                        l4 = System.currentTimeMillis() / 1000L - this.startTime;
                    }
                    if (l4 > 0L) {
                        long l5 = Math.round((double)this.copiedSize / (double)l4);
                        this.currentSpeed = ImmoToolUtils.getHumanReadableByteCount((long)l5, (NumberFormat)this.floatFormat) + "/s";
                    }
                }
                if (this.currentSpeed != null) {
                    string2 = string2 + " (" + this.currentSpeed + ")";
                }
                this.callback.setMessage(I18N.tr("{0} of {1}", (Object)string, (Object)string2));
                this.callback.setProgress((float)this.permille / 1000.0f);
            }
            try {
                this.callback.checkCancelled();
            }
            catch (CancellationException cancellationException) {
                throw new RuntimeException("Transfer was cancelled by user!", cancellationException);
            }
        }
    }

    public static final class TransferFailedException
    extends Exception {
        public TransferFailedException(String string) {
            super(string);
        }

        public TransferFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static final class CommunicationFailedException
    extends Exception {
        public CommunicationFailedException(String string) {
            super(string);
        }

        public CommunicationFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static final class AuthenticationFailedException
    extends Exception {
        public AuthenticationFailedException(String string) {
            super(string);
        }

        public AuthenticationFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class Request
    extends AbstractTransportRequest<FtpTransport> {
        private final File exportFile;
        private final String stampFileName;
        private ExportContext currentContext = null;
        private FTPClient currentFtpClient = null;
        private TransferListener currentTransferListener = null;

        public Request(FtpTransport ftpTransport, File file) {
            this(ftpTransport, file, null);
        }

        public Request(FtpTransport ftpTransport, File file, String string) {
            super(ftpTransport);
            if (file == null) {
                throw new IllegalArgumentException("No export file was specified!");
            }
            if (!file.isFile() && !file.isDirectory()) {
                throw new IllegalArgumentException("The export file is neither a file nor a directory (" + file.getAbsolutePath() + ")!");
            }
            this.exportFile = file;
            this.stampFileName = StringUtils.trimToNull((String)string);
        }

        protected FTPClient doConnect(ExportContext exportContext) throws IOException, AuthenticationFailedException {
            String string;
            FtpTransport ftpTransport = (FtpTransport)this.getTransport();
            try {
                string = IDN.toASCII(ftpTransport.getFtpHost());
            }
            catch (Exception exception) {
                string = ftpTransport.getFtpHost();
                LOGGER.warn("Can't parse international host name!");
                LOGGER.warn("> Falling back to: " + ftpTransport.getFtpHost());
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            FTPClient fTPClient = FtpUtils.openClient((String)string, (int)ftpTransport.getFtpPort(), (boolean)ftpTransport.isFtpPassive(), (FtpUtils.CryptMethod)ftpTransport.getFtpCryptMethod(), (boolean)ftpTransport.isFtpCryptSslSessionReused());
            if (ftpTransport.isFtpLogin() && !fTPClient.login(ftpTransport.getFtpLoginUser(), ftpTransport.getFtpLoginPass())) {
                throw new AuthenticationFailedException("Login failed for user '" + ftpTransport.getFtpLoginUser() + "'!");
            }
            if (this.currentTransferListener != null) {
                fTPClient.setCopyStreamListener((CopyStreamListener)this.currentTransferListener);
            }
            return fTPClient;
        }

        protected void doDisconnect(FTPClient fTPClient) {
            if (fTPClient == null || !fTPClient.isConnected()) {
                return;
            }
            try {
                fTPClient.disconnect();
            }
            catch (IOException iOException) {
                LOGGER.warn("Can't disconnect from FTP server!");
                LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            }
        }

        protected final FTPClient doReconnect(String string) throws IOException, AuthenticationFailedException {
            if (this.currentFtpClient != null) {
                this.doDisconnect(this.currentFtpClient);
                this.currentFtpClient = null;
            }
            this.currentFtpClient = this.doConnect(this.currentContext);
            if (!StringUtils.isBlank((CharSequence)string)) {
                this.currentFtpClient.changeWorkingDirectory(string);
            }
            return this.currentFtpClient;
        }

        protected void doSend(File file, String string, int n, ImmoToolTask.Callback callback) throws CommunicationFailedException, TransferFailedException, AuthenticationFailedException, CancellationException {
            block38: {
                FTPClient fTPClient = this.getCurrentFtpClient();
                if (file.isFile()) {
                    String string2 = string;
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    string2 = string2 + file.getName();
                    callback.checkCancelled();
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        if (!fTPClient.setFileType(2)) {
                            LOGGER.warn("Can't set binary file type!");
                        }
                        if (!fTPClient.storeFile(file.getName(), (InputStream)fileInputStream)) {
                            throw new IOException("Can't store file: " + string2);
                        }
                        break block38;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Can't store file '" + file.getName() + "' into remote folder '" + string2 + "'!");
                        if (n < 3) {
                            callback.checkCancelled();
                            this.doDisconnect(fTPClient);
                            LOGGER.info("Trying to reconnect, attempt #" + ++n);
                            try {
                                LOGGER.info("> Waiting for 10 seconds...");
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                callback.checkCancelled();
                                this.doReconnect(string);
                                this.doSend(file, string, n, callback);
                                break block38;
                            }
                            catch (IOException iOException2) {
                                LOGGER.error("Reconnection #" + n + " failed: " + iOException2.getLocalizedMessage());
                                LOGGER.error("> " + iOException2.getLocalizedMessage(), (Throwable)iOException2);
                                throw new TransferFailedException("Can't store '" + file.getName() + "' into remote folder '" + string2 + "'!", iOException);
                            }
                        }
                        throw new TransferFailedException("Can't store '" + file.getName() + "' into remote folder '" + string2 + "'!", iOException);
                    }
                }
                if (file.isDirectory()) {
                    callback.checkCancelled();
                    String string3 = string;
                    if (!string3.endsWith("/")) {
                        string3 = string3 + "/";
                    }
                    string3 = string3 + file.getName();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        callback.checkCancelled();
                        Object[] objectArray = fTPClient.listNames();
                        if (objectArray != null) {
                            arrayList.addAll(Arrays.asList(objectArray));
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Can't retrieve directory listing from FTP server!");
                        LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                    try {
                        callback.checkCancelled();
                        if (!arrayList.contains(file.getName()) && !fTPClient.makeDirectory(file.getName())) {
                            throw new TransferFailedException("Can't create directory: " + string3);
                        }
                    }
                    catch (IOException iOException) {
                        throw new CommunicationFailedException("Can't create directory: " + string3, iOException);
                    }
                    try {
                        callback.checkCancelled();
                        if (!fTPClient.changeWorkingDirectory(file.getName())) {
                            throw new TransferFailedException("Can't change working directory: " + string3);
                        }
                    }
                    catch (IOException iOException) {
                        throw new CommunicationFailedException("Can't change working directory: " + string3, iOException);
                    }
                    for (File file2 : (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0])) {
                        callback.checkCancelled();
                        this.doSend(file2, string3 + "/", 0, callback);
                    }
                    try {
                        if (!fTPClient.changeToParentDirectory()) {
                            throw new TransferFailedException("Can't change to parent directory of " + string3);
                        }
                        break block38;
                    }
                    catch (IOException iOException) {
                        throw new CommunicationFailedException("Can't change to parent directory of " + string3, iOException);
                    }
                }
                LOGGER.warn("Invalid source file '" + file.getAbsolutePath() + "' for FTP transport!");
            }
        }

        protected void doTransportFinish(FTPClient fTPClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            if (fTPClient == null) {
                throw new IllegalStateException("No FTP client was loaded!");
            }
        }

        protected void doTransportInit(FTPClient fTPClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            block63: {
                StringBuilder stringBuilder;
                block65: {
                    Object[] iOException;
                    Object throwable2;
                    block64: {
                        boolean bl;
                        File file2;
                        if (fTPClient == null) {
                            throw new IllegalStateException("No FTP client was loaded!");
                        }
                        if (this.stampFileName == null) break block63;
                        File file3 = file != null && file.isFile() ? file.getAbsoluteFile().getParentFile() : (file2 = file != null && file.isDirectory() ? file : null);
                        if (file2 == null || !file2.isDirectory()) {
                            throw new IllegalArgumentException("An invalid export directory was specified!");
                        }
                        callback.checkCancelled();
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(System.currentTimeMillis()).append("\n");
                        Object[] objectArray2 = file2.listFiles();
                        if (ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                            for (Object objectArray3 : objectArray2) {
                                ImmoToolUtils.buildFileList((File)objectArray3, (String)"", (StringBuilder)stringBuilder);
                            }
                        }
                        Object object2 = null;
                        try {
                            callback.checkCancelled();
                            String[] stringArray = fTPClient.listNames();
                            if (stringArray == null) {
                                stringArray = new String[]{};
                            }
                            object2 = Arrays.asList(stringArray);
                        }
                        catch (IOException iOException2) {
                            throw new IOException("Can't read existing files from FTP server!", iOException2);
                        }
                        boolean bl2 = bl = !object2.contains(this.stampFileName);
                        if (!bl) break block64;
                        callback.checkCancelled();
                        if (ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                            for (Object throwable2 : objectArray2) {
                                if (!object2.contains(((File)throwable2).getName())) continue;
                                throw new IOException("The file '" + ((File)throwable2).getName() + "' already exists on the FTP server!");
                            }
                        }
                        break block65;
                    }
                    File file4 = null;
                    Object object = null;
                    try {
                        callback.checkCancelled();
                        file4 = File.createTempFile("ftp.", ".stamp");
                        Object object2 = new FileOutputStream(file4);
                        throwable2 = null;
                        try {
                            fTPClient.retrieveFile(this.stampFileName, (OutputStream)object2);
                            ((OutputStream)object2).flush();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (object2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)object2).close();
                                    }
                                    catch (Throwable iOException3) {
                                        ((Throwable)throwable2).addSuppressed(iOException3);
                                    }
                                } else {
                                    ((OutputStream)object2).close();
                                }
                            }
                        }
                        object2 = ImmoToolUtils.readFile((File)file4);
                        iOException = ((String)object2).split("\\n");
                    }
                    catch (IOException iOException4) {
                        try {
                            throw new IOException("Can't read '" + this.stampFileName + "' from FTP server!", iOException4);
                        }
                        catch (Throwable throwable4) {
                            FileUtils.deleteQuietly(file4);
                            throw throwable4;
                        }
                    }
                    FileUtils.deleteQuietly((File)file4);
                    if (iOException != null && !ArrayUtils.isEmpty((Object[])iOException)) {
                        for (int i = 1; i < iOException.length; ++i) {
                            callback.checkCancelled();
                            throwable2 = StringUtils.trimToNull((String)iOException[i]);
                            if (throwable2 == null) continue;
                            try {
                                if (((String)throwable2).endsWith("/")) {
                                    String string = ((String)throwable2).substring(0, ((String)throwable2).length() - 1);
                                    if (fTPClient.removeDirectory(string)) continue;
                                    LOGGER.warn("Can't remove directory '" + string + "'!");
                                    continue;
                                }
                                if (fTPClient.deleteFile((String)throwable2)) continue;
                                LOGGER.warn("Can't remove file '" + (String)throwable2 + "'!");
                                continue;
                            }
                            catch (IOException iOException5) {
                                LOGGER.warn("Can't delete '" + (String)throwable2 + "' from FTP server!");
                                LOGGER.warn("> " + iOException5.getLocalizedMessage(), (Throwable)iOException5);
                            }
                        }
                    }
                }
                File file5 = File.createTempFile(this.stampFileName, "");
                try {
                    try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file5, "UTF-8");){
                        fileWriterWithEncoding.write(stringBuilder.toString());
                        fileWriterWithEncoding.flush();
                    }
                    var12_28 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(file5);){
                        if (!fTPClient.setFileType(2)) {
                            LOGGER.warn("Can't change file-type!");
                        }
                        if (!fTPClient.storeFile(this.stampFileName, (InputStream)fileInputStream)) {
                            LOGGER.warn("Can't store file: " + file5.getName());
                        }
                    }
                    catch (Throwable throwable) {
                        var12_28 = throwable;
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw new IOException("Can't write '" + this.stampFileName + "' to FTP server!", iOException);
                }
                finally {
                    FileUtils.deleteQuietly((File)file5);
                }
            }
        }

        @Override
        public AbstractTransportRequest[] getChildRequests() {
            return null;
        }

        protected final FTPClient getCurrentFtpClient() {
            return this.currentFtpClient;
        }

        public final String getStampFileName() {
            return this.stampFileName;
        }

        @Override
        public String getTitle() {
            return I18N.tr("Transferring files via {0}.", (Object)"FTP");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ExportContext exportContext, ImmoToolTask.Callback callback) throws AbstractTransportRequest.TransferException {
            FtpTransport ftpTransport = (FtpTransport)this.getTransport();
            try {
                block23: {
                    this.currentContext = exportContext;
                    if (this.currentFtpClient != null) {
                        this.doDisconnect(this.currentFtpClient);
                    }
                    long l = this.exportFile.isDirectory() ? FileUtils.sizeOfDirectory((File)this.exportFile) : this.exportFile.length();
                    this.currentTransferListener = new TransferListener(l, callback);
                    try {
                        this.currentFtpClient = this.doConnect(exportContext);
                    }
                    catch (AuthenticationFailedException authenticationFailedException) {
                        throw new AbstractTransportRequest.TransferException("Can't login at the FTP server!", authenticationFailedException);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new AbstractTransportRequest.TransferException("Can't resolve hostname of the FTP server (" + ftpTransport.getFtpHost() + ")!", unknownHostException);
                    }
                    catch (IOException iOException) {
                        throw new AbstractTransportRequest.TransferException("Can't connect to FTP server!", iOException);
                    }
                    String string = StringUtils.trimToNull((String)ftpTransport.getFtpPath());
                    if (string != null) {
                        try {
                            if (!this.currentFtpClient.changeWorkingDirectory(string)) {
                                throw new AbstractTransportRequest.TransferException("Can't change working directory to '" + string + "'!");
                            }
                        }
                        catch (IOException iOException) {
                            throw new AbstractTransportRequest.TransferException("Can't change working directory to '" + string + "'!", iOException);
                        }
                    }
                    try {
                        this.doTransportInit(this.currentFtpClient, this.exportFile, this.currentContext, callback);
                    }
                    catch (IOException iOException) {
                        throw new AbstractTransportRequest.TransferException("Can't initialize FTP transfer!", iOException);
                    }
                    try {
                        if (this.exportFile.isDirectory()) {
                            for (File file : (File[])ObjectUtils.defaultIfNull((Object)this.exportFile.listFiles(), (Object)new File[0])) {
                                callback.checkCancelled();
                                this.doSend(file, StringUtils.trimToEmpty((String)string), 0, callback);
                            }
                            break block23;
                        }
                        if (this.exportFile.isFile()) {
                            callback.checkCancelled();
                            this.doSend(this.exportFile, StringUtils.trimToEmpty((String)string), 0, callback);
                            break block23;
                        }
                        throw new AbstractTransportRequest.TransferException("The export file is invalid!");
                    }
                    catch (AuthenticationFailedException authenticationFailedException) {
                        throw new AbstractTransportRequest.TransferException("Can't login at the FTP server!", authenticationFailedException);
                    }
                    catch (CommunicationFailedException communicationFailedException) {
                        throw new AbstractTransportRequest.TransferException("Communication with FTP server failed!", communicationFailedException);
                    }
                    catch (TransferFailedException transferFailedException) {
                        throw new AbstractTransportRequest.TransferException("Transfer to FTP server failed!", transferFailedException);
                    }
                }
                try {
                    this.doTransportFinish(this.currentFtpClient, this.exportFile, this.currentContext, callback);
                }
                catch (IOException iOException) {
                    throw new AbstractTransportRequest.TransferException("Can't finalize FTP transfer!", iOException);
                }
            }
            finally {
                this.doDisconnect(this.currentFtpClient);
                this.currentFtpClient = null;
                this.currentTransferListener = null;
                this.currentContext = null;
            }
        }
    }
}

