/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ImmonetDeFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmonetDeFormatPanel
extends AbstractFormatPanel<ImmonetDeFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmonetDeFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmonetDeFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private JLabel agentMailLabel;
    private JTextField agentMailField;
    private JLabel technMailLabel;
    private JTextField technMailField;
    private JLabel recipientLabel;
    private JComboBox<ImmonetDeFormat.Recipient> recipientBox;
    private JLabel optionsLabel;
    private JCheckBox publicIdExportBox;
    private JCheckBox energyCertificateBox;

    public ImmonetDeFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        this.technMailLabel = new JLabel();
        this.technMailField = new JTextField();
        this.agentMailLabel = new JLabel();
        this.agentMailField = new JTextField();
        this.publicIdExportBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.recipientLabel = new JLabel();
        this.recipientBox = new JComboBox();
        this.recipientBox.setRenderer((ListCellRenderer<ImmonetDeFormat.Recipient>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        for (ImmonetDeFormat.Recipient recipient : ImmonetDeFormat.Recipient.values()) {
            this.recipientBox.addItem(recipient);
        }
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return StringUtils.isBlank((CharSequence)object.toString()) || ValidationHandler.EMAIL.isValid(object);
            }
        });
        this.validationHandler.putRule((JComponent)this.agentMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return StringUtils.isBlank((CharSequence)object.toString()) || ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.agentMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.technMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.technMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.recipientLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.recipientBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdExportBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (ImmonetDeFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, ImmonetDeFormat immonetDeFormat) {
        if (immonetDeFormat == null) {
            this.agentIdField.setText("");
            this.agentMailField.setText("");
            this.estateIdPrefixField.setText("");
            this.publicIdExportBox.setSelected(true);
            this.technMailField.setText("");
            this.recipientBox.setSelectedItem((Object)ImmonetDeFormat.Recipient.ALL);
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(immonetDeFormat.getAgentId());
            this.agentMailField.setText(immonetDeFormat.getAgentMail());
            this.estateIdPrefixField.setText(immonetDeFormat.getPropertyPrefix());
            this.publicIdExportBox.setSelected(immonetDeFormat.isOpenImmoPropertyPublicIdExported());
            this.technMailField.setText(immonetDeFormat.getOpenImmoTechnicsMail());
            this.energyCertificateBox.setSelected(immonetDeFormat.isPropertyDescriptionWithEnergyCertificate());
            ImmonetDeFormat.Recipient recipient = immonetDeFormat.getImmonetRecipient();
            this.recipientBox.setSelectedItem((Object)(recipient != null ? recipient : ImmonetDeFormat.Recipient.ALL));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, ImmonetDeFormat immonetDeFormat) {
        if (immonetDeFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        immonetDeFormat.setAgentId(this.agentIdField.getText().trim());
        immonetDeFormat.setAgentMail(this.agentMailField.getText().trim());
        immonetDeFormat.setPropertyPrefix(this.estateIdPrefixField.getText().trim());
        immonetDeFormat.setOpenImmoPropertyPublicIdExported(this.publicIdExportBox.isSelected());
        immonetDeFormat.setOpenImmoTechnicsMail(this.technMailField.getText().trim());
        immonetDeFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        immonetDeFormat.setImmonetRecipient((ImmonetDeFormat.Recipient)((Object)this.recipientBox.getSelectedItem()));
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.agentMailLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-mail")) + ":");
        this.technMailLabel.setText(StringUtils.capitalize((String)I18N.tr("support-mail")) + ":");
        this.technMailField.setToolTipText(I18N.tr("Enter your e-mail address for technical feedback. Some recipients are sending their protocols to this address."));
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.recipientLabel.setText(StringUtils.capitalize((String)I18N.tr("recipient")) + ":");
        this.recipientBox.setToolTipText(I18N.tr("Use this field to specify, at which partner the exported properties are published."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdExportBox.setText(I18N.tr("Publish property-nr."));
        this.publicIdExportBox.setToolTipText(I18N.tr("Enable this option to publish the property-nr next to the property-ID. Not all recipients support this feature."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

