/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ImmoXmlFormat;
import com.openindex.openestate.tool.agency.export.ImmopoolDeFormatPanel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.immoxml.xml.Anbieter;
import org.openestate.io.immoxml.xml.Anhang;
import org.openestate.io.immoxml.xml.Immobilie;
import org.openestate.io.immoxml.xml.Immoxml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmopoolDeFormat
extends ImmoXmlFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmopoolDeFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmopoolDeFormat.class);
    private static final String NAME = "immopool_de";
    private final SimpleDateFormat IMMOPOOL_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmm");

    @Override
    public Immoxml convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        Immoxml immoxml = super.convertXml(transferImpl, exportContext);
        for (Anbieter anbieter : immoxml.getAnbieter()) {
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                if (immobilie.getAnhaenge() == null) continue;
                ArrayList<Anhang> arrayList = new ArrayList<Anhang>();
                for (Anhang anhang : immobilie.getAnhaenge().getAnhang()) {
                    String string = anhang.getFormat();
                    if ("image/bmp".equals(string)) {
                        anhang.setFormat("bmp");
                        continue;
                    }
                    if ("image/gif".equals(string)) {
                        anhang.setFormat("gif");
                        continue;
                    }
                    if ("image/jpeg".equals(string)) {
                        anhang.setFormat("jpg");
                        continue;
                    }
                    if ("image/png".equals(string)) {
                        anhang.setFormat("png");
                        continue;
                    }
                    arrayList.add(anhang);
                }
                for (Anhang anhang : arrayList) {
                    immobilie.getAnhaenge().getAnhang().remove(anhang);
                }
            }
        }
        return immoxml;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new ImmopoolDeFormatPanel();
    }

    @Override
    protected String getCompressedFileName(AbstractFormat.Compression compression, ExportContext exportContext) {
        String string = StringUtils.trimToEmpty((String)this.getAgentId());
        if (AbstractFormat.Compression.GZIP.equals((Object)compression)) {
            return "IMMOPOOL-" + string.replaceAll("\\W", "") + "-" + this.IMMOPOOL_DATEFORMAT.format(exportContext.stamp) + ".gzip";
        }
        if (AbstractFormat.Compression.ZIP.equals((Object)compression)) {
            return "IMMOPOOL-" + string.replaceAll("\\W", "") + "-" + this.IMMOPOOL_DATEFORMAT.format(exportContext.stamp) + ".zip";
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected String[] getPreferredMimeTypes() {
        return new String[]{"image/jpeg", "image/png"};
    }

    @Override
    public String getTitle() {
        return "Portal: Immopool.de";
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        String string = StringUtils.trimToEmpty((String)this.getAgentId());
        return "IMMOPOOL-" + string.replaceAll("\\W", "") + "-" + this.IMMOPOOL_DATEFORMAT.format(exportContext.stamp) + ".xml";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setLanguages(new Locale[]{Locale.GERMAN});
    }
}

