/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.utils.Authorization;
import org.openestate.is24.restapi.utils.Verification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24RestAccessDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24RestAccessDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24RestAccessDialog.class);
    private AbstractClient client = null;
    private Verification verification = null;
    private Authorization authorization = null;
    private JXTitledSeparator verificationUrlTitle;
    private JLabel verificationUrlLabel;
    private JXLabel verificationUrlInfoLabel;
    private JTextField verificationUrlField;
    private JButton verificationUrlButton;
    private JXTitledSeparator verificationCodeTitle;
    private JLabel verificationCodeLabel;
    private JXLabel verificationCodeInfoLabel;
    private JTextField verificationCodeField;
    private JXBusyLabel busyLabel;
    private SubmitAction submitAction;
    private CancelAction cancelAction;

    private Is24RestAccessDialog(Frame frame) {
        super(frame);
        this.setSize(new Dimension(500, 375));
        this.setLocationRelativeTo(frame);
    }

    private Is24RestAccessDialog(Dialog dialog) {
        super(dialog);
        this.setSize(new Dimension(500, 375));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.cancelAction = new CancelAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.cancelAction});
    }

    protected JComponent buildMainComponent() {
        this.verificationUrlTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.verificationUrlInfoLabel = new JXLabel();
        this.verificationUrlInfoLabel.setLineWrap(true);
        this.verificationUrlLabel = new JLabel();
        this.verificationUrlField = new JTextField();
        this.verificationUrlField.setEditable(false);
        this.verificationUrlButton = new JButton((Action)((Object)new OpenUrlAction()));
        this.verificationCodeTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.verificationCodeInfoLabel = new JXLabel();
        this.verificationCodeInfoLabel.setLineWrap(true);
        this.verificationCodeLabel = new JLabel();
        this.verificationCodeField = new JTextField();
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setVisible(false);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.add((Component)this.verificationUrlTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.verificationUrlLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.verificationUrlField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.verificationUrlButton).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.verificationUrlInfoLabel).xyw(3, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.verificationCodeTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.verificationCodeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.verificationCodeField).xyw(3, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.verificationCodeInfoLabel).xyw(3, defaultFormBuilder.nextRow(), 3);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
        jPanel.add((Component)this.busyLabel, "South");
        this.updateLocalization();
        return jPanel;
    }

    private void doSubmit() {
        String string = StringUtils.trimToNull((String)this.verificationCodeField.getText());
        if (string == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Please enter a verification code."), (Component)((Object)this));
            return;
        }
        this.authorization = null;
        this.busyLabel.setBusy(true);
        this.busyLabel.setText(I18N.tr("Verifying access to the webservice."));
        this.busyLabel.setVisible(true);
        this.setDialogEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(string));
    }

    protected void firstOpened(WindowEvent windowEvent) {
        super.firstOpened(windowEvent);
        this.verificationUrlButton.requestFocus();
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("create access to the webservice"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"password.png", (int)32);
    }

    protected String getHeaderInfo() {
        return StringUtils.trimToEmpty((String)I18N.tr("Please take the following steps to create an access to the webservice."));
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("create access to the webservice"));
    }

    private void load(AbstractClient abstractClient, Verification verification) {
        this.client = abstractClient;
        this.verification = verification;
        this.authorization = null;
        this.verificationCodeField.setText("");
        this.verificationUrlField.setText(StringUtils.trimToEmpty((String)verification.verificationUrl));
        this.verificationUrlField.setCaretPosition(0);
    }

    private void setDialogEnabled(boolean bl) {
        this.verificationCodeField.setEnabled(bl);
        this.verificationUrlField.setEnabled(bl);
        this.verificationUrlButton.setEnabled(bl);
        this.submitAction.setEnabled(bl);
        this.cancelAction.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Authorization showDialog(AbstractClient abstractClient, Verification verification, Window window) {
        Authorization authorization;
        Is24RestAccessDialog is24RestAccessDialog = null;
        try {
            is24RestAccessDialog = window instanceof Dialog ? new Is24RestAccessDialog((Dialog)window) : (window instanceof Frame ? new Is24RestAccessDialog((Frame)window) : new Is24RestAccessDialog((Frame)null));
            is24RestAccessDialog.load(abstractClient, verification);
            is24RestAccessDialog.setVisible(true);
            authorization = is24RestAccessDialog.authorization;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(is24RestAccessDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)is24RestAccessDialog));
        return authorization;
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.verificationUrlTitle.setTitle("1. " + StringUtils.capitalize((String)I18N.tr("grant access to the webservice")));
        this.verificationUrlInfoLabel.setText(I18N.tr("Open this address in your web-browser in order to grant access to the webservice for this export interface."));
        this.verificationUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.verificationCodeTitle.setTitle("2. " + StringUtils.capitalize((String)I18N.tr("enter the verification code")));
        this.verificationCodeInfoLabel.setText(I18N.tr("Enter the verification code, that is shown in your web-browser after access was granted."));
        this.verificationCodeLabel.setText(StringUtils.capitalize((String)I18N.tr("code")) + ":");
    }

    private class SubmitTask
    extends ImmoToolTask<Authorization, Void> {
        private final String verificationCode;

        private SubmitTask(String string) {
            this.verificationCode = string;
        }

        protected Authorization doInBackground() throws Exception {
            return Is24RestAccessDialog.this.client.authorizeAfterVerification(Is24RestAccessDialog.this.verification, this.verificationCode);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            Is24RestAccessDialog.this.busyLabel.setText("<html><b stlye=\"color:red;\">" + I18N.tr("Verification failed!") + "</b></html>");
            ImmoToolUtils.showMessageErrorDialog((String)"Can't verify access for the webservice!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            Is24RestAccessDialog.this.busyLabel.setBusy(false);
            Is24RestAccessDialog.this.setDialogEnabled(true);
        }

        protected void succeeded(Authorization authorization) {
            super.succeeded((Object)authorization);
            Is24RestAccessDialog.this.busyLabel.setVisible(false);
            Is24RestAccessDialog.this.authorization = authorization;
            Is24RestAccessDialog.this.setVisible(false);
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        public SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Is24RestAccessDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
        }
    }

    private class OpenUrlAction
    extends AbstractI18nAction {
        public OpenUrlAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"web.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = StringUtils.trimToNull((String)Is24RestAccessDialog.this.verificationUrlField.getText());
            if (string == null) {
                return;
            }
            try {
                ImmoToolUtils.openURL((URI)new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't open website!");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("open")));
            this.setShortDescription(I18N.tr("Open the website in your web browser."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        public CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Is24RestAccessDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
        }
    }
}

