/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.Is24XmlFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24XmlFormatPanel
extends AbstractFormatPanel<Is24XmlFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24XmlFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private JLabel technMailLabel;
    private JTextField technMailField;
    private JLabel exportLineBreakLabel;
    private JComboBox<AbstractXmlFormat.LineBreakMode> exportLineBreakBox;
    private JLabel optionsLabel;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;
    private LocaleComboBox exportLocaleBox;

    public Is24XmlFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.zipExportBox = new JCheckBox();
        this.publicIdBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.exportLocaleBox = new LocaleComboBox(AgencyPlugin.getLocales(), true);
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        this.technMailLabel = new JLabel();
        this.technMailField = new JTextField();
        this.exportLineBreakLabel = new JLabel();
        this.exportLineBreakBox = new JComboBox();
        this.exportLineBreakBox.setRenderer((ListCellRenderer<AbstractXmlFormat.LineBreakMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        for (AbstractXmlFormat.LineBreakMode lineBreakMode : AbstractXmlFormat.LineBreakMode.values()) {
            this.exportLineBreakBox.addItem(lineBreakMode);
        }
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, ValidationHandler.EMAIL);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLocaleBox).xyw(5, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.technMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.technMailField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLineBreakLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.exportLineBreakBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.zipExportBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (Is24XmlFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.publicIdBox.isSelected()) {
            list.add(AgencyPluginUtils.Message.PROPERTY_NR_IDENTIFICATION_WARNING.getTranslation());
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, Is24XmlFormat is24XmlFormat) {
        if (is24XmlFormat == null) {
            this.agentIdField.setText("");
            this.estateIdPrefixField.setText("");
            this.exportLineBreakBox.setSelectedItem((Object)AbstractXmlFormat.LineBreakMode.NATIVE);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.publicIdBox.setSelected(false);
            this.technMailField.setText("");
            this.zipExportBox.setSelected(true);
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(is24XmlFormat.getAgentId());
            this.estateIdPrefixField.setText(is24XmlFormat.getPropertyPrefix());
            this.exportLocaleBox.setSelectedLocale(is24XmlFormat.getLanguage());
            this.publicIdBox.setSelected(is24XmlFormat.isPropertyPublicId());
            this.technMailField.setText(is24XmlFormat.getAgentMail());
            this.energyCertificateBox.setSelected(is24XmlFormat.isPropertyDescriptionWithEnergyCertificate());
            AbstractFormat.Compression compression = is24XmlFormat.getCompression();
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)compression));
            AbstractXmlFormat.LineBreakMode lineBreakMode = is24XmlFormat.getXmlLineBreak();
            this.exportLineBreakBox.setSelectedItem((Object)(lineBreakMode != null ? lineBreakMode : AbstractXmlFormat.LineBreakMode.NATIVE));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, Is24XmlFormat is24XmlFormat) {
        if (is24XmlFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        is24XmlFormat.setAgentId(this.agentIdField.getText().trim());
        is24XmlFormat.setPropertyPrefix(this.estateIdPrefixField.getText().trim());
        is24XmlFormat.setLanguage(this.exportLocaleBox.getSelectedLocale());
        is24XmlFormat.setAgentMail(this.technMailField.getText().trim());
        is24XmlFormat.setPropertyPublicId(this.publicIdBox.isSelected());
        is24XmlFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        is24XmlFormat.setXmlLineBreak((AbstractXmlFormat.LineBreakMode)((Object)this.exportLineBreakBox.getSelectedItem()));
        is24XmlFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.technMailLabel.setText(StringUtils.capitalize((String)I18N.tr("support-mail")) + ":");
        this.technMailField.setToolTipText(I18N.tr("Enter your e-mail address for technical feedback. Some recipients are sending their protocols to this address."));
        this.exportLineBreakLabel.setText(StringUtils.capitalize((String)I18N.tr("line break")) + ":");
        this.exportLineBreakBox.setToolTipText(I18N.tr("Use this field to specify, how line breaks are written into the exported file."));
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.exportLocaleBox.setToolTipText(I18N.tr("The properties will be sent to the recipient in the selected language."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdBox.setText(I18N.tr("Use property number for identification."));
        this.publicIdBox.setToolTipText(I18N.tr("Enable this option to export the property number instead of the property ID."));
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

