/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.KyeroXmlFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultWebLinkField;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class KyeroXmlFormatPanel
extends AbstractFormatPanel<KyeroXmlFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroXmlFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(KyeroXmlFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel baseUrlLabel;
    private DefaultWebLinkField baseUrlField;
    private JLabel optionsLabel;
    private JCheckBox zipExportBox;
    private JCheckBox energyCertificateBox;

    public KyeroXmlFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.baseUrlLabel = new JLabel();
        this.baseUrlField = new DefaultWebLinkField(false);
        this.zipExportBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.validationHandler.putRule((JComponent)this.baseUrlField, ValidationHandler.URL);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.baseUrlLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.baseUrlField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.zipExportBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.energyCertificateBox).xy(3, defaultFormBuilder.nextRow());
        this.updateLocalization();
        this.load((DbAgencyExport)null, (KyeroXmlFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(AgencyPluginUtils.Message.FULL_EXPORT_WARNING.getTranslation());
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, KyeroXmlFormat kyeroXmlFormat) {
        if (kyeroXmlFormat == null) {
            this.baseUrlField.setUrl(null);
            this.energyCertificateBox.setSelected(false);
            this.zipExportBox.setSelected(false);
        } else {
            this.baseUrlField.setUrl(kyeroXmlFormat.getKyeroBaseUrl());
            this.energyCertificateBox.setSelected(kyeroXmlFormat.isPropertyDescriptionWithEnergyCertificate());
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)kyeroXmlFormat.getCompression()));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, KyeroXmlFormat kyeroXmlFormat) {
        if (kyeroXmlFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        kyeroXmlFormat.setKyeroBaseUrl(this.baseUrlField.isEnabled() ? this.baseUrlField.getUrl() : null);
        kyeroXmlFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        kyeroXmlFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.baseUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("base-URL")) + ":");
        this.baseUrlField.setToolTipText(I18N.tr("This URL points to the location at your webspace, where the exported files are stored."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

