/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.OpenEstateXmlFormatPanel;
import java.io.IOException;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OpenEstateXmlFormat
extends AbstractXmlFormat<TransferImpl> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenEstateXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(OpenEstateXmlFormat.class);
    private static final String NAME = "openestate_xml";

    @Override
    protected TransferImpl convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            if (transferAgencyImpl.getCustomValues() == null) continue;
            transferAgencyImpl.getCustomValues().getValueMap().clear();
        }
        return transferImpl;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new OpenEstateXmlFormatPanel();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public String getTitle() {
        return "OpenEstate-XML";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setXmlLineBreak(AbstractXmlFormat.LineBreakMode.XHTML);
        this.setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        if (!super.prepareObjectForExport(l, estateImpl)) {
            return false;
        }
        estateImpl.getCustomValues().getValueMap().clear();
        return true;
    }

    @Override
    protected void writeXmlObject(TransferImpl transferImpl, Writer writer) throws IOException, JAXBException {
        try {
            AbstractXmlFormat.LineBreakMode lineBreakMode = this.getXmlLineBreak();
            String string = lineBreakMode != null ? lineBreakMode.getSeparator() : null;
            OpenEstateUtils.serializeToXML((SerializableXmlElement)transferImpl, (Writer)writer, (boolean)true, (String)"UTF-8", (String)string);
        }
        catch (DocumentException documentException) {
            throw new IOException("Can't write OpenEstate-XML!", documentException);
        }
    }
}

