/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.expose.PdfDetailedExpose;
import com.openindex.openestate.tool.agency.gui.ExposeHorizontalAlignRenderer;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.ColorPickButton;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class PdfDetailedExposePanel
extends AbstractExposePanel<PdfDetailedExpose> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfDetailedExposePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(PdfDetailedExposePanel.class);
    private static final String AREA_TABLE_ID = "PdfDetailedExposePanel.AreaTable";
    private ValidationHandler validationHandler;
    private JTabbedPane tabbedPane;
    private GeneralTab generalTab;
    private AbstractExposePanel.HeaderAndFooterTab headerAndFooterTab;
    private ContentTab contentTab;
    private AbstractExposePanel.EncryptionTab encryptionTab;

    public PdfDetailedExposePanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.tabbedPane = new JTabbedPane();
        this.generalTab = (GeneralTab)ImmoToolUtils.addTab((AbstractTab)new GeneralTab(), (JTabbedPane)this.tabbedPane);
        this.headerAndFooterTab = (AbstractExposePanel.HeaderAndFooterTab)ImmoToolUtils.addTab((AbstractTab)new AbstractExposePanel.HeaderAndFooterTab(), (JTabbedPane)this.tabbedPane);
        this.contentTab = (ContentTab)ImmoToolUtils.addTab((AbstractTab)new ContentTab(), (JTabbedPane)this.tabbedPane);
        this.encryptionTab = (AbstractExposePanel.EncryptionTab)ImmoToolUtils.addTab((AbstractTab)new AbstractExposePanel.EncryptionTab(), (JTabbedPane)this.tabbedPane);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add(this.tabbedPane, "Center");
    }

    private void doAreaMoveDown() {
        if (this.contentTab.areaTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.contentTab.areaTable.getSelectedRow();
        if (n + 1 < this.contentTab.areaTable.getRowCount()) {
            this.contentTab.areaTable.moveRow(n, n + 1);
            this.contentTab.areaTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }
    }

    private void doAreaMoveUp() {
        if (this.contentTab.areaTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.contentTab.areaTable.getSelectedRow();
        if (n > 0) {
            this.contentTab.areaTable.moveRow(n, n - 1);
            this.contentTab.areaTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }
    }

    private void doTemplateSelect() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18N.tr("Select a PDF file."));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
            }

            @Override
            public String getDescription() {
                return I18N.tr("PDF files") + " (*.pdf)";
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        this.generalTab.templateFileField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
    }

    @Override
    public boolean isTemplateSelected() {
        return this.generalTab.templateField != null && this.generalTab.templateField.isSelected();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(PdfDetailedExpose pdfDetailedExpose) {
        this.generalTab.load(pdfDetailedExpose);
        this.headerAndFooterTab.load(pdfDetailedExpose);
        this.contentTab.load(pdfDetailedExpose);
        this.encryptionTab.load(pdfDetailedExpose);
        this.validationHandler.init();
    }

    @Override
    public void save(PdfDetailedExpose pdfDetailedExpose) {
        this.generalTab.save(pdfDetailedExpose);
        this.headerAndFooterTab.save(pdfDetailedExpose);
        this.contentTab.save(pdfDetailedExpose);
        this.encryptionTab.save(pdfDetailedExpose);
    }

    private class TemplateSelectAction
    extends AbstractI18nAction {
        private TemplateSelectAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDetailedExposePanel.this.doTemplateSelect();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("select")));
            this.setShortDescription(I18N.tr("Select a custom PDF template from your harddisk."));
        }
    }

    private class AreaMoveUpAction
    extends AbstractI18nAction {
        private AreaMoveUpAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_up.png", (int)16));
            this.setName("");
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDetailedExposePanel.this.doAreaMoveUp();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move up the selected area."));
        }
    }

    private class AreaMoveDownAction
    extends AbstractI18nAction {
        private AreaMoveDownAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_down.png", (int)16));
            this.setName("");
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDetailedExposePanel.this.doAreaMoveDown();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move down the selected area."));
        }
    }

    private static class AreaTableRow
    extends AbstractTable.Row {
        private final PdfDetailedExpose.Area area;
        private boolean enabled;

        private AreaTableRow(PdfDetailedExpose.Area area, boolean bl) {
            this.area = area;
            this.enabled = bl;
        }

        public PdfDetailedExpose.Area getArea() {
            return this.area;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof AreaTableColumn) {
                return this.getValueForArea((AreaTableColumn)column);
            }
            return null;
        }

        private Object getValueForArea(AreaTableColumn areaTableColumn) {
            switch (areaTableColumn) {
                case AREA: {
                    return this.area;
                }
                case ENABLED: {
                    return this.enabled;
                }
            }
            return null;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (AreaTableColumn.ENABLED.equals(column)) {
                this.enabled = Boolean.TRUE.equals(object);
            }
        }
    }

    private static enum AreaTableColumn implements AbstractTable.Column
    {
        ENABLED,
        AREA;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case AREA: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ENABLED: {
                    return Boolean.class;
                }
                case AREA: {
                    return PdfDetailedExpose.Area.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ENABLED: {
                    return I18N.tr("active");
                }
                case AREA: {
                    return I18N.tr("expos\u00e9 area");
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private final class AreaTable
    extends AbstractTable<AreaTableRow, AbstractTable.Model<AreaTableRow>> {
        private AreaTable() {
            super(PdfDetailedExposePanel.AREA_TABLE_ID);
        }

        protected void doSelect() {
            int n = this.getSelectedRow();
            if (n < 0) {
                PdfDetailedExposePanel.this.contentTab.areaUpAction.setEnabled(false);
                PdfDetailedExposePanel.this.contentTab.areaDownAction.setEnabled(false);
            } else {
                PdfDetailedExposePanel.this.contentTab.areaUpAction.setEnabled(n > 0);
                PdfDetailedExposePanel.this.contentTab.areaDownAction.setEnabled(n + 1 < this.getRowCount());
            }
        }

        private PdfDetailedExpose.Area getAreaAt(int n) {
            AreaTableRow areaTableRow = (AreaTableRow)this.getRow(n);
            return areaTableRow != null ? areaTableRow.getArea() : null;
        }

        protected void init() {
            this.setSingleSelection();
            this.setSortable(false);
            this.setEditable(true);
            this.setColumnControlVisible(false);
            super.init();
        }

        private boolean isEnabledAt(int n) {
            AreaTableRow areaTableRow = (AreaTableRow)this.getRow(n);
            return areaTableRow != null && areaTableRow.isEnabled();
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(AreaTableColumn.values()));
        }

        public void setEnabledAt(int n, Boolean bl) {
            AreaTableRow areaTableRow = (AreaTableRow)this.getRow(n);
            if (areaTableRow != null) {
                areaTableRow.setEnabled(bl);
            }
        }
    }

    private class GeneralTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JXTitledSeparator templateTitle;
        private JLabel optionsLabel;
        private JLabel formatLabel;
        private JComboBox<AbstractExpose.Orientation> formatField;
        private JLabel resolutionLabel;
        private JComboBox<AbstractExposePanel.Resolution> resolutionField;
        private JLabel localeLabel;
        private LocaleComboBox localeField;
        private JLabel templateLabel;
        private JCheckBox templateField;
        private JTextField templateFileField;
        private JButton templateButton;
        private JCheckBox numberedHeadlinesField;
        private JLabel termsLabel;
        private JSpinner termsSizeField;
        private JLabel publishAddressLabel;
        private JComboBox<PublishingMode> publishAddressField;
        private JLabel imageGalleryLabel;
        private JComboBox<PdfDetailedExpose.GalleryMode> imageGalleryField;
        private JCheckBox imageSeparatePanoramasField;
        private JCheckBox imageSeparatePlansField;
        private JCheckBox imageUnpublishedField;
        private JCheckBox linkUnpublishedField;

        private GeneralTab() {
            this.build();
        }

        /*
         * WARNING - void declaration
         */
        private void build() {
            void var4_12;
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.templateTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.optionsLabel = new JLabel();
            this.localeLabel = new JLabel();
            this.localeField = new LocaleComboBox(AbstractExpose.getSupportedLocales(), true);
            this.resolutionLabel = new JLabel();
            this.resolutionField = new JComboBox();
            this.resolutionField.setRenderer((ListCellRenderer<AbstractExposePanel.Resolution>)new DefaultListCellRenderer((Renderer)new AbstractExposePanel.ResolutionRenderer()));
            this.resolutionField.addItem(null);
            for (AbstractExposePanel.Resolution enum_ : AbstractExposePanel.Resolution.values()) {
                this.resolutionField.addItem(enum_);
            }
            this.resolutionField.setSelectedItem(null);
            this.formatLabel = new JLabel();
            this.formatField = new JComboBox();
            this.formatField.setRenderer((ListCellRenderer<AbstractExpose.Orientation>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (Enum enum_ : AbstractExpose.Orientation.values()) {
                this.formatField.addItem((AbstractExpose.Orientation)enum_);
            }
            this.templateLabel = new JLabel();
            this.templateField = new JCheckBox();
            this.templateField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralTab.this.setTemplateEnabled(GeneralTab.this.templateField.isSelected());
                }
            });
            this.templateButton = new JButton((Action)((Object)new TemplateSelectAction()));
            this.templateFileField = new JTextField();
            this.templateFileField.setEditable(false);
            this.publishAddressLabel = new JLabel();
            this.publishAddressField = new JComboBox();
            this.publishAddressField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (Enum enum_ : PublishingMode.values()) {
                this.publishAddressField.addItem((PublishingMode)enum_);
            }
            this.termsLabel = new JLabel();
            this.termsSizeField = new JSpinner(new SpinnerNumberModel(10, 1, 30, 1));
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            jPanel.add(this.termsSizeField);
            jPanel.add(new JLabel(" pt"));
            this.imageGalleryLabel = new JLabel();
            this.imageGalleryField = new JComboBox();
            this.imageGalleryField.setRenderer((ListCellRenderer<PdfDetailedExpose.GalleryMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            DefaultFormBuilder defaultFormBuilder = PdfDetailedExpose.GalleryMode.values();
            int n = ((PdfDetailedExpose.GalleryMode[])defaultFormBuilder).length;
            boolean bl = false;
            while (var4_12 < n) {
                PdfDetailedExpose.GalleryMode galleryMode = defaultFormBuilder[var4_12];
                this.imageGalleryField.addItem(galleryMode);
                ++var4_12;
            }
            this.numberedHeadlinesField = new JCheckBox();
            this.imageSeparatePlansField = new JCheckBox();
            this.imageSeparatePanoramasField = new JCheckBox();
            this.imageUnpublishedField = new JCheckBox();
            this.linkUnpublishedField = new JCheckBox();
            PdfDetailedExposePanel.this.validationHandler.putRule((JComponent)this.localeField, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.localeField));
            defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.localeLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.localeField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.formatLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.formatField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.resolutionLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.resolutionField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.publishAddressLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.publishAddressField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.termsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)jPanel).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.imageGalleryLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.imageGalleryField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.imageSeparatePlansField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.imageSeparatePanoramasField).xyw(3, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.imageUnpublishedField).xyw(3, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.linkUnpublishedField).xyw(3, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.numberedHeadlinesField).xyw(3, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.row(), 5);
            defaultFormBuilder.add((Component)this.templateTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.templateLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.templateField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.templateFileField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.templateButton).xy(5, defaultFormBuilder.row());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.setTemplateSelected(false);
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("general"));
        }

        public void load(PdfDetailedExpose pdfDetailedExpose) {
            block3: {
                Locale locale;
                Object object;
                int n;
                block2: {
                    int n2;
                    this.formatField.setSelectedItem((Object)(pdfDetailedExpose.getOrientation() != null ? pdfDetailedExpose.getOrientation() : AbstractExpose.Orientation.PORTRAIT));
                    this.publishAddressField.setSelectedItem((Object)pdfDetailedExpose.getPublishAddress());
                    this.numberedHeadlinesField.setSelected(pdfDetailedExpose.isBodyHeadNumbered());
                    this.imageGalleryField.setSelectedItem((Object)pdfDetailedExpose.getGalleryMode());
                    this.imageSeparatePlansField.setSelected(Boolean.TRUE.equals(pdfDetailedExpose.isGallerySeparatePlans()));
                    this.imageSeparatePanoramasField.setSelected(Boolean.TRUE.equals(pdfDetailedExpose.isGallerySeparatePanoramas()));
                    this.imageUnpublishedField.setSelected(Boolean.TRUE.equals(pdfDetailedExpose.isGalleryShowUnpublishedImages()));
                    this.linkUnpublishedField.setSelected(Boolean.TRUE.equals(pdfDetailedExpose.isShowUnpublishedLinks()));
                    this.resolutionField.setSelectedItem(null);
                    int n3 = pdfDetailedExpose.getResolution();
                    AbstractExposePanel.Resolution[] resolutionArray = AbstractExposePanel.Resolution.values();
                    int n4 = resolutionArray.length;
                    for (n = 0; n < n4; ++n) {
                        object = resolutionArray[n];
                        if (object.getValue() != n3) continue;
                        this.resolutionField.setSelectedItem(object);
                        break;
                    }
                    this.termsSizeField.setValue((n2 = pdfDetailedExpose.getTermsTextSize()) > 0 ? n2 : 10);
                    locale = pdfDetailedExpose.getLocale();
                    this.localeField.setSelectedIndex(0);
                    if (locale != null) break block2;
                    if (this.localeField.getItemCount() <= 1) break block3;
                    this.localeField.setSelectedIndex(1);
                    break block3;
                }
                for (n = 1; n < this.localeField.getItemCount(); ++n) {
                    object = this.localeField.getLocaleAt(n);
                    if (!((Locale)object).getLanguage().equals(locale.getLanguage())) continue;
                    this.localeField.setSelectedIndex(n);
                    break;
                }
            }
            this.setTemplateSelected(pdfDetailedExpose.isTemplate());
        }

        public void save(PdfDetailedExpose pdfDetailedExpose) {
            File file;
            pdfDetailedExpose.setOrientation((AbstractExpose.Orientation)((Object)this.formatField.getSelectedItem()));
            pdfDetailedExpose.setLocale(this.localeField.getSelectedLocale());
            pdfDetailedExpose.setPublishAddress((PublishingMode)((Object)this.publishAddressField.getSelectedItem()));
            pdfDetailedExpose.setTermsTextSize(((Number)this.termsSizeField.getValue()).intValue());
            pdfDetailedExpose.setBodyHeadNumbered(this.numberedHeadlinesField.isSelected());
            pdfDetailedExpose.setGalleryMode((PdfDetailedExpose.GalleryMode)((Object)this.imageGalleryField.getSelectedItem()));
            pdfDetailedExpose.setGallerySeparatePlans(this.imageSeparatePlansField.isSelected());
            pdfDetailedExpose.setGallerySeparatePanoramas(this.imageSeparatePanoramasField.isSelected());
            pdfDetailedExpose.setGalleryShowUnpublishedImages(this.imageUnpublishedField.isSelected());
            pdfDetailedExpose.setShowUnpublishedLinks(this.linkUnpublishedField.isSelected());
            AbstractExposePanel.Resolution resolution = (AbstractExposePanel.Resolution)((Object)this.resolutionField.getSelectedItem());
            pdfDetailedExpose.setResolution(resolution != null ? resolution.getValue() : 0);
            String string = this.templateFileField.getText().trim();
            pdfDetailedExpose.setTemplate(this.templateField.isSelected());
            if (string.length() > 0 && (file = new File(string)).isFile()) {
                pdfDetailedExpose.setTemporaryTemplate(new File(string));
            }
        }

        private void setTemplateEnabled(boolean bl) {
            this.templateButton.setEnabled(bl);
            this.templateFileField.setEnabled(bl);
        }

        private void setTemplateSelected(boolean bl) {
            this.templateField.setSelected(bl);
            this.setTemplateEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general options")));
            this.localeLabel.setText(StringUtils.capitalize((String)I18N.tr("language")) + ":");
            this.localeField.setToolTipText(I18N.tr("Select the language for the generated document."));
            this.formatLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
            this.formatField.setToolTipText(I18N.tr("Select a page format for the generated document."));
            this.resolutionLabel.setText(StringUtils.capitalize((String)I18N.tr("resolution")) + ":");
            this.resolutionField.setToolTipText(I18N.tr("Select a resolution for the exported images. A higher resolution leads to better quality and bigger file size."));
            this.publishAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
            this.publishAddressField.setToolTipText(I18N.tr("Use this field to specify, how to deal with addresses in the generated document."));
            this.termsLabel.setText(StringUtils.capitalize((String)I18N.tr("terms font")) + ":");
            this.termsSizeField.setToolTipText(I18N.tr("Select the font-size, that should be used for the terms text."));
            this.imageGalleryLabel.setText(StringUtils.capitalize((String)I18N.tr("gallery")) + ":");
            this.imageGalleryField.setToolTipText(I18N.tr("Use this field to specify, how to deal with images in the generated document."));
            this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("options")) + ":");
            this.numberedHeadlinesField.setText(I18N.tr("Display headlines with numbering."));
            this.numberedHeadlinesField.setToolTipText(I18N.tr("Enable this option to display headlines with numbering."));
            this.imageSeparatePlansField.setText(I18N.tr("Show groundplans & maps separately."));
            this.imageSeparatePlansField.setToolTipText(I18N.tr("Enable this option, to display groundplans & maps outside the gallery with one image per page."));
            this.imageSeparatePanoramasField.setText(I18N.tr("Show panoramas separately."));
            this.imageSeparatePanoramasField.setToolTipText(I18N.tr("Enable this option, to show panorama images outside the gallery with one image per page."));
            this.imageUnpublishedField.setText(I18N.tr("Show unpublished images."));
            this.imageUnpublishedField.setToolTipText(I18N.tr("Enable this option, to show unpublished images in the generated document."));
            this.linkUnpublishedField.setText(I18N.tr("Show unpublished web links."));
            this.linkUnpublishedField.setToolTipText(I18N.tr("Enable this option, to show unpublished web links in the generated document."));
            this.templateTitle.setTitle(StringUtils.capitalize((String)I18N.tr("template for PDF generation")));
            this.templateLabel.setText(I18N.tr("PDF template") + ":");
            this.templateField.setText(I18N.tr("Use a customised PDF template."));
            this.templateField.setToolTipText(I18N.tr("Enable this option, to use a customised PDF template for the generated document."));
            this.templateFileField.setToolTipText(I18N.tr("The selected PDF file will be saved permanently into the database."));
        }
    }

    private class ContentTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JLabel alignmentLabel;
        private JLabel colorsLabel;
        private ColorPickButton borderColorField;
        private ColorPickButton bodyHeadBgColorField;
        private ColorPickButton bodyHeadFgColorField;
        private ColorPickButton bodyTextBgColorField;
        private ColorPickButton bodyTextFgColorField;
        private JComboBox<AbstractExpose.HorizontalAlign> bodyTextAlignmentField;
        private JXTitledSeparator areaTitle;
        private AreaTable areaTable;
        private AbstractI18nAction areaUpAction;
        private AbstractI18nAction areaDownAction;

        private ContentTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.areaTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.alignmentLabel = new JLabel();
            this.colorsLabel = new JLabel();
            this.borderColorField = new ColorPickButton();
            this.bodyHeadBgColorField = new ColorPickButton();
            this.bodyHeadFgColorField = new ColorPickButton();
            this.bodyTextBgColorField = new ColorPickButton();
            this.bodyTextFgColorField = new ColorPickButton();
            this.bodyTextAlignmentField = new JComboBox();
            this.bodyTextAlignmentField.setRenderer((ListCellRenderer<AbstractExpose.HorizontalAlign>)new DefaultListCellRenderer((Renderer)new ExposeHorizontalAlignRenderer()));
            for (AbstractExpose.HorizontalAlign horizontalAlign : AbstractExpose.HorizontalAlign.values()) {
                this.bodyTextAlignmentField.addItem(horizontalAlign);
            }
            this.areaUpAction = new AreaMoveUpAction();
            this.areaDownAction = new AreaMoveDownAction();
            this.areaTable = new AreaTable();
            for (PdfDetailedExpose.Area area : PdfDetailedExpose.Area.values()) {
                this.areaTable.addRow(new AreaTableRow(area, true));
            }
            this.areaTable.packAll();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.areaTitle, (Action[])new Action[]{this.areaUpAction, this.areaDownAction});
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.areaTable));
            jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.alignmentLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.bodyTextAlignmentField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.colorsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyTextFgColorField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.bodyTextBgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyHeadFgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyHeadBgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.borderColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            this.setLayout(new BorderLayout(5, 5));
            this.add(defaultFormBuilder.getPanel(), "North");
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("content"));
        }

        public void load(PdfDetailedExpose pdfDetailedExpose) {
            this.bodyHeadBgColorField.setColor(pdfDetailedExpose.getBodyHeadBgColor());
            this.bodyHeadFgColorField.setColor(pdfDetailedExpose.getBodyHeadFgColor());
            this.bodyTextBgColorField.setColor(pdfDetailedExpose.getBodyTextBgColor());
            this.bodyTextFgColorField.setColor(pdfDetailedExpose.getBodyTextFgColor());
            this.borderColorField.setColor(pdfDetailedExpose.getBorderColor());
            this.bodyTextAlignmentField.setSelectedItem((Object)pdfDetailedExpose.getBodyTextAlignment());
            this.areaTable.clearSelection();
            PdfDetailedExpose.Area[] areaArray = pdfDetailedExpose.getAreas();
            for (int i = 0; i < this.areaTable.getRowCount(); ++i) {
                PdfDetailedExpose.Area area = this.areaTable.getAreaAt(i);
                this.areaTable.setEnabledAt(i, ArrayUtils.contains((Object[])areaArray, (Object)((Object)area)));
            }
        }

        public void save(PdfDetailedExpose pdfDetailedExpose) {
            pdfDetailedExpose.setBodyHeadBgColor(this.bodyHeadBgColorField.getColor());
            pdfDetailedExpose.setBodyHeadFgColor(this.bodyHeadFgColorField.getColor());
            pdfDetailedExpose.setBodyTextBgColor(this.bodyTextBgColorField.getColor());
            pdfDetailedExpose.setBodyTextFgColor(this.bodyTextFgColorField.getColor());
            pdfDetailedExpose.setBorderColor(this.borderColorField.getColor());
            pdfDetailedExpose.setBodyTextAlignment((AbstractExpose.HorizontalAlign)((Object)this.bodyTextAlignmentField.getSelectedItem()));
            ArrayList<PdfDetailedExpose.Area> arrayList = new ArrayList<PdfDetailedExpose.Area>();
            for (int i = 0; i < this.areaTable.getRowCount(); ++i) {
                boolean bl = this.areaTable.isEnabledAt(i);
                if (!Boolean.TRUE.equals(bl)) continue;
                arrayList.add(this.areaTable.getAreaAt(i));
            }
            pdfDetailedExpose.setAreas(arrayList.toArray(new PdfDetailedExpose.Area[0]));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("content")));
            this.alignmentLabel.setText(StringUtils.capitalize((String)I18N.tr("orientation")) + ":");
            this.bodyTextAlignmentField.setToolTipText(I18N.tr("Set alignment of texts."));
            this.colorsLabel.setText(StringUtils.capitalize((String)I18N.tr("colors")) + ":");
            this.borderColorField.setText(I18N.tr("color for lines & borders"));
            this.borderColorField.setToolTipText(I18N.tr("This color is used for borders and lines."));
            this.bodyHeadBgColorField.setText(I18N.tr("background color of headlines"));
            this.bodyHeadBgColorField.setToolTipText(I18N.tr("This color is used as headline background."));
            this.bodyHeadFgColorField.setText(I18N.tr("foreground color of headlines"));
            this.bodyHeadFgColorField.setToolTipText(I18N.tr("This color is used for headline texts."));
            this.bodyTextBgColorField.setText(I18N.tr("background color of texts"));
            this.bodyTextBgColorField.setToolTipText(I18N.tr("This color is used as text background."));
            this.bodyTextFgColorField.setText(I18N.tr("foreground color of texts"));
            this.bodyHeadFgColorField.setToolTipText(I18N.tr("This color is used for texts."));
            this.areaTitle.setTitle(StringUtils.capitalize((String)I18N.tr("arrange the main areas")));
        }
    }
}

