/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.gui;

import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AreaValueRenderer
extends AbstractRenderer<AreaValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaValueRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(AreaValueRenderer.class);
    private final NumberFormat format;

    public AreaValueRenderer() {
        this(null, null);
    }

    public AreaValueRenderer(String string) {
        this(string, null);
    }

    public AreaValueRenderer(NumberFormat numberFormat) {
        this(null, numberFormat);
    }

    public AreaValueRenderer(String string, NumberFormat numberFormat) {
        super(string);
        if (numberFormat != null) {
            this.format = numberFormat;
        } else {
            this.format = NumberFormat.getNumberInstance(Locale.getDefault());
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(2);
        }
    }

    public void render(AreaValue areaValue, JLabel jLabel) {
        jLabel.setHorizontalAlignment(4);
        if (areaValue != null) {
            jLabel.setText(areaValue.getUnit() != null ? this.format.format(areaValue) + " " + areaValue.getUnit().write() : this.format.format(areaValue));
        } else {
            jLabel.setText(this.getEmptyText());
        }
    }
}

