/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.immoxml.ImmoXmlReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.immoxml.ImmoXmlDocument;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.ImmoXmlVersion;
import org.openestate.io.immoxml.xml.Aktion;
import org.openestate.io.immoxml.xml.Anbieter;
import org.openestate.io.immoxml.xml.Immobilie;
import org.openestate.io.immoxml.xml.Immoxml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmoXmlImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlImport.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmoXmlImport.class);
    private static final String NAME = "immoxml";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "ImmoXML";
    }

    @Override
    public String[] getVersions() {
        return new String[]{ImmoXmlUtils.VERSION.toReadableVersion()};
    }

    @Override
    public boolean isIncrementalTransferSupported() {
        return true;
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        try {
            ImmoXmlImportReader immoXmlImportReader = new ImmoXmlImportReader();
            immoXmlImportReader.setOpenEstateLanguage(settings.getLanguage());
            immoXmlImportReader.setImportRemovedObjects(settings.isImportRemovedObjects());
            return immoXmlImportReader.readTransfer(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't load parser!", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException("Can't parse document!", sAXException);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't process document!", jAXBException);
        }
    }

    @Override
    public String validateFile(File file) throws IOException {
        ImmoXmlDocument immoXmlDocument = null;
        try {
            immoXmlDocument = ImmoXmlUtils.createDocument((File)file);
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        if (immoXmlDocument == null) {
            throw new IOException("The file does not contain a supported document.");
        }
        ImmoXmlVersion immoXmlVersion = immoXmlDocument.getDocumentVersion();
        return immoXmlVersion != null ? immoXmlVersion.toReadableVersion() : null;
    }

    public static class ImmoXmlImportReader
    extends ImmoXmlReader {
        private boolean importRemovedObjects = false;

        public ImmoXmlImportReader() {
            ImmoXmlImportReader.initJAXB();
        }

        protected EstateImpl convertImmobilie(Immobilie immobilie, Map<String, AgentContactImpl> map) {
            EstateImpl estateImpl = super.convertImmobilie(immobilie, map);
            if (estateImpl == null) {
                return null;
            }
            return estateImpl;
        }

        protected TransferImpl convertToTransfer(Immoxml immoxml) {
            if (this.isImportRemovedObjects()) {
                for (Anbieter anbieter : immoxml.getAnbieter()) {
                    for (Immobilie immobilie : anbieter.getImmobilie()) {
                        Aktion.AktionArt aktionArt = immobilie.getVerwaltungTechn() != null && immobilie.getVerwaltungTechn().getAktion() != null ? immobilie.getVerwaltungTechn().getAktion().getAktionart() : null;
                        if (!Aktion.AktionArt.DELETE.equals(aktionArt)) continue;
                        immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
                    }
                }
            }
            return super.convertToTransfer(immoxml);
        }

        public static void initJAXB() {
            AgencyPluginUtils.initJAXB(ImmoXmlUtils.class);
        }

        public boolean isImportRemovedObjects() {
            return this.importRemovedObjects;
        }

        public void setImportRemovedObjects(boolean bl) {
            this.importRemovedObjects = bl;
        }
    }
}

