/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.db.DbGeoArea;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GeoData {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoData.class);
    private static final I18n I18N = I18nFactory.getI18n(GeoData.class);
    private String countryCode;
    private String region;
    private final Map<Long, DbGeoArea> geoAreas;

    public GeoData(String string, String string2) {
        this.countryCode = string;
        this.region = string2;
        this.geoAreas = new HashMap<Long, DbGeoArea>();
    }

    public DbGeoArea getArea(long l) {
        return this.geoAreas.get(l);
    }

    public Map<Long, DbGeoArea> getAreaMap() {
        return Collections.unmodifiableMap(this.geoAreas);
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Iterable<Long> getGeoDbIds() {
        return this.geoAreas.keySet();
    }

    public String getRegion() {
        return this.region;
    }

    public void putArea(long l, DbGeoArea dbGeoArea) {
        this.geoAreas.put(l, dbGeoArea);
    }

    public void setCountryCode(String string) {
        this.countryCode = string;
    }

    public void setRegion(String string) {
        this.region = string;
    }
}

