-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 11 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Remove 'attrib_group' from table 'openestate_objects_attribs'
-- Remove 'attrib_group' from table 'openestate_searches_attribs'
-- Rebuild view 'view_openestate_objects_attribs'
-- Rebuild view 'view_openestate_searches_attribs'
-- Rebuild procedure 'remove_openestate_objects_attribs'
-- Rebuild procedure 'remove_openestate_searches_attribs'
-- Rebuild procedure 'save_openestate_objects_attribs'
-- Rebuild procedure 'save_openestate_searches_attribs'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Remove 'attrib_group' from table 'openestate_objects_attribs'
-- -----------------------------------------------------
\c true
ALTER TABLE openestate_objects_attribs
  DROP PRIMARY KEY;
\c false
ALTER TABLE openestate_objects_attribs
  ALTER COLUMN attrib_group SET NULL;
UPDATE openestate_objects_attribs
  SET attrib_group = NULL, attrib_name = attrib_group || '_' || attrib_name
  WHERE attrib_group IS NOT NULL;
DROP VIEW
  IF EXISTS view_openestate_objects_attribs;
DROP PROCEDURE
  IF EXISTS remove_openestate_objects_attribs;
DROP PROCEDURE
  IF EXISTS save_openestate_objects_attribs;
ALTER TABLE openestate_objects_attribs
  DROP COLUMN attrib_group;
ALTER TABLE openestate_objects_attribs
  ADD PRIMARY KEY (object_id, language_id, attrib_name);

-- -----------------------------------------------------
-- Remove 'attrib_group' from table 'openestate_searches_attribs'
-- -----------------------------------------------------
ALTER TABLE openestate_searches_attribs
  ALTER COLUMN attrib_group SET NULL;
UPDATE openestate_searches_attribs
  SET attrib_group = NULL, attrib_name = attrib_group || '_' || attrib_name
  WHERE attrib_group IS NOT NULL;
DROP VIEW
  IF EXISTS view_openestate_searches_attribs;
DROP PROCEDURE
  IF EXISTS remove_openestate_searches_attribs;
DROP PROCEDURE
  IF EXISTS save_openestate_searches_attribs;
ALTER TABLE openestate_searches_attribs
  DROP COLUMN attrib_group;

-- -----------------------------------------------------
-- Rebuild view 'view_openestate_objects_attribs'
-- -----------------------------------------------------
CREATE VIEW view_openestate_objects_attribs AS
  SELECT * FROM openestate_objects_attribs
  WHERE object_id IN (SELECT object_id FROM view_openestate_objects);

GRANT SELECT
  ON view_openestate_objects_attribs
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Rebuild view 'view_openestate_searches_attribs'
-- -----------------------------------------------------
CREATE VIEW view_openestate_searches_attribs AS
  SELECT * FROM openestate_searches_attribs
  WHERE search_id IN (SELECT search_id FROM view_openestate_searches);

GRANT SELECT
  ON view_openestate_searches_attribs
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Rebuild procedure 'remove_openestate_objects_attribs'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_openestate_objects_attribs(
    val_object_id BIGINT,
    val_language_id BIGINT,
    val_attrib_name VARCHAR(255)
  )
  SPECIFIC remove_openestate_objects_attribs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_agency_objects( val_object_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Attribut in einer Sprache entfernen
    IF val_language_id IS NOT NULL AND val_attrib_name IS NOT NULL THEN

      DELETE
        FROM openestate_objects_attribs
        WHERE object_id = val_object_id
        AND language_id = val_language_id
        AND attrib_name = val_attrib_name;

    -- Attribut in allen Sprachen entfernen
    ELSEIF val_attrib_name IS NOT NULL THEN

      DELETE
        FROM openestate_objects_attribs
        WHERE object_id = val_object_id
        AND attrib_name = val_attrib_name;

    -- Attribute in allen Sprache entfernen
    ELSEIF val_language_id IS NOT NULL THEN

      DELETE
        FROM openestate_objects_attribs
        WHERE object_id = val_object_id
        AND language_id = val_language_id;

    -- Alle Attribute entfernen
    ELSE

      DELETE
        FROM openestate_objects_attribs
        WHERE object_id = val_object_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_openestate_objects_attribs
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Rebuild procedure 'remove_openestate_searches_attribs'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_openestate_searches_attribs( val_search_id BIGINT )
  SPECIFIC remove_openestate_searches_attribs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_search_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_agency_searches( val_search_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Kriterien entfernen
    DELETE
      FROM openestate_searches_attribs
      WHERE search_id = val_search_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_openestate_searches_attribs
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Rebuild procedure 'save_openestate_objects_attribs'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_openestate_objects_attribs(
    val_object_id BIGINT,
    val_language_id BIGINT,
    val_attrib_name VARCHAR(255),
    val_attrib_unit VARCHAR(25),
    val_value_text LONGVARCHAR,
    val_value_string VARCHAR(255),
    val_value_boolean BOOLEAN,
    val_value_numeric DECIMAL(15,2),
    val_value_numeric_base DECIMAL(15,2),
    val_value_date DATE,
    val_value_time TIME,
    val_value_datetime TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_openestate_objects_attribs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_objects(val_object_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Attribut speichern
    INSERT INTO openestate_objects_attribs (
      object_id,
      language_id,
      attrib_name,
      attrib_unit,
      value_text,
      value_string,
      value_boolean,
      value_numeric,
      value_numeric_base,
      value_date,
      value_time,
      value_datetime )
    VALUES (
      val_object_id,
      val_language_id,
      val_attrib_name,
      val_attrib_unit,
      val_value_text,
      val_value_string,
      val_value_boolean,
      val_value_numeric,
      val_value_numeric_base,
      val_value_date,
      val_value_time,
      val_value_datetime );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_openestate_objects_attribs
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Rebuild procedure 'save_openestate_searches_attribs'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_openestate_searches_attribs(
    val_search_id BIGINT,
    val_attrib_name VARCHAR(255),
    val_attrib_equals VARCHAR(255),
    val_attrib_equals_like BOOLEAN,
    val_attrib_equals_case BOOLEAN,
    val_attrib_matches VARCHAR(255),
    val_attrib_numeric_min DECIMAL(15,2),
    val_attrib_numeric_max DECIMAL(15,2),
    val_attrib_numeric_unit VARCHAR(20),
    val_attrib_time_begin TIMESTAMP WITH TIME ZONE,
    val_attrib_time_end TIMESTAMP WITH TIME ZONE,
    val_attrib_order BIGINT
  )
  SPECIFIC save_openestate_searches_attribs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_search_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_searches(val_search_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Kriterium speichern
    INSERT INTO openestate_searches_attribs (
      search_id,
      attrib_name,
      attrib_equals,
      attrib_equals_like,
      attrib_equals_case,
      attrib_matches,
      attrib_numeric_min,
      attrib_numeric_max,
      attrib_numeric_unit,
      attrib_time_begin,
      attrib_time_end,
      attrib_order )
    VALUES (
      val_search_id,
      val_attrib_name,
      val_attrib_equals,
      val_attrib_equals_like,
      val_attrib_equals_case,
      val_attrib_matches,
      val_attrib_numeric_min,
      val_attrib_numeric_max,
      val_attrib_numeric_unit,
      val_attrib_time_begin,
      val_attrib_time_end,
      val_attrib_order );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_openestate_searches_attribs
  TO "IMMOTOOL";
