-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 3 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add table 'immotool_agency_objects_logs'
-- Add view 'view_immotool_agency_objects_logs'
-- Add procedure 'save_immotool_agency_objects_logs'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table immotool_agency_objects_logs
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_agency_objects_logs (
  log_id BIGINT NOT NULL,
  object_id BIGINT NOT NULL,
  PRIMARY KEY (log_id, object_id),
  FOREIGN KEY (log_id)
    REFERENCES immotool_logs(log_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (object_id)
    REFERENCES openestate_objects(object_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);


-- -----------------------------------------------------
-- View view_immotool_agency_objects_logs
-- -----------------------------------------------------
CREATE VIEW view_immotool_agency_objects_logs AS
  SELECT a.object_id, b.* FROM immotool_agency_objects_logs a
  INNER JOIN immotool_logs b ON ( a.log_id = b.log_id )
  WHERE a.object_id IN (SELECT object_id FROM view_openestate_objects);

GRANT SELECT
  ON view_immotool_agency_objects_logs
  TO "IMMOTOOL";


\.
-- -----------------------------------------------------
-- Procedure save_immotool_agency_objects_logs
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_agency_objects_logs(
  val_log_id BIGINT,
  val_object_id BIGINT )
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_objects( val_object_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Protokolleintrag aktualisieren
    DELETE FROM immotool_agency_objects_logs
      WHERE log_id = val_log_id;

    INSERT
      INTO immotool_agency_objects_logs (log_id, object_id)
      VALUES (val_log_id, val_object_id);

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_objects_logs
  TO "IMMOTOOL";
