-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 17 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'get_openestate_objects_id'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add function 'get_openestate_objects_id'
-- -----------------------------------------------------
DROP FUNCTION IF EXISTS get_openestate_objects_id;
\.
CREATE FUNCTION get_openestate_objects_id( val_public_id VARCHAR(255) )
  RETURNS BIGINT
  SPECIFIC get_openestate_objects_id
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE object_id BIGINT;

    -- Objekt-ID aus Objekt-Nr ermitteln
    SELECT object_id
      INTO object_id
      FROM openestate_objects
      WHERE object_public_id IS NOT NULL AND object_public_id = val_public_id;

    -- ID der ermittelten Immobilie zurückliefern
    RETURN object_id;
  END;
.;
GRANT EXECUTE
  ON FUNCTION get_openestate_objects_id
  TO "IMMOTOOL";
