-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 18 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'can_read_immotool_agency_contacts'
-- Add function 'can_read_immotool_agency_exports'
-- Add function 'can_read_immotool_agency_exposes'
-- Add function 'can_read_immotool_agency_objects'
-- Add function 'can_read_immotool_agency_searches'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Function can_read_immotool_agency_contacts
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_agency_contacts( val_contact_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_agency_contacts
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_contacts
      WHERE contact_id = val_contact_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_agency_exports
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_agency_exports( val_export_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_agency_exports
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_exports
      WHERE export_id = val_export_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_agency_exposes
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_agency_exposes( val_expose_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_agency_exposes
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_exposes
      WHERE expose_id = val_expose_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_agency_objects
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_agency_objects( val_object_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_agency_objects
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_objects
      WHERE object_id = val_object_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_agency_searches
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_agency_searches( val_search_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_agency_searches
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_searches
      WHERE search_id = val_search_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;