-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 7 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Convert attribute 'CONDITION.BUILD_YEAR' to numeric
-- Convert attribute 'CONDITION.REFURBISHMENT' to numeric
-- Convert attribute 'PRICES.PURCHASE_PRICE_ON_ANNUAL_RENTAL_INCOME' to numeric
-- Rename attribute 'CONDITION.REFURBISHMENT' to 'CONDITION.REFURBISHMENT_YEAR'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Convert attribute 'CONDITION.BUILD_YEAR' to numeric
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    value_numeric = CAST( value_string AS NUMERIC ),
    value_string = NULL
  WHERE
    attrib_group = 'CONDITION'
  AND
    attrib_name = 'BUILD_YEAR'
  AND
    value_string IS NOT NULL
  AND
    REGEXP_MATCHES( value_string, '\d+' );

DELETE FROM openestate_objects_attribs
  WHERE
    attrib_group = 'CONDITION'
  AND
    attrib_name = 'BUILD_YEAR'
  AND
    value_numeric IS NULL
  AND
    (value_string IS NULL OR NOT REGEXP_MATCHES( value_string, '\d+' ));


-- -----------------------------------------------------
-- Convert attribute 'CONDITION.REFURBISHMENT' to numeric
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    value_numeric = CAST( value_string AS NUMERIC ),
    value_string = NULL
  WHERE
    attrib_group = 'CONDITION'
  AND
    attrib_name = 'REFURBISHMENT'
  AND
    value_string IS NOT NULL
  AND
    REGEXP_MATCHES( value_string, '\d+' );

DELETE FROM openestate_objects_attribs
  WHERE
    attrib_group = 'CONDITION'
  AND
    attrib_name = 'REFURBISHMENT'
  AND
    value_numeric IS NULL
  AND
    (value_string IS NULL OR NOT REGEXP_MATCHES( value_string, '\d+' ));


-- -----------------------------------------------------
-- Convert attribute 'PRICES.PURCHASE_PRICE_ON_ANNUAL_RENTAL_INCOME' to numeric
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    value_numeric = CAST( value_string AS NUMERIC ),
    value_string = NULL
  WHERE
    attrib_group = 'PRICES'
  AND
    attrib_name = 'PURCHASE_PRICE_ON_ANNUAL_RENTAL_INCOME'
  AND
    value_string IS NOT NULL
  AND
    REGEXP_MATCHES( value_string, '\d+' );

DELETE FROM openestate_objects_attribs
  WHERE
    attrib_group = 'PRICES'
  AND
    attrib_name = 'PURCHASE_PRICE_ON_ANNUAL_RENTAL_INCOME'
  AND
    value_numeric IS NULL
  AND
    (value_string IS NULL OR NOT REGEXP_MATCHES( value_string, '\d+' ));


-- -----------------------------------------------------
-- Rename attribute 'CONDITION.REFURBISHMENT' to 'CONDITION.REFURBISHMENT_YEAR'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'REFURBISHMENT_YEAR'
  WHERE
    attrib_group = 'CONDITION'
  AND
    attrib_name = 'REFURBISHMENT';
