-- -----------------------------------------------------
-- Calender extensions to the Agency-Addon for OpenEstate-ImmoTool
-- routines for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_agency_objects_calendar_entries
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_agency_objects_calendar_entries(
    val_agency_object_id BIGINT,
    val_calendar_entry_id BIGINT
  )
  SPECIFIC remove_immotool_agency_objects_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    IF val_agency_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_calendar_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Lese-Rechte besitzt
    IF NOT is_admin() = TRUE THEN

      -- Lese-Rechte auf der Immobilie müssen vorliegen
      IF NOT can_read_immotool_agency_objects( val_agency_object_id ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

      -- Lese-Rechte auf dem Kalendereintrag müssen vorliegen
      IF NOT can_read_immotool_calendar_entries( val_calendar_entry_id ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

    END IF;

    -- Relation entfernen
    DELETE
      FROM immotool_agency_objects_calendar_entries
      WHERE agency_object_id = val_agency_object_id
      AND calendar_entry_id = val_calendar_entry_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_agency_objects_calendar_entries
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_agency_objects_calendar_entries
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_agency_objects_calendar_entries(
    val_agency_object_id BIGINT,
    val_calendar_entry_id BIGINT,
    val_relation_type VARCHAR(100),
    val_relation_notes LONGVARCHAR
  )
  SPECIFIC save_immotool_agency_objects_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC

    -- Relation ggf. entfernen
    CALL remove_immotool_agency_objects_calendar_entries( val_agency_object_id, val_calendar_entry_id );

    -- Relation einfügen
    INSERT INTO immotool_agency_objects_calendar_entries (
      agency_object_id,
      calendar_entry_id,
      relation_type,
      relation_notes )
    VALUES (
      val_agency_object_id,
      val_calendar_entry_id,
      val_relation_type,
      val_relation_notes );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_objects_calendar_entries
  TO "IMMOTOOL";
