-- -----------------------------------------------------
-- Contacts extensions to the Agency-Addon for OpenEstate-ImmoTool
-- update 4 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Rebuild 'view_immotool_agency_objects_contacts_entries'
-- Rebuild 'remove_immotool_agency_objects_contacts_entries'
-- Rebuild 'save_immotool_agency_objects_contacts_entries'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Rebuild 'view_immotool_agency_objects_contacts_entries'
-- -----------------------------------------------------
DROP VIEW IF EXISTS view_immotool_agency_objects_contacts_entries CASCADE;

CREATE VIEW view_immotool_agency_objects_contacts_entries AS
  SELECT * FROM immotool_agency_objects_contacts_entries
  WHERE agency_object_id IN (SELECT object_id FROM view_openestate_objects)
  AND contacts_entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);

GRANT SELECT
  ON view_immotool_agency_objects_contacts_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'remove_immotool_agency_objects_contacts_entries'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS remove_immotool_agency_objects_contacts_entries CASCADE;
\.
CREATE PROCEDURE remove_immotool_agency_objects_contacts_entries(
    val_agency_object_id BIGINT,
    val_contacts_entry_id BIGINT
  )
  SPECIFIC remove_immotool_agency_objects_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    IF val_agency_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_contacts_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Lese-Rechte besitzt
    IF NOT is_admin() = TRUE THEN

      -- Lese-Rechte auf der Immobilie müssen vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_agency_objects
        WHERE object_id = val_agency_object_id;
      IF NOT can_read( permissions, owner_uid, owner_gid ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

      -- Lese-Rechte auf dem Adresseintrag müssen vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_contacts_groups
        WHERE group_id IN (SELECT group_id FROM immotool_contacts_entries WHERE entry_id = val_contacts_entry_id);
      IF NOT can_read( permissions, owner_uid, owner_gid ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;
    END IF;

    -- Relation entfernen
    DELETE
      FROM immotool_agency_objects_contacts_entries
      WHERE agency_object_id = val_agency_object_id
      AND contacts_entry_id = val_contacts_entry_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_agency_objects_contacts_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'save_immotool_agency_objects_contacts_entries'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_agency_objects_contacts_entries CASCADE;
\.
CREATE PROCEDURE save_immotool_agency_objects_contacts_entries(
    val_agency_object_id BIGINT,
    val_contacts_entry_id BIGINT,
    val_relation_type VARCHAR(100),
    val_relation_notes LONGVARCHAR
  )
  SPECIFIC save_immotool_agency_objects_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC

    -- Relation ggf. entfernen
    CALL remove_immotool_agency_objects_contacts_entries( val_agency_object_id, val_contacts_entry_id );

    -- Relation einfügen
    INSERT INTO immotool_agency_objects_contacts_entries (
      agency_object_id,
      contacts_entry_id,
      relation_type,
      relation_notes )
    VALUES (
      val_agency_object_id,
      val_contacts_entry_id,
      val_relation_type,
      val_relation_notes );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_objects_contacts_entries
  TO "IMMOTOOL";
