/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryRelationPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.crm.CrmActivityViewTask;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.CrmPluginUtils;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.crm.extensions.ActivityViewExtension;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateTimeIntervalValidationListener;
import com.openindex.openestate.tool.gui.DefaultDateTimeField;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CrmActivityViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityViewPanel.class);
    private static final String CONTACTS_TABLE_ID = "CrmActivityViewPanel.ContactsTable";
    private DbCrmActivity currentActivity = null;
    private long nextActivityId = 0L;
    private long prevActivityId = 0L;
    private boolean mayEditActivity = false;
    private boolean mayRemoveActivity = false;
    private List<ActivityViewExtension> addons;
    private ActivityTab activityTab;
    private ContactsTab contactsTab;
    private NotesTab notesTab;
    private PermissionsTab permissionTab;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private CrmActivityViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(CrmPlugin.getResourceIcon("crm.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.activityTab = (ActivityTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ActivityTab(), (JTabbedPane)jTabbedPane);
        this.contactsTab = (ContactsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ContactsTab(), (JTabbedPane)jTabbedPane);
        try {
            for (ActivityViewExtension activityViewExtension : this.addons) {
                AbstractTab[] abstractTabArray = activityViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addon-panels!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.notesTab = (NotesTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesTab(), (JTabbedPane)jTabbedPane);
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionTab = (PermissionsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new PermissionsTab(), (JTabbedPane)jTabbedPane);
        }
    }

    public static CrmActivityViewPanel createTab() {
        CrmActivityViewPanel crmActivityViewPanel = new CrmActivityViewPanel();
        crmActivityViewPanel.setActivity(null, null);
        return crmActivityViewPanel;
    }

    public static CrmActivityViewPanel createTab(DbCrmActivity.Type type) {
        CrmActivityViewPanel crmActivityViewPanel = new CrmActivityViewPanel();
        crmActivityViewPanel.setActivity(null, type);
        return crmActivityViewPanel;
    }

    public static CrmActivityViewPanel createTab(DbCrmActivity dbCrmActivity) {
        CrmActivityViewPanel crmActivityViewPanel = new CrmActivityViewPanel();
        crmActivityViewPanel.setActivity(dbCrmActivity);
        return crmActivityViewPanel;
    }

    private void doContactsAdd() {
        this.contactsTab.tablePanel.contactsRelationForm.selectEmptyRelation();
    }

    private void doContactsRemove() {
        if (this.contactsTab.tablePanel.contactsTable.removeSelectedRows()) {
            this.contactsTab.tablePanel.contactsRelationForm.unselectRelation();
            this.contactsTab.tablePanel.updateTitle();
        }
    }

    private void doContactsEntrySubmit() {
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        if (!this.contactsTab.submitNewContact(dbContactsEntry)) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new ContactsEntrySubmitTask(dbContactsEntry));
    }

    private void doContactsEntryView() {
        int n = this.contactsTab.tablePanel.contactsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.contactsTab.tablePanel.contactsTable.getContactEntryIdAt(this.contactsTab.tablePanel.contactsTable.convertRowIndexToModel(n));
        new ContactsPlugin.EntryFormAction(l).actionPerformed(null);
    }

    private void doContactsRefresh() {
        try {
            this.contactsTab.load(this.currentActivity);
            ImmoToolUtils.executeTask((ImmoToolTask)new ContactsRefreshTask());
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload activity contacts!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload activity contacts!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doContactsShowActions(Component component, int n, int n2) {
        if (this.contactsTab.tablePanel.contactsTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new ContactsRemoveAction()));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.setIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
        jPopupMenu.add(jMenu);
        jMenu.add((Action)((Object)new ContactsEntryViewAction()));
        Object[] objectArray = this.contactsTab.tablePanel.contactsTable.getAddons();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Long[] longArray = null;
            if (longArray == null) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = this.contactsTab.tablePanel.contactsTable.getSelectedRows();
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[i];
                    int n5 = this.contactsTab.tablePanel.contactsTable.convertRowIndexToModel(n4);
                    arrayList.add(this.contactsTab.tablePanel.contactsTable.getContactEntryIdAt(n5));
                }
                longArray = arrayList.toArray(new Long[0]);
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                try {
                    objectArray2 = object.createActionMenuItems(immoToolProject, longArray, (JComponent)((Object)this));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load popup extension!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                if (ArrayUtils.isEmpty((Object[])objectArray2)) continue;
                for (Object object2 : objectArray2) {
                    jMenu.add((JMenuItem)object2);
                }
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    protected void doCopy() {
        if (!this.mayEditActivity) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doHelp() {
    }

    protected void doLoadInBackground(Connection connection) {
        DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
        this.nextActivityId = 0L;
        this.prevActivityId = 0L;
        try {
            long[] lArray = dbCrmActivityHandler.getActivityIds(connection);
            int n = ArrayUtils.indexOf((long[])lArray, (long)this.currentActivity.id);
            if (n > 0) {
                this.prevActivityId = lArray[n - 1];
            }
            if (n + 1 < lArray.length) {
                this.nextActivityId = lArray[n + 1];
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void doRefresh() {
        if (this.currentActivity != null && this.currentActivity.id > 0L) {
            this.setActivity(this.currentActivity);
            this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentActivity == null || this.currentActivity.id < 1L) {
            return;
        }
        if (!this.mayRemoveActivity) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove activity {0}?", (Object)("#" + this.currentActivity.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask(this.currentActivity.id));
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentActivity != null && this.currentActivity.id > 0L && CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentActivity != null && this.currentActivity.id > 0L && this.mayRemoveActivity));
        jPopupMenu.addSeparator();
        for (ActivityViewExtension activityViewExtension : this.addons) {
            Object[] objectArray = activityViewExtension.createActionMenuItems(this.currentActivity);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.add((Action)this.notesTab.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditActivity) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextActivityId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new CrmActivityViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.nextActivityId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevActivityId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new CrmActivityViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.prevActivityId, this));
        }
    }

    public long getCurrentActivityId() {
        return this.currentActivity != null ? this.currentActivity.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return CrmPlugin.getResourceIcon("crm.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentActivity == null || this.currentActivity.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new activity"));
        }
        return StringUtils.capitalize((String)I18N.tr("activity")) + " #" + this.currentActivity.id;
    }

    public String getTabTitle() {
        if (this.currentActivity == null || this.currentActivity.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new activity"));
        }
        return StringUtils.capitalize((String)I18N.tr("activity")) + " #" + this.currentActivity.id;
    }

    public String getTabToolTipText() {
        if (this.currentActivity == null || this.currentActivity.id < 1L) {
            return I18N.tr("Create a new activity.");
        }
        return I18N.tr("Edit activity {0}.", (Object)("#" + this.currentActivity.id));
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<ActivityViewExtension>();
        try {
            for (ActivityViewExtension activityViewExtension : CrmPluginUtils.getActivityViewExtensions()) {
                this.addons.add(activityViewExtension);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected boolean isLoadedInBackground() {
        return this.currentActivity != null && this.currentActivity.id > 0L;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditActivity);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextActivityId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevActivityId > 0L);
        this.contactsTab.tablePanel.createAction.setEnabled(bl);
        this.contactsTab.tablePanel.refreshAction.setEnabled(bl);
        this.contactsTab.tablePanel.showActionsAction.setEnabled(bl && this.contactsTab.tablePanel.contactsTable.getRowCount() > 0);
        if (this.contactsTab.formPanel != null) {
            this.contactsTab.formPanel.submitAction.setEnabled(bl);
        }
    }

    public void setActivity(DbCrmActivity dbCrmActivity) {
        this.setActivity(dbCrmActivity, null);
    }

    private void setActivity(DbCrmActivity dbCrmActivity, DbCrmActivity.Type type) {
        DbCrmActivity dbCrmActivity2 = this.currentActivity = dbCrmActivity != null ? dbCrmActivity : new DbCrmActivity();
        if (type != null) {
            this.currentActivity.type = type;
        }
        this.prevActivityId = 0L;
        this.nextActivityId = 0L;
        this.mayEditActivity = CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT);
        this.mayRemoveActivity = CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_REMOVE);
        if (this.currentActivity.permission != null) {
            AbstractMainViewTab[] abstractMainViewTabArray = ImmoToolProject.getAppInstance().getUser();
            this.mayEditActivity = this.mayEditActivity && this.currentActivity.permission.canWrite((DbUser)abstractMainViewTabArray, this.currentActivity.ownerUserId, this.currentActivity.ownerGroupId);
            this.mayRemoveActivity = this.mayRemoveActivity && this.currentActivity.permission.canDelete((DbUser)abstractMainViewTabArray, this.currentActivity.ownerUserId, this.currentActivity.ownerGroupId);
        }
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentActivity);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbCrmActivity, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbCrmActivity doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            this.warnings.clear();
            Connection connection = null;
            try {
                DbCrmActivity dbCrmActivity;
                long l;
                connection = immoToolProject.getDbConnection();
                long l2 = l = CrmActivityViewPanel.this.currentActivity != null ? ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.id : 0L;
                if (l < 1L || this.saveAsCopy) {
                    dbCrmActivity = new DbCrmActivity();
                } else {
                    dbCrmActivity = dbCrmActivityHandler.getActivity(connection, l);
                    if (dbCrmActivity == null) {
                        throw new Exception("Can't load activity #" + l + "!");
                    }
                    dbCrmActivityHandler.loadContactEntries(connection, dbCrmActivity);
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbCrmActivity);
                }
                dbCrmActivityHandler.saveActivity(connection, dbCrmActivity);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, immoToolProject, dbCrmActivity);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                DbCrmActivity dbCrmActivity2 = dbCrmActivity;
                return dbCrmActivity2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save activity!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CrmActivityViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbCrmActivity dbCrmActivity) {
            super.succeeded((Object)dbCrmActivity);
            if (dbCrmActivity == null) {
                return;
            }
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            CrmActivityViewPanel.this.setActivity(dbCrmActivity);
            CrmActivityViewPanel.this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long activityId;

        private RemoveTask(long l) {
            this.activityId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCrmActivityHandler.removeActivity(connection, this.activityId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete activity!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CrmActivityViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)CrmActivityViewPanel.this), (boolean)true);
        }
    }

    private class ContactsShowActionsAction
    extends AbstractI18nAction {
        private ContactsShowActionsAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmActivityViewPanel.this.doContactsShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected addresses."));
        }
    }

    private class ContactsRemoveAction
    extends AbstractI18nAction {
        private ContactsRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityViewPanel.this.doContactsRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class ContactsRefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private ContactsRefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmActivityViewPanel.this.contactsTab.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class ContactsRefreshAction
    extends AbstractI18nAction {
        private ContactsRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityViewPanel.this.doContactsRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ContactsEntryViewAction
    extends AbstractI18nAction {
        private ContactsEntryViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityViewPanel.this.doContactsEntryView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show the selected addresses."));
        }
    }

    private class ContactsEntrySubmitTask
    extends ImmoToolTask<Boolean, Void> {
        private final DbContactsEntry entry;
        private String groupName = null;

        private ContactsEntrySubmitTask(DbContactsEntry dbContactsEntry) {
            this.entry = dbContactsEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            this.groupName = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsHandler.saveEntry(connection, this.entry);
                DbContactsGroup dbContactsGroup = dbContactsHandler.getGroup(connection, this.entry.groupId);
                if (dbContactsGroup == null) {
                    throw new Exception("Can't find group #" + this.entry.groupId + "!");
                }
                this.groupName = dbContactsGroup.name;
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void finished() {
            super.finished();
            CrmActivityViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            CrmActivityViewPanel.this.contactsTab.tablePanel.contactsRelationForm.unselectRelation();
            CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.addRow((AbstractTable.Row)new ContactsEntryTable.Row(this.entry, this.groupName));
            CrmActivityViewPanel.this.contactsTab.tablePanel.updateTitle();
            CrmActivityViewPanel.this.contactsTab.clearNewContact();
            CrmActivityViewPanel.this.contactsTab.tabbedPane.setSelectedIndex(0);
        }
    }

    private class ContactsEntrySubmitAction
    extends AbstractI18nAction {
        private ContactsEntrySubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityViewPanel.this.doContactsEntrySubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save and assign the new address."));
        }
    }

    private class ContactsAddAction
    extends AbstractI18nAction {
        private ContactsAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityViewPanel.this.doContactsAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private final class PermissionsTab
    extends AbstractTab {
        private ImmoToolPermissionPanel form;
        private boolean loaded = false;

        private PermissionsTab() {
            this.build();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel();
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void doLoadInBackground(Connection connection) {
            this.loaded = false;
            try {
                ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                DbExtension dbExtension = immoToolProject.getDbExtension();
                DbUser dbUser = immoToolProject.getUser();
                if (CrmActivityViewPanel.this.currentActivity != null && ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.id > 0L) {
                    this.form.setPermission(((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.ownerUserId, ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.ownerGroupId, ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.permission);
                } else {
                    this.form.setPermission(dbUser.id, 0L, null);
                }
                this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
                this.loaded = true;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load permissions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.loaded = false;
            }
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabEnabled() {
            return this.loaded;
        }

        @Override
        public void load(DbCrmActivity dbCrmActivity) {
            this.loaded = false;
            this.form.setPermission(0L, 0L, null);
        }

        @Override
        public void save(DbCrmActivity dbCrmActivity) {
            DbGroup dbGroup;
            dbCrmActivity.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbCrmActivity.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbCrmActivity.ownerGroupId = dbGroup.id;
            }
        }
    }

    private final class NotesTab
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbCrmActivity dbCrmActivity) {
            this.notesField.setText(dbCrmActivity != null ? StringUtils.trimToEmpty((String)dbCrmActivity.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbCrmActivity dbCrmActivity) {
            dbCrmActivity.notes = this.notesField.getText().trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the activity")));
        }
    }

    private final class ContactsRelationForm
    extends ContactsEntryRelationPanel {
        private ContactsRelationForm() {
            super(false);
        }

        protected void close() {
            if (CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.getSelectedRowCount() > 0) {
                CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbContactsGroup dbContactsGroup, DbContactsEntry dbContactsEntry, String string) {
            if (dbContactsGroup == null || dbContactsEntry == null) {
                return false;
            }
            CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.setEnabled(false);
            try {
                if (this.getCurrentContactEntryId() < 1L) {
                    CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.addRow((AbstractTable.Row)new ContactsEntryTable.Row(dbContactsEntry, dbContactsGroup.name));
                } else {
                    int n = CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.convertRowIndexToModel(n);
                        CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.setRowAt(n2, (AbstractTable.Row)new ContactsEntryTable.Row(dbContactsEntry, dbContactsGroup.name));
                    }
                }
            }
            finally {
                CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.clearSelection();
                CrmActivityViewPanel.this.contactsTab.tablePanel.contactsTable.setEnabled(true);
                CrmActivityViewPanel.this.contactsTab.tablePanel.updateTitle();
            }
            return true;
        }
    }

    private final class ContactsTable
    extends ContactsEntryTable<ContactsEntryTable.Row> {
        private ContactsTable() {
            super(CrmActivityViewPanel.CONTACTS_TABLE_ID);
        }

        protected void doSelect() {
            CrmActivityViewPanel.this.contactsTab.tablePanel.showActionsAction.setEnabled(this.getSelectedColumnCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmActivityViewPanel.this.contactsTab.tablePanel.contactsRelationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CrmActivityViewPanel.this.contactsTab.tablePanel.contactsRelationForm.selectRelation(this.getContactEntryAt(n), null);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmActivityViewPanel.this.doContactsShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmActivityViewPanel.this.doContactsEntryView();
        }
    }

    private final class ContactsTabTable
    extends com.openindex.openestate.tool.gui.AbstractTab {
        private JXTitledSeparator titleLabel;
        private ContactsTable contactsTable;
        private ContactsRelationForm contactsRelationForm;
        private AbstractI18nAction showActionsAction;
        private AbstractI18nAction refreshAction;
        private AbstractI18nAction createAction;

        private ContactsTabTable() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.createAction = new ContactsAddAction();
            this.refreshAction = new ContactsRefreshAction();
            this.showActionsAction = new ContactsShowActionsAction();
            this.showActionsAction.setEnabled(false);
            this.contactsTable = new ContactsTable();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.titleLabel, (Action[])new Action[]{this.refreshAction, this.createAction, this.showActionsAction});
            this.contactsRelationForm = new ContactsRelationForm();
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.contactsTable.createScrollPane(), "Center");
            this.add((Component)((Object)this.contactsRelationForm), "South");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("addresses"));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.updateTitle();
        }

        private void updateTitle() {
            int n;
            String string = StringUtils.capitalize((String)I18N.tr("assigned addresses"));
            int n2 = n = this.contactsTable != null ? this.contactsTable.getRowCount() : 0;
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.titleLabel.setTitle(string);
        }
    }

    private final class ContactsTabForm
    extends com.openindex.openestate.tool.gui.AbstractTab {
        private ValidationHandler newContactValidationHandler;
        private JXTitledSeparator titleLabel;
        private JLabel newContactGroupLabel;
        private JComboBox<DbContactsGroup> newContactGroupBox;
        private ContactsEntryExtendedAddressPanel newContactAddressPanel;
        private ContactsEntrySubmitAction submitAction;

        private ContactsTabForm() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.submitAction = new ContactsEntrySubmitAction();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.titleLabel, (Action[])new Action[]{this.submitAction});
            this.newContactGroupLabel = new JLabel();
            this.newContactGroupBox = new JComboBox();
            this.newContactGroupBox.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select address group") + " ]";
                }
            }));
            this.newContactAddressPanel = new ContactsEntryExtendedAddressPanel(50);
            this.newContactAddressPanel.load(new DbContactsEntry());
            this.newContactValidationHandler = ImmoToolUtils.createValidationHandler();
            this.newContactValidationHandler.putRule(this.newContactGroupBox, ValidationHandler.NOT_BLANK);
            this.newContactValidationHandler.init();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.newContactGroupLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.newContactGroupBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.newContactAddressPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        private void clearNewContact() {
            this.newContactAddressPanel.load(new DbContactsEntry());
            this.newContactGroupBox.setSelectedItem(null);
            this.newContactValidationHandler.init();
            this.newContactAddressPanel.initInputs();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("new address"));
        }

        private boolean submitNewContact(DbContactsEntry dbContactsEntry) {
            this.newContactValidationHandler.validate();
            this.newContactAddressPanel.validateInputs();
            if (!this.newContactValidationHandler.isValid() || !this.newContactAddressPanel.isValidInput()) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided address is incomplete!"), (Component)((Object)CrmActivityViewPanel.this));
                return false;
            }
            this.newContactAddressPanel.save(dbContactsEntry);
            dbContactsEntry.groupId = ((DbContactsGroup)this.newContactGroupBox.getSelectedItem()).id;
            return true;
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("create a new address")));
            this.newContactGroupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
        }
    }

    private final class ContactsTab
    extends AbstractTab {
        private JXTitledSeparator titleLabel;
        private JTabbedPane tabbedPane;
        private ContactsTabForm formPanel;
        private ContactsTabTable tablePanel;

        private ContactsTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.tabbedPane = new JTabbedPane();
            this.tablePanel = (ContactsTabTable)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ContactsTabTable(), (JTabbedPane)this.tabbedPane);
            this.formPanel = ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT) ? (ContactsTabForm)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ContactsTabForm(), (JTabbedPane)this.tabbedPane) : null;
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.titleLabel, "North");
            this.add(this.tabbedPane, "Center");
        }

        private void clearNewContact() {
            if (this.formPanel != null) {
                this.formPanel.clearNewContact();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection) throws Exception {
            this.tablePanel.contactsTable.setEnabled(false);
            this.tablePanel.contactsTable.clearSelection();
            this.tablePanel.contactsTable.clearRows();
            if (CrmActivityViewPanel.this.currentActivity != null) {
                if (((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.contactEntryIds == null) {
                    ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.contactEntryIds = new ArrayList<Long>();
                } else {
                    ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.contactEntryIds.clear();
                }
            }
            HashMap<Long, DbContactsGroup> hashMap = new HashMap<Long, DbContactsGroup>();
            ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
            try {
                DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
                DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
                for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
                    hashMap.put(dbContactsGroup.id, dbContactsGroup);
                }
                if (CrmActivityViewPanel.this.currentActivity != null && ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.id > 0L) {
                    dbCrmActivityHandler.loadContactEntries(connection, CrmActivityViewPanel.this.currentActivity);
                    List<Long> list = ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.contactEntryIds;
                    long[] lArray = ArrayUtils.toPrimitive((Long[])list.toArray(new Long[0]));
                    DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntries(connection, lArray);
                    dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
                    arrayList.addAll(Arrays.asList(dbContactsEntryArray));
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(hashMap, arrayList){
                    final /* synthetic */ Map val$groupsMap;
                    final /* synthetic */ List val$entriesList;
                    {
                        this.val$groupsMap = map;
                        this.val$entriesList = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object2;
                            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                            for (Object object2 : this.val$groupsMap.values()) {
                                Iterator iterator = StringUtils.trimToEmpty((String)((DbContactsGroup)object2).name);
                                int n = 0;
                                while (treeMap.containsKey(iterator)) {
                                    iterator = StringUtils.trimToEmpty((String)((DbContactsGroup)object2).name) + "_" + ++n;
                                }
                                treeMap.put((String)((Object)iterator), object2);
                            }
                            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
                            object2 = new DefaultComboBoxModel();
                            defaultComboBoxModel.addElement(null);
                            ((DefaultComboBoxModel)object2).addElement(null);
                            for (DbContactsGroup dbContactsGroup : treeMap.values()) {
                                defaultComboBoxModel.addElement(dbContactsGroup);
                                ((DefaultComboBoxModel)object2).addElement(dbContactsGroup);
                            }
                            ContactsTab.this.tablePanel.contactsRelationForm.setContactsGroupsModel((ComboBoxModel)object2);
                            if (ContactsTab.this.formPanel != null) {
                                ContactsTab.this.formPanel.newContactGroupBox.setModel(defaultComboBoxModel);
                            }
                            for (DbContactsEntry dbContactsEntry : this.val$entriesList) {
                                String string = this.val$groupsMap.containsKey(dbContactsEntry.groupId) ? ((DbContactsGroup)this.val$groupsMap.get((Object)Long.valueOf((long)dbContactsEntry.groupId))).name : null;
                                ContactsTab.this.tablePanel.contactsTable.addRow((AbstractTable.Row)new ContactsEntryTable.Row(dbContactsEntry, string));
                            }
                        }
                        finally {
                            ContactsTab.this.tablePanel.contactsTable.setEnabled(true);
                            ContactsTab.this.tablePanel.showActionsAction.setEnabled(false);
                            ContactsTab.this.tablePanel.updateTitle();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("addresses"));
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabUsable() {
            return this.tabbedPane.getTabCount() > 0;
        }

        @Override
        public void load(DbCrmActivity dbCrmActivity) {
            this.tablePanel.contactsRelationForm.unselectRelation();
            this.tablePanel.contactsTable.setEnabled(false);
            this.tablePanel.contactsTable.clearSelection();
            this.tablePanel.contactsTable.clearRows();
            this.tablePanel.updateTitle();
        }

        @Override
        public void save(DbCrmActivity dbCrmActivity) {
            this.tabbedPane.setSelectedIndex(0);
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCrmActivity dbCrmActivity) throws SQLException {
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            dbCrmActivityHandler.loadContactEntries(connection, dbCrmActivity);
            if (dbCrmActivity.contactEntryIds == null) {
                dbCrmActivity.contactEntryIds = new ArrayList<Long>();
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < this.tablePanel.contactsTable.getRowCount(); ++i) {
                Long l = this.tablePanel.contactsTable.getContactEntryIdAt(i);
                dbCrmActivityHandler.saveActivityContactEntry(connection, dbCrmActivity.id, l);
                arrayList.add(l);
                if (dbCrmActivity.contactEntryIds.contains(l)) continue;
                dbCrmActivity.contactEntryIds.add(l);
            }
            for (Long l : dbCrmActivity.contactEntryIds.toArray(new Long[0])) {
                if (arrayList.contains(l)) continue;
                dbCrmActivityHandler.removeActivityContactEntry(connection, dbCrmActivity.id, l);
                dbCrmActivity.contactEntryIds.remove(l);
            }
        }

        private boolean submitNewContact(DbContactsEntry dbContactsEntry) {
            return this.formPanel != null && this.formPanel.submitNewContact(dbContactsEntry);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("addresses of the activity")));
        }
    }

    private final class ActivityTab
    extends AbstractTab {
        private ActivityViewExtension viewExtension = null;
        private ValidationHandler validationHandler;
        private JXTitledSeparator formTitle;
        private JPanel formPanel;
        private JPanel viewPanel;
        private JLabel subjectLabel;
        private JTextField subjectField;
        private JLabel beginLabel;
        private DefaultDateTimeField beginField;
        private DefaultDateTimeField endField;
        private JCheckBox endLabelBox;
        private JLabel statusLabel;
        private JComboBox<DbCrmActivity.Status> statusField;
        private JLabel typeLabel;
        private JComboBox<DbCrmActivity.Type> typeField;
        private JComboBox<DbCrmActivity.Direction> directionField;

        private ActivityTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.subjectLabel = new JLabel();
            this.subjectField = new JTextField();
            this.beginLabel = new JLabel();
            this.beginField = new DefaultDateTimeField();
            this.beginField.setValue(new Date());
            this.endField = new DefaultDateTimeField();
            this.endField.setValue((Date)null);
            this.endLabelBox = new JCheckBox();
            this.endLabelBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ActivityTab.this.endLabelBox.isEnabled()) {
                        return;
                    }
                    ActivityTab.this.endField.setEnabled(ActivityTab.this.endLabelBox.isSelected());
                    ActivityTab.this.validationHandler.validate((JComponent)ActivityTab.this.endField);
                }
            });
            this.statusLabel = new JLabel();
            this.statusField = new JComboBox();
            this.statusField.setRenderer((ListCellRenderer<DbCrmActivity.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.statusField.addItem(null);
            for (DbCrmActivity.Status enum_ : DbCrmActivity.Status.values()) {
                this.statusField.addItem(enum_);
            }
            this.directionField = new JComboBox();
            this.directionField.setRenderer((ListCellRenderer<DbCrmActivity.Direction>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.directionField.addItem(null);
            for (Enum enum_ : DbCrmActivity.Direction.values()) {
                this.directionField.addItem((DbCrmActivity.Direction)enum_);
            }
            this.typeLabel = new JLabel();
            this.typeField = new JComboBox();
            this.typeField.setRenderer((ListCellRenderer<DbCrmActivity.Type>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.typeField.addItem(null);
            for (Enum enum_ : DbCrmActivity.Type.values()) {
                this.typeField.addItem((DbCrmActivity.Type)enum_);
            }
            this.typeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ActivityTab.this.typeField.isEnabled()) {
                        return;
                    }
                    DbCrmActivity.Type type = (DbCrmActivity.Type)((Object)ActivityTab.this.typeField.getSelectedItem());
                    ActivityTab.this.endLabelBox.setEnabled(type == null || type.supportsEndDate());
                    if (!ActivityTab.this.endLabelBox.isEnabled()) {
                        ActivityTab.this.endLabelBox.setSelected(false);
                    }
                    ActivityTab.this.endField.setEnabled(ActivityTab.this.endLabelBox.isSelected());
                    ActivityTab.this.validationHandler.validate((JComponent)ActivityTab.this.endField);
                    ActivityTab.this.directionField.setEnabled(!DbCrmActivity.Type.MEETING.equals((Object)type));
                    if (DbCrmActivity.Type.MEETING.equals((Object)type)) {
                        ActivityTab.this.directionField.setSelectedItem(null);
                    }
                    ActivityTab.this.validationHandler.validate((JComponent)ActivityTab.this.directionField);
                    CrmActivityViewPanel.this.updateLocalization();
                }
            });
            this.validationHandler.putRule((JComponent)this.subjectField, ValidationHandler.NOT_BLANK);
            this.validationHandler.putRule(this.statusField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.typeField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.directionField, ValidationHandler.NOT_NULL);
            DateTimeIntervalValidationListener.install((ValidationHandler)this.validationHandler, (DefaultDateTimeField)this.beginField, (DefaultDateTimeField)this.endField);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 35dlu:grow, 3dlu, right:[30dlu,pref], 3dlu, 35dlu:grow, 3dlu, pref");
            defaultFormBuilder.add((Component)this.subjectLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.subjectField).xyw(3, defaultFormBuilder.row(), 7);
            defaultFormBuilder.add((Component)this.beginLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.beginField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.typeLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.typeField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add(this.directionField).xy(9, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.endLabelBox).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.endField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.statusLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.statusField).xy(7, defaultFormBuilder.row());
            this.viewPanel = new JPanel(new BorderLayout());
            this.formPanel = new JPanel(new BorderLayout(5, 5));
            this.formPanel.add((Component)this.formTitle, "North");
            this.formPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
            this.setLayout(new BorderLayout(5, 5));
            this.add(this.formPanel, "North");
            this.add(this.viewPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            this.viewExtension.load(ImmoToolProject.getAppInstance(), connection, CrmActivityViewPanel.this.currentActivity);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("activity"));
        }

        public boolean isLoadedInBackground() {
            return CrmActivityViewPanel.this.currentActivity != null && ((CrmActivityViewPanel)CrmActivityViewPanel.this).currentActivity.id > 0L && this.viewExtension != null;
        }

        public boolean isTabValid() {
            this.validationHandler.validate();
            return this.validationHandler.isValid();
        }

        @Override
        public void load(DbCrmActivity dbCrmActivity) {
            boolean bl = dbCrmActivity.type == null || dbCrmActivity.type.supportsEndDate();
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.add(12, 30);
            this.subjectField.setText(dbCrmActivity.subject);
            this.beginField.setValue(dbCrmActivity.begin != null ? dbCrmActivity.begin : calendar.getTime());
            this.endField.setValue(dbCrmActivity.end != null ? dbCrmActivity.end : calendar2.getTime());
            this.endLabelBox.setSelected(dbCrmActivity.id < 1L || dbCrmActivity.end != null);
            this.statusField.setSelectedItem((Object)(dbCrmActivity.status != null ? dbCrmActivity.status : DbCrmActivity.Status.FINISHED));
            this.typeField.setSelectedItem((Object)dbCrmActivity.type);
            this.directionField.setSelectedItem((Object)(!DbCrmActivity.Type.MEETING.equals((Object)dbCrmActivity.type) ? dbCrmActivity.direction : null));
            this.beginField.setEnabled(!dbCrmActivity.fixed);
            this.endField.setEnabled(!dbCrmActivity.fixed && bl && this.endLabelBox.isSelected());
            this.endField.setVisible(!dbCrmActivity.fixed);
            this.endLabelBox.setEnabled(!dbCrmActivity.fixed && bl);
            this.endLabelBox.setVisible(!dbCrmActivity.fixed);
            this.statusField.setEnabled(!dbCrmActivity.fixed);
            this.typeField.setEnabled(!dbCrmActivity.fixed);
            this.directionField.setEnabled(!dbCrmActivity.fixed && !DbCrmActivity.Type.MEETING.equals((Object)dbCrmActivity.type));
            this.viewPanel.removeAll();
            this.viewExtension = null;
            if (dbCrmActivity.id > 0L) {
                for (ActivityViewExtension activityViewExtension : CrmActivityViewPanel.this.addons) {
                    try {
                        JComponent jComponent = activityViewExtension.getActivityView(dbCrmActivity);
                        if (jComponent == null) continue;
                        this.viewExtension = activityViewExtension;
                        this.viewPanel.add((Component)jComponent, "Center");
                        break;
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load addon-view!");
                        LOGGER.warn("from " + activityViewExtension.getClass().getName());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
            if (dbCrmActivity.id > 0L) {
                this.validationHandler.validate();
            } else {
                this.validationHandler.init();
            }
            CrmActivityViewPanel.this.updateLocalization();
        }

        @Override
        public void save(DbCrmActivity dbCrmActivity) {
            dbCrmActivity.subject = this.subjectField.getText().trim();
            if (!dbCrmActivity.fixed) {
                dbCrmActivity.begin = this.beginField.getValueAsDate();
                dbCrmActivity.end = this.endField.isEnabled() ? this.endField.getValueAsDate() : null;
                dbCrmActivity.status = (DbCrmActivity.Status)((Object)this.statusField.getSelectedItem());
                dbCrmActivity.type = (DbCrmActivity.Type)((Object)this.typeField.getSelectedItem());
                dbCrmActivity.direction = this.directionField.isEnabled() ? (DbCrmActivity.Direction)((Object)this.directionField.getSelectedItem()) : null;
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("details about the activity")));
            this.subjectLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
            this.beginLabel.setText(StringUtils.capitalize((String)I18N.tr("begin")) + ":");
            this.endLabelBox.setText(StringUtils.capitalize((String)I18N.tr("end")) + ":");
            this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
            this.typeLabel.setText(StringUtils.capitalize((String)I18N.tr("type")) + ":");
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<CrmActivityViewPanel> viewPanel = null;
        private final List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public CrmActivityViewPanel getViewPanel() {
            return this.viewPanel != null ? (CrmActivityViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbCrmActivity var1) throws Exception;

        public abstract void save(DbCrmActivity var1) throws Exception;

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCrmActivity dbCrmActivity) throws SQLException, IOException {
        }

        public void setViewPanel(CrmActivityViewPanel crmActivityViewPanel) {
            this.viewPanel = crmActivityViewPanel != null ? new WeakReference<CrmActivityViewPanel>(crmActivityViewPanel) : null;
        }
    }
}

