/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryField;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.utils.SwingUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.InternetAddress;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailAddressContactsDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAddressContactsDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAddressContactsDialog.class);
    private MailContactItem currentItem = null;
    private final List<NewContactsEntry> newContactEntries = new ArrayList<NewContactsEntry>();
    private boolean submitted = false;
    private ValidationHandler validationHandler;
    private JComponent mainFormComponent;
    private JComponent mainTableComponent;
    private JXTitledSeparator addressTableTitle;
    private JXTable addressTable;
    private AdressTableModel addressTableModel;
    private JLabel contactLabel;
    private JComboBox<MailContactAction> contactTypeBox;
    private ContactsEntryField contactEntriesBox;
    private JComboBox<DbContactsGroup> contactGroupsBox;
    private JPanel contactEntriesPanel;
    private JXTitledSeparator contactEntryTitle;
    private ContactsEntryExtendedAddressPanel contactEntryForm;
    private CancelAction cancelAction;
    private SubmitAction submitAction;
    private SelectNextAddressAction selectNextAddressAction;
    private SelectPrevAddressAction selectPrevAddressAction;

    private MailAddressContactsDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private MailAddressContactsDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.cancelAction = new CancelAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.cancelAction});
    }

    protected JComponent buildMainComponent() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.mainFormComponent = this.buildMainComponentForm();
        this.mainTableComponent = this.buildMainComponentTable();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder((Border)Paddings.DIALOG);
        jPanel.add((Component)this.mainTableComponent, "North");
        jPanel.add((Component)this.mainFormComponent, "Center");
        return jPanel;
    }

    private JComponent buildMainComponentForm() {
        this.selectNextAddressAction = new SelectNextAddressAction();
        this.selectPrevAddressAction = new SelectPrevAddressAction();
        this.contactEntryTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = new ButtonBarBuilder().addGrowing((JComponent)this.contactEntryTitle).addRelatedGap().addFixed((JComponent)new JButton((Action)((Object)this.selectPrevAddressAction))).addRelatedGap().addFixed((JComponent)new JButton((Action)((Object)this.selectNextAddressAction))).getPanel();
        this.contactLabel = new JLabel();
        this.contactTypeBox = new JComboBox();
        this.contactTypeBox.setRenderer((ListCellRenderer<MailContactAction>)new DefaultListCellRenderer((Renderer)new MailContactActionRenderer()));
        for (MailContactAction mailContactAction : MailContactAction.values()) {
            this.contactTypeBox.addItem(mailContactAction);
        }
        this.contactTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MailAddressContactsDialog.this.contactTypeBox.isEnabled()) {
                    return;
                }
                MailAddressContactsDialog.this.updateContactTypeSelection();
            }
        });
        this.contactGroupsBox = new JComboBox();
        this.contactGroupsBox.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("Please select an address group.") + " ]";
            }
        }));
        this.contactGroupsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MailAddressContactsDialog.this.contactGroupsBox.isEnabled()) {
                    return;
                }
                MailAddressContactsDialog.this.updateContactGroupSelection();
            }
        });
        this.contactEntriesBox = new ContactsEntryField();
        this.contactEntriesBox.addSelectionListener(new DefaultAutoCompleteField.SelectionListener(){

            public void valueChanged() {
                if (!MailAddressContactsDialog.this.contactEntriesBox.isEnabled()) {
                    return;
                }
                DbContactsEntry dbContactsEntry = MailAddressContactsDialog.this.contactEntriesBox.getContactsEntry();
                MailAddressContactsDialog.this.contactEntryForm.load(dbContactsEntry);
            }
        });
        this.contactEntryForm = new ContactsEntryExtendedAddressPanel(40);
        this.contactEntriesPanel = new JPanel(new BorderLayout());
        this.contactEntriesPanel.add((Component)this.contactEntriesBox, "Center");
        this.validationHandler.putRule(this.contactGroupsBox, ValidationHandler.NOT_NULL);
        this.validationHandler.putRule((JComponent)this.contactEntriesBox, ValidationHandler.NOT_NULL);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref, 3dlu, pref, 3dlu, 40dlu:grow");
        defaultFormBuilder.add((Component)this.contactLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.contactTypeBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add(this.contactGroupsBox).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.contactEntriesPanel).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.contactEntryForm).xyw(1, defaultFormBuilder.nextRow(), 7);
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        return jPanel2;
    }

    private JComponent buildMainComponentTable() {
        this.addressTableTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.addressTableModel = new AdressTableModel();
        this.addressTable = new JXTable((TableModel)this.addressTableModel);
        this.addressTable.setAutoCreateColumnsFromModel(false);
        this.addressTable.setColumnControlVisible(false);
        this.addressTable.setEditable(false);
        this.addressTable.setSelectionMode(0);
        this.addressTable.getColumnExt(0).setSortable(true);
        this.addressTable.getColumnExt(1).setSortable(false);
        this.addressTable.getColumnExt(2).setSortable(false);
        this.addressTable.getColumnExt(1).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer((Renderer)new MailContactActionRenderer()));
        this.addressTable.getColumnExt(2).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer((Renderer)new MailContactItemRenderer()));
        this.addressTable.setSortOrder(0, SortOrder.ASCENDING);
        this.addressTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!MailAddressContactsDialog.this.addressTable.isEnabled()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MailAddressContactsDialog.this.updateAddressSelection();
            }
        });
        ImmoToolUtils.configureTable((JXTable)this.addressTable);
        JScrollPane jScrollPane = new JScrollPane((Component)this.addressTable);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.addressTableTitle, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void doSelectNextAddress() {
        int n = this.addressTable.getSelectedRow();
        int n2 = n + 1;
        if (n2 < this.addressTable.getRowCount()) {
            this.addressTable.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private void doSelectPrevAddress() {
        int n = this.addressTable.getSelectedRow();
        int n2 = n - 1;
        if (n2 > -1) {
            this.addressTable.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private void doSubmit() {
        if (!this.saveCurrentItem(false)) {
            return;
        }
        this.submitted = true;
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("select addresses for assignment"));
    }

    protected Icon getHeaderIcon() {
        return CrmPlugin.getResourceIcon((String)"crm.png", (int)32);
    }

    protected String getHeaderTitle() {
        return I18N.tr("Select addresses for assignment.");
    }

    private Map<Long, DbContactsEntry> getMessageContacts() {
        HashMap<Long, DbContactsEntry> hashMap = new HashMap<Long, DbContactsEntry>();
        for (int i = 0; i < this.addressTable.getRowCount(); ++i) {
            MailContactItem mailContactItem = this.addressTableModel.getItemAt(i);
            if (mailContactItem.mailMessageIds == null || mailContactItem.mailMessageIds.isEmpty()) continue;
            for (Long l : mailContactItem.mailMessageIds) {
                if (hashMap.containsKey(l)) continue;
                if (MailContactAction.ADD_CONTACT.equals((Object)mailContactItem.action) || MailContactAction.USE_CONTACT.equals((Object)mailContactItem.action)) {
                    hashMap.put(l, mailContactItem.contactsEntry);
                    continue;
                }
                hashMap.put(l, null);
            }
        }
        return hashMap;
    }

    private void load(Connection connection, DbMailMessage[] dbMailMessageArray) throws SQLException {
        Serializable serializable;
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        this.newContactEntries.clear();
        this.addressTableModel.setRowCount(0);
        if (!ArrayUtils.isEmpty((Object[])dbMailMessageArray)) {
            serializable = new LinkedHashMap();
            DbContactsGroup[] dbContactsGroupArray = new HashMap();
            for (DbMailMessage dbMailMessage : dbMailMessageArray) {
                MailContactItem mailContactItem;
                String string = dbMailMessage.isReceived ? (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trimToEmpty((String)dbMailMessage.from), (CharSequence)"???") : (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trimToEmpty((String)dbMailMessage.to), (CharSequence)"???");
                String string2 = string.toLowerCase();
                if (serializable.containsKey(string2)) {
                    mailContactItem = (MailContactItem)serializable.get(string2);
                } else {
                    mailContactItem = new MailContactItem(string);
                    serializable.put(string2, mailContactItem);
                    InternetAddress internetAddress = mailContactItem.getInternetAddress();
                    if (internetAddress != null) {
                        long l;
                        DbContactsEntry dbContactsEntry = dbContactsHandler.getEntry(connection, internetAddress);
                        long l2 = l = dbContactsEntry != null ? dbContactsEntry.id : 0L;
                        if (l > 0L) {
                            if (!dbContactsGroupArray.containsKey(l)) {
                                dbContactsGroupArray.put(l, dbContactsEntry);
                            }
                            mailContactItem.contactsEntry = (DbContactsEntry)dbContactsGroupArray.get(l);
                        }
                    }
                    mailContactItem.action = mailContactItem.contactsEntry != null ? MailContactAction.USE_CONTACT : MailContactAction.NO_CONTACT;
                }
                mailContactItem.mailMessageIds.add(dbMailMessage.id);
            }
            dbContactsHandler.loadEntrySettings(connection, dbContactsGroupArray.values().toArray(new DbContactsEntry[0]));
            for (MailContactItem mailContactItem : serializable.values()) {
                this.addressTableModel.addItem(mailContactItem);
            }
        }
        this.contactEntriesBox.setEnabled(false);
        this.contactEntriesBox.setContactsEntry(null);
        this.contactGroupsBox.setEnabled(false);
        this.contactGroupsBox.setSelectedItem(null);
        serializable = new DefaultComboBoxModel();
        ((DefaultComboBoxModel)serializable).addElement(null);
        for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
            ((DefaultComboBoxModel)serializable).addElement(dbContactsGroup);
        }
        this.contactGroupsBox.setModel((ComboBoxModel<DbContactsGroup>)((Object)serializable));
        this.submitAction.setEnabled(this.addressTableModel.getRowCount() > 0);
        if (this.addressTable.getRowCount() > 0) {
            this.addressTable.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.updateAddressSelection();
        }
        this.addressTable.packAll();
        this.mainTableComponent.setVisible(this.addressTable.getRowCount() > 1);
        this.pack();
    }

    private boolean saveCurrentItem(boolean bl) {
        NewContactsEntry newContactsEntry;
        if (this.currentItem == null) {
            return false;
        }
        this.validationHandler.validate();
        this.contactEntryForm.validateInputs();
        if (!this.validationHandler.isValid() || !this.contactEntryForm.isValidInput()) {
            if (!bl) {
                ImmoToolUtils.showMessageWarningDialog((String)"Bitte vervollst\u00e4ndigen Sie Ihre Eingaben!", (Component)((Object)this));
            }
            return false;
        }
        this.currentItem.action = (MailContactAction)((Object)this.contactTypeBox.getSelectedItem());
        if (MailContactAction.NO_CONTACT.equals((Object)this.currentItem.action)) {
            if (this.currentItem.contactsEntry instanceof NewContactsEntry) {
                newContactsEntry = (NewContactsEntry)this.currentItem.contactsEntry;
                newContactsEntry.items.remove(this.currentItem);
                if (newContactsEntry.items.isEmpty()) {
                    this.newContactEntries.remove((Object)newContactsEntry);
                } else if (newContactsEntry.items.size() == 1) {
                    ((MailContactItem)newContactsEntry.items.get(0)).action = MailContactAction.ADD_CONTACT;
                }
            }
            this.currentItem.contactsEntry = null;
        } else if (MailContactAction.ADD_CONTACT.equals((Object)this.currentItem.action)) {
            NewContactsEntry newContactsEntry2;
            newContactsEntry = (DbContactsGroup)this.contactGroupsBox.getSelectedItem();
            if (newContactsEntry == null) {
                this.currentItem.action = MailContactAction.NO_CONTACT;
                this.currentItem.contactsEntry = null;
                return false;
            }
            if (this.currentItem.contactsEntry instanceof NewContactsEntry) {
                newContactsEntry2 = (NewContactsEntry)this.currentItem.contactsEntry;
            } else {
                newContactsEntry2 = new NewContactsEntry();
                newContactsEntry2.items.add(this.currentItem);
                this.newContactEntries.add(newContactsEntry2);
            }
            this.currentItem.contactsEntry = newContactsEntry2;
            ((MailContactItem)this.currentItem).contactsEntry.groupId = ((DbContactsGroup)newContactsEntry).id;
            this.contactEntryForm.save(this.currentItem.contactsEntry);
        } else if (MailContactAction.USE_CONTACT.equals((Object)this.currentItem.action)) {
            NewContactsEntry newContactsEntry3;
            boolean bl2;
            newContactsEntry = this.contactEntriesBox.getContactsEntry();
            if (newContactsEntry == null) {
                this.currentItem.action = MailContactAction.NO_CONTACT;
                this.currentItem.contactsEntry = null;
                return false;
            }
            boolean bl3 = newContactsEntry instanceof NewContactsEntry;
            boolean bl4 = bl2 = this.currentItem.contactsEntry != null && this.currentItem.contactsEntry instanceof NewContactsEntry;
            if (bl2 && !bl3) {
                newContactsEntry3 = (NewContactsEntry)this.currentItem.contactsEntry;
                newContactsEntry3.items.remove(this.currentItem);
                if (newContactsEntry3.items.isEmpty()) {
                    this.newContactEntries.remove((Object)newContactsEntry3);
                } else if (newContactsEntry3.items.size() == 1) {
                    ((MailContactItem)newContactsEntry3.items.get(0)).action = MailContactAction.ADD_CONTACT;
                }
            } else if (!bl2 && bl3) {
                newContactsEntry3 = newContactsEntry;
                newContactsEntry3.items.add(this.currentItem);
            }
            if (bl3 && (newContactsEntry3 = newContactsEntry).items.size() == 1) {
                this.currentItem.action = MailContactAction.ADD_CONTACT;
            }
            this.currentItem.contactsEntry = newContactsEntry;
        } else {
            return false;
        }
        this.addressTable.setEnabled(false);
        int n = this.addressTable.getSelectedRow();
        this.addressTableModel.updateItems();
        this.addressTableModel.fireTableDataChanged();
        if (n > -1) {
            this.addressTable.getSelectionModel().setSelectionInterval(n, n);
        }
        this.addressTable.setEnabled(true);
        this.addressTable.packAll();
        return true;
    }

    private void selectContactsGroup(long l) {
        int n = 0;
        if (l > 0L) {
            for (int i = 0; i < this.contactGroupsBox.getItemCount(); ++i) {
                DbContactsGroup dbContactsGroup = this.contactGroupsBox.getItemAt(i);
                if (dbContactsGroup == null || dbContactsGroup.id != l) continue;
                n = i;
                break;
            }
        }
        this.contactGroupsBox.setSelectedIndex(n);
    }

    public static DbContactsEntry showDialog(DbMailMessage dbMailMessage, ImmoToolProject immoToolProject, Window window) throws SQLException {
        if (dbMailMessage == null) {
            return null;
        }
        Map<Long, DbContactsEntry> map = MailAddressContactsDialog.showDialog(new DbMailMessage[]{dbMailMessage}, immoToolProject, window);
        return map != null ? map.get(dbMailMessage.id) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, DbContactsEntry> showDialog(DbMailMessage[] dbMailMessageArray, ImmoToolProject immoToolProject, Window window) throws SQLException {
        Map<Long, DbContactsEntry> map;
        if (ArrayUtils.isEmpty((Object[])dbMailMessageArray)) {
            throw new IllegalArgumentException("No messages provided!");
        }
        MailAddressContactsDialog mailAddressContactsDialog = null;
        try {
            mailAddressContactsDialog = window instanceof Dialog ? new MailAddressContactsDialog((Dialog)window) : (window instanceof Frame ? new MailAddressContactsDialog((Frame)window) : new MailAddressContactsDialog((Frame)null));
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                mailAddressContactsDialog.load(connection, dbMailMessageArray);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            mailAddressContactsDialog.setVisible(true);
            map = mailAddressContactsDialog.submitted ? mailAddressContactsDialog.getMessageContacts() : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(mailAddressContactsDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)mailAddressContactsDialog));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAddressSelection() {
        try {
            int n;
            if (this.currentItem != null) {
                this.saveCurrentItem(true);
            }
            this.selectNextAddressAction.setEnabled((n = this.addressTable.getSelectedRow()) > -1 && n + 1 < this.addressTable.getRowCount());
            this.selectPrevAddressAction.setEnabled(n > 0);
            if (n < 0) {
                this.currentItem = null;
                this.contactTypeBox.setEnabled(false);
                this.contactGroupsBox.setEnabled(false);
                this.contactGroupsBox.setSelectedItem(null);
                this.contactEntriesBox.setEnabled(false);
                this.contactEntriesBox.setValue(null);
                this.contactEntryForm.setEnabled(false);
                this.contactEntryForm.load(null);
                return;
            }
            this.addressTable.scrollRowToVisible(n);
            int n2 = this.addressTable.convertRowIndexToModel(n);
            MailContactItem mailContactItem = this.addressTableModel.getItemAt(n2);
            if (this.currentItem != null && this.currentItem.address.equalsIgnoreCase(mailContactItem.address)) {
                return;
            }
            this.currentItem = mailContactItem;
            this.contactTypeBox.setEnabled(true);
            this.contactTypeBox.setSelectedItem((Object)mailContactItem.action);
            if (MailContactAction.ADD_CONTACT.equals((Object)mailContactItem.action) || MailContactAction.USE_CONTACT.equals((Object)mailContactItem.action)) {
                this.selectContactsGroup(mailContactItem.contactsEntry != null ? ((MailContactItem)mailContactItem).contactsEntry.groupId : 0L);
            } else {
                this.selectContactsGroup(0L);
                this.contactEntryForm.load(new DbContactsEntry());
            }
        }
        finally {
            this.updateLocalization();
        }
    }

    private void updateContactGroupSelection() {
        MailContactAction mailContactAction = (MailContactAction)((Object)this.contactTypeBox.getSelectedItem());
        DbContactsGroup dbContactsGroup = (DbContactsGroup)this.contactGroupsBox.getSelectedItem();
        if (dbContactsGroup == null || !MailContactAction.USE_CONTACT.equals((Object)mailContactAction)) {
            this.contactEntriesBox.setContactsGroupId(0L);
            this.contactEntriesBox.setValue(null);
            this.contactEntriesBox.setEnabled(false);
        } else {
            this.contactEntriesBox.setContactsGroupId(dbContactsGroup.id);
            this.contactEntriesBox.setValue(null);
            this.contactEntriesBox.setEnabled(true);
        }
    }

    private void updateContactTypeSelection() {
        MailContactAction mailContactAction = (MailContactAction)((Object)this.contactTypeBox.getSelectedItem());
        this.contactGroupsBox.setEnabled(false);
        this.contactEntriesBox.setEnabled(false);
        if (MailContactAction.NO_CONTACT.equals((Object)mailContactAction)) {
            this.contactEntryForm.setEnabled(false);
            this.contactEntryForm.setEditable(false);
            this.contactEntryForm.load(new DbContactsEntry());
        } else if (MailContactAction.ADD_CONTACT.equals((Object)mailContactAction)) {
            this.contactGroupsBox.setEnabled(true);
            this.contactEntryForm.setEnabled(true);
            this.contactEntryForm.setEditable(true);
            if (this.currentItem.contactsEntry == null || ((MailContactItem)this.currentItem).contactsEntry.id > 0L) {
                InternetAddress internetAddress = this.currentItem.getInternetAddress();
                this.currentItem.contactsEntry = new DbContactsEntry();
                ((MailContactItem)this.currentItem).contactsEntry.address = new CompanyAddressImpl();
                if (!StringUtils.isBlank((CharSequence)internetAddress.getAddress())) {
                    ((MailContactItem)this.currentItem).contactsEntry.address.setPersonMail(internetAddress.getAddress());
                }
                if (!StringUtils.isBlank((CharSequence)internetAddress.getPersonal())) {
                    ((MailContactItem)this.currentItem).contactsEntry.address.setPersonLastName(internetAddress.getPersonal());
                }
            }
            this.selectContactsGroup(((MailContactItem)this.currentItem).contactsEntry.groupId);
            this.contactEntryForm.load(this.currentItem.contactsEntry);
        } else if (MailContactAction.USE_CONTACT.equals((Object)mailContactAction)) {
            this.selectContactsGroup(this.currentItem.contactsEntry != null ? ((MailContactItem)this.currentItem).contactsEntry.groupId : 0L);
            this.contactGroupsBox.setEnabled(true);
            this.contactEntriesBox.setEnabled(true);
            this.contactEntryForm.setEnabled(true);
            this.contactEntryForm.setEditable(false);
            this.contactEntryForm.load(this.currentItem.contactsEntry);
        }
        this.contactEntryForm.initInputs();
        this.validationHandler.init();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        if (this.currentItem != null && !StringUtils.isBlank((CharSequence)this.currentItem.address)) {
            this.contactEntryTitle.setTitle(StringUtils.capitalize((String)I18N.tr("address for {0}", (Object)StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)this.currentItem.address), (int)50))));
        } else {
            this.contactEntryTitle.setTitle(StringUtils.capitalize((String)I18N.tr("assign an address")));
        }
        this.contactLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.addressTableTitle.setTitle(StringUtils.capitalize((String)I18N.tr("assigned addresses")));
        this.addressTable.repaint();
    }

    private static class NewContactsEntry
    extends DbContactsEntry {
        private List<MailContactItem> items;

        private NewContactsEntry() {
            this.address = new CompanyAddressImpl();
            this.items = new ArrayList<MailContactItem>();
        }
    }

    private static class MailContactItemRenderer
    extends AbstractRenderer<MailContactItem> {
        private MailContactItemRenderer() {
        }

        public void render(MailContactItem mailContactItem, JLabel jLabel) {
            if (mailContactItem != null) {
                if (!MailContactAction.ADD_CONTACT.equals((Object)mailContactItem.action) && !MailContactAction.USE_CONTACT.equals((Object)mailContactItem.action)) {
                    jLabel.setText("-");
                } else {
                    String string = null;
                    if (mailContactItem.contactsEntry != null && ((MailContactItem)mailContactItem).contactsEntry.address != null && StringUtils.isBlank((CharSequence)(string = ((MailContactItem)mailContactItem).contactsEntry.address.writePersonFullName()))) {
                        string = ((MailContactItem)mailContactItem).contactsEntry.address.getCompanyName();
                    }
                    String string2 = string = !StringUtils.isBlank(string) ? string.trim() : "[Adresse #" + ((MailContactItem)mailContactItem).contactsEntry.id + "]";
                    if (MailContactAction.USE_CONTACT.equals((Object)mailContactItem.action) && mailContactItem.contactsEntry instanceof NewContactsEntry) {
                        string = "[NEU] " + string;
                    }
                    jLabel.setText(string);
                }
            } else {
                jLabel.setText("???");
            }
        }
    }

    private static class MailContactItem {
        private String address;
        private MailContactAction action = MailContactAction.NO_CONTACT;
        private DbContactsEntry contactsEntry = null;
        private List<Long> mailMessageIds = new ArrayList<Long>();

        private MailContactItem(String string) {
            this.address = string;
        }

        private InternetAddress getInternetAddress() {
            if (StringUtils.isBlank((CharSequence)this.address) || "???".equals(this.address)) {
                return null;
            }
            try {
                Object[] objectArray = InternetAddress.parse((String)this.address);
                return !ArrayUtils.isEmpty((Object[])objectArray) ? objectArray[0] : null;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't parse address: '" + this.address + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                return null;
            }
        }
    }

    private static class MailContactActionRenderer
    extends AbstractRenderer<MailContactAction> {
        private MailContactActionRenderer() {
        }

        public void render(MailContactAction mailContactAction, JLabel jLabel) {
            if (mailContactAction != null) {
                jLabel.setText(mailContactAction.getTranslation());
                jLabel.setFont(jLabel.getFont().deriveFont(1));
                switch (mailContactAction) {
                    case ADD_CONTACT: {
                        jLabel.setForeground(Color.BLUE);
                        break;
                    }
                    case USE_CONTACT: {
                        jLabel.setForeground(Color.BLACK);
                        break;
                    }
                    default: {
                        jLabel.setForeground(Color.RED);
                        break;
                    }
                }
            } else {
                jLabel.setText("???");
                jLabel.setFont(jLabel.getFont().deriveFont(0));
                jLabel.setForeground(Color.BLACK);
            }
        }
    }

    private static enum MailContactAction implements Translatable
    {
        NO_CONTACT(I18n.marktr((String)"no address")),
        USE_CONTACT(I18n.marktr((String)"use address")),
        ADD_CONTACT(I18n.marktr((String)"new address"));

        private final String i18nKey;

        private MailContactAction(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(MailAddressContactsDialog.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    private static class AdressTableModel
    extends DefaultTableModel {
        private static final int COLUMN_ADDRESS = 0;
        private static final int COLUMN_ACTION = 1;
        private static final int COLUMN_ITEM = 2;

        private AdressTableModel() {
            this.setColumnCount(3);
        }

        public void addItem(MailContactItem mailContactItem) {
            this.addRow(this.buildRow(mailContactItem));
        }

        private Object[] buildRow(MailContactItem mailContactItem) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                treeMap.put(i, null);
            }
            if (mailContactItem != null) {
                treeMap.put(0, mailContactItem.address);
                treeMap.put(1, (Object)mailContactItem.action);
                treeMap.put(2, mailContactItem);
            }
            return treeMap.values().toArray(new Object[0]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return MailContactAction.class;
                }
                case 2: {
                    return MailContactItem.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return StringUtils.capitalize((String)I18N.tr("e-mail address"));
                }
                case 1: {
                    return StringUtils.capitalize((String)I18N.tr("action"));
                }
                case 2: {
                    return StringUtils.capitalize((String)I18N.tr("addressbook entry"));
                }
            }
            return null;
        }

        public MailContactAction getActionAt(int n) {
            return (MailContactAction)((Object)this.getValueAt(n, 1));
        }

        public MailContactItem getItemAt(int n) {
            return (MailContactItem)this.getValueAt(n, 2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setItemAt(int n, MailContactItem mailContactItem) {
            Object[] objectArray = this.buildRow(mailContactItem);
            for (int i = 0; i < objectArray.length; ++i) {
                this.setValueAt(objectArray[i], n, i);
            }
        }

        private void updateItems() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setItemAt(i, this.getItemAt(i));
            }
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAddressContactsDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
        }
    }

    private class SelectPrevAddressAction
    extends AbstractI18nAction {
        private SelectPrevAddressAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_left.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAddressContactsDialog.this.doSelectPrevAddress();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Select previous address from table."));
        }
    }

    private class SelectNextAddressAction
    extends AbstractI18nAction {
        private SelectNextAddressAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_right.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAddressContactsDialog.this.doSelectNextAddress();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Select next address from table."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAddressContactsDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
        }
    }
}

