/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.extensions.FrameMenuAdapter;
import com.openindex.openestate.tool.gui.DefaultMenu;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmFrameMenuExtension
extends FrameMenuAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmFrameMenuExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmFrameMenuExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_SELECT = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_ACTIVITY = 4;
    public static final int MENU_ADD_MARKETING = 5;
    public static final int MENU_ADD_END = 6;
    public static final int MENU_ACTIVITIES = 7;
    public static final int MENU_MARKETINGS = 8;
    public static final int MENU_END = 9;

    public JMenu createMainMenu() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Collection collection = CrmFrameMenuExtension.getAddons((ImmoToolProject)immoToolProject, ((Object)((Object)this)).getClass());
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(CrmPlugin.getInstance().getTitle());
            }
        };
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)0, (Collection)collection);
        defaultMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.SidebarSelectAction())));
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)1, (Collection)collection);
        DefaultMenu defaultMenu2 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the CRM addon."));
            }
        };
        defaultMenu2.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)3, (Collection)collection);
        if (CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT)) {
            for (DbCrmActivity.Type type : DbCrmActivity.Type.values()) {
                defaultMenu2.add(new JMenuItem((Action)((Object)new CrmPlugin.ActivityFormAction(type))));
            }
        }
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)4, (Collection)collection);
        if (CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT)) {
            if (defaultMenu2.getItemCount() > 0) {
                defaultMenu2.addSeparator();
            }
            defaultMenu2.add(new JMenuItem((Action)((Object)new CrmPlugin.MarketingFormAction())));
        }
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)5, (Collection)collection);
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)6, (Collection)collection);
        if (defaultMenu2.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu2);
        }
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)2, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            defaultMenu.addSeparator();
        }
        if (CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.ActivityTableAction(true))));
        }
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)7, (Collection)collection);
        if (CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.MarketingTableAction(true))));
        }
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)8, (Collection)collection);
        CrmFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)9, (Collection)collection);
        return defaultMenu;
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }
}

