/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.crm.gui.MarketingRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Dimension;
import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmMarketingField
extends DefaultAutoCompleteField<DbCrmMarketing> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMarketingField.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMarketingField.class);

    public CrmMarketingField() {
        this.setCustomValueAllowed(false);
        this.setMultipleSelectionAllowed(false);
        this.setAutoCompleteItemRenderer((ListCellRenderer)new DefaultListCellRenderer((Renderer)new MarketingRenderer("-")));
        this.setAutoCompleteHandler(new Handler());
        DbCrmMarketing dbCrmMarketing = new DbCrmMarketing();
        dbCrmMarketing.title = "example marketing";
        this.setCrmMarketing(dbCrmMarketing);
    }

    public DbCrmMarketing getCrmMarketing() {
        return (DbCrmMarketing)this.getValue();
    }

    public void setCrmMarketing(DbCrmMarketing dbCrmMarketing) {
        this.setValue(dbCrmMarketing);
    }

    private static final class Handler
    implements DefaultAutoCompleteField.AutoCompleteHandler<DbCrmMarketing> {
        private Handler() {
        }

        public Dimension getOptionIconSize() {
            return new Dimension(16, 16);
        }

        public String getOptionText(DbCrmMarketing dbCrmMarketing) {
            if (dbCrmMarketing != null) {
                return dbCrmMarketing.print();
            }
            return "-";
        }

        public URL getOptionIconUrl(DbCrmMarketing dbCrmMarketing) {
            if (dbCrmMarketing != null) {
                return CrmPlugin.getResourceImageURL("crm.png", 16);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DbCrmMarketing> search(String string) throws Exception {
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                DbCrmMarketing[] dbCrmMarketingArray = dbCrmMarketingHandler.getMarketingsByKeyword(connection, string, 100);
                List<DbCrmMarketing> list = Arrays.asList(dbCrmMarketingArray);
                return list;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }
}

