/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmMarketingTable;
import com.openindex.openestate.tool.crm.CrmMarketingViewTask;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CrmMarketingTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMarketingTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMarketingTablePanel.class);
    private static final String TABLE_ID = "CrmMarketingTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_TITLE = 1;
    private static final int FILTER_STATUS = 2;
    private static final int COUNT_FILTERS = 3;
    private List<String> filterValues;
    private Table table;
    private JLabel filterIdLabel;
    private JFormattedTextField filterIdField;
    private JLabel filterTitleLabel;
    private JTextField filterTitleField;
    private JLabel filterStatusLabel;
    private JComboBox<DbCrmMarketing.Status> filterStatusField;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private CrmMarketingTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new MarketingAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(CrmPlugin.getResourceIcon("crm.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            this.filterValues.add(null);
        }
        this.filterIdLabel = new JLabel();
        this.filterIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.filterIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!CrmMarketingTablePanel.this.filterIdField.isEnabled()) {
                    return;
                }
                try {
                    CrmMarketingTablePanel.this.filterIdField.commitEdit();
                }
                catch (Exception exception) {
                    CrmMarketingTablePanel.this.filterIdField.setValue(null);
                }
                String string2 = string = CrmMarketingTablePanel.this.filterIdField.isEditValid() ? CrmMarketingTablePanel.this.filterIdField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && CrmMarketingTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase((String)CrmMarketingTablePanel.this.filterValues.get(0))) {
                    return;
                }
                CrmMarketingTablePanel.this.filterValues.set(0, string);
                CrmMarketingTablePanel.this.updateFilters(true);
            }
        });
        this.filterTitleLabel = new JLabel();
        this.filterTitleField = new JTextField();
        this.filterTitleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!CrmMarketingTablePanel.this.filterTitleField.isEnabled()) {
                    return;
                }
                String string = CrmMarketingTablePanel.this.filterTitleField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && CrmMarketingTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)CrmMarketingTablePanel.this.filterValues.get(1))) {
                    return;
                }
                CrmMarketingTablePanel.this.filterValues.set(1, string);
                CrmMarketingTablePanel.this.updateFilters(true);
            }
        });
        this.filterStatusLabel = new JLabel();
        this.filterStatusField = new JComboBox();
        this.filterStatusField.setRenderer((ListCellRenderer<DbCrmMarketing.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.filterStatusField.addItem(null);
        for (DbCrmMarketing.Status status : DbCrmMarketing.Status.values()) {
            this.filterStatusField.addItem(status);
        }
        this.filterStatusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CrmMarketingTablePanel.this.filterStatusField.isEnabled()) {
                    return;
                }
                DbCrmMarketing.Status status = (DbCrmMarketing.Status)((Object)CrmMarketingTablePanel.this.filterStatusField.getSelectedItem());
                if (status == null && CrmMarketingTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (status != null && status.name().equalsIgnoreCase((String)CrmMarketingTablePanel.this.filterValues.get(2))) {
                    return;
                }
                CrmMarketingTablePanel.this.filterValues.set(2, status != null ? status.name() : null);
                CrmMarketingTablePanel.this.updateFilters(true);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref");
        defaultFormBuilder.add((Component)this.filterIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.filterIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterTitleLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterTitleField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterStatusLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add(this.filterStatusField).xy(11, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    public static CrmMarketingTablePanel createTab() {
        return new CrmMarketingTablePanel();
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmMarketingTable.Row>(){

            public boolean include(CrmMarketingTable.Row row) {
                Number number = CrmMarketingTablePanel.this.filterIdField.isEditValid() ? (Number)((Number)CrmMarketingTablePanel.this.filterIdField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getMarketing().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmMarketingTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(CrmMarketingTable.Row row) {
                String string = StringUtils.trimToNull((String)CrmMarketingTablePanel.this.filterTitleField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 5.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)row.getMarketing().title)).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmMarketingTable.Row>(){

            public boolean include(CrmMarketingTable.Row row) {
                DbCrmMarketing.Status status = (DbCrmMarketing.Status)((Object)CrmMarketingTablePanel.this.filterStatusField.getSelectedItem());
                return status == null || status.equals((Object)row.getMarketing().status);
            }
        });
        return this.table;
    }

    protected void doHelp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.table.setEnabled(false);
        this.table.clearRows();
        this.table.clearSelection();
        this.updateFilters(false);
        ArrayList<DbCrmMarketing> arrayList = new ArrayList<DbCrmMarketing>();
        try {
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            DbCrmMarketing[] dbCrmMarketingArray = dbCrmMarketingHandler.getMarketings(connection);
            arrayList.addAll(Arrays.asList(dbCrmMarketingArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$marketingsList;
                {
                    this.val$marketingsList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbCrmMarketing dbCrmMarketing : this.val$marketingsList) {
                            CrmMarketingTablePanel.this.table.addRow(new CrmMarketingTable.Row(dbCrmMarketing));
                        }
                    }
                    finally {
                        CrmMarketingTablePanel.this.table.setEnabled(true);
                        CrmMarketingTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doMarketingRemove() {
        if (!CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_REMOVE)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getMarketingIdAt(n2);
            if (l <= 0L) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to delete the selected marketing actions?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new MarketingRemoveTask(lArray));
    }

    private void doMarketingView() {
        if (!CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        int n = this.table.getSelectedRowCount();
        int n2 = 0;
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            long l = this.table.getMarketingIdAt(n4);
            ImmoToolUtils.executeTask((ImmoToolTask)new CrmMarketingViewTask(immoToolProject.getDbDriver(), l, n == 1));
            if (++n2 >= 10) break;
        }
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new MarketingViewAction()));
        jPopupMenu.add((Action)((Object)new MarketingRemoveAction()));
        jPopupMenu.show(component, n, n2);
    }

    protected Icon getHeaderIcon() {
        return CrmPlugin.getResourceIcon("crm.png", 32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("table of marketing actions"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("marketings"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of your marketing actions.");
    }

    protected String getTableTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
        this.filterIdField.setEnabled(bl);
        this.filterStatusField.setEnabled(bl);
        this.filterTitleField.setEnabled(bl);
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.filterIdLabel.setText(StringUtils.capitalize((String)I18N.tr("ID")) + ":");
        this.filterTitleLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        this.filterStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
    }

    private class MarketingViewAction
    extends AbstractI18nAction {
        private MarketingViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingTablePanel.this.doMarketingView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show marketing")));
            this.setShortDescription(I18N.tr("Show details about the marketing action."));
        }
    }

    private class MarketingRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] marketingIds;

        private MarketingRemoveTask(long[] lArray) {
            this.marketingIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCrmMarketingHandler.removeMarketings(connection, this.marketingIds);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove marketing activities!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CrmMarketingTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            for (long l : this.marketingIds) {
                int n = CrmMarketingTablePanel.this.table.getRowForMarketingId(l);
                if (n <= -1) continue;
                CrmMarketingTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class MarketingRemoveAction
    extends AbstractI18nAction {
        private MarketingRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingTablePanel.this.doMarketingRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove marketing")));
            this.setShortDescription(I18N.tr("Remove the selected marketing actions."));
        }
    }

    private static class MarketingAddAction
    extends AbstractI18nAction {
        private MarketingAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new CrmPlugin.MarketingFormAction().actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new marketing action."));
        }
    }

    private class Table
    extends CrmMarketingTable<CrmMarketingTable.Row> {
        public Table() {
            super(CrmMarketingTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            CrmMarketingTablePanel.this.doMarketingRemove();
        }

        protected void doSelect() {
            CrmMarketingTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            CrmMarketingTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmMarketingTablePanel.this.doMarketingView();
        }
    }
}

