/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public enum CrmPermission implements ProjectPermission
{
    USE_PLUGIN(null, I18n.marktr((String)"use addon")),
    ACTIVITIES(USE_PLUGIN, I18n.marktr((String)"access to activities")),
    ACTIVITIES_EDIT(ACTIVITIES, I18n.marktr((String)"edit activities")),
    ACTIVITIES_REMOVE(ACTIVITIES, I18n.marktr((String)"remove activities")),
    MARKETINGS(USE_PLUGIN, I18n.marktr((String)"access to marketing actions")),
    MARKETINGS_EDIT(MARKETINGS, I18n.marktr((String)"edit marketing actions")),
    MARKETINGS_REMOVE(MARKETINGS, I18n.marktr((String)"remove marketing actions"));

    private static final Logger LOGGER;
    private static final I18n I18N;
    private final String i18nKey;
    private final ProjectPermission parent;

    private CrmPermission(ProjectPermission projectPermission, String string2) {
        this.parent = projectPermission;
        this.i18nKey = string2;
    }

    public ProjectPermission[] getChildren() {
        ArrayList<CrmPermission> arrayList = new ArrayList<CrmPermission>();
        for (CrmPermission crmPermission : CrmPermission.values()) {
            if (!this.equals(crmPermission.parent)) continue;
            arrayList.add(crmPermission);
        }
        return arrayList.toArray(new ProjectPermission[0]);
    }

    public String getKey() {
        return this.name();
    }

    public ProjectPermission getParent() {
        return this.parent;
    }

    public String getTranslation() {
        return ImmoToolUtils.getI18nString(CrmPermission.class, (String)this.i18nKey);
    }

    public String getTranslation(Locale locale) {
        return ImmoToolUtils.getI18nString(CrmPermission.class, (String)this.i18nKey, (Locale)locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(CrmPermission.class);
        I18N = I18nFactory.getI18n(CrmPermission.class);
    }
}

