/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.db;

import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingFeedback;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class DbCrmMarketingHandlerImpl
implements DbCrmMarketingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCrmMarketingHandlerImpl.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCrmMarketingHandlerImpl.class);

    protected DbCrmMarketing buildMarketing() {
        return new DbCrmMarketing();
    }

    protected DbCrmMarketingFeedback buildMarketingFeedback() {
        return new DbCrmMarketingFeedback();
    }

    @Override
    public final DbCrmMarketing[] getMarketings(Connection connection) throws SQLException {
        return this.getMarketings(connection, (long[])null);
    }

    @Override
    public abstract DbCrmMarketing[] getMarketings(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbCrmMarketing[] getMarketings(Connection var1, DbCrmMarketing.Status var2) throws SQLException;

    @Override
    public final DbCrmMarketing[] getMarketingsByKeyword(Connection connection, String string) throws SQLException {
        return this.getMarketingsByKeyword(connection, string, 0);
    }

    @Override
    public abstract DbCrmMarketing[] getMarketingsByKeyword(Connection var1, String var2, int var3) throws SQLException;

    @Override
    public final DbCrmMarketing[] getMarketingsForContact(Connection connection, long l) throws SQLException {
        return l > 0L ? this.getMarketingsForContact(connection, new long[]{l}) : new DbCrmMarketing[]{};
    }

    @Override
    public abstract DbCrmMarketing[] getMarketingsForContact(Connection var1, long[] var2) throws SQLException;

    @Override
    public final DbCrmMarketing getMarketing(Connection connection, long l) throws SQLException {
        DbCrmMarketing[] dbCrmMarketingArray = l > 0L ? this.getMarketings(connection, new long[]{l}) : null;
        return dbCrmMarketingArray != null && dbCrmMarketingArray.length > 0 ? dbCrmMarketingArray[0] : null;
    }

    @Override
    public final long[] getMarketingIds(Connection connection) throws SQLException {
        return this.getMarketingIds(connection, null, null);
    }

    @Override
    public final long[] getMarketingIds(Connection connection, long l) throws SQLException {
        return l > 0L ? this.getMarketingIds(connection, new long[]{l}, null) : new long[]{};
    }

    @Override
    public abstract long[] getMarketingIds(Connection var1, long[] var2, DbCrmMarketing.Status var3) throws SQLException;

    @Override
    public final void loadFeedbacks(Connection connection, DbCrmMarketing dbCrmMarketing) throws SQLException {
        if (dbCrmMarketing != null) {
            this.loadFeedbacks(connection, new DbCrmMarketing[]{dbCrmMarketing});
        }
    }

    @Override
    public abstract void loadFeedbacks(Connection var1, DbCrmMarketing[] var2) throws SQLException;

    @Override
    public final void removeMarketing(Connection connection, long l) throws SQLException {
        if (l > 0L) {
            this.removeMarketings(connection, new long[]{l});
        }
    }

    @Override
    public abstract void removeMarketings(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removeMarketingFeedback(Connection connection, long l, long l2) throws SQLException {
        if (l > 0L && l2 > 0L) {
            this.removeMarketingFeedbacks(connection, l, new long[]{l2});
        }
    }

    @Override
    public abstract void removeMarketingFeedbacks(Connection var1, long var2, long[] var4) throws SQLException;

    @Override
    public abstract void saveMarketing(Connection var1, DbCrmMarketing var2) throws SQLException;

    @Override
    public final void saveMarketingFeedback(Connection connection, DbCrmMarketingFeedback dbCrmMarketingFeedback) throws SQLException {
        if (dbCrmMarketingFeedback != null) {
            this.saveMarketingFeedbacks(connection, new DbCrmMarketingFeedback[]{dbCrmMarketingFeedback});
        }
    }

    @Override
    public abstract void saveMarketingFeedbacks(Connection var1, DbCrmMarketingFeedback[] var2) throws SQLException;
}

