/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingFeedback;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandlerImpl;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCrmMarketingHandler
extends DbCrmMarketingHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmMarketingHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmMarketingHandler.class);
    public static final String PROC_REMOVE_MARKETING = "remove_immotool_crm_marketing";
    public static final String PROC_REMOVE_MARKETING_FEEDBACK = "remove_immotool_crm_marketing_feedback";
    public static final String PROC_SAVE_MARKETING = "save_immotool_crm_marketing";
    public static final String PROC_SAVE_MARKETING_FEEDBACK = "save_immotool_crm_marketing_feedback";
    public static final String VIEW_MARKETING = "view_immotool_crm_marketing";
    public static final String VIEW_MARKETING_FEEDBACK = "view_immotool_crm_marketing_feedback";
    public static final String TABLE_MARKETING = "immotool_crm_marketing";
    private static final String FIELD_MARKETING_ID = "marketing_id";
    private static final String FIELD_MARKETING_TITLE = "marketing_title";
    private static final String FIELD_MARKETING_STATUS = "marketing_status";
    private static final String FIELD_MARKETING_INTERVAL = "marketing_interval";
    private static final String FIELD_MARKETING_COSTS = "marketing_costs";
    private static final String FIELD_MARKETING_BEGIN = "marketing_begin";
    private static final String FIELD_MARKETING_END = "marketing_end";
    private static final String FIELD_MARKETING_NOTES = "marketing_notes";
    public static final String TABLE_MARKETING_FEEDBACK = "immotool_crm_marketing_feedback";
    private static final String FIELD_FEEDBACK_POSITIVE = "feedback_positive";
    private static final String FIELD_FEEDBACK_TIME = "feedback_time";
    private static final String FIELD_CONTACTS_ENTRY_ID = "contacts_entry_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private DbCrmMarketing createMarketing(ResultSet resultSet) throws SQLException {
        DbCrmMarketing dbCrmMarketing = this.buildMarketing();
        dbCrmMarketing.id = resultSet.getLong(FIELD_MARKETING_ID);
        dbCrmMarketing.begin = resultSet.getDate(FIELD_MARKETING_BEGIN);
        dbCrmMarketing.end = resultSet.getDate(FIELD_MARKETING_END);
        dbCrmMarketing.title = resultSet.getString(FIELD_MARKETING_TITLE);
        dbCrmMarketing.notes = resultSet.getString(FIELD_MARKETING_NOTES);
        dbCrmMarketing.costs = resultSet.getBigDecimal(FIELD_MARKETING_COSTS);
        dbCrmMarketing.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbCrmMarketing.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbCrmMarketing.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbCrmMarketing.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbCrmMarketing.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        try {
            dbCrmMarketing.status = DbCrmMarketing.Status.valueOf(resultSet.getString(FIELD_MARKETING_STATUS));
        }
        catch (Exception exception) {
            dbCrmMarketing.status = null;
            LOGGER.warn("Can't read status of CRM marketing #" + dbCrmMarketing.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            dbCrmMarketing.interval = DbCrmMarketing.Interval.valueOf(resultSet.getString(FIELD_MARKETING_INTERVAL));
        }
        catch (Exception exception) {
            dbCrmMarketing.status = null;
            LOGGER.warn("Can't read interval of CRM marketing #" + dbCrmMarketing.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbCrmMarketing;
    }

    private DbCrmMarketingFeedback createMarketingFeedback(ResultSet resultSet) throws SQLException {
        DbCrmMarketingFeedback dbCrmMarketingFeedback = this.buildMarketingFeedback();
        dbCrmMarketingFeedback.marketingId = resultSet.getLong(FIELD_MARKETING_ID);
        dbCrmMarketingFeedback.contactEntryId = resultSet.getLong(FIELD_CONTACTS_ENTRY_ID);
        dbCrmMarketingFeedback.isPositive = resultSet.getBoolean(FIELD_FEEDBACK_POSITIVE);
        dbCrmMarketingFeedback.time = resultSet.getTimestamp(FIELD_FEEDBACK_TIME);
        return dbCrmMarketingFeedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmMarketing[] getMarketings(Connection connection, long[] lArray) throws SQLException {
        DbCrmMarketing[] dbCrmMarketingArray;
        if (lArray != null && lArray.length < 1) {
            return new DbCrmMarketing[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing ORDER BY marketing_begin ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing WHERE marketing_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_MARKETING_BEGIN + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmMarketing> arrayList = new ArrayList<DbCrmMarketing>();
            while (resultSet.next()) {
                arrayList.add(this.createMarketing(resultSet));
            }
            dbCrmMarketingArray = arrayList.toArray(new DbCrmMarketing[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmMarketingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmMarketing[] getMarketings(Connection connection, DbCrmMarketing.Status status) throws SQLException {
        DbCrmMarketing[] dbCrmMarketingArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (status == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing ORDER BY marketing_begin ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing WHERE marketing_status = ? ORDER BY marketing_begin ASC;");
                preparedStatement.setString(1, status.name());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmMarketing> arrayList = new ArrayList<DbCrmMarketing>();
            while (resultSet.next()) {
                arrayList.add(this.createMarketing(resultSet));
            }
            dbCrmMarketingArray = arrayList.toArray(new DbCrmMarketing[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmMarketingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmMarketing[] getMarketingsByKeyword(Connection connection, String string, int n) throws SQLException {
        DbCrmMarketing[] dbCrmMarketingArray;
        string = StringUtils.trimToNull((String)StringUtils.lowerCase((String)string));
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (string == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing ORDER BY marketing_begin ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing WHERE LOWER(marketing_title) LIKE ? ORDER BY marketing_begin ASC;");
                preparedStatement.setString(1, "%" + string + "%");
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmMarketing> arrayList = new ArrayList<DbCrmMarketing>();
            while (resultSet.next()) {
                arrayList.add(this.createMarketing(resultSet));
            }
            dbCrmMarketingArray = arrayList.toArray(new DbCrmMarketing[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmMarketingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmMarketing[] getMarketingsForContact(Connection connection, long[] lArray) throws SQLException {
        DbCrmMarketing[] dbCrmMarketingArray;
        if (lArray != null && lArray.length < 1) {
            return new DbCrmMarketing[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing ORDER BY marketing_begin ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing WHERE marketing_id IN (SELECT marketing_id FROM view_immotool_crm_marketing_feedback WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")) ORDER BY " + FIELD_MARKETING_BEGIN + " ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmMarketing> arrayList = new ArrayList<DbCrmMarketing>();
            while (resultSet.next()) {
                arrayList.add(this.createMarketing(resultSet));
            }
            dbCrmMarketingArray = arrayList.toArray(new DbCrmMarketing[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmMarketingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMarketingIds(Connection connection, long[] lArray, DbCrmMarketing.Status status) throws SQLException {
        long[] lArray2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("marketing_id IN (SELECT marketing_id FROM view_immotool_crm_marketing_feedback WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + "))");
            }
            if (status != null) {
                arrayList.add("marketing_status = ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT marketing_id FROM view_immotool_crm_marketing " + string + " ORDER BY " + FIELD_MARKETING_ID + " ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (status != null) {
                preparedStatement.setString(++n, status.name());
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(resultSet.getLong(FIELD_MARKETING_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])object.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadFeedbacks(Connection connection, DbCrmMarketing[] dbCrmMarketingArray) throws SQLException {
        HashMap<Long, DbCrmMarketing> hashMap = new HashMap<Long, DbCrmMarketing>();
        for (DbCrmMarketing dbCrmMarketing : dbCrmMarketingArray) {
            if (dbCrmMarketing.id <= 0L || hashMap.containsKey(dbCrmMarketing.id)) continue;
            hashMap.put(dbCrmMarketing.id, dbCrmMarketing);
            if (dbCrmMarketing.feedback != null) {
                dbCrmMarketing.feedback.clear();
                continue;
            }
            dbCrmMarketing.feedback = new HashMap<Long, DbCrmMarketingFeedback>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_marketing_feedback WHERE marketing_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_MARKETING_ID + " ASC, " + FIELD_CONTACTS_ENTRY_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DbCrmMarketingFeedback dbCrmMarketingFeedback = this.createMarketingFeedback(resultSet);
                ((DbCrmMarketing)hashMap.get((Object)Long.valueOf((long)dbCrmMarketingFeedback.marketingId))).feedback.put(dbCrmMarketingFeedback.contactEntryId, dbCrmMarketingFeedback);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeMarketings(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_crm_marketing(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeMarketingFeedbacks(Connection connection, long l, long[] lArray) throws SQLException {
        if (l < 1L || lArray == null) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_crm_marketing_feedback(:marketing_id, :contacts_entry_id);");
            for (long l2 : lArray) {
                if (l2 <= 0L) continue;
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MARKETING_ID, l);
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, l2);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveMarketing(Connection connection, DbCrmMarketing dbCrmMarketing) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block13: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_marketing(:marketing_id, :marketing_title, :marketing_status, :marketing_interval, :marketing_costs, :marketing_begin, :marketing_end, :marketing_notes, :access_owner_id, :access_group_id, :access_permissions);");
                namedCallableStatement.setLong(FIELD_MARKETING_ID, dbCrmMarketing.id);
                namedCallableStatement.setString(FIELD_MARKETING_TITLE, StringUtils.abbreviate((String)dbCrmMarketing.title, (int)255));
                namedCallableStatement.setString(FIELD_MARKETING_NOTES, dbCrmMarketing.notes);
                namedCallableStatement.setBigDecimal(FIELD_MARKETING_COSTS, dbCrmMarketing.costs != null ? dbCrmMarketing.costs : BigDecimal.ZERO);
                namedCallableStatement.setString(FIELD_MARKETING_STATUS, dbCrmMarketing.status != null ? dbCrmMarketing.status.name() : null);
                namedCallableStatement.setString(FIELD_MARKETING_INTERVAL, dbCrmMarketing.interval != null ? dbCrmMarketing.interval.name() : null);
                namedCallableStatement.setTimestamp(FIELD_MARKETING_BEGIN, dbCrmMarketing.begin != null ? new Timestamp(dbCrmMarketing.begin.getTime()) : null);
                namedCallableStatement.setTimestamp(FIELD_MARKETING_END, dbCrmMarketing.end != null ? new Timestamp(dbCrmMarketing.end.getTime()) : null);
                namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbCrmMarketing.ownerUserId);
                namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbCrmMarketing.ownerGroupId);
                namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbCrmMarketing.permission != null ? dbCrmMarketing.permission.getValue() : -1);
                namedCallableStatement.execute();
                long l2 = l = dbCrmMarketing.id < 1L ? namedCallableStatement.getLong(FIELD_MARKETING_ID) : dbCrmMarketing.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbCrmMarketing.feedback != null) {
                    DbCrmMarketing dbCrmMarketing2;
                    ArrayList<Long> arrayList2 = new ArrayList<Long>();
                    if (dbCrmMarketing.id > 0L) {
                        dbCrmMarketing2 = new DbCrmMarketing();
                        dbCrmMarketing2.id = dbCrmMarketing.id;
                        this.loadFeedbacks(connection, dbCrmMarketing2);
                        if (dbCrmMarketing2.feedback != null && !dbCrmMarketing2.feedback.isEmpty()) {
                            arrayList2.addAll(dbCrmMarketing2.feedback.keySet());
                        }
                        NamedCallableStatement namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_crm_marketing_feedback(:marketing_id, :contacts_entry_id);");
                        for (Long l3 : arrayList2) {
                            if (dbCrmMarketing.feedback.containsKey(l3)) continue;
                            namedCallableStatement2.clearParameters();
                            namedCallableStatement2.setLong(FIELD_MARKETING_ID, dbCrmMarketing.id);
                            namedCallableStatement2.setLong(FIELD_CONTACTS_ENTRY_ID, l3.longValue());
                            namedCallableStatement2.execute();
                            arrayList.add(namedCallableStatement2.getStatement());
                        }
                    }
                    if (!dbCrmMarketing.feedback.isEmpty()) {
                        dbCrmMarketing2 = new NamedCallableStatement(connection, "CALL save_immotool_crm_marketing_feedback(:marketing_id, :contacts_entry_id, :feedback_positive, :feedback_time);");
                        for (DbCrmMarketingFeedback dbCrmMarketingFeedback : dbCrmMarketing.feedback.values()) {
                            dbCrmMarketing2.clearParameters();
                            dbCrmMarketing2.setLong(FIELD_MARKETING_ID, l);
                            dbCrmMarketing2.setLong(FIELD_CONTACTS_ENTRY_ID, dbCrmMarketingFeedback.contactEntryId);
                            dbCrmMarketing2.setBoolean(FIELD_FEEDBACK_POSITIVE, dbCrmMarketingFeedback.isPositive);
                            dbCrmMarketing2.setTimestamp(FIELD_FEEDBACK_TIME, dbCrmMarketingFeedback.time != null ? new Timestamp(dbCrmMarketingFeedback.time.getTime()) : null);
                            dbCrmMarketing2.execute();
                        }
                        arrayList.add(dbCrmMarketing2.getStatement());
                    }
                }
                connection.commit();
                if (dbCrmMarketing.id >= 1L) break block13;
                dbCrmMarketing.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveMarketingFeedbacks(Connection connection, DbCrmMarketingFeedback[] dbCrmMarketingFeedbackArray) throws SQLException {
        if (dbCrmMarketingFeedbackArray == null || dbCrmMarketingFeedbackArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_marketing_feedback(:marketing_id, :contacts_entry_id, :feedback_positive, :feedback_time);");
            for (DbCrmMarketingFeedback dbCrmMarketingFeedback : dbCrmMarketingFeedbackArray) {
                if (dbCrmMarketingFeedback.marketingId <= 0L || dbCrmMarketingFeedback.contactEntryId <= 0L) continue;
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MARKETING_ID, dbCrmMarketingFeedback.marketingId);
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbCrmMarketingFeedback.contactEntryId);
                namedCallableStatement.setBoolean(FIELD_FEEDBACK_POSITIVE, dbCrmMarketingFeedback.isPositive);
                namedCallableStatement.setTimestamp(FIELD_FEEDBACK_TIME, dbCrmMarketingFeedback.time != null ? new Timestamp(dbCrmMarketingFeedback.time.getTime()) : null);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

