/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.crm.addons.calendar.db.DbCrmActivityCalendarEntry;
import com.openindex.openestate.tool.crm.addons.calendar.db.DbCrmCalendarHandlerImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCrmCalendarHandler
extends DbCrmCalendarHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmCalendarHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmCalendarHandler.class);
    public static final String VIEW_CRM_ACTIVITIES_CALENDAR_ENTRIES = "view_immotool_crm_activities_calendar_entries";
    public static final String PROC_REMOVE_CRM_ACTIVITIES_CALENDAR_ENTRIES = "remove_immotool_crm_activities_calendar_entries";
    public static final String PROC_SAVE_CRM_ACTIVITIES_CALENDAR_ENTRIES = "save_immotool_crm_activities_calendar_entries";
    private static final String FIELD_CRM_ACTIVITY_ID = "activity_id";
    private static final String FIELD_CALENDAR_ENTRY_ID = "calendar_entry_id";

    private DbCrmActivityCalendarEntry createActivityCalendarEntry(ResultSet resultSet) throws SQLException {
        DbCrmActivityCalendarEntry dbCrmActivityCalendarEntry = this.buildActivityCalendarEntry();
        dbCrmActivityCalendarEntry.crmActivityId = resultSet.getLong(FIELD_CRM_ACTIVITY_ID);
        dbCrmActivityCalendarEntry.calendarEntryId = resultSet.getLong(FIELD_CALENDAR_ENTRY_ID);
        return dbCrmActivityCalendarEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbCrmActivityCalendarEntry[] getActivityCalendarEntries(Connection connection, long[] lArray, long[] lArray2) throws SQLException {
        DbCrmActivityCalendarEntry[] dbCrmActivityCalendarEntryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("activity_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            if (lArray2 != null) {
                arrayList.add("calendar_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities_calendar_entries " + string + " ORDER BY " + FIELD_CRM_ACTIVITY_ID + " ASC, " + FIELD_CALENDAR_ENTRY_ID + " ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (lArray2 != null) {
                for (long l : lArray2) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.createActivityCalendarEntry(resultSet));
            }
            dbCrmActivityCalendarEntryArray = object.toArray(new DbCrmActivityCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityCalendarEntryArray;
    }

    @Override
    public void removeActivityCalendarEntries(Connection connection, DbCrmActivityCalendarEntry[] dbCrmActivityCalendarEntryArray) throws SQLException {
        if (dbCrmActivityCalendarEntryArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_crm_activities_calendar_entries(:activity_id, :calendar_entry_id);");
            for (DbCrmActivityCalendarEntry dbCrmActivityCalendarEntry : dbCrmActivityCalendarEntryArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_CRM_ACTIVITY_ID, dbCrmActivityCalendarEntry.crmActivityId);
                namedCallableStatement.setLong(FIELD_CALENDAR_ENTRY_ID, dbCrmActivityCalendarEntry.calendarEntryId);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveActivityCalendarEntries(Connection connection, DbCrmActivityCalendarEntry dbCrmActivityCalendarEntry) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_activities_calendar_entries(:activity_id, :calendar_entry_id);");
            namedCallableStatement.setLong(FIELD_CRM_ACTIVITY_ID, dbCrmActivityCalendarEntry.crmActivityId);
            namedCallableStatement.setLong(FIELD_CALENDAR_ENTRY_ID, dbCrmActivityCalendarEntry.calendarEntryId);
            namedCallableStatement.execute();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

