/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.gui.ActivityTypeRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.FormattedDate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmActivityTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityTable.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityTable.class);

    public CrmActivityTable(String string) {
        super(string);
    }

    public CrmActivityTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public DbCrmActivity getActivityAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getActivity() : null;
    }

    public Long getActivityIdAt(int n) {
        DbCrmActivity dbCrmActivity = this.getActivityAt(n);
        return dbCrmActivity != null ? dbCrmActivity.id : 0L;
    }

    public int getRowForActivityId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getActivityIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    public DbCrmActivity.Type getTypeAt(int n) {
        DbCrmActivity dbCrmActivity = this.getActivityAt(n);
        return dbCrmActivity != null ? dbCrmActivity.type : null;
    }

    protected void init() {
        this.setSortable(true);
        this.setColumnControlVisible(true);
        this.setMultipleIntervalSelection();
        super.init();
        this.getColumn(Column.ID).setMaxWidth(75);
        this.getColumn(Column.TYPE).setMinWidth(40);
        this.getColumn(Column.TYPE).setMaxWidth(40);
        this.setSortOrder((Object)Column.BEGIN, SortOrder.DESCENDING);
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbCrmActivity activity;

        public Row(DbCrmActivity dbCrmActivity) {
            this.activity = dbCrmActivity;
        }

        public DbCrmActivity getActivity() {
            return this.activity;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForActivity((Column)column);
            }
            return null;
        }

        public Object getValueForActivity(Column column) {
            if (this.activity == null) {
                return null;
            }
            switch (column) {
                case ID: {
                    return this.activity.id;
                }
                case SUBJECT: {
                    return StringUtils.trimToEmpty((String)this.activity.subject);
                }
                case TYPE: {
                    return this.activity.type;
                }
                case DIRECTION: {
                    return this.activity.direction;
                }
                case STATUS: {
                    return this.activity.status;
                }
                case BEGIN: {
                    return this.activity.begin != null ? FormattedDate.createDateTimeInstance((Date)this.activity.begin, (int)3, (int)3) : null;
                }
                case END: {
                    return this.activity.end != null ? FormattedDate.createDateTimeInstance((Date)this.activity.end, (int)3, (int)3) : null;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        TYPE,
        SUBJECT,
        BEGIN,
        END,
        DIRECTION,
        STATUS;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case BEGIN: 
                case END: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(2, 3)));
                }
                case TYPE: {
                    return new DefaultTableCellRenderer((Renderer)new ActivityTypeRenderer(true));
                }
                case DIRECTION: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
                case STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case SUBJECT: {
                    return String.class;
                }
                case BEGIN: 
                case END: {
                    return Date.class;
                }
                case TYPE: {
                    return DbCrmActivity.Type.class;
                }
                case DIRECTION: {
                    return DbCrmActivity.Direction.class;
                }
                case STATUS: {
                    return DbCrmActivity.Status.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case SUBJECT: {
                    return StringUtils.capitalize((String)I18N.tr("subject"));
                }
                case BEGIN: {
                    return StringUtils.capitalize((String)I18N.tr("begin"));
                }
                case END: {
                    return StringUtils.capitalize((String)I18N.tr("end"));
                }
                case TYPE: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
                case DIRECTION: {
                    return StringUtils.capitalize((String)I18N.tr("direction"));
                }
                case STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("status"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
            }
            return true;
        }
    }
}

