/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryRelationPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.crm.CrmMarketingViewTask;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.CrmPluginUtils;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingFeedback;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.crm.extensions.MarketingViewExtension;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.BooleanRenderer;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CrmMarketingViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMarketingViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMarketingViewPanel.class);
    private static final String FEEDBACK_TABLE_ID = "CrmMarketingViewPanel.FeedbackTable";
    private DbCrmMarketing currentMarketing = null;
    private long nextMarketingId = 0L;
    private long prevMarketingId = 0L;
    private boolean mayEditMarketing = false;
    private boolean mayRemoveMarketing = false;
    private List<MarketingViewExtension> addons;
    private MarketingTab marketingTab;
    private FeedbackTab feedbackTab;
    private NotesTab notesTab;
    private PermissionsTab permissionTab;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private CrmMarketingViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(CrmPlugin.getResourceIcon("crm.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.marketingTab = (MarketingTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new MarketingTab(), (JTabbedPane)jTabbedPane);
        this.feedbackTab = (FeedbackTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new FeedbackTab(), (JTabbedPane)jTabbedPane);
        try {
            for (MarketingViewExtension marketingViewExtension : this.addons) {
                AbstractTab[] abstractTabArray = marketingViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addon-panels!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.notesTab = (NotesTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesTab(), (JTabbedPane)jTabbedPane);
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionTab = (PermissionsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new PermissionsTab(), (JTabbedPane)jTabbedPane);
        }
    }

    public static CrmMarketingViewPanel createTab() {
        return CrmMarketingViewPanel.createTab(null);
    }

    public static CrmMarketingViewPanel createTab(DbCrmMarketing dbCrmMarketing) {
        CrmMarketingViewPanel crmMarketingViewPanel = new CrmMarketingViewPanel();
        crmMarketingViewPanel.setMarketing(dbCrmMarketing);
        return crmMarketingViewPanel;
    }

    protected void doCopy() {
        if (!this.mayEditMarketing) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    private void doFeedbackAdd() {
        this.feedbackTab.tablePanel.contactsRelationForm.selectEmptyRelation();
    }

    private void doFeedbackEntrySubmit() {
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        if (!this.feedbackTab.submitNewContact(dbContactsEntry)) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new FeedbackEntrySubmitTask(dbContactsEntry));
    }

    private void doFeedbackEntryView() {
        int n = this.feedbackTab.tablePanel.contactsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.feedbackTab.tablePanel.contactsTable.getContactEntryIdAt(this.feedbackTab.tablePanel.contactsTable.convertRowIndexToModel(n));
        new ContactsPlugin.EntryFormAction(l).actionPerformed(null);
    }

    private void doFeedbackRefresh() {
        try {
            this.feedbackTab.load(this.currentMarketing);
            ImmoToolUtils.executeTask((ImmoToolTask)new FeedbackRefreshTask());
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload marketing feedbacks!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload marketing feedbacks!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doFeedbackRemove() {
        if (this.feedbackTab.tablePanel.contactsTable.removeSelectedRows()) {
            this.feedbackTab.unselectRelation();
            this.feedbackTab.tablePanel.updateTitle();
        }
    }

    private void doFeedbackShowActions(Component component, int n, int n2) {
        if (this.feedbackTab.tablePanel.contactsTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new FeedbackRemoveAction()));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_user.png", (int)16));
        jPopupMenu.add(jMenu);
        jMenu.add((Action)((Object)new FeedbackEntryViewAction()));
        Object[] objectArray = this.feedbackTab.tablePanel.contactsTable.getAddons();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Long[] longArray = null;
            if (longArray == null) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = this.feedbackTab.tablePanel.contactsTable.getSelectedRows();
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[i];
                    int n5 = this.feedbackTab.tablePanel.contactsTable.convertRowIndexToModel(n4);
                    arrayList.add(this.feedbackTab.tablePanel.contactsTable.getContactEntryIdAt(n5));
                }
                longArray = arrayList.toArray(new Long[0]);
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                try {
                    objectArray2 = object.createActionMenuItems(immoToolProject, longArray, (JComponent)((Object)this));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load popup extension!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                if (!ArrayUtils.isNotEmpty((Object[])objectArray2)) continue;
                for (Object object2 : objectArray2) {
                    jMenu.add((JMenuItem)object2);
                }
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    protected void doHelp() {
    }

    protected void doLoadInBackground(Connection connection) {
        DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
        this.nextMarketingId = 0L;
        this.prevMarketingId = 0L;
        try {
            long[] lArray = dbCrmMarketingHandler.getMarketingIds(connection);
            int n = ArrayUtils.indexOf((long[])lArray, (long)this.currentMarketing.id);
            if (n > 0) {
                this.prevMarketingId = lArray[n - 1];
            }
            if (n + 1 < lArray.length) {
                this.nextMarketingId = lArray[n + 1];
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void doRefresh() {
        if (this.currentMarketing != null && this.currentMarketing.id > 0L) {
            this.setMarketing(this.currentMarketing);
            this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentMarketing == null || this.currentMarketing.id < 1L) {
            return;
        }
        if (!this.mayRemoveMarketing) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove marketing action {0}?", (Object)("#" + this.currentMarketing.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask(this.currentMarketing.id));
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentMarketing != null && this.currentMarketing.id > 0L && CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentMarketing != null && this.currentMarketing.id > 0L && this.mayRemoveMarketing));
        jPopupMenu.addSeparator();
        for (MarketingViewExtension marketingViewExtension : this.addons) {
            Object[] objectArray = marketingViewExtension.createActionMenuItems(this.currentMarketing);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.add((Action)this.notesTab.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditMarketing) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextMarketingId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new CrmMarketingViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.nextMarketingId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevMarketingId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new CrmMarketingViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.prevMarketingId, this));
        }
    }

    public long getCurrentMarketingId() {
        return this.currentMarketing != null ? this.currentMarketing.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return CrmPlugin.getResourceIcon("crm.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentMarketing == null || this.currentMarketing.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new marketing action"));
        }
        return StringUtils.capitalize((String)I18N.tr("marketing action")) + " #" + this.currentMarketing.id;
    }

    public String getTabTitle() {
        if (this.currentMarketing == null || this.currentMarketing.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new marketing action"));
        }
        return StringUtils.capitalize((String)I18N.tr("marketing action")) + " #" + this.currentMarketing.id;
    }

    public String getTabToolTipText() {
        if (this.currentMarketing == null || this.currentMarketing.id < 1L) {
            return I18N.tr("Create a new marketing action.");
        }
        return I18N.tr("Edit marketing action {0}.", (Object)("#" + this.currentMarketing.id));
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<MarketingViewExtension>();
        try {
            for (MarketingViewExtension marketingViewExtension : CrmPluginUtils.getMarketingViewExtensions()) {
                this.addons.add(marketingViewExtension);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected boolean isLoadedInBackground() {
        return this.currentMarketing != null && this.currentMarketing.id > 0L;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditMarketing);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextMarketingId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevMarketingId > 0L);
        this.feedbackTab.tablePanel.createAction.setEnabled(bl);
        this.feedbackTab.tablePanel.refreshAction.setEnabled(bl);
        this.feedbackTab.tablePanel.showActionsAction.setEnabled(bl && this.feedbackTab.tablePanel.contactsTable.getRowCount() > 0);
        if (this.feedbackTab.formPanel != null) {
            this.feedbackTab.formPanel.submitAction.setEnabled(bl);
        }
    }

    public void setMarketing(DbCrmMarketing dbCrmMarketing) {
        this.currentMarketing = dbCrmMarketing != null ? dbCrmMarketing : new DbCrmMarketing();
        this.prevMarketingId = 0L;
        this.nextMarketingId = 0L;
        this.mayEditMarketing = CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT);
        this.mayRemoveMarketing = CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_REMOVE);
        if (this.currentMarketing.permission != null) {
            AbstractMainViewTab[] abstractMainViewTabArray = ImmoToolProject.getAppInstance().getUser();
            this.mayEditMarketing = this.mayEditMarketing && this.currentMarketing.permission.canWrite((DbUser)abstractMainViewTabArray, this.currentMarketing.ownerUserId, this.currentMarketing.ownerGroupId);
            this.mayRemoveMarketing = this.mayRemoveMarketing && this.currentMarketing.permission.canDelete((DbUser)abstractMainViewTabArray, this.currentMarketing.ownerUserId, this.currentMarketing.ownerGroupId);
        }
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentMarketing);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbCrmMarketing, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbCrmMarketing doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            this.warnings.clear();
            Connection connection = null;
            try {
                DbCrmMarketing dbCrmMarketing;
                long l;
                connection = immoToolProject.getDbConnection();
                long l2 = l = CrmMarketingViewPanel.this.currentMarketing != null ? ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.id : 0L;
                if (l < 1L || this.saveAsCopy) {
                    dbCrmMarketing = new DbCrmMarketing();
                } else {
                    dbCrmMarketing = dbCrmMarketingHandler.getMarketing(connection, l);
                    if (dbCrmMarketing == null) {
                        throw new Exception("Can't load marketing #" + l + "!");
                    }
                    dbCrmMarketingHandler.loadFeedbacks(connection, dbCrmMarketing);
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbCrmMarketing);
                }
                dbCrmMarketingHandler.saveMarketing(connection, dbCrmMarketing);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, immoToolProject, dbCrmMarketing);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                DbCrmMarketing dbCrmMarketing2 = dbCrmMarketing;
                return dbCrmMarketing2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save marketing!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CrmMarketingViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbCrmMarketing dbCrmMarketing) {
            super.succeeded((Object)dbCrmMarketing);
            if (dbCrmMarketing == null) {
                return;
            }
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            CrmMarketingViewPanel.this.setMarketing(dbCrmMarketing);
            CrmMarketingViewPanel.this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long marketingId;

        private RemoveTask(long l) {
            this.marketingId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCrmMarketingHandler.removeMarketing(connection, this.marketingId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete marketing action!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CrmMarketingViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)CrmMarketingViewPanel.this), (boolean)true);
        }
    }

    public static class FeedbackTableRow
    extends ContactsEntryTable.Row {
        private final DbCrmMarketingFeedback feedback;

        private FeedbackTableRow(DbContactsEntry dbContactsEntry, String string, DbCrmMarketingFeedback dbCrmMarketingFeedback) {
            super(dbContactsEntry, string);
            this.feedback = dbCrmMarketingFeedback;
        }

        public DbCrmMarketingFeedback getFeedback() {
            return this.feedback;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof FeedbackTableColumn) {
                return this.getValueForFeedback((FeedbackTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForFeedback(FeedbackTableColumn feedbackTableColumn) {
            if (this.feedback == null) {
                return null;
            }
            switch (feedbackTableColumn) {
                case FEEDBACK_POSITIVE: {
                    return this.feedback.isPositive;
                }
                case FEEDBACK_TIME: {
                    return this.feedback.time;
                }
            }
            return null;
        }
    }

    public static enum FeedbackTableColumn implements AbstractTable.Column
    {
        FEEDBACK_POSITIVE,
        FEEDBACK_TIME;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case FEEDBACK_POSITIVE: {
                    return new DefaultTableCellRenderer((Renderer)new BooleanRenderer());
                }
                case FEEDBACK_TIME: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(2, 3)));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case FEEDBACK_POSITIVE: {
                    return Boolean.class;
                }
                case FEEDBACK_TIME: {
                    return Date.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case FEEDBACK_POSITIVE: {
                    return I18N.tr("positive");
                }
                case FEEDBACK_TIME: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private class FeedbackTable
    extends ContactsEntryTable<FeedbackTableRow> {
        private FeedbackTable() {
            super(CrmMarketingViewPanel.FEEDBACK_TABLE_ID);
        }

        protected void doRemove() {
            CrmMarketingViewPanel.this.doFeedbackRemove();
        }

        protected void doSelect() {
            CrmMarketingViewPanel.this.feedbackTab.tablePanel.showActionsAction.setEnabled(this.getSelectedColumnCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmMarketingViewPanel.this.feedbackTab.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                DbContactsEntry dbContactsEntry = this.getContactEntryAt(n);
                DbCrmMarketingFeedback dbCrmMarketingFeedback = new DbCrmMarketingFeedback();
                dbCrmMarketingFeedback.marketingId = ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.id;
                dbCrmMarketingFeedback.contactEntryId = dbContactsEntry.id;
                dbCrmMarketingFeedback.isPositive = this.isPositiveAt(n);
                dbCrmMarketingFeedback.time = this.getTimeAt(n);
                CrmMarketingViewPanel.this.feedbackTab.selectRelation(dbContactsEntry, dbCrmMarketingFeedback);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmMarketingViewPanel.this.doFeedbackShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmMarketingViewPanel.this.doFeedbackEntryView();
        }

        public DbCrmMarketingFeedback getFeedbackAt(int n) {
            FeedbackTableRow feedbackTableRow = (FeedbackTableRow)this.getRow(n);
            return feedbackTableRow != null ? feedbackTableRow.getFeedback() : null;
        }

        public Date getTimeAt(int n) {
            DbCrmMarketingFeedback dbCrmMarketingFeedback = this.getFeedbackAt(n);
            return dbCrmMarketingFeedback != null ? dbCrmMarketingFeedback.time : null;
        }

        public boolean isPositiveAt(int n) {
            DbCrmMarketingFeedback dbCrmMarketingFeedback = this.getFeedbackAt(n);
            return dbCrmMarketingFeedback != null && dbCrmMarketingFeedback.isPositive;
        }

        protected List<AbstractTable.Column> listColumns() {
            List list = super.listColumns();
            list.addAll(Arrays.asList(FeedbackTableColumn.values()));
            return list;
        }
    }

    private class FeedbackShowActionsAction
    extends AbstractI18nAction {
        private FeedbackShowActionsAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmMarketingViewPanel.this.doFeedbackShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected addresses."));
        }
    }

    private class FeedbackRemoveAction
    extends AbstractI18nAction {
        private FeedbackRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingViewPanel.this.doFeedbackRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class FeedbackRefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private FeedbackRefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmMarketingViewPanel.this.feedbackTab.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class FeedbackRefreshAction
    extends AbstractI18nAction {
        private FeedbackRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingViewPanel.this.doFeedbackRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class FeedbackEntryViewAction
    extends AbstractI18nAction {
        private FeedbackEntryViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingViewPanel.this.doFeedbackEntryView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show the selected addresses."));
        }
    }

    private class FeedbackEntrySubmitTask
    extends ImmoToolTask<Boolean, Void> {
        private final DbContactsEntry entry;
        private String groupName = null;

        private FeedbackEntrySubmitTask(DbContactsEntry dbContactsEntry) {
            this.entry = dbContactsEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            this.groupName = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsHandler.saveEntry(connection, this.entry);
                DbContactsGroup dbContactsGroup = dbContactsHandler.getGroup(connection, this.entry.groupId);
                if (dbContactsGroup == null) {
                    throw new Exception("Can't find group #" + this.entry.groupId + "!");
                }
                this.groupName = dbContactsGroup.name;
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void finished() {
            super.finished();
            CrmMarketingViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsRelationForm.unselectRelation();
            DbCrmMarketingFeedback dbCrmMarketingFeedback = new DbCrmMarketingFeedback();
            dbCrmMarketingFeedback.time = new Date();
            dbCrmMarketingFeedback.contactEntryId = this.entry.id;
            CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.addRow((AbstractTable.Row)new FeedbackTableRow(this.entry, this.groupName, dbCrmMarketingFeedback));
            CrmMarketingViewPanel.this.feedbackTab.tablePanel.updateTitle();
            CrmMarketingViewPanel.this.feedbackTab.clearNewContact();
            CrmMarketingViewPanel.this.feedbackTab.tabbedPane.setSelectedIndex(0);
        }
    }

    private class FeedbackEntrySubmitAction
    extends AbstractI18nAction {
        private FeedbackEntrySubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingViewPanel.this.doFeedbackEntrySubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save and assign the new address."));
        }
    }

    private class FeedbackAddAction
    extends AbstractI18nAction {
        private FeedbackAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingViewPanel.this.doFeedbackAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private final class PermissionsTab
    extends AbstractTab {
        private ImmoToolPermissionPanel form;
        private boolean loaded = false;

        private PermissionsTab() {
            this.build();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel();
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void doLoadInBackground(Connection connection) {
            this.loaded = false;
            try {
                ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                DbExtension dbExtension = immoToolProject.getDbExtension();
                DbUser dbUser = immoToolProject.getUser();
                if (CrmMarketingViewPanel.this.currentMarketing != null && ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.id > 0L) {
                    this.form.setPermission(((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.ownerUserId, ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.ownerGroupId, ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.permission);
                } else {
                    this.form.setPermission(dbUser.id, 0L, null);
                }
                this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
                this.loaded = true;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load permissions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.loaded = false;
            }
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabEnabled() {
            return this.loaded;
        }

        @Override
        public void load(DbCrmMarketing dbCrmMarketing) {
            this.loaded = false;
            this.form.setPermission(0L, 0L, null);
        }

        @Override
        public void save(DbCrmMarketing dbCrmMarketing) {
            DbGroup dbGroup;
            dbCrmMarketing.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbCrmMarketing.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbCrmMarketing.ownerGroupId = dbGroup.id;
            }
        }
    }

    private final class NotesTab
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbCrmMarketing dbCrmMarketing) {
            this.notesField.setText(dbCrmMarketing != null ? StringUtils.trimToEmpty((String)dbCrmMarketing.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbCrmMarketing dbCrmMarketing) {
            dbCrmMarketing.notes = this.notesField.getText().trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the marketing action")));
        }
    }

    private final class FeedbackRelationForm
    extends ContactsEntryRelationPanel {
        private JCheckBox feedbackPositiveField;
        private JLabel feedbackTimeLabel;
        private JSpinner feedbackTimeField;

        private FeedbackRelationForm() {
            super(false);
            this.updateLocalization();
        }

        protected void buildForm(DefaultFormBuilder defaultFormBuilder) {
            this.feedbackPositiveField = new JCheckBox();
            this.feedbackTimeLabel = new JLabel();
            this.feedbackTimeField = new JSpinner(new SpinnerDateModel());
            this.feedbackTimeField.setEditor(new JSpinner.DateEditor(this.feedbackTimeField));
            this.feedbackTimeField.setValue(new Date());
            defaultFormBuilder.add((Component)this.feedbackTimeLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.feedbackTimeField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.feedbackPositiveField).xy(5, defaultFormBuilder.row());
        }

        protected void close() {
            if (CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.getSelectedRowCount() > 0) {
                CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbContactsGroup dbContactsGroup, DbContactsEntry dbContactsEntry, String string) {
            if (dbContactsGroup == null || dbContactsEntry == null) {
                return false;
            }
            CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.setEnabled(false);
            try {
                this.feedbackTimeField.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                DbCrmMarketingFeedback dbCrmMarketingFeedback = new DbCrmMarketingFeedback();
                dbCrmMarketingFeedback.contactEntryId = dbContactsEntry.id;
                dbCrmMarketingFeedback.marketingId = ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.id;
                dbCrmMarketingFeedback.isPositive = this.feedbackPositiveField.isSelected();
                dbCrmMarketingFeedback.time = (Date)this.feedbackTimeField.getValue();
                if (this.getCurrentContactEntryId() < 1L) {
                    CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.addRow((AbstractTable.Row)new FeedbackTableRow(dbContactsEntry, dbContactsGroup.name, dbCrmMarketingFeedback));
                } else {
                    int n = CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.convertRowIndexToModel(n);
                        CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.setRowAt(n2, (AbstractTable.Row)new FeedbackTableRow(dbContactsEntry, dbContactsGroup.name, dbCrmMarketingFeedback));
                    }
                }
            }
            finally {
                CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.clearSelection();
                CrmMarketingViewPanel.this.feedbackTab.tablePanel.contactsTable.setEnabled(true);
                CrmMarketingViewPanel.this.feedbackTab.tablePanel.updateTitle();
            }
            return true;
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.feedbackTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("time")) + ":");
            this.feedbackPositiveField.setText(I18N.tr("Feedback is positive."));
        }
    }

    private final class FeedbackTabTable
    extends com.openindex.openestate.tool.gui.AbstractTab {
        private JXTitledSeparator titleLabel;
        private FeedbackTable contactsTable;
        private FeedbackRelationForm contactsRelationForm;
        private AbstractI18nAction showActionsAction;
        private AbstractI18nAction refreshAction;
        private AbstractI18nAction createAction;

        private FeedbackTabTable() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.createAction = new FeedbackAddAction();
            this.refreshAction = new FeedbackRefreshAction();
            this.showActionsAction = new FeedbackShowActionsAction();
            this.showActionsAction.setEnabled(false);
            this.contactsTable = new FeedbackTable();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.titleLabel, (Action[])new Action[]{this.refreshAction, this.createAction, this.showActionsAction});
            this.contactsRelationForm = new FeedbackRelationForm();
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.contactsTable.createScrollPane(), "Center");
            this.add((Component)((Object)this.contactsRelationForm), "South");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("addresses"));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.updateTitle();
        }

        private void updateTitle() {
            int n;
            String string = StringUtils.capitalize((String)I18N.tr("assigned addresses"));
            int n2 = n = this.contactsTable != null ? this.contactsTable.getRowCount() : 0;
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.titleLabel.setTitle(string);
        }
    }

    private final class FeedbackTabForm
    extends com.openindex.openestate.tool.gui.AbstractTab {
        private ValidationHandler newContactValidationHandler;
        private JXTitledSeparator titleLabel;
        private JLabel newContactGroupLabel;
        private JComboBox<DbContactsGroup> newContactGroupBox;
        private ContactsEntryExtendedAddressPanel newContactAddressPanel;
        private FeedbackEntrySubmitAction submitAction;

        private FeedbackTabForm() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.submitAction = new FeedbackEntrySubmitAction();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.titleLabel, (Action[])new Action[]{this.submitAction});
            this.newContactGroupLabel = new JLabel();
            this.newContactGroupBox = new JComboBox();
            this.newContactGroupBox.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select address group") + " ]";
                }
            }));
            this.newContactAddressPanel = new ContactsEntryExtendedAddressPanel(50);
            this.newContactAddressPanel.load(new DbContactsEntry());
            this.newContactValidationHandler = ImmoToolUtils.createValidationHandler();
            this.newContactValidationHandler.putRule(this.newContactGroupBox, ValidationHandler.NOT_BLANK);
            this.newContactValidationHandler.init();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.newContactGroupLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.newContactGroupBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.newContactAddressPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        private void clearNewContact() {
            this.newContactAddressPanel.load(new DbContactsEntry());
            this.newContactGroupBox.setSelectedItem(null);
            this.newContactValidationHandler.init();
            this.newContactAddressPanel.initInputs();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("new address"));
        }

        private boolean submitNewContact(DbContactsEntry dbContactsEntry) {
            this.newContactValidationHandler.validate();
            this.newContactAddressPanel.validateInputs();
            if (!this.newContactValidationHandler.isValid() || !this.newContactAddressPanel.isValidInput()) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided address is incomplete!"), (Component)((Object)CrmMarketingViewPanel.this));
                return false;
            }
            this.newContactAddressPanel.save(dbContactsEntry);
            dbContactsEntry.groupId = ((DbContactsGroup)this.newContactGroupBox.getSelectedItem()).id;
            return true;
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("create a new address")));
            this.newContactGroupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
        }
    }

    private final class FeedbackTab
    extends AbstractTab {
        private JXTitledSeparator titleLabel;
        private JTabbedPane tabbedPane;
        private FeedbackTabForm formPanel;
        private FeedbackTabTable tablePanel;

        private FeedbackTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.tabbedPane = new JTabbedPane();
            this.tablePanel = (FeedbackTabTable)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new FeedbackTabTable(), (JTabbedPane)this.tabbedPane);
            this.formPanel = ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT) ? (FeedbackTabForm)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new FeedbackTabForm(), (JTabbedPane)this.tabbedPane) : null;
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.titleLabel, "North");
            this.add(this.tabbedPane, "Center");
        }

        private void clearNewContact() {
            if (this.formPanel != null) {
                this.formPanel.clearNewContact();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection) throws Exception {
            this.tablePanel.contactsTable.setEnabled(false);
            this.tablePanel.contactsTable.clearSelection();
            this.tablePanel.contactsTable.clearRows();
            if (CrmMarketingViewPanel.this.currentMarketing != null) {
                if (((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.feedback == null) {
                    ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.feedback = new HashMap<Long, DbCrmMarketingFeedback>();
                } else {
                    ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.feedback.clear();
                }
            }
            HashMap<Long, DbContactsGroup> hashMap = new HashMap<Long, DbContactsGroup>();
            HashMap<Long, DbContactsEntry> hashMap2 = new HashMap<Long, DbContactsEntry>();
            try {
                DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
                DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
                for (DbContactsGroup dbContactsEntryArray : dbContactsHandler.getGroups(connection)) {
                    hashMap.put(dbContactsEntryArray.id, dbContactsEntryArray);
                }
                if (CrmMarketingViewPanel.this.currentMarketing != null && ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.id > 0L) {
                    dbCrmMarketingHandler.loadFeedbacks(connection, CrmMarketingViewPanel.this.currentMarketing);
                    ArrayList<Long> arrayList = new ArrayList<Long>(((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.feedback.keySet());
                    long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
                    DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntries(connection, lArray);
                    dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
                    for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
                        hashMap2.put(dbContactsEntry.id, dbContactsEntry);
                    }
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(hashMap, hashMap2){
                    final /* synthetic */ Map val$groupsMap;
                    final /* synthetic */ Map val$entriesMap;
                    {
                        this.val$groupsMap = map;
                        this.val$entriesMap = map2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object2;
                            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                            for (Object object2 : this.val$groupsMap.values()) {
                                Iterator<Map.Entry<Long, DbCrmMarketingFeedback>> iterator = StringUtils.trimToEmpty((String)((DbContactsGroup)object2).name);
                                int n = 0;
                                while (treeMap.containsKey(iterator)) {
                                    iterator = StringUtils.trimToEmpty((String)((DbContactsGroup)object2).name) + "_" + ++n;
                                }
                                treeMap.put((String)((Object)iterator), object2);
                            }
                            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
                            object2 = new DefaultComboBoxModel();
                            defaultComboBoxModel.addElement(null);
                            ((DefaultComboBoxModel)object2).addElement(null);
                            for (DbContactsGroup dbContactsGroup : treeMap.values()) {
                                defaultComboBoxModel.addElement(dbContactsGroup);
                                ((DefaultComboBoxModel)object2).addElement(dbContactsGroup);
                            }
                            FeedbackTab.this.tablePanel.contactsRelationForm.setContactsGroupsModel((ComboBoxModel)object2);
                            if (FeedbackTab.this.formPanel != null) {
                                FeedbackTab.this.formPanel.newContactGroupBox.setModel(defaultComboBoxModel);
                            }
                            for (Map.Entry<Long, DbCrmMarketingFeedback> entry : ((CrmMarketingViewPanel)CrmMarketingViewPanel.this).currentMarketing.feedback.entrySet()) {
                                DbCrmMarketingFeedback dbCrmMarketingFeedback = entry.getValue();
                                DbContactsEntry dbContactsEntry = (DbContactsEntry)this.val$entriesMap.get(entry.getKey());
                                String string = this.val$groupsMap.containsKey(dbContactsEntry.groupId) ? ((DbContactsGroup)this.val$groupsMap.get((Object)Long.valueOf((long)dbContactsEntry.groupId))).name : null;
                                FeedbackTab.this.tablePanel.contactsTable.addRow((AbstractTable.Row)new FeedbackTableRow(dbContactsEntry, string, dbCrmMarketingFeedback));
                            }
                        }
                        finally {
                            FeedbackTab.this.tablePanel.contactsTable.setEnabled(true);
                            FeedbackTab.this.tablePanel.showActionsAction.setEnabled(false);
                            FeedbackTab.this.tablePanel.updateTitle();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("addresses"));
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabUsable() {
            return this.tabbedPane.getTabCount() > 0;
        }

        @Override
        public void load(DbCrmMarketing dbCrmMarketing) {
            this.unselectRelation();
            this.tablePanel.contactsTable.setEnabled(false);
            this.tablePanel.contactsTable.clearSelection();
            this.tablePanel.contactsTable.clearRows();
            this.tablePanel.updateTitle();
        }

        @Override
        public void save(DbCrmMarketing dbCrmMarketing) {
            this.tabbedPane.setSelectedIndex(0);
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCrmMarketing dbCrmMarketing) throws SQLException {
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            dbCrmMarketingHandler.loadFeedbacks(connection, dbCrmMarketing);
            if (dbCrmMarketing.feedback == null) {
                dbCrmMarketing.feedback = new HashMap<Long, DbCrmMarketingFeedback>();
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < this.tablePanel.contactsTable.getRowCount(); ++i) {
                Long l = this.tablePanel.contactsTable.getContactEntryIdAt(i);
                DbCrmMarketingFeedback dbCrmMarketingFeedback = dbCrmMarketing.feedback.containsKey(l) ? dbCrmMarketing.feedback.get(l) : new DbCrmMarketingFeedback();
                dbCrmMarketingFeedback.marketingId = dbCrmMarketing.id;
                dbCrmMarketingFeedback.contactEntryId = l;
                dbCrmMarketingFeedback.isPositive = this.tablePanel.contactsTable.isPositiveAt(i);
                dbCrmMarketingFeedback.time = this.tablePanel.contactsTable.getTimeAt(i);
                dbCrmMarketingHandler.saveMarketingFeedback(connection, dbCrmMarketingFeedback);
                arrayList.add(l);
                dbCrmMarketing.feedback.put(l, dbCrmMarketingFeedback);
            }
            for (Long l : dbCrmMarketing.feedback.keySet().toArray(new Long[0])) {
                if (arrayList.contains(l)) continue;
                dbCrmMarketingHandler.removeMarketingFeedback(connection, dbCrmMarketing.id, l);
                dbCrmMarketing.feedback.remove(l);
            }
        }

        private void selectRelation(DbContactsEntry dbContactsEntry, DbCrmMarketingFeedback dbCrmMarketingFeedback) {
            this.tablePanel.contactsRelationForm.selectRelation(dbContactsEntry, null);
            this.tablePanel.contactsRelationForm.feedbackPositiveField.setSelected(dbCrmMarketingFeedback == null || dbCrmMarketingFeedback.isPositive);
            this.tablePanel.contactsRelationForm.feedbackTimeField.setValue(dbCrmMarketingFeedback != null && dbCrmMarketingFeedback.time != null ? dbCrmMarketingFeedback.time : new Date());
        }

        private boolean submitNewContact(DbContactsEntry dbContactsEntry) {
            return this.formPanel != null && this.formPanel.submitNewContact(dbContactsEntry);
        }

        private void unselectRelation() {
            this.selectRelation(null, null);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("feedback addresses of the marketing action")));
        }
    }

    private final class MarketingTab
    extends AbstractTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator title;
        private JLabel titleLabel;
        private JTextField titleField;
        private JLabel beginLabel;
        private DefaultDatePicker beginField;
        private JLabel endLabel;
        private DefaultDatePicker endField;
        private JLabel statusLabel;
        private JComboBox<DbCrmMarketing.Status> statusField;
        private JLabel intervalLabel;
        private JComboBox<DbCrmMarketing.Interval> intervalField;

        private MarketingTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.titleLabel = new JLabel();
            this.titleField = new JTextField();
            this.beginLabel = new JLabel();
            this.beginField = new DefaultDatePicker();
            this.endLabel = new JLabel();
            this.endField = new DefaultDatePicker();
            this.statusLabel = new JLabel();
            this.statusField = new JComboBox();
            this.statusField.setRenderer((ListCellRenderer<DbCrmMarketing.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.statusField.addItem(null);
            for (DbCrmMarketing.Status enum_ : DbCrmMarketing.Status.values()) {
                this.statusField.addItem(enum_);
            }
            this.intervalLabel = new JLabel();
            this.intervalField = new JComboBox();
            this.intervalField.setRenderer((ListCellRenderer<DbCrmMarketing.Interval>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.intervalField.addItem(null);
            for (Enum enum_ : DbCrmMarketing.Interval.values()) {
                this.intervalField.addItem((DbCrmMarketing.Interval)enum_);
            }
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.validationHandler.putRule((JComponent)this.titleField, ValidationHandler.NOT_BLANK);
            this.validationHandler.putRule((JComponent)this.beginField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.statusField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.intervalField, ValidationHandler.NOT_NULL);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow");
            defaultFormBuilder.add((Component)this.titleLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.titleField).xyw(3, defaultFormBuilder.row(), 5);
            defaultFormBuilder.add((Component)this.beginLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.beginField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.intervalLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.intervalField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.endLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.endField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.statusLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.statusField).xy(7, defaultFormBuilder.row());
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(defaultFormBuilder.getPanel(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("marketing"));
        }

        public boolean isTabValid() {
            this.validationHandler.validate();
            return this.validationHandler.isValid();
        }

        @Override
        public void load(DbCrmMarketing dbCrmMarketing) {
            this.titleField.setText(dbCrmMarketing.title);
            this.beginField.setDate(dbCrmMarketing.begin);
            this.endField.setDate(dbCrmMarketing.end);
            this.statusField.setSelectedItem((Object)(dbCrmMarketing.status != null ? dbCrmMarketing.status : DbCrmMarketing.Status.PLANNED));
            this.intervalField.setSelectedItem((Object)(dbCrmMarketing.interval != null ? dbCrmMarketing.interval : DbCrmMarketing.Interval.UNIQUE));
            if (dbCrmMarketing.id > 0L) {
                this.validationHandler.validate();
            } else {
                this.validationHandler.init();
            }
        }

        @Override
        public void save(DbCrmMarketing dbCrmMarketing) {
            dbCrmMarketing.title = this.titleField.getText().trim();
            dbCrmMarketing.begin = this.beginField.getDate();
            dbCrmMarketing.end = this.endField.getDate();
            dbCrmMarketing.status = (DbCrmMarketing.Status)((Object)this.statusField.getSelectedItem());
            dbCrmMarketing.interval = (DbCrmMarketing.Interval)((Object)this.intervalField.getSelectedItem());
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("details about the marketing action")));
            this.titleLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
            this.beginLabel.setText(StringUtils.capitalize((String)I18N.tr("begin")) + ":");
            this.endLabel.setText(StringUtils.capitalize((String)I18N.tr("end")) + ":");
            this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
            this.intervalLabel.setText(StringUtils.capitalize((String)I18N.tr("interval")) + ":");
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<CrmMarketingViewPanel> viewPanel = null;
        private final List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public CrmMarketingViewPanel getViewPanel() {
            return this.viewPanel != null ? (CrmMarketingViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbCrmMarketing var1) throws Exception;

        public abstract void save(DbCrmMarketing var1) throws Exception;

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCrmMarketing dbCrmMarketing) throws SQLException, IOException {
        }

        public void setViewPanel(CrmMarketingViewPanel crmMarketingViewPanel) {
            this.viewPanel = crmMarketingViewPanel != null ? new WeakReference<CrmMarketingViewPanel>(crmMarketingViewPanel) : null;
        }
    }
}

