/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.EnumRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.extensions.MailAccountSetupExtension;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.mail.io.ImapPanel;
import com.openindex.openestate.tool.mail.io.Pop3Panel;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAccountReaderTab
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountReaderTab.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountReaderTab.class);
    private JTabbedPane tabbedPane;
    private GeneralTab generalTab;
    private OptionsTab optionsTab;
    private List<MailAccountSetupExtension> extensions;

    public MailAccountReaderTab(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.extensions = new ArrayList<MailAccountSetupExtension>();
        try {
            for (MailAccountSetupExtension mailAccountSetupExtension : MailPluginUtils.getMailAccountSetupExtensions()) {
                try {
                    this.extensions.add(mailAccountSetupExtension);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load mail-account-setup-extension!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load mail-account-setup-extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.tabbedPane = new JTabbedPane();
        this.generalTab = (GeneralTab)ImmoToolUtils.addTab((AbstractTab)new GeneralTab(), (JTabbedPane)this.tabbedPane);
        this.optionsTab = (OptionsTab)ImmoToolUtils.addTab((AbstractTab)new OptionsTab(), (JTabbedPane)this.tabbedPane);
        this.setLayout(new BorderLayout());
        this.add(this.tabbedPane, "Center");
        this.setOpaque(false);
        this.setBorder(Paddings.EMPTY);
        this.updateLocalization();
        this.load(null);
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("receiving"));
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return this.generalTab.currentFormPanel != null ? this.generalTab.currentFormPanel.getValidationHandler() : null;
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        this.generalTab.load(dbMailAccount);
        this.optionsTab.load(dbMailAccount);
        for (MailAccountSetupExtension mailAccountSetupExtension : this.extensions) {
            mailAccountSetupExtension.load(dbMailAccount);
        }
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        this.generalTab.save(dbMailAccount);
        this.optionsTab.save(dbMailAccount);
        for (MailAccountSetupExtension mailAccountSetupExtension : this.extensions) {
            mailAccountSetupExtension.save(dbMailAccount);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.generalTab.setEnabled(bl);
        this.optionsTab.setEnabled(bl);
    }

    private static class EmptyFormPanel
    extends MailAccountDialogForm {
        private EmptyFormPanel() {
        }

        @Override
        public String getTitle() {
            return "";
        }

        @Override
        public ValidationHandler getValidationHandler() {
            return null;
        }

        @Override
        public void load(DbMailAccount dbMailAccount) {
        }

        @Override
        public void save(DbMailAccount dbMailAccount) {
        }
    }

    private class OptionsTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JCheckBox debugField;
        private JCheckBox autoRetrievalField;
        private JSpinner autoRetrievalIntervalField;
        private JLabel autoRetrievalIntervalLabel1;
        private JLabel autoRetrievalIntervalLabel2;
        private JLabel optionsLabel;
        private JPanel optionsPanel;
        private final List<JComponent> optionComponents = new ArrayList<JComponent>();

        private OptionsTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.debugField = new JCheckBox();
            this.autoRetrievalField = new JCheckBox();
            this.autoRetrievalField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = OptionsTab.this.autoRetrievalField.isSelected();
                    OptionsTab.this.autoRetrievalIntervalField.setEnabled(bl);
                    OptionsTab.this.autoRetrievalIntervalLabel1.setEnabled(bl);
                    OptionsTab.this.autoRetrievalIntervalLabel2.setEnabled(bl);
                }
            });
            this.autoRetrievalIntervalField = new JSpinner(new SpinnerNumberModel(5, 1, 999, 1));
            this.autoRetrievalIntervalField.setPreferredSize(new Dimension(60, this.autoRetrievalIntervalField.getPreferredSize().height));
            this.autoRetrievalIntervalLabel1 = new JLabel();
            this.autoRetrievalIntervalLabel2 = new JLabel();
            this.optionsLabel = new JLabel();
            this.optionsPanel = new JPanel();
            this.optionsPanel.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane(this.optionsPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
            this.updateForm(null);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("options"));
        }

        public void load(DbMailAccount dbMailAccount) {
            this.debugField.setSelected(dbMailAccount != null && dbMailAccount.isReaderDebug());
            int n = dbMailAccount != null ? (int)(dbMailAccount.autoRetrievalInterval / 60000L) : 5;
            this.autoRetrievalField.setSelected(dbMailAccount != null && dbMailAccount.autoRetrieval);
            this.autoRetrievalIntervalField.setValue(n > 0 ? n : 5);
            this.autoRetrievalIntervalField.setEnabled(this.isEnabled() && this.autoRetrievalField.isSelected());
            this.autoRetrievalIntervalLabel1.setEnabled(this.autoRetrievalField.isSelected());
            this.autoRetrievalIntervalLabel2.setEnabled(this.autoRetrievalField.isSelected());
        }

        public void save(DbMailAccount dbMailAccount) {
            AbstractMailReader.Type type;
            if (this.autoRetrievalIntervalField.isEnabled()) {
                try {
                    this.autoRetrievalIntervalField.commitEdit();
                }
                catch (ParseException parseException) {
                    LOGGER.warn("Invalid interval!");
                    LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                }
            }
            dbMailAccount.setReaderDebug((type = dbMailAccount.getReaderType()) != null && this.debugField.isSelected());
            dbMailAccount.autoRetrieval = this.autoRetrievalField.isSelected();
            if (dbMailAccount.autoRetrieval) {
                dbMailAccount.autoRetrievalInterval = ((Number)this.autoRetrievalIntervalField.getValue()).longValue() * 60000L;
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.debugField.setEnabled(bl);
            this.autoRetrievalField.setEnabled(bl);
            this.autoRetrievalIntervalField.setEnabled(bl && this.autoRetrievalField.isSelected());
            for (JComponent jComponent : this.optionComponents) {
                jComponent.setEnabled(bl);
            }
        }

        private void updateForm(AbstractMailReader.Type type) {
            Object[] objectArray;
            this.optionsPanel.removeAll();
            this.optionComponents.clear();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
            jPanel.add(this.autoRetrievalIntervalLabel1);
            jPanel.add(this.autoRetrievalIntervalField);
            jPanel.add(this.autoRetrievalIntervalLabel2);
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 0));
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow", (JPanel)this.optionsPanel);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            for (MailAccountSetupExtension mailAccountSetupExtension : MailAccountReaderTab.this.extensions) {
                objectArray = mailAccountSetupExtension.getReaderOptions(type);
                if (objectArray == null || objectArray.isEmpty()) continue;
                for (Map.Entry<String, JComponent> entry : objectArray.entrySet()) {
                    JComponent jComponent = entry.getValue();
                    this.optionComponents.add(jComponent);
                    defaultFormBuilder.add((Component)new JLabel(entry.getKey() + ":")).xy(1, defaultFormBuilder.nextRow());
                    defaultFormBuilder.add((Component)jComponent).xy(3, defaultFormBuilder.row());
                }
            }
            defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.autoRetrievalField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)jPanel).xy(3, defaultFormBuilder.nextRow());
            for (MailAccountSetupExtension mailAccountSetupExtension : MailAccountReaderTab.this.extensions) {
                objectArray = mailAccountSetupExtension.getReaderFurtherOptions(type);
                if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                for (Object object : objectArray) {
                    defaultFormBuilder.add((Component)object).xy(3, defaultFormBuilder.nextRow());
                }
            }
            defaultFormBuilder.add((Component)this.debugField).xy(3, defaultFormBuilder.nextRow());
            this.optionsPanel.revalidate();
            this.optionsPanel.repaint();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("options for mail receiving")));
            this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
            this.debugField.setText(I18N.tr("Log mail transfer."));
            this.debugField.setToolTipText(I18N.tr("Enable this option to protocol the mail traffic into a separate log file. This option may be helpful in case of mailing problems."));
            this.autoRetrievalField.setText(I18N.tr("Check for new messages automatically."));
            this.autoRetrievalField.setToolTipText(I18N.tr("Enable this option to check the mail account for new messages automatically."));
            this.autoRetrievalIntervalField.setToolTipText(I18N.tr("Use this field to specify, in which intervals the mail account is checked for new messages."));
            this.autoRetrievalIntervalLabel1.setText(I18N.tr("every"));
            this.autoRetrievalIntervalLabel2.setText(I18N.tr("minutes"));
        }
    }

    private class GeneralTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JLabel protocolLabel;
        private JComboBox<AbstractMailReader.Type> protocolField;
        private JPanel formContainerPanel;
        private MailAccountDialogForm emptyFormPanel;
        private MailAccountDialogForm currentFormPanel = null;
        private final Map<AbstractMailReader.Type, MailAccountDialogForm> forms = new EnumMap<AbstractMailReader.Type, MailAccountDialogForm>(AbstractMailReader.Type.class);

        private GeneralTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.protocolLabel = new JLabel();
            this.protocolField = new JComboBox();
            this.protocolField.addItem(null);
            for (AbstractMailReader.Type type : AbstractMailReader.Type.values()) {
                this.protocolField.addItem(type);
            }
            this.protocolField.setRenderer((ListCellRenderer<AbstractMailReader.Type>)new DefaultListCellRenderer((Renderer)new EnumRenderer<AbstractMailReader.Type>(){

                public String getEmptyText() {
                    return I18N.tr("no mail receiving");
                }
            }));
            this.protocolField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!GeneralTab.this.protocolField.isEnabled()) {
                        return;
                    }
                    GeneralTab.this.selectReader((AbstractMailReader.Type)((Object)GeneralTab.this.protocolField.getSelectedItem()), null);
                }
            });
            this.formContainerPanel = new JPanel();
            this.emptyFormPanel = new EmptyFormPanel();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.protocolLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.protocolField).xy(3, defaultFormBuilder.row());
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
            jPanel.add((Component)this.formContainerPanel, "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("receiving"));
        }

        public void load(DbMailAccount dbMailAccount) {
            AbstractMailReader.Type type = dbMailAccount != null ? dbMailAccount.getReaderType() : null;
            this.forms.clear();
            this.protocolField.setEnabled(false);
            this.selectReader(type, dbMailAccount);
            this.protocolField.setSelectedItem((Object)type);
            this.protocolField.setEnabled(this.isEnabled());
        }

        public void save(DbMailAccount dbMailAccount) {
            AbstractMailReader.Type type = (AbstractMailReader.Type)((Object)this.protocolField.getSelectedItem());
            if (type != null && this.forms.containsKey((Object)type)) {
                this.forms.get((Object)type).save(dbMailAccount);
            } else {
                dbMailAccount.setReader(null);
            }
        }

        private void selectReader(AbstractMailReader.Type type, DbMailAccount dbMailAccount) {
            MailAccountDialogForm mailAccountDialogForm;
            if (type == null) {
                mailAccountDialogForm = this.emptyFormPanel;
            } else if (this.forms.containsKey((Object)type)) {
                mailAccountDialogForm = this.forms.get((Object)type);
            } else {
                switch (type) {
                    case IMAP: {
                        mailAccountDialogForm = new ImapPanel(MailAccountReaderTab.this.getDialog());
                        break;
                    }
                    case POP3: {
                        mailAccountDialogForm = new Pop3Panel(MailAccountReaderTab.this.getDialog());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown mail-reader-type: " + type.toString());
                    }
                }
                this.forms.put(type, mailAccountDialogForm);
            }
            if (dbMailAccount != null) {
                if (mailAccountDialogForm != null) {
                    mailAccountDialogForm.load(dbMailAccount);
                }
            } else if (mailAccountDialogForm != null) {
                mailAccountDialogForm.loadDefaults();
            }
            this.currentFormPanel = mailAccountDialogForm;
            this.formContainerPanel.removeAll();
            this.formContainerPanel.setLayout(new BorderLayout());
            if (mailAccountDialogForm != null) {
                this.formContainerPanel.add((Component)((Object)mailAccountDialogForm), "Center");
            }
            this.formContainerPanel.revalidate();
            this.formContainerPanel.repaint();
            MailAccountReaderTab.this.tabbedPane.setSelectedIndex(0);
            MailAccountReaderTab.this.tabbedPane.setEnabledAt(1, type != null);
            MailAccountReaderTab.this.optionsTab.updateForm(type);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.protocolField.setEnabled(bl);
            for (MailAccountDialogForm mailAccountDialogForm : this.forms.values()) {
                mailAccountDialogForm.setEnabled(bl);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("configure mail receiving")));
            this.protocolLabel.setText(StringUtils.capitalize((String)I18N.tr("protocol")) + ":");
            this.protocolField.setToolTipText(I18N.tr("Use this field to specify, how messages are received for this mail account."));
        }
    }
}

