/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.mail.MailNotification;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAccountHandler;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import com.openindex.openestate.tool.mail.extensions.MailHandlerExtension;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.mail.io.ImapIdleStore;
import com.openindex.openestate.tool.mail.io.ImapReader;
import com.openindex.openestate.tool.mail.io.Pop3Reader;
import com.openindex.openestate.tool.mail.utils.ExtendedMimeMessage;
import com.openindex.openestate.tool.mail.utils.MdnMail;
import com.openindex.openestate.tool.utils.Permission;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.IMAPFolder;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.UIDFolder;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.jsieve.mailet.mdn.ActionModeAutomatic;
import org.apache.jsieve.mailet.mdn.SendingModeAutomatic;
import org.apache.jsieve.mailet.mdn.TypeDisplayed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(MailHandler.class);
    public static final Flags FORWARDED = new Flags("forwarded");
    private Map<Long, DbMailAccount> remoteAccounts = new LinkedHashMap<Long, DbMailAccount>();
    private Map<Long, Store> remoteAccountStores = new HashMap<Long, Store>();
    private Map<Long, ImapIdleStore> remoteAccountIdleStores = new HashMap<Long, ImapIdleStore>();
    private Map<Long, Transport> remoteAccountTransports = new HashMap<Long, Transport>();
    private Map<Long, DbMailAccount> localSharedAccounts = new LinkedHashMap<Long, DbMailAccount>();
    private DbMailAccount localPrivateAccount = null;
    private Map<Long, DbMailFolder> rootFolders = new HashMap<Long, DbMailFolder>();
    private Map<Long, Integer> folderUnseenMessageCount = new HashMap<Long, Integer>();
    private ArrayList<WeakReference<MailHandlerExtension>> customListeners = new ArrayList();
    private List<Long> loadingFolders = new ArrayList<Long>();
    private List<Long> loadingAccounts = new ArrayList<Long>();

    public synchronized void addCustomListener(MailHandlerExtension mailHandlerExtension) {
        if (mailHandlerExtension != null) {
            this.customListeners.add(new WeakReference<MailHandlerExtension>(mailHandlerExtension));
        }
        for (int i = this.customListeners.size() - 1; i > 0; --i) {
            WeakReference<MailHandlerExtension> weakReference = this.customListeners.get(i);
            if (weakReference != null && weakReference.get() != null) continue;
            this.customListeners.remove(i);
        }
        this.customListeners.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolder(String string, DbMailFolder dbMailFolder) throws MessagingException, SQLException {
        if (dbMailFolder == null || dbMailFolder.id < 1L || !dbMailFolder.holdsFolders || StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.addFolder(immoToolProject, connection, string.trim(), dbMailFolder);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void addFolder(ImmoToolProject immoToolProject, Connection connection, String string, DbMailFolder dbMailFolder) throws MessagingException, SQLException {
        DbMailFolder dbMailFolder2;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder.id < 1L || !dbMailFolder.holdsFolders || StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        string = string.trim();
        Folder folder = this.getRemoteFolder(dbMailFolder);
        int n = -1;
        if (folder != null && folder.exists() && (folder.getType() & 2) == 2 && !(dbMailFolder2 = folder.getFolder(string)).exists()) {
            MailPluginUtils.createRemoteFolder((Folder)dbMailFolder2);
            n = dbMailFolder2.getType();
            try {
                dbMailFolder2.setSubscribed(true);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't subscribe folder!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (dbMailFolder.subFolders == null) {
            dbMailMessageHandler.loadFolderChildren(connection, dbMailFolder, false);
        }
        if (!dbMailFolder.hasSubFolder(string)) {
            dbMailFolder2 = dbMailFolder.createSubFolder(string);
            boolean bl = n > -1 ? (n & 2) == 2 : (dbMailFolder2.holdsFolders = true);
            dbMailFolder2.holdsMessages = n > -1 ? (n & 1) == 1 : true;
            dbMailFolder2.parentFolder = dbMailFolder;
            dbMailFolder2.subFolders = new ArrayList<DbMailFolder>();
            dbMailFolder.subFolders.add(dbMailFolder2);
            dbMailMessageHandler.saveFolder(connection, dbMailFolder2);
            this.fireFolderWasAdded(immoToolProject, dbMailFolder2);
        }
    }

    public void addFolderInBackground(final String string, final DbMailFolder dbMailFolder) {
        if (dbMailFolder == null || dbMailFolder.id < 1L || !dbMailFolder.holdsFolders || StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Add folder"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.addFolder(string.trim(), dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't add folder!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMailMessage addMessage(MimeMessage mimeMessage, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        if (dbMailFolder == null || dbMailFolder.id < 1L || mimeMessage == null) {
            return null;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            DbMailMessage dbMailMessage = this.addMessage(immoToolProject, connection, mimeMessage, dbMailFolder);
            return dbMailMessage;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMailMessage addMessage(ImmoToolProject immoToolProject, Connection connection, MimeMessage mimeMessage, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        Object object;
        DbMailMessage dbMailMessage;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder.id < 1L || mimeMessage == null) {
            return null;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        String string = null;
        Long l = null;
        Long l2 = null;
        DbMailAccount dbMailAccount = this.getRemoteAccount(dbMailFolder.accountId);
        if (dbMailAccount != null && AbstractMailReader.Type.IMAP.equals((Object)dbMailAccount.getReaderType())) {
            dbMailMessage = this.getRemoteFolder(dbMailFolder);
            if (dbMailMessage == null || !dbMailMessage.exists()) {
                throw new MessagingException("Can't find remote folder!");
            }
            try {
                dbMailMessage.open(2);
                object = (IMAPFolder)dbMailMessage;
                mimeMessage = new ExtendedMimeMessage(mimeMessage, null, false);
                Object[] objectArray = object.appendUIDMessages(new Message[]{mimeMessage});
                if (ArrayUtils.isEmpty((Object[])objectArray)) {
                    throw new MessagingException("Mail server did not send an UID response for the appended message!");
                }
                l = ((AppendUID)objectArray[0]).uid;
                l2 = ((AppendUID)objectArray[0]).uidvalidity;
                MimeMessage mimeMessage2 = (MimeMessage)object.getMessageByUID(l.longValue());
                string = mimeMessage2.getMessageID();
            }
            finally {
                MailPluginUtils.closeQuietly((Folder)dbMailMessage);
            }
        }
        dbMailMessage = DbMailMessage.createMessage(mimeMessage);
        dbMailMessage.folderId = dbMailFolder.id;
        if (l != null) {
            dbMailMessage.uid = l;
        }
        if (l2 != null) {
            dbMailMessage.uidValidity = l2;
        }
        if (!StringUtils.isEmpty(string)) {
            dbMailMessage.mimeId = string;
        }
        dbMailMessage.isDownloaded = false;
        dbMailMessageHandler.saveMessage(connection, dbMailMessage);
        object = DbMailPart.createPart(mimeMessage);
        ((DbMailPart)object).setMessageId(dbMailMessage.id);
        dbMailMessageHandler.savePart(connection, (DbMailPart)object, true);
        dbMailMessage.isDownloaded = true;
        dbMailMessage.hasAttachments = ((DbMailPart)object).hasAttachment();
        dbMailMessageHandler.saveMessage(connection, dbMailMessage);
        if (!dbMailMessage.isSeen) {
            int n = this.getUnseenMessageCount(dbMailMessage.folderId);
            if (++n > 0) {
                this.folderUnseenMessageCount.put(dbMailMessage.folderId, n);
            } else {
                this.folderUnseenMessageCount.remove(dbMailMessage.folderId);
            }
        }
        this.fireMessageWasAdded(immoToolProject, dbMailMessage);
        return dbMailMessage;
    }

    public void addMessageInBackground(final MimeMessage mimeMessage, final DbMailFolder dbMailFolder) {
        if (dbMailFolder == null || dbMailFolder.id < 1L || mimeMessage == null) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Add message"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.addMessage(mimeMessage, dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't add message!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMessages(long[] lArray, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        if (lArray == null || lArray.length < 1 || dbMailFolder == null || !dbMailFolder.holdsMessages) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.copyMessages(immoToolProject, connection, lArray, dbMailFolder);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMessages(ImmoToolProject immoToolProject, Connection connection, long[] lArray, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        DbMailMessageHandler dbMailMessageHandler;
        if (lArray == null || lArray.length < 1 || dbMailFolder == null || !dbMailFolder.holdsMessages) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null && (folder.getType() & 1) != 1) {
            throw new MessagingException("Destination folder '" + folder.getFullName() + "' does not allow messages!");
        }
        for (long l : lArray) {
            Object object62;
            Object object2;
            Object object3;
            DbMailMessage dbMailMessage = dbMailMessageHandler.getMessage(connection, l);
            if (dbMailMessage == null) {
                LOGGER.warn("Can't find message #" + l);
                continue;
            }
            if (dbMailMessage.folderId == dbMailFolder.id) continue;
            dbMailMessageHandler.loadAddresses(connection, dbMailMessage);
            boolean bl = dbMailMessage.isSeen;
            DbMailFolder dbMailFolder2 = this.getFolder(dbMailMessage.folderId);
            Folder folder2 = this.getRemoteFolder(dbMailFolder2);
            String string = null;
            Long l2 = null;
            Long l3 = null;
            if (folder2 != null && folder != null) {
                try {
                    folder2.open(1);
                    folder.open(2);
                    object3 = MailPluginUtils.searchFolder(folder2, dbMailMessage);
                    if (object3 == null) {
                        throw new MessagingException("Can't find message '" + dbMailMessage.mimeId + "' in source folder '" + folder2.getFullName() + "'!");
                    }
                    dbMailMessage.updateFlags(object3.getFlags());
                    if (!IMAPFolder.class.isInstance(folder)) {
                        string = MailPluginUtils.getUniqueMessageId();
                        object2 = new ExtendedMimeMessage((MimeMessage)object3, string, true);
                        folder.appendMessages(new Message[]{object2});
                    }
                    object2 = (IMAPFolder)folder;
                    object62 = new ExtendedMimeMessage((MimeMessage)object3, null, true);
                    Object[] objectArray = object2.appendUIDMessages(new Message[]{object62});
                    if (ArrayUtils.isEmpty((Object[])objectArray)) {
                        LOGGER.warn("Mail server did not send an UID response for the appended message!");
                        continue;
                    }
                    l2 = ((AppendUID)objectArray[0]).uid;
                    l3 = ((AppendUID)objectArray[0]).uidvalidity;
                    MimeMessage mimeMessage = (MimeMessage)object2.getMessageByUID(l2.longValue());
                    string = mimeMessage.getMessageID();
                }
                finally {
                    MailPluginUtils.closeQuietly(folder2);
                    MailPluginUtils.closeQuietly(folder);
                }
            } else if (folder2 == null && folder != null) {
                object3 = null;
                try {
                    Object object4;
                    folder.open(2);
                    object2 = dbMailMessageHandler.getPartOnRoot(connection, dbMailMessage.id);
                    dbMailMessageHandler.loadPartChildren(connection, (DbMailPart)object2, true);
                    dbMailMessageHandler.loadPartHeaders(connection, (DbMailPart)object2, true);
                    object3 = MailPluginUtils.downloadAttachments(connection, dbMailMessageHandler, (DbMailPart)object2, !StringUtils.isBlank((CharSequence)dbMailMessage.mimeId));
                    object62 = MailPluginUtils.createMimeMessage(dbMailMessage, (DbMailPart)object2, null, false, (Map<Long, File>)object3);
                    if (!IMAPFolder.class.isInstance(folder)) {
                        string = MailPluginUtils.getUniqueMessageId();
                        object4 = new ExtendedMimeMessage((MimeMessage)object62, string, true);
                        folder.appendMessages(new Message[]{object4});
                    }
                    object4 = (IMAPFolder)folder;
                    ExtendedMimeMessage extendedMimeMessage = new ExtendedMimeMessage((MimeMessage)object62, null, true);
                    Object[] objectArray = object4.appendUIDMessages(new Message[]{extendedMimeMessage});
                    if (ArrayUtils.isEmpty((Object[])objectArray)) {
                        LOGGER.warn("Mail server did not send an UID response for the appended message!");
                        continue;
                    }
                    l2 = ((AppendUID)objectArray[0]).uid;
                    l3 = ((AppendUID)objectArray[0]).uidvalidity;
                    MimeMessage mimeMessage = (MimeMessage)object4.getMessageByUID(l2.longValue());
                    string = mimeMessage.getMessageID();
                }
                finally {
                    MailPluginUtils.closeQuietly(folder);
                    if (object3 != null && !object3.isEmpty()) {
                        for (Object object62 : object3.values()) {
                            FileUtils.deleteQuietly((File)object62);
                        }
                    }
                }
            } else if (folder2 != null && folder == null) {
                try {
                    folder2.open(1);
                    object3 = MailPluginUtils.searchFolder(folder2, dbMailMessage);
                    if (object3 == null) {
                        throw new MessagingException("Can't find message '" + dbMailMessage.mimeId + "' in source folder '" + folder2.getFullName() + "'!");
                    }
                    dbMailMessage.updateFlags(object3.getFlags());
                    if (!dbMailMessage.isDownloaded) {
                        object2 = (MimeMessage)object3;
                        this.downloadMessageParts(null, connection, (Message)object2, dbMailMessage);
                    }
                }
                finally {
                    MailPluginUtils.closeQuietly(folder2);
                }
            }
            dbMailMessageHandler.saveMessage(connection, dbMailMessage);
            if (!bl) {
                int n = this.getUnseenMessageCount(dbMailFolder2.id);
                if (--n > 0) {
                    this.folderUnseenMessageCount.put(dbMailFolder2.id, n);
                } else {
                    this.folderUnseenMessageCount.remove(dbMailFolder2.id);
                }
            }
            this.fireFolderWasUpdated(immoToolProject, dbMailFolder2);
            object3 = dbMailMessageHandler.getMessage(connection, dbMailMessage.id);
            dbMailMessageHandler.loadAddresses(connection, (DbMailMessage)object3);
            ((DbMailMessage)object3).id = 0L;
            ((DbMailMessage)object3).folderId = dbMailFolder.id;
            ((DbMailMessage)object3).uid = l2 != null ? l2 : null;
            Long l4 = ((DbMailMessage)object3).uidValidity = l3 != null ? l3 : null;
            if (!StringUtils.isBlank((CharSequence)string)) {
                ((DbMailMessage)object3).mimeId = string;
            }
            dbMailMessageHandler.saveMessage(connection, (DbMailMessage)object3);
            object2 = dbMailMessageHandler.getPartOnRoot(connection, dbMailMessage.id);
            dbMailMessageHandler.loadPartChildren(connection, (DbMailPart)object2, true);
            dbMailMessageHandler.loadPartHeaders(connection, (DbMailPart)object2, true);
            object62 = MailPluginUtils.downloadAttachments(connection, dbMailMessageHandler, (DbMailPart)object2, true);
            if (object62.containsKey(((DbMailPart)object2).id)) {
                ((DbMailPart)object2).tempFileContent = (File)object62.get(((DbMailPart)object2).id);
            }
            for (DbMailPart dbMailPart : ((DbMailPart)object2).getAllSubParts()) {
                if (object62.containsKey(dbMailPart.id)) {
                    dbMailPart.tempFileContent = (File)object62.get(dbMailPart.id);
                }
                dbMailPart.id = 0L;
            }
            ((DbMailPart)object2).id = 0L;
            ((DbMailPart)object2).setMessageId(((DbMailMessage)object3).id);
            dbMailMessageHandler.savePart(connection, (DbMailPart)object2, true);
            if (!((DbMailMessage)object3).isSeen) {
                int n = this.getUnseenMessageCount(dbMailFolder.id);
                if (++n > 0) {
                    this.folderUnseenMessageCount.put(dbMailFolder.id, n);
                } else {
                    this.folderUnseenMessageCount.remove(dbMailFolder.id);
                }
            }
            this.fireMessageWasAdded(immoToolProject, (DbMailMessage)object3);
        }
    }

    public void copyMessagesInBackground(final long[] lArray, final DbMailFolder dbMailFolder) {
        if (lArray == null || lArray.length < 1 || dbMailFolder == null || !dbMailFolder.holdsMessages) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Copy messages"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.copyMessages(lArray, dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't copy messages!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    private DbMailMessage downloadMessage(ImmoToolProject immoToolProject, Connection connection, Message message, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException, IOException {
        Object object;
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        if (!MimeMessage.class.isInstance(message)) {
            throw new MessagingException("Message is not a MIME message!");
        }
        MimeMessage mimeMessage = (MimeMessage)message;
        DbMailMessage dbMailMessage = this.getLocalMessage(connection, (Message)mimeMessage, dbMailFolder.id);
        if (dbMailMessage != null) {
            boolean bl2;
            object = mimeMessage.getFlags();
            boolean bl3 = bl2 = object != null && object.contains(Flags.Flag.SEEN);
            if (dbMailMessage.isSeen != bl2 && immoToolProject != null) {
                this.markMessageSeen(immoToolProject, connection, dbMailMessage, dbMailFolder, bl2);
            }
        } else {
            dbMailMessage = DbMailMessage.createMessage(mimeMessage);
            dbMailMessage.folderId = dbMailFolder.id;
            dbMailMessage.isDownloaded = false;
            dbMailMessageHandler.saveMessage(connection, dbMailMessage);
            if (!dbMailMessage.isSeen) {
                int n = this.getUnseenMessageCount(dbMailFolder.id);
                this.folderUnseenMessageCount.put(dbMailFolder.id, n + 1);
            }
            if (immoToolProject != null) {
                this.fireMessageWasFound(immoToolProject, dbMailMessage);
            }
        }
        if (bl && !dbMailMessage.isDownloaded) {
            object = DbMailPart.createPart(mimeMessage);
            ((DbMailPart)object).setMessageId(dbMailMessage.id);
            dbMailMessageHandler.savePart(connection, (DbMailPart)object, true);
            dbMailMessage.isDownloaded = true;
            dbMailMessage.hasAttachments = ((DbMailPart)object).hasAttachment();
            dbMailMessageHandler.saveMessage(connection, dbMailMessage);
            if (immoToolProject != null) {
                this.fireMessageWasLoaded(immoToolProject, dbMailMessage, (DbMailPart)object);
            }
        }
        return dbMailMessage;
    }

    private DbMailPart downloadMessageParts(ImmoToolProject immoToolProject, Connection connection, Message message, DbMailMessage dbMailMessage) throws MessagingException, SQLException, IOException {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        if (!MimeMessage.class.isInstance(message)) {
            throw new MessagingException("Message is not a MIME message!");
        }
        MimeMessage mimeMessage = (MimeMessage)message;
        DbMailPart dbMailPart = null;
        if (!dbMailMessage.isDownloaded) {
            dbMailPart = DbMailPart.createPart(mimeMessage);
            dbMailPart.setMessageId(dbMailMessage.id);
            dbMailMessageHandler.savePart(connection, dbMailPart, true);
            dbMailMessage.isDownloaded = true;
            dbMailMessage.hasAttachments = dbMailPart.hasAttachment();
            dbMailMessageHandler.saveMessage(connection, dbMailMessage);
            if (immoToolProject != null) {
                this.fireMessageWasLoaded(immoToolProject, dbMailMessage, dbMailPart);
            }
        }
        return dbMailPart;
    }

    private void fireAccountsWereLoaded(ImmoToolProject immoToolProject) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.accountsWereLoaded();
        }
    }

    private void fireAccountsWereUnloaded(ImmoToolProject immoToolProject) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.accountsWereUnloaded();
        }
    }

    private void fireFolderWasAdded(ImmoToolProject immoToolProject, DbMailFolder dbMailFolder) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.folderWasAdded(dbMailFolder);
        }
    }

    private void fireFolderWasMoved(ImmoToolProject immoToolProject, DbMailFolder dbMailFolder, long l, long l2) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.folderWasMoved(dbMailFolder, l, l2);
        }
    }

    private void fireFolderWasRemoved(ImmoToolProject immoToolProject, long l) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.folderWasRemoved(l);
        }
    }

    private void fireFolderWasUpdated(ImmoToolProject immoToolProject, DbMailFolder dbMailFolder) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.folderWasUpdated(dbMailFolder);
        }
    }

    private void fireMessageMarkedAnswered(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageMarkedAnswered(dbMailMessage);
        }
    }

    private void fireMessageMarkedForwarded(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageMarkedForwarded(dbMailMessage);
        }
    }

    private void fireMessageMarkedSeen(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageMarkedSeen(dbMailMessage);
        }
    }

    private void fireMessageWasAdded(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageWasAdded(dbMailMessage);
        }
    }

    private void fireMessageWasFound(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageWasFound(dbMailMessage);
        }
    }

    private void fireMessageWasLoaded(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage, DbMailPart dbMailPart) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageWasLoaded(dbMailMessage, dbMailPart);
        }
    }

    private void fireMessageWasMoved(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage, long l, long l2) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageWasMoved(dbMailMessage, l, l2);
        }
    }

    private void fireMessageWasRemoved(ImmoToolProject immoToolProject, long l, long l2) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageWasRemoved(l, l2);
        }
    }

    private void fireMessageWasUpdated(ImmoToolProject immoToolProject, DbMailMessage dbMailMessage) {
        for (MailHandlerExtension mailHandlerExtension : this.getListeners(immoToolProject)) {
            mailHandlerExtension.messageWasUpdated(dbMailMessage);
        }
    }

    private List<MailHandlerExtension> getListeners(ImmoToolProject immoToolProject) {
        ArrayList<MailHandlerExtension> arrayList = new ArrayList<MailHandlerExtension>();
        for (MailHandlerExtension object : MailPluginUtils.getMailHandlerExtensions()) {
            arrayList.add(object);
        }
        for (WeakReference weakReference : this.customListeners) {
            MailHandlerExtension mailHandlerExtension = (MailHandlerExtension)weakReference.get();
            if (mailHandlerExtension == null || arrayList.contains(mailHandlerExtension)) continue;
            arrayList.add(mailHandlerExtension);
        }
        return arrayList;
    }

    public synchronized DbMailAccount getAccount(long l) {
        if (this.localPrivateAccount != null && this.localPrivateAccount.id == l) {
            return this.localPrivateAccount;
        }
        if (this.localSharedAccounts.containsKey(l)) {
            return this.localSharedAccounts.get(l);
        }
        if (this.remoteAccounts.containsKey(l)) {
            return this.remoteAccounts.get(l);
        }
        return null;
    }

    public DbMailFolder getFolder(long l) {
        for (DbMailFolder dbMailFolder : this.rootFolders.values()) {
            DbMailFolder dbMailFolder2 = dbMailFolder.lookupFolder(l);
            if (dbMailFolder2 == null) continue;
            return dbMailFolder2;
        }
        return null;
    }

    public String getFolderSeparator(long l) throws MessagingException {
        DbMailAccount dbMailAccount = this.getAccount(l);
        if (dbMailAccount == null) {
            throw new MessagingException("Unknown mail account #" + l + "!");
        }
        if (!dbMailAccount.isRemote()) {
            return "/";
        }
        Store store = this.getRemoteStore(l);
        if (store == null) {
            throw new MessagingException("Invalid remote mail account #" + l + "!");
        }
        try {
            return String.valueOf(store.getDefaultFolder().getSeparator());
        }
        catch (Exception exception) {
            throw new MessagingException("Can't detect folder separator for mail account #" + l + "!", exception);
        }
    }

    private DbMailMessage getLocalMessage(Connection connection, Message message, long l) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        if (!MimeMessage.class.isInstance(message)) {
            LOGGER.warn("Message is not a MIME message!");
            return null;
        }
        MimeMessage mimeMessage = (MimeMessage)message;
        Folder folder = message.getFolder();
        if (UIDFolder.class.isInstance(folder)) {
            try {
                UIDFolder uIDFolder = (UIDFolder)folder;
                long l2 = uIDFolder.getUID(message);
                long l3 = uIDFolder.getUIDValidity();
                return dbMailMessageHandler.getMessageFromFolder(connection, l, l2, l3);
            }
            catch (NoSuchElementException noSuchElementException) {
                LOGGER.warn("Can't determine UID for remote message!");
            }
        } else {
            String string = (String)StringUtils.defaultIfBlank((CharSequence)MailPluginUtils.calculateMessageHash((Message)mimeMessage), null);
            String string2 = (String)StringUtils.defaultIfBlank((CharSequence)mimeMessage.getMessageID(), null);
            return dbMailMessageHandler.getMessageFromFolder(connection, l, string, string2);
        }
        return null;
    }

    public synchronized DbMailAccount getLocalPrivateAccount() {
        return this.localPrivateAccount;
    }

    public long[] getLocalSharedAccountIds() {
        return ArrayUtils.toPrimitive((Long[])this.localSharedAccounts.keySet().toArray(new Long[0]));
    }

    public DbMailAccount getLocalSharedAccount(long l) {
        return this.localSharedAccounts.containsKey(l) ? this.localSharedAccounts.get(l) : null;
    }

    public DbMailAccount[] getLocalSharedAccounts() {
        return this.localSharedAccounts.values().toArray(new DbMailAccount[0]);
    }

    public long[] getRemoteAccountIds() {
        return ArrayUtils.toPrimitive((Long[])this.remoteAccounts.keySet().toArray(new Long[0]));
    }

    public DbMailAccount getRemoteAccount(long l) {
        return this.remoteAccounts.containsKey(l) ? this.remoteAccounts.get(l) : null;
    }

    public DbMailAccount[] getRemoteAccounts() {
        return this.remoteAccounts.values().toArray(new DbMailAccount[0]);
    }

    public Folder getRemoteFolder(long l) throws MessagingException {
        DbMailFolder dbMailFolder = this.getFolder(l);
        return dbMailFolder != null ? this.getRemoteFolder(dbMailFolder) : null;
    }

    public Folder getRemoteFolder(DbMailFolder dbMailFolder) throws MessagingException {
        Store store = this.getRemoteStore(dbMailFolder.accountId);
        if (store == null) {
            return null;
        }
        if (!store.isConnected()) {
            store.connect();
        }
        Folder folder = store.getDefaultFolder();
        return dbMailFolder.parentFolderId > 0L ? MailPluginUtils.getRemoteSubFolder(folder, dbMailFolder.getPath()) : folder;
    }

    public Store getRemoteStore(long l) {
        return this.remoteAccountStores.containsKey(l) ? this.remoteAccountStores.get(l) : null;
    }

    public Transport getRemoteTransport(long l) {
        return this.remoteAccountTransports.containsKey(l) ? this.remoteAccountTransports.get(l) : null;
    }

    public DbMailFolder getRootFolder(long l) {
        return this.rootFolders.containsKey(l) ? this.rootFolders.get(l) : null;
    }

    public int getUnseenMessageCount(long l) {
        return this.folderUnseenMessageCount.containsKey(l) ? this.folderUnseenMessageCount.get(l) : 0;
    }

    private synchronized void initRemoteAccount(DbMailAccount dbMailAccount) {
        Transport transport;
        Session session;
        if (this.remoteAccountTransports.containsKey(dbMailAccount.id)) {
            MailPluginUtils.closeQuietly(this.remoteAccountTransports.get(dbMailAccount.id));
            this.remoteAccountTransports.remove(dbMailAccount.id);
        }
        if (this.remoteAccountStores.containsKey(dbMailAccount.id)) {
            MailPluginUtils.closeQuietly(this.remoteAccountStores.get(dbMailAccount.id));
            this.remoteAccountStores.remove(dbMailAccount.id);
        }
        if (this.remoteAccountIdleStores.containsKey(dbMailAccount.id)) {
            this.remoteAccountIdleStores.get(dbMailAccount.id).disconnect();
            this.remoteAccountIdleStores.remove(dbMailAccount.id);
        }
        try {
            session = dbMailAccount.buildWriterSession();
            if (session != null) {
                transport = session.getTransport();
                this.remoteAccountTransports.put(dbMailAccount.id, transport);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load mail transport for account #" + dbMailAccount.id + " (" + dbMailAccount.name + ")!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            session = dbMailAccount.buildReaderSession();
            if (session != null) {
                transport = session.getStore();
                transport.addStoreListener((StoreListener)new MailStoreListener(dbMailAccount));
                this.remoteAccountStores.put(dbMailAccount.id, (Store)transport);
                if (AbstractMailReader.Type.IMAP.equals((Object)dbMailAccount.getReaderType())) {
                    MailIdleListener mailIdleListener = new MailIdleListener();
                    ImapReader imapReader = (ImapReader)dbMailAccount.buildReader();
                    if (imapReader.isIdleEnabled()) {
                        ImapIdleStore imapIdleStore = new ImapIdleStore(session, dbMailAccount.id, mailIdleListener);
                        this.remoteAccountIdleStores.put(dbMailAccount.id, imapIdleStore);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load mail store for account #" + dbMailAccount.id + " (" + dbMailAccount.name + ")!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void initRemoteIdleFolder(DbMailFolder dbMailFolder) {
        if (!this.remoteAccountIdleStores.containsKey(dbMailFolder.accountId)) {
            return;
        }
        boolean bl = dbMailFolder.isAutoRetrieval || DbMailFolder.SpecialType.INBOX.equals((Object)dbMailFolder.specialType);
        ImapIdleStore imapIdleStore = this.remoteAccountIdleStores.get(dbMailFolder.accountId);
        try {
            if (bl && !imapIdleStore.containsFolder(dbMailFolder.id)) {
                imapIdleStore.addFolder(dbMailFolder.id);
            } else if (!bl && imapIdleStore.containsFolder(dbMailFolder.id)) {
                imapIdleStore.removeFolder(dbMailFolder.id);
            }
        }
        catch (Exception exception) {
            LOGGER.error(bl ? "Can't open IDLE connection!" : "Can't close IDLE connection!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private synchronized void initRemoteIdleStore(Connection connection, DbMailAccount dbMailAccount, ImapIdleStore imapIdleStore) {
        DbMailMessageHandler dbMailMessageHandler;
        if (imapIdleStore == null) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        try {
            for (DbMailFolder dbMailFolder : dbMailMessageHandler.getFoldersForAutoRetrieval(connection, dbMailAccount.id)) {
                imapIdleStore.addFolder(dbMailFolder.id);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't load auto retrieval folders for '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return;
        }
        if (!imapIdleStore.isConnected()) {
            try {
                imapIdleStore.connect();
            }
            catch (Exception exception) {
                LOGGER.error("IDLE connection failed for '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void loadAccounts() throws SQLException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.loadAccounts(immoToolProject, connection);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadAccounts(ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        DbUser dbUser = immoToolProject.getUser();
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailAccountHandler dbMailAccountHandler = dbMailExtension != null ? dbMailExtension.getAccountHandler() : null;
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null || dbMailAccountHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        this.rootFolders.clear();
        this.remoteAccounts.clear();
        this.localSharedAccounts.clear();
        this.localPrivateAccount = null;
        this.folderUnseenMessageCount.clear();
        this.fireAccountsWereUnloaded(immoToolProject);
        try {
            DbMailAccount[] dbMailAccountArray = dbMailAccountHandler.getAccounts(connection, new DbMailAccount.Type[]{DbMailAccount.Type.REMOTE, DbMailAccount.Type.LOCAL_SHARED}, (Boolean)true);
            dbMailAccountHandler.loadAccountSettings(connection, dbMailAccountArray);
            TreeMap<String, DbMailAccount> treeMap = new TreeMap<String, DbMailAccount>();
            for (Comparable<DbMailAccount> comparable : dbMailAccountArray) {
                if (!comparable.enabled) continue;
                String string = comparable.name.toLowerCase();
                int n = 0;
                while (treeMap.containsKey(string)) {
                    string = comparable.name.toLowerCase() + "_" + ++n;
                }
                treeMap.put(string, (DbMailAccount)comparable);
            }
            for (DbMailAccount dbMailAccount : treeMap.values()) {
                if (!dbMailAccount.isRemote()) continue;
                this.remoteAccounts.put(dbMailAccount.id, dbMailAccount);
            }
            this.localPrivateAccount = dbMailAccountHandler.getPrivateAccount(connection);
            if (this.localPrivateAccount == null) {
                LOGGER.info("create private mailbox for user #" + dbUser.id);
                this.localPrivateAccount = new DbMailAccount();
                this.localPrivateAccount.name = "my private mailbox";
                this.localPrivateAccount.enabled = true;
                this.localPrivateAccount.type = DbMailAccount.Type.LOCAL_PRIVATE;
                this.localPrivateAccount.permission = new Permission(0);
                this.localPrivateAccount.permission.putFlag(1);
                this.localPrivateAccount.permission.putFlag(2);
                this.localPrivateAccount.permission.putFlag(4);
                dbMailAccountHandler.saveAccount(connection, this.localPrivateAccount);
            }
            for (DbMailAccount dbMailAccount : treeMap.values()) {
                if (!dbMailAccount.isLocalShared()) continue;
                this.localSharedAccounts.put(dbMailAccount.id, dbMailAccount);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(this.localPrivateAccount);
            arrayList.addAll(this.localSharedAccounts.values());
            arrayList.addAll(this.remoteAccounts.values());
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                Comparable<DbMailAccount> comparable;
                DbMailAccount dbMailAccount = (DbMailAccount)object.next();
                comparable = dbMailMessageHandler.getFolderOnRoot(connection, dbMailAccount.id);
                if (comparable == null) {
                    LOGGER.info("create root folder in mailbox #" + dbMailAccount.id);
                    comparable = dbMailAccount.createRootFolder();
                    dbMailMessageHandler.saveFolder(connection, (DbMailFolder)comparable);
                }
                if (comparable != null) {
                    dbMailMessageHandler.loadFolderChildren(connection, (DbMailFolder)comparable, true);
                }
                this.rootFolders.put(dbMailAccount.id, (DbMailFolder)comparable);
            }
            if (this.rootFolders.containsKey(this.localPrivateAccount.id)) {
                object = this.rootFolders.get(this.localPrivateAccount.id);
                if (!((DbMailFolder)object).holdsFolders || ((DbMailFolder)object).holdsMessages) {
                    ((DbMailFolder)object).holdsFolders = true;
                    ((DbMailFolder)object).holdsMessages = false;
                    dbMailMessageHandler.saveFolder(connection, (DbMailFolder)object);
                }
                for (DbMailFolder.SpecialType specialType : DbMailFolder.SpecialType.values()) {
                    DbMailFolder dbMailFolder = ((DbMailFolder)object).getSubFolder(specialType.name());
                    if (dbMailFolder == null) {
                        LOGGER.info("create folder '" + specialType.name() + "' in private mailbox of user #" + dbUser.id);
                        dbMailFolder = ((DbMailFolder)object).createSubFolder(specialType.name());
                        dbMailFolder.holdsFolders = true;
                        dbMailFolder.holdsMessages = true;
                        dbMailFolder.isAutoRetrieval = true;
                        dbMailFolder.specialType = specialType;
                        dbMailMessageHandler.saveFolder(connection, dbMailFolder);
                        if (((DbMailFolder)object).subFolders == null) {
                            ((DbMailFolder)object).subFolders = new ArrayList<DbMailFolder>();
                        }
                        ((DbMailFolder)object).subFolders.add(dbMailFolder);
                        continue;
                    }
                    boolean bl = false;
                    if (!dbMailFolder.holdsFolders) {
                        bl = true;
                        dbMailFolder.holdsFolders = true;
                    }
                    if (!dbMailFolder.holdsMessages) {
                        bl = true;
                        dbMailFolder.holdsMessages = true;
                    }
                    if (!specialType.equals((Object)dbMailFolder.specialType)) {
                        bl = true;
                        dbMailFolder.specialType = specialType;
                    }
                    if (DbMailFolder.SpecialType.INBOX.equals((Object)dbMailFolder.specialType) && !dbMailFolder.isAutoRetrieval) {
                        bl = true;
                        dbMailFolder.isAutoRetrieval = true;
                    }
                    if (!bl) continue;
                    dbMailMessageHandler.saveFolder(connection, dbMailFolder);
                }
            }
            this.folderUnseenMessageCount = dbMailMessageHandler.getUnseenMessagesCount(connection);
        }
        finally {
            this.fireAccountsWereLoaded(immoToolProject);
        }
    }

    public void loadRemoteAccounts() throws SQLException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.loadRemoteAccounts(immoToolProject, connection);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void loadRemoteAccounts(ImmoToolProject immoToolProject, Connection connection) {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        this.unloadRemoteAccounts();
        for (DbMailAccount dbMailAccount : this.remoteAccounts.values()) {
            Object object;
            this.initRemoteAccount(dbMailAccount);
            try {
                object = this.getRootFolder(dbMailAccount.id);
                Store store = this.getRemoteStore(dbMailAccount.id);
                if (store != null) {
                    this.loadRemoteFolders(immoToolProject, connection, dbMailMessageHandler, store, (DbMailFolder)object);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load remote folders for account #" + dbMailAccount.id + " (" + dbMailAccount.name + ")!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            if (!this.remoteAccountIdleStores.containsKey(dbMailAccount.id)) continue;
            object = this.remoteAccountIdleStores.get(dbMailAccount.id);
            this.initRemoteIdleStore(connection, dbMailAccount, (ImapIdleStore)object);
        }
    }

    public void loadRemoteAccountsInBackground() {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Load mail accounts"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.loadRemoteAccounts();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't load mail accounts!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    private void loadRemoteFolders(ImmoToolProject immoToolProject, Connection connection, DbMailMessageHandler dbMailMessageHandler, Store store, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        if (!store.isConnected()) {
            store.connect();
        }
        Folder folder = store.getDefaultFolder();
        this.loadRemoteFolders(immoToolProject, connection, dbMailMessageHandler, folder, dbMailFolder);
    }

    private void loadRemoteFolders(ImmoToolProject immoToolProject, Connection connection, DbMailMessageHandler dbMailMessageHandler, Folder folder, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        DbMailFolder.SpecialType specialType;
        Object object;
        Serializable serializable;
        if (dbMailFolder.subFolders == null) {
            dbMailFolder.subFolders = new ArrayList<DbMailFolder>();
        } else {
            dbMailFolder.subFolders.clear();
        }
        HashMap<String, DbMailFolder> hashMap = new HashMap<String, DbMailFolder>();
        DbMailFolder[] dbMailFolderArray = dbMailMessageHandler.getFolderChildren(connection, dbMailFolder.id);
        int n = dbMailFolderArray.length;
        for (int i = 0; i < n; ++i) {
            serializable = dbMailFolderArray[i];
            hashMap.put(((DbMailFolder)serializable).name, (DbMailFolder)serializable);
        }
        boolean bl = (folder.getType() & 1) == 1;
        int n2 = n = (folder.getType() & 2) == 2 ? 1 : 0;
        if (dbMailFolder.holdsMessages != bl || dbMailFolder.holdsFolders != n) {
            dbMailFolder.holdsMessages = bl;
            dbMailFolder.holdsFolders = n;
            dbMailMessageHandler.saveFolder(connection, dbMailFolder);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dbMailFolder.holdsFolders) {
            serializable = null;
            if (dbMailFolder.parentFolderId < 1L) {
                serializable = new ArrayList();
                for (DbMailFolder dbMailFolder2 : hashMap.values()) {
                    if (dbMailFolder2.specialType == null) continue;
                    if (!serializable.contains((Object)dbMailFolder2.specialType)) {
                        serializable.add(dbMailFolder2.specialType);
                        continue;
                    }
                    LOGGER.warn("Special Folder '" + (Object)((Object)dbMailFolder2.specialType) + "' is already used for mail account #" + dbMailFolder2.accountId + "!");
                    dbMailFolder2.specialType = null;
                    dbMailMessageHandler.saveFolder(connection, dbMailFolder2);
                }
            }
            for (Folder object2 : folder.list("%")) {
                boolean object3;
                object = null;
                if (hashMap.containsKey(object2.getName())) {
                    object = (DbMailFolder)hashMap.get(object2.getName());
                    object3 = false;
                } else {
                    object = dbMailFolder.createSubFolder(object2.getName());
                    if (serializable != null && (specialType = DbMailFolder.SpecialType.guessFromFolderName(object.name)) != null && !serializable.contains((Object)specialType)) {
                        serializable.add(specialType);
                        object.specialType = specialType;
                        object.isAutoRetrieval = DbMailFolder.SpecialType.INBOX.equals((Object)object.specialType);
                    }
                    dbMailMessageHandler.saveFolder(connection, (DbMailFolder)object);
                    object3 = true;
                }
                object.parentFolder = dbMailFolder;
                dbMailFolder.subFolders.add((DbMailFolder)object);
                if (object3) {
                    this.fireFolderWasAdded(immoToolProject, (DbMailFolder)object);
                }
                arrayList.add(object2.getName());
                this.loadRemoteFolders(immoToolProject, connection, dbMailMessageHandler, object2, (DbMailFolder)object);
            }
        }
        serializable = this.getLocalPrivateAccount();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (arrayList.contains(string)) continue;
            DbMailFolder dbMailFolder2 = (DbMailFolder)entry.getValue();
            object = dbMailMessageHandler.getArchivedMessages(connection, dbMailFolder2.id);
            if (!ArrayUtils.isEmpty((Object[])object)) {
                DbMailFolder dbMailFolder3 = dbMailFolder2;
                specialType = dbMailFolder3.specialType;
                while (specialType == null && dbMailFolder3.parentFolder != null) {
                    dbMailFolder3 = dbMailFolder3.parentFolder;
                    specialType = dbMailFolder3.specialType;
                }
                if (specialType == null) {
                    specialType = DbMailFolder.SpecialType.INBOX;
                }
                DbMailFolder dbMailFolder4 = dbMailMessageHandler.getSpecialFolder(connection, ((DbMailAccount)serializable).id, specialType);
                LOGGER.debug("Move archived messages from remote folder #" + dbMailFolder2.id + " (" + dbMailFolder2.name + ") to local folder #" + dbMailFolder4.id + " (" + dbMailFolder4.name + ")");
                for (Object object2 : object) {
                    LOGGER.debug("> move message #" + ((DbMailMessage)object2).id + " (" + ((DbMailMessage)object2).subject + ")");
                    long l = ((DbMailMessage)object2).folderId;
                    ((DbMailMessage)object2).uid = null;
                    ((DbMailMessage)object2).uidValidity = null;
                    ((DbMailMessage)object2).folderId = dbMailFolder4.id;
                    dbMailMessageHandler.saveMessage(connection, (DbMailMessage)object2);
                    this.fireMessageWasMoved(immoToolProject, (DbMailMessage)object2, l, ((DbMailMessage)object2).folderId);
                }
            }
            dbMailMessageHandler.removeFolder(connection, dbMailFolder2.id);
            this.fireFolderWasRemoved(immoToolProject, dbMailFolder2.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRemoteMessage(DbMailMessage dbMailMessage, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.loadRemoteMessage(immoToolProject, connection, dbMailMessage, dbMailFolder);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRemoteMessage(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        if (dbMailMessage.isDownloaded) {
            return;
        }
        if (dbMailFolder == null) {
            dbMailFolder = this.getFolder(dbMailMessage.folderId);
        }
        if (dbMailFolder == null) {
            throw new IllegalArgumentException("Can't find local folder #" + dbMailMessage.folderId + "!");
        }
        DbMailAccount dbMailAccount = this.getRemoteAccount(dbMailFolder.accountId);
        if (dbMailAccount == null) {
            LOGGER.warn("Can't find account #" + dbMailFolder.accountId + "!");
            return;
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder == null || !folder.exists()) {
            LOGGER.warn("Remote folder does not exist!");
            if (folder != null) {
                LOGGER.warn("> " + folder.getFullName());
            } else {
                LOGGER.warn("> NULL");
            }
            return;
        }
        if ((folder.getType() & 1) != 1) {
            LOGGER.warn("Remote folder does not hold messages!");
            LOGGER.warn("> " + folder.getFullName());
            return;
        }
        try {
            folder.open(1);
            MimeMessage mimeMessage = (MimeMessage)MailPluginUtils.searchFolder(folder, dbMailMessage);
            if (mimeMessage == null) {
                LOGGER.warn("Remote message was not found: " + dbMailMessage.mimeId + "!");
                return;
            }
            this.downloadMessageParts(immoToolProject, connection, (Message)mimeMessage, dbMailMessage);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't download message from mail server!");
            LOGGER.warn("> account '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")");
            LOGGER.warn("> folder '" + folder.getFullName() + "'");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            MailPluginUtils.closeQuietly(folder);
        }
    }

    public void loadRemoteMessageInBackground(final DbMailMessage dbMailMessage, final DbMailFolder dbMailFolder) {
        if (dbMailFolder == null) {
            return;
        }
        if (!this.remoteAccountStores.containsKey(dbMailFolder.accountId)) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Load remote message"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.loadRemoteMessage(dbMailMessage, dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't load remote message!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRemoteMessages(DbMailFolder dbMailFolder) throws MessagingException, SQLException {
        if (dbMailFolder == null || !dbMailFolder.holdsMessages || this.loadingFolders.contains(dbMailFolder.id)) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.loadRemoteMessages(immoToolProject, connection, dbMailFolder);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRemoteMessages(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder) throws MessagingException, SQLException {
        MailHandler mailHandler;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || !dbMailFolder.holdsMessages || this.loadingFolders.contains(dbMailFolder.id)) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        DbMailAccount dbMailAccount = this.getRemoteAccount(dbMailFolder.accountId);
        if (dbMailAccount == null) {
            LOGGER.warn("Can't find account #" + dbMailFolder.accountId + "!");
            return;
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder == null || !folder.exists()) {
            LOGGER.warn("Remote folder does not exist!");
            if (folder != null) {
                LOGGER.warn("> " + folder.getFullName());
            } else {
                LOGGER.warn("> NULL");
            }
            return;
        }
        try {
            mailHandler = this;
            synchronized (mailHandler) {
                this.loadingFolders.add(dbMailFolder.id);
            }
            mailHandler = null;
            Long l = null;
            if (IMAPFolder.class.isInstance(folder)) {
                mailHandler = (IMAPFolder)folder;
                l = mailHandler.getUIDValidity();
            }
            Long l2 = null;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
            DbMailMessage[] dbMailMessageArray = dbMailMessageHandler.getMessagesFromFolder(connection, dbMailFolder.id);
            for (DbMailMessage dbMailMessage : dbMailMessageArray) {
                int n = 0;
                if (l == null && dbMailMessage.uidValidity != null) {
                    n = 1;
                } else if (l != null && dbMailMessage.uidValidity == null) {
                    n = 1;
                } else if (l != null && dbMailMessage.uidValidity != null && l.longValue() != dbMailMessage.uidValidity.longValue()) {
                    n = 1;
                }
                if (n != 0 && !dbMailMessage.isArchived) {
                    LOGGER.debug("Drop invalidated message '" + dbMailMessage.subject + "' (#" + dbMailMessage.id + ")!");
                    dbMailMessageHandler.removeMessage(connection, dbMailMessage.id);
                    if (!dbMailMessage.isSeen) {
                        int n2 = this.getUnseenMessageCount(dbMailMessage.folderId);
                        if (--n2 > 0) {
                            this.folderUnseenMessageCount.put(dbMailMessage.folderId, n2);
                        } else {
                            this.folderUnseenMessageCount.remove(dbMailMessage.folderId);
                        }
                    }
                    this.fireMessageWasRemoved(immoToolProject, dbMailMessage.id, dbMailMessage.folderId);
                    continue;
                }
                arrayList.add(dbMailMessage.id);
                if (dbMailMessage.isArchived) {
                    arrayList2.add(dbMailMessage.id);
                }
                if (l == null || dbMailMessage.uid == null || dbMailMessage.uidValidity == null || dbMailMessage.uidValidity.longValue() != l.longValue()) continue;
                hashMap.put(dbMailMessage.uid, dbMailMessage.id);
                if (l2 != null && l2 >= dbMailMessage.uid) continue;
                l2 = dbMailMessage.uid;
            }
            ArrayList arrayList3 = new ArrayList();
            if ((folder.getType() & 1) == 1) {
                try {
                    folder.open(1);
                    if (mailHandler != null && l2 != null) {
                        Message[] messageArray;
                        for (Message message : messageArray = mailHandler.getMessagesByUID(l2 + 1L, -1L)) {
                            try {
                                DbMailMessage dbMailMessage = this.downloadMessage(immoToolProject, connection, message, dbMailFolder, false);
                                arrayList.add(dbMailMessage.id);
                                hashMap.put(dbMailMessage.uid, dbMailMessage.id);
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Can't download message from mail server!");
                                LOGGER.warn("> account '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")");
                                LOGGER.warn("> folder '" + folder.getFullName() + "'");
                                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            }
                        }
                    }
                    for (int i = 1; i <= folder.getMessageCount(); ++i) {
                        try {
                            Long l3;
                            Message message = folder.getMessage(i);
                            if (mailHandler != null && hashMap.containsValue(l3 = Long.valueOf(mailHandler.getUID(message)))) {
                                arrayList3.add(hashMap.get(l3));
                                continue;
                            }
                            DbMailMessage dbMailMessage = this.downloadMessage(immoToolProject, connection, message, dbMailFolder, false);
                            arrayList3.add(dbMailMessage.id);
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't download message from mail server!");
                            LOGGER.warn("> account '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")");
                            LOGGER.warn("> folder '" + folder.getFullName() + "'");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
                finally {
                    MailPluginUtils.closeQuietly(folder);
                }
            }
            for (Long l4 : arrayList) {
                if (arrayList3.contains(l4) || arrayList2.contains(l4)) continue;
                dbMailMessageHandler.removeMessage(connection, l4);
                this.fireMessageWasRemoved(immoToolProject, l4, dbMailFolder.id);
            }
        }
        finally {
            mailHandler = this;
            synchronized (mailHandler) {
                while (this.loadingFolders.contains(dbMailFolder.id)) {
                    this.loadingFolders.remove(dbMailFolder.id);
                }
            }
        }
    }

    public void loadRemoteMessagesInBackground(final DbMailFolder dbMailFolder) {
        if (dbMailFolder == null || !dbMailFolder.holdsMessages || this.loadingFolders.contains(dbMailFolder.id)) {
            return;
        }
        if (!this.remoteAccountStores.containsKey(dbMailFolder.accountId)) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Load remote messages"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.loadRemoteMessages(dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't load remote messages!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookForNewMessages(boolean bl, boolean bl2) throws SQLException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.lookForNewMessages(immoToolProject, connection, bl, bl2);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void lookForNewMessages(ImmoToolProject immoToolProject, Connection connection, boolean bl, boolean bl2) throws SQLException {
        long l;
        DbMailMessageHandler dbMailMessageHandler;
        Date date = new Date();
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailAccountHandler dbMailAccountHandler = dbMailExtension != null ? dbMailExtension.getAccountHandler() : null;
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null || dbMailAccountHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        Map<Long, Integer> map = dbMailMessageHandler.getUnseenMessagesCount(connection);
        for (Map.Entry<Long, Integer> object : map.entrySet()) {
            l = object.getKey();
            int n = object.getValue();
            int n2 = this.getUnseenMessageCount(l);
            if (n2 == n) continue;
            this.folderUnseenMessageCount.put(l, n);
            DbMailFolder dbMailFolder = this.getFolder(l);
            if (dbMailFolder == null) continue;
            this.fireFolderWasUpdated(immoToolProject, dbMailFolder);
        }
        for (Map.Entry<Long, Integer> entry : this.folderUnseenMessageCount.entrySet()) {
            l = entry.getKey();
            if (map.containsKey(l)) continue;
            this.folderUnseenMessageCount.remove(l);
            DbMailFolder dbMailFolder = this.getFolder(l);
            if (dbMailFolder == null) continue;
            this.fireFolderWasUpdated(immoToolProject, dbMailFolder);
        }
        DbMailAccount[] dbMailAccountArray = bl ? dbMailAccountHandler.getAccountsForAutoRetrieval(connection) : dbMailAccountHandler.getAccounts(connection, true);
        dbMailAccountHandler.loadAccountSettings(connection, dbMailAccountArray);
        for (DbMailAccount dbMailAccount : dbMailAccountArray) {
            if (dbMailAccount.isLocal() || dbMailAccount.getReaderType() == null || this.loadingAccounts.contains(dbMailAccount.id) || !bl2 && this.remoteAccountIdleStores.containsKey(dbMailAccount.id)) continue;
            try {
                if (bl) {
                    Date date2;
                    Date date3 = date2 = dbMailAccount.autoRetrievalAt != null ? new Date(dbMailAccount.autoRetrievalAt.getTime() + dbMailAccount.autoRetrievalInterval) : new Date(0L);
                    if (date2.after(date)) continue;
                }
                this.lookForNewMessages(immoToolProject, connection, dbMailAccount);
            }
            catch (MessagingException messagingException) {
                LOGGER.warn("Automatic retrieval failed for '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")!");
                LOGGER.warn("> " + messagingException.getLocalizedMessage(), (Throwable)messagingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookForNewMessages(DbMailAccount dbMailAccount) throws SQLException, MessagingException {
        if (dbMailAccount == null || !dbMailAccount.isRemote() || dbMailAccount.getReaderType() == null || this.loadingAccounts.contains(dbMailAccount.id)) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.lookForNewMessages(immoToolProject, connection, dbMailAccount);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookForNewMessages(ImmoToolProject immoToolProject, Connection connection, DbMailAccount object) throws SQLException, MessagingException {
        block39: {
            DbMailMessageHandler dbMailMessageHandler;
            if (object == null || !((DbMailAccount)object).isRemote() || ((DbMailAccount)object).getReaderType() == null || this.loadingAccounts.contains(((DbMailAccount)object).id)) {
                return;
            }
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            DbMailAccountHandler dbMailAccountHandler = dbMailExtension != null ? dbMailExtension.getAccountHandler() : null;
            DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
            if (dbMailExtension == null || dbMailMessageHandler == null || dbMailAccountHandler == null) {
                LOGGER.warn("The mail addon is not properly initialized.");
                return;
            }
            try {
                Object object2;
                Object object3 = this;
                synchronized (object3) {
                    this.loadingAccounts.add(((DbMailAccount)object).id);
                }
                ((DbMailAccount)object).autoRetrievalAt = new Date();
                ((DbMailAccount)object).settings = null;
                dbMailAccountHandler.saveAccount(connection, (DbMailAccount)object);
                dbMailAccountHandler.loadAccountSettings(connection, (DbMailAccount)object);
                object3 = this.getRemoteAccount(((DbMailAccount)object).id);
                int n = ((DbMailAccount)object3).calculateHash();
                int n2 = ((DbMailAccount)object).calculateHash();
                if (n == n2) {
                    object = object3;
                } else {
                    this.remoteAccounts.put(((DbMailAccount)object).id, (DbMailAccount)object);
                    this.initRemoteAccount((DbMailAccount)object);
                    if (this.remoteAccountIdleStores.containsKey(((DbMailAccount)object).id)) {
                        object2 = this.remoteAccountIdleStores.get(((DbMailAccount)object).id);
                        this.initRemoteIdleStore(connection, (DbMailAccount)object, (ImapIdleStore)object2);
                    }
                }
                object2 = ((DbMailAccount)object).getReaderType();
                if (AbstractMailReader.Type.IMAP.equals(object2)) {
                    DbMailFolder[] dbMailFolderArray;
                    for (DbMailFolder dbMailFolder : dbMailFolderArray = dbMailMessageHandler.getFoldersForAutoRetrieval(connection, ((DbMailAccount)object).id)) {
                        this.loadRemoteMessages(immoToolProject, connection, dbMailFolder);
                    }
                    break block39;
                }
                if (AbstractMailReader.Type.POP3.equals(object2)) {
                    DbMailFolder dbMailFolder;
                    long l = this.getLocalPrivateAccount().id;
                    DbMailFolder dbMailFolder2 = dbMailMessageHandler.getSpecialFolder(connection, l, DbMailFolder.SpecialType.INBOX);
                    if (dbMailFolder2 == null) {
                        LOGGER.warn("Can't find local inbox folder from account #" + l + " for POP3 download!");
                        return;
                    }
                    Store store = this.getRemoteStore(((DbMailAccount)object).id);
                    Object object4 = dbMailFolder = store != null ? store.getFolder("INBOX") : null;
                    if (dbMailFolder == null || !dbMailFolder.exists()) {
                        LOGGER.warn("Can't find remote inbox folder from account #" + ((DbMailAccount)object).id + " for POP3 download!");
                        return;
                    }
                    boolean bl = Pop3Reader.isRemoveDownloadedMessages((DbMailAccount)object);
                    try {
                        dbMailFolder.open(bl ? 2 : 1);
                        for (int i = 1; i <= dbMailFolder.getMessageCount(); ++i) {
                            try {
                                Message message = dbMailFolder.getMessage(i);
                                String string = (String)StringUtils.defaultIfBlank((CharSequence)MailPluginUtils.calculateMessageHash(message), null);
                                DbMailMessage dbMailMessage = dbMailMessageHandler.getMessageFromFolder(connection, dbMailFolder2.id, string, null);
                                if (dbMailMessage == null) {
                                    dbMailMessage = this.downloadMessage(immoToolProject, connection, message, dbMailFolder2, true);
                                }
                                if (!string.equals(dbMailMessage.hash)) {
                                    dbMailMessage.hash = string;
                                    dbMailMessageHandler.saveMessage(connection, dbMailMessage);
                                }
                                if (!bl) continue;
                                dbMailFolder.setFlags(new Message[]{message}, new Flags(Flags.Flag.DELETED), true);
                                continue;
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Can't download message from POP3 server!");
                                LOGGER.warn("> account '" + ((DbMailAccount)object).name + "' (#" + ((DbMailAccount)object).id + ")");
                                LOGGER.warn("> folder '" + dbMailFolder.getFullName() + "'");
                                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            }
                        }
                        break block39;
                    }
                    finally {
                        MailPluginUtils.closeQuietly((Folder)dbMailFolder, true);
                    }
                }
                throw new MessagingException("Unsupported mail reader: '" + (Object)object2 + "'!");
            }
            finally {
                MailHandler mailHandler = this;
                synchronized (mailHandler) {
                    while (this.loadingAccounts.contains(((DbMailAccount)object).id)) {
                        this.loadingAccounts.remove(((DbMailAccount)object).id);
                    }
                }
            }
        }
    }

    public void lookForNewMessagesInBackground(final DbMailAccount dbMailAccount) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Look for new messages"){

            protected Boolean doInBackground() throws Exception {
                if (dbMailAccount != null) {
                    MailHandler.this.lookForNewMessages(dbMailAccount);
                } else {
                    MailHandler.this.lookForNewMessages(false, false);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't look for new messages!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageAnswered(DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException, IOException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.markMessageAnswered(immoToolProject, connection, dbMailMessage, dbMailFolder, bl);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageAnswered(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        if (dbMailFolder == null) {
            dbMailFolder = this.getFolder(dbMailMessage.folderId);
        }
        if (dbMailFolder == null) {
            throw new IllegalArgumentException("Can't find local folder #" + dbMailMessage.folderId + "!");
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null) {
            if ((folder.getType() & 1) != 1) {
                LOGGER.warn("Remote folder does not hold messages!");
                LOGGER.warn("> " + folder.getFullName());
                return;
            }
            try {
                folder.open(2);
                MimeMessage mimeMessage = (MimeMessage)MailPluginUtils.searchFolder(folder, dbMailMessage);
                if (mimeMessage == null) {
                    LOGGER.warn("Remote message was not found: " + dbMailMessage.mimeId + "!");
                } else {
                    Flags flags = mimeMessage.getFlags();
                    if (flags.contains(Flags.Flag.ANSWERED) != bl) {
                        Flags flags2 = new Flags();
                        flags2.add(Flags.Flag.ANSWERED);
                        folder.setFlags(new Message[]{mimeMessage}, flags2, bl);
                    }
                }
            }
            finally {
                MailPluginUtils.closeQuietly(folder);
            }
        }
        if (dbMailMessage.isAnswered != bl) {
            dbMailMessage.isAnswered = bl;
            dbMailMessageHandler.setMessageAnswered(connection, dbMailMessage.id, bl);
            this.fireMessageMarkedAnswered(immoToolProject, dbMailMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageArchived(DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws SQLException, MessagingException, IOException {
        if (dbMailMessage == null || dbMailMessage.id < 1L || dbMailMessage.isArchived == bl) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.markMessageArchived(immoToolProject, connection, dbMailMessage, dbMailFolder, bl);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void markMessageArchived(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws SQLException, MessagingException, IOException {
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailMessage == null || dbMailMessage.id < 1L || dbMailMessage.isArchived == bl) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        if (dbMailFolder == null) {
            dbMailFolder = this.getFolder(dbMailMessage.folderId);
        }
        if (dbMailFolder == null) {
            throw new IllegalArgumentException("Can't find local folder #" + dbMailMessage.folderId + "!");
        }
        if (!bl && dbMailMessage.isArchived) {
            dbMailMessage.isArchived = false;
        } else if (bl && !dbMailMessage.isArchived) {
            if (!dbMailMessage.isDownloaded) {
                this.loadRemoteMessage(immoToolProject, connection, dbMailMessage, dbMailFolder);
            }
            dbMailMessage.isArchived = true;
        } else {
            return;
        }
        dbMailMessageHandler.setMessageArchived(connection, dbMailMessage.id, dbMailMessage.isArchived);
        this.fireMessageWasUpdated(immoToolProject, dbMailMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageForwarded(DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException, IOException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.markMessageForwarded(immoToolProject, connection, dbMailMessage, dbMailFolder, bl);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageForwarded(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        if (dbMailFolder == null) {
            dbMailFolder = this.getFolder(dbMailMessage.folderId);
        }
        if (dbMailFolder == null) {
            throw new IllegalArgumentException("Can't find local folder #" + dbMailMessage.folderId + "!");
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null) {
            if ((folder.getType() & 1) != 1) {
                LOGGER.warn("Remote folder does not hold messages!");
                LOGGER.warn("> " + folder.getFullName());
                return;
            }
            try {
                folder.open(2);
                if (folder.getPermanentFlags().contains(Flags.Flag.USER)) {
                    MimeMessage mimeMessage = (MimeMessage)MailPluginUtils.searchFolder(folder, dbMailMessage);
                    if (mimeMessage == null) {
                        LOGGER.warn("Remote message was not found: " + dbMailMessage.mimeId + "!");
                    } else {
                        Flags flags = mimeMessage.getFlags();
                        if (flags.contains(FORWARDED) != bl) {
                            folder.setFlags(new Message[]{mimeMessage}, flags, bl);
                        }
                    }
                }
            }
            finally {
                MailPluginUtils.closeQuietly(folder);
            }
        }
        if (dbMailMessage.isForwarded != bl) {
            dbMailMessage.isForwarded = bl;
            dbMailMessageHandler.setMessageForwarded(connection, dbMailMessage.id, bl);
            this.fireMessageMarkedForwarded(immoToolProject, dbMailMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageSeen(DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException, IOException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.markMessageSeen(immoToolProject, connection, dbMailMessage, dbMailFolder, bl);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessageSeen(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailFolder dbMailFolder, boolean bl) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        if (dbMailFolder == null) {
            dbMailFolder = this.getFolder(dbMailMessage.folderId);
        }
        if (dbMailFolder == null) {
            throw new IllegalArgumentException("Can't find local folder #" + dbMailMessage.folderId + "!");
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null) {
            if ((folder.getType() & 1) != 1) {
                LOGGER.warn("Remote folder does not hold messages!");
                LOGGER.warn("> " + folder.getFullName());
                return;
            }
            try {
                folder.open(2);
                MimeMessage mimeMessage = (MimeMessage)MailPluginUtils.searchFolder(folder, dbMailMessage);
                if (mimeMessage == null) {
                    LOGGER.warn("Remote message was not found: " + dbMailMessage.mimeId + "!");
                } else {
                    Flags flags = mimeMessage.getFlags();
                    if (flags.contains(Flags.Flag.SEEN) != bl) {
                        Flags flags2 = new Flags();
                        flags2.add(Flags.Flag.SEEN);
                        folder.setFlags(new Message[]{mimeMessage}, flags2, bl);
                    }
                }
            }
            finally {
                MailPluginUtils.closeQuietly(folder);
            }
        }
        if (dbMailMessage.isSeen != bl) {
            dbMailMessage.isSeen = bl;
            dbMailMessageHandler.setMessageSeen(connection, dbMailMessage.id, bl);
            int n = this.getUnseenMessageCount(dbMailFolder.id);
            if (n == 1 && bl) {
                this.folderUnseenMessageCount.remove(dbMailFolder.id);
            } else if (n > 0 && bl) {
                this.folderUnseenMessageCount.put(dbMailFolder.id, n - 1);
            } else if (!bl) {
                this.folderUnseenMessageCount.put(dbMailFolder.id, n + 1);
            }
            this.fireMessageMarkedSeen(immoToolProject, dbMailMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFolder(DbMailFolder dbMailFolder, DbMailFolder dbMailFolder2) throws MessagingException, SQLException, IOException {
        if (dbMailFolder == null || dbMailFolder2 == null || !dbMailFolder2.holdsFolders || dbMailFolder.parentFolderId == dbMailFolder2.id) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.moveFolder(immoToolProject, connection, dbMailFolder, dbMailFolder2);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void moveFolder(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder, DbMailFolder dbMailFolder2) throws MessagingException, SQLException, IOException {
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder2 == null || !dbMailFolder2.holdsFolders || dbMailFolder.parentFolderId == dbMailFolder2.id) {
            return;
        }
        long l = dbMailFolder.parentFolderId;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        String string = this.getFolderSeparator(dbMailFolder2.accountId);
        String string2 = "_".equals(string) ? "-" : "_";
        String string3 = StringUtils.replace((String)dbMailFolder.name, (String)string, (String)string2);
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null && !folder.exists()) {
            throw new IllegalArgumentException("Source folder '" + dbMailFolder.name + "' does not exists on the mail server!");
        }
        Folder folder2 = null;
        Folder folder3 = this.getRemoteFolder(dbMailFolder2);
        if (folder3 != null) {
            if (!folder3.exists()) {
                throw new IllegalArgumentException("Destination parent folder '" + dbMailFolder2.name + "' does not exists on the mail server!");
            }
            if ((folder3.getType() & 2) != 2) {
                throw new IllegalArgumentException("Destination folder '" + dbMailFolder2.name + "' does not allow subfolders!");
            }
            folder2 = folder3.getFolder(string3);
            if (folder2.exists()) {
                throw new IllegalArgumentException("Destination folder '" + string3 + "' already exists on the mail server!");
            }
        }
        if (folder != null && folder2 != null) {
            if (dbMailFolder.accountId == dbMailFolder2.accountId) {
                try {
                    folder.setSubscribed(false);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't unsubscribe folder!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                folder.renameTo(folder2);
                try {
                    folder2.setSubscribed(true);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't subscribe folder!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                this.moveLocalFolder(connection, dbMailFolder, dbMailFolder2, folder2.getType());
                this.fireFolderWasMoved(immoToolProject, dbMailFolder, l, dbMailFolder2.id);
            } else {
                this.loadRemoteMessages(immoToolProject, connection, dbMailFolder);
                MailPluginUtils.createRemoteFolder(folder2);
                DbMailFolder dbMailFolder3 = dbMailFolder2.createSubFolder(string3);
                dbMailFolder3.holdsFolders = (folder2.getType() & 2) == 2;
                dbMailFolder3.holdsMessages = (folder2.getType() & 1) == 1;
                dbMailMessageHandler.saveFolder(connection, dbMailFolder3);
                dbMailFolder3.subFolders = new ArrayList<DbMailFolder>();
                dbMailFolder3.parentFolder = dbMailFolder2;
                dbMailFolder2.subFolders.add(dbMailFolder3);
                this.fireFolderWasAdded(immoToolProject, dbMailFolder3);
                long[] lArray = dbMailMessageHandler.getMessageIdsFromFolder(connection, dbMailFolder.id);
                if (!ArrayUtils.isEmpty((long[])lArray)) {
                    this.moveMessages(immoToolProject, connection, lArray, dbMailFolder3);
                }
                if (dbMailFolder.subFolders != null && !dbMailFolder.subFolders.isEmpty()) {
                    for (DbMailFolder dbMailFolder4 : dbMailFolder.subFolders) {
                        this.moveFolder(immoToolProject, connection, dbMailFolder4, dbMailFolder3);
                    }
                }
                try {
                    folder.setSubscribed(false);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't unsubscribe folder!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                folder.delete(true);
                dbMailMessageHandler.removeFolder(connection, dbMailFolder.id);
                this.fireFolderWasRemoved(immoToolProject, dbMailFolder.id);
            }
        } else if (folder == null && folder2 != null) {
            MailPluginUtils.createRemoteFolder(folder2);
            DbMailFolder dbMailFolder5 = dbMailFolder2.createSubFolder(string3);
            dbMailFolder5.holdsFolders = (folder2.getType() & 2) == 2;
            dbMailFolder5.holdsMessages = (folder2.getType() & 1) == 1;
            dbMailMessageHandler.saveFolder(connection, dbMailFolder5);
            dbMailFolder5.subFolders = new ArrayList<DbMailFolder>();
            dbMailFolder5.parentFolder = dbMailFolder2;
            dbMailFolder2.subFolders.add(dbMailFolder5);
            this.fireFolderWasAdded(immoToolProject, dbMailFolder5);
            long[] lArray = dbMailMessageHandler.getMessageIdsFromFolder(connection, dbMailFolder.id);
            if (!ArrayUtils.isEmpty((long[])lArray)) {
                this.moveMessages(immoToolProject, connection, lArray, dbMailFolder5);
            }
            if (dbMailFolder.subFolders != null && !dbMailFolder.subFolders.isEmpty()) {
                for (DbMailFolder dbMailFolder6 : dbMailFolder.subFolders) {
                    this.moveFolder(immoToolProject, connection, dbMailFolder6, dbMailFolder5);
                }
            }
            dbMailMessageHandler.removeFolder(connection, dbMailFolder.id);
            this.fireFolderWasRemoved(immoToolProject, dbMailFolder.id);
        } else if (folder != null && folder2 == null) {
            this.loadRemoteMessages(immoToolProject, connection, dbMailFolder);
            DbMailFolder dbMailFolder7 = dbMailFolder2.createSubFolder(string3);
            dbMailFolder7.holdsFolders = true;
            dbMailFolder7.holdsMessages = true;
            dbMailMessageHandler.saveFolder(connection, dbMailFolder7);
            dbMailFolder7.subFolders = new ArrayList<DbMailFolder>();
            dbMailFolder7.parentFolder = dbMailFolder2;
            dbMailFolder2.subFolders.add(dbMailFolder7);
            this.fireFolderWasAdded(immoToolProject, dbMailFolder7);
            long[] lArray = dbMailMessageHandler.getMessageIdsFromFolder(connection, dbMailFolder.id);
            if (!ArrayUtils.isEmpty((long[])lArray)) {
                this.moveMessages(immoToolProject, connection, lArray, dbMailFolder7);
            }
            if (dbMailFolder.subFolders != null && !dbMailFolder.subFolders.isEmpty()) {
                for (DbMailFolder dbMailFolder8 : dbMailFolder.subFolders) {
                    this.moveFolder(immoToolProject, connection, dbMailFolder8, dbMailFolder7);
                }
            }
            try {
                folder.setSubscribed(false);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't unsubscribe folder!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            folder.delete(true);
            dbMailMessageHandler.removeFolder(connection, dbMailFolder.id);
            this.fireFolderWasRemoved(immoToolProject, dbMailFolder.id);
        } else {
            this.moveLocalFolder(connection, dbMailFolder, dbMailFolder2, -1);
            this.fireFolderWasMoved(immoToolProject, dbMailFolder, l, dbMailFolder2.id);
        }
    }

    public void moveFolderInBackground(final DbMailFolder dbMailFolder, final DbMailFolder dbMailFolder2) {
        if (dbMailFolder == null || dbMailFolder2 == null || !dbMailFolder2.holdsFolders || dbMailFolder.parentFolderId == dbMailFolder2.id) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Move folder"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.moveFolder(dbMailFolder, dbMailFolder2);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't move folder!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    private void moveLocalFolder(Connection connection, DbMailFolder dbMailFolder, DbMailFolder dbMailFolder2, int n) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        dbMailFolder.parentFolder.subFolders.remove(dbMailFolder);
        dbMailFolder.accountId = dbMailFolder2.accountId;
        dbMailFolder.parentFolderId = dbMailFolder2.id;
        dbMailFolder.parentFolder = dbMailFolder2;
        dbMailFolder.holdsFolders = n < 0 || (n & 2) == 2;
        dbMailFolder.holdsMessages = n < 0 || (n & 1) == 1;
        dbMailFolder2.subFolders.add(dbMailFolder);
        dbMailMessageHandler.saveFolder(connection, dbMailFolder);
        for (DbMailFolder dbMailFolder3 : dbMailFolder.getAllSubFolders()) {
            dbMailFolder3.accountId = dbMailFolder.accountId;
            dbMailMessageHandler.saveFolder(connection, dbMailFolder3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMessages(long[] lArray, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        if (lArray == null || lArray.length < 1 || dbMailFolder == null || !dbMailFolder.holdsMessages) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.moveMessages(immoToolProject, connection, lArray, dbMailFolder);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMessages(ImmoToolProject immoToolProject, Connection connection, long[] lArray, DbMailFolder dbMailFolder) throws MessagingException, SQLException, IOException {
        DbMailMessageHandler dbMailMessageHandler;
        if (lArray == null || lArray.length < 1 || dbMailFolder == null || !dbMailFolder.holdsMessages) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null && (folder.getType() & 1) != 1) {
            throw new MessagingException("Destination folder '" + folder.getFullName() + "' does not allow messages!");
        }
        for (long l : lArray) {
            Long l2;
            Long l3;
            String string;
            DbMailFolder dbMailFolder2;
            boolean bl;
            DbMailMessage dbMailMessage;
            block41: {
                dbMailMessage = dbMailMessageHandler.getMessage(connection, l);
                if (dbMailMessage == null) {
                    LOGGER.warn("Can't find message #" + l);
                    continue;
                }
                if (dbMailMessage.folderId == dbMailFolder.id) continue;
                dbMailMessageHandler.loadAddresses(connection, dbMailMessage);
                bl = dbMailMessage.isSeen;
                dbMailFolder2 = this.getFolder(dbMailMessage.folderId);
                Folder folder2 = this.getRemoteFolder(dbMailFolder2);
                string = null;
                l3 = null;
                l2 = null;
                try {
                    AppendUID[] appendUIDArray;
                    Object object;
                    IMAPFolder iMAPFolder;
                    block42: {
                        ExtendedMimeMessage extendedMimeMessage;
                        MimeMessage mimeMessage;
                        Object object3;
                        Message message = null;
                        if (folder2 != null) {
                            folder2.open(2);
                            message = MailPluginUtils.searchFolder(folder2, dbMailMessage);
                        }
                        if (folder2 != null && folder != null && message != null) {
                            folder.open(2);
                            dbMailMessage.updateFlags(message.getFlags());
                            if (!IMAPFolder.class.isInstance(folder)) {
                                iMAPFolder = (MimeMessage)message;
                                object3 = new ExtendedMimeMessage((MimeMessage)iMAPFolder, iMAPFolder.getMessageID(), true);
                                folder2.copyMessages(new Message[]{object3}, folder);
                            } else {
                                iMAPFolder = (IMAPFolder)folder;
                                object3 = (MimeMessage)message;
                                ExtendedMimeMessage extendedMimeMessage2 = new ExtendedMimeMessage((MimeMessage)object3, object3.getMessageID(), true);
                                object = iMAPFolder.appendUIDMessages(new Message[]{extendedMimeMessage2});
                                if (ArrayUtils.isEmpty((Object[])object)) {
                                    LOGGER.warn("Mail server did not send an UID response for the appended message!");
                                    continue;
                                }
                                l3 = ((AppendUID)object[0]).uid;
                                l2 = ((AppendUID)object[0]).uidvalidity;
                                mimeMessage = (MimeMessage)iMAPFolder.getMessageByUID(l3.longValue());
                                string = mimeMessage.getMessageID();
                                extendedMimeMessage = mimeMessage.getFlags();
                                if (extendedMimeMessage != null && extendedMimeMessage.contains(Flags.Flag.SEEN) != dbMailMessage.isSeen) {
                                    appendUIDArray = new Flags();
                                    appendUIDArray.add(Flags.Flag.SEEN);
                                    iMAPFolder.setFlags(new Message[]{mimeMessage}, (Flags)appendUIDArray, dbMailMessage.isSeen);
                                }
                            }
                            folder2.setFlags(new Message[]{message}, new Flags(Flags.Flag.DELETED), true);
                            folder2.expunge();
                            break block41;
                        }
                        if (folder2 != null && folder == null) {
                            if (message == null) {
                                if (!dbMailMessage.isDownloaded) {
                                    throw new MessagingException("Can't find message '" + dbMailMessage.mimeId + "' in source folder '" + folder2.getFullName() + "' for download!");
                                }
                            } else {
                                dbMailMessage.updateFlags(message.getFlags());
                                if (!dbMailMessage.isDownloaded) {
                                    iMAPFolder = (MimeMessage)message;
                                    this.downloadMessageParts(null, connection, (Message)iMAPFolder, dbMailMessage);
                                }
                                folder2.setFlags(new Message[]{message}, new Flags(Flags.Flag.DELETED), true);
                                folder2.expunge();
                            }
                            break block41;
                        }
                        if (message != null && folder2 != null || folder == null) break block41;
                        iMAPFolder = null;
                        folder.open(2);
                        object3 = dbMailMessageHandler.getPartOnRoot(connection, dbMailMessage.id);
                        dbMailMessageHandler.loadPartChildren(connection, (DbMailPart)object3, true);
                        dbMailMessageHandler.loadPartHeaders(connection, (DbMailPart)object3, true);
                        iMAPFolder = MailPluginUtils.downloadAttachments(connection, dbMailMessageHandler, (DbMailPart)object3, !StringUtils.isBlank((CharSequence)dbMailMessage.mimeId));
                        MimeMessage mimeMessage2 = MailPluginUtils.createMimeMessage(dbMailMessage, (DbMailPart)object3, null, true, iMAPFolder);
                        if (!IMAPFolder.class.isInstance(folder)) {
                            string = MailPluginUtils.getUniqueMessageId();
                            object = new ExtendedMimeMessage(mimeMessage2, string, true);
                            folder.appendMessages(new Message[]{object});
                        }
                        object = (IMAPFolder)folder;
                        mimeMessage = mimeMessage2;
                        extendedMimeMessage = new ExtendedMimeMessage(mimeMessage, mimeMessage.getMessageID(), true);
                        appendUIDArray = object.appendUIDMessages(new Message[]{extendedMimeMessage});
                        if (!ArrayUtils.isEmpty((Object[])appendUIDArray)) break block42;
                        LOGGER.warn("Mail server did not send an UID response for the appended message!");
                        if (iMAPFolder == null || iMAPFolder.isEmpty()) continue;
                        for (File file : iMAPFolder.values()) {
                            FileUtils.deleteQuietly((File)file);
                        }
                        continue;
                    }
                    try {
                        File file;
                        l3 = appendUIDArray[0].uid;
                        l2 = appendUIDArray[0].uidvalidity;
                        MimeMessage mimeMessage = (MimeMessage)object.getMessageByUID(l3.longValue());
                        string = mimeMessage.getMessageID();
                        file = mimeMessage.getFlags();
                        if (file != null) {
                            if (file.contains(Flags.Flag.SEEN) != dbMailMessage.isSeen) {
                                Flags flags = new Flags();
                                flags.add(Flags.Flag.SEEN);
                                object.setFlags(new Message[]{mimeMessage}, flags, dbMailMessage.isSeen);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (iMAPFolder != null && !iMAPFolder.isEmpty()) {
                            for (File file : iMAPFolder.values()) {
                                FileUtils.deleteQuietly((File)file);
                            }
                        }
                    }
                }
                finally {
                    if (folder2 != null) {
                        MailPluginUtils.closeQuietly(folder2, true);
                    }
                    if (folder != null) {
                        MailPluginUtils.closeQuietly(folder);
                    }
                }
            }
            dbMailMessage.folderId = dbMailFolder.id;
            dbMailMessage.uid = l3 != null ? l3 : null;
            Long l4 = dbMailMessage.uidValidity = l2 != null ? l2 : null;
            if (!StringUtils.isBlank(string)) {
                dbMailMessage.mimeId = string;
            }
            dbMailMessageHandler.saveMessage(connection, dbMailMessage);
            if (!bl) {
                int n = this.getUnseenMessageCount(dbMailFolder2.id);
                if (--n > 0) {
                    this.folderUnseenMessageCount.put(dbMailFolder2.id, n);
                } else {
                    this.folderUnseenMessageCount.remove(dbMailFolder2.id);
                }
            }
            if (!dbMailMessage.isSeen) {
                int n = this.getUnseenMessageCount(dbMailFolder.id);
                if (++n > 0) {
                    this.folderUnseenMessageCount.put(dbMailFolder.id, n);
                } else {
                    this.folderUnseenMessageCount.remove(dbMailFolder.id);
                }
            }
            this.fireMessageWasMoved(immoToolProject, dbMailMessage, dbMailFolder2.id, dbMailFolder.id);
        }
    }

    public void moveMessagesInBackground(final long[] lArray, final DbMailFolder dbMailFolder) {
        if (lArray == null || lArray.length < 1 || dbMailFolder == null || !dbMailFolder.holdsMessages) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Move messages"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.moveMessages(lArray, dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't move messages!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    public synchronized void removeCustomListener(MailHandlerExtension mailHandlerExtension) {
        if (mailHandlerExtension == null) {
            return;
        }
        ArrayList<WeakReference<MailHandlerExtension>> arrayList = new ArrayList<WeakReference<MailHandlerExtension>>();
        for (WeakReference<MailHandlerExtension> weakReference : this.customListeners) {
            MailHandlerExtension mailHandlerExtension2 = (MailHandlerExtension)weakReference.get();
            if (mailHandlerExtension2 != null && mailHandlerExtension != mailHandlerExtension2) continue;
            arrayList.add(weakReference);
        }
        for (WeakReference<MailHandlerExtension> weakReference : arrayList) {
            this.customListeners.remove(weakReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolder(DbMailFolder dbMailFolder) throws MessagingException, SQLException {
        if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.removeFolder(immoToolProject, connection, dbMailFolder);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void removeFolder(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        Folder folder = this.getRemoteFolder(dbMailFolder);
        if (folder != null && folder.exists()) {
            MailPluginUtils.closeQuietly(folder);
            try {
                folder.setSubscribed(false);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't unsubscribe folder!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            folder.delete(true);
        }
        if (dbMailFolder.id > 0L) {
            dbMailMessageHandler.removeFolder(connection, dbMailFolder.id);
            this.fireFolderWasRemoved(immoToolProject, dbMailFolder.id);
        }
    }

    public void removeFolderInBackground(final DbMailFolder dbMailFolder) {
        if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Remove folder #" + dbMailFolder.id){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.removeFolder(dbMailFolder);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't remove folder!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessages(long[] lArray) throws MessagingException, SQLException {
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.removeMessages(immoToolProject, connection, lArray);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessages(ImmoToolProject immoToolProject, Connection connection, long[] lArray) throws MessagingException, SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        for (long l : lArray) {
            DbMailMessage dbMailMessage = dbMailMessageHandler.getMessage(connection, l);
            if (dbMailMessage == null) {
                LOGGER.warn("Can't find message #" + l + "!");
                continue;
            }
            DbMailFolder dbMailFolder = this.getFolder(dbMailMessage.folderId);
            Folder folder = this.getRemoteFolder(dbMailFolder);
            if (folder != null) {
                try {
                    folder.open(2);
                    Message message = MailPluginUtils.searchFolder(folder, dbMailMessage);
                    if (message != null) {
                        folder.setFlags(new Message[]{message}, new Flags(Flags.Flag.DELETED), true);
                        folder.expunge();
                    }
                }
                finally {
                    MailPluginUtils.closeQuietly(folder, true);
                }
            }
            dbMailMessageHandler.removeMessage(connection, dbMailMessage.id);
            if (!dbMailMessage.isSeen) {
                int n = this.getUnseenMessageCount(dbMailFolder.id);
                if (--n < 1) {
                    this.folderUnseenMessageCount.remove(dbMailFolder.id);
                } else {
                    this.folderUnseenMessageCount.put(dbMailFolder.id, n);
                }
            }
            this.fireMessageWasRemoved(immoToolProject, l, dbMailFolder.id);
        }
    }

    public void removeMessagesInBackground(final long[] lArray) {
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Remove messages"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.removeMessages(lArray);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't remove messages!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFolder(DbMailFolder dbMailFolder, String string) throws MessagingException, SQLException {
        if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L || StringUtils.isBlank((CharSequence)string) || dbMailFolder.name.equals(string.trim())) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.renameFolder(immoToolProject, connection, dbMailFolder, string.trim());
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void renameFolder(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder, String string) throws MessagingException, SQLException {
        DbMailFolder dbMailFolder2;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L || StringUtils.isBlank((CharSequence)string) || dbMailFolder.name.equals(string.trim())) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        String string2 = this.getFolderSeparator(dbMailFolder.accountId);
        String string3 = "_".equals(string2) ? "-" : "_";
        string = StringUtils.replace((String)string.trim(), (String)string2, (String)string3);
        Folder folder = this.getRemoteFolder(dbMailFolder);
        Folder folder2 = null;
        if (folder != null && folder.exists() && (folder2 = (dbMailFolder2 = folder.getParent()).getFolder(string)).exists()) {
            throw new IllegalArgumentException("A remote folder with the name '" + string + "' already exists!");
        }
        dbMailFolder2 = dbMailFolder.parentFolder;
        if (dbMailFolder2 == null) {
            dbMailFolder2 = this.getFolder(dbMailFolder.parentFolderId);
        }
        if (dbMailFolder2.subFolders == null) {
            throw new IllegalArgumentException("Subfolders not loaded!");
        }
        if (dbMailFolder2.hasSubFolder(string)) {
            throw new IllegalArgumentException("A local folder with the name '" + string + "' already exists!");
        }
        if (folder != null && folder2 != null) {
            try {
                folder.setSubscribed(false);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't unsubscribe folder!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            folder.renameTo(folder2);
            try {
                folder2.setSubscribed(true);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't subscribe folder!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        dbMailFolder.name = string;
        dbMailMessageHandler.saveFolder(connection, dbMailFolder);
        this.fireFolderWasUpdated(immoToolProject, dbMailFolder);
    }

    public void renameFolderInBackground(final DbMailFolder dbMailFolder, final String string) {
        if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L || StringUtils.isBlank((CharSequence)string) || dbMailFolder.name.equals(string.trim())) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Rename folder #" + dbMailFolder.id){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.renameFolder(dbMailFolder, string.trim());
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't rename folder!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMailMessage sendMessage(Email email, long l, boolean bl) throws MessagingException, SQLException, IOException {
        if (email == null || l < 1L) {
            return null;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = bl ? immoToolProject.getDbConnection() : null;
            DbMailMessage dbMailMessage = this.sendMessage(immoToolProject, connection, email, l, bl);
            return dbMailMessage;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMailMessage sendMessage(ImmoToolProject immoToolProject, Connection connection, Email email, long l, boolean bl) throws MessagingException, SQLException, IOException {
        DbMailMessageHandler dbMailMessageHandler;
        if (email == null || l < 1L) {
            return null;
        }
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        Transport transport = this.getRemoteTransport(l);
        if (transport == null) {
            throw new MessagingException("Can't find transport for account #" + l + "!");
        }
        MimeMessage mimeMessage = null;
        try {
            email.buildMimeMessage();
            mimeMessage = email.getMimeMessage();
            mimeMessage.saveChanges();
        }
        catch (Exception exception) {
            throw new MessagingException("Can't build MIME message!", exception);
        }
        try {
            transport.connect();
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        }
        finally {
            MailPluginUtils.closeQuietly(transport);
        }
        if (bl) {
            Connection connection2 = null;
            try {
                connection2 = connection == null ? immoToolProject.getDbConnection() : connection;
                DbMailFolder dbMailFolder = dbMailMessageHandler.getSpecialFolder(connection, l, DbMailFolder.SpecialType.OUTBOX);
                if (dbMailFolder == null) {
                    dbMailFolder = dbMailMessageHandler.getSpecialFolder(connection, mailHandler.getLocalPrivateAccount().id, DbMailFolder.SpecialType.OUTBOX);
                }
                if (dbMailFolder == null) {
                    throw new MessagingException("Can't find '" + (Object)((Object)DbMailFolder.SpecialType.OUTBOX) + "' special folder!");
                }
                ExtendedMimeMessage extendedMimeMessage = new ExtendedMimeMessage(mimeMessage, mimeMessage.getMessageID());
                extendedMimeMessage.setFlags(new Flags(Flags.Flag.SEEN), true);
                DbMailMessage dbMailMessage = this.addMessage(immoToolProject, connection, extendedMimeMessage, dbMailFolder);
                return dbMailMessage;
            }
            finally {
                if (connection == null) {
                    JdbcUtils.closeQuietly((Connection)connection2);
                }
            }
        }
        return null;
    }

    public void sendMessageInBackground(final Email email, final long l, final boolean bl) {
        if (email == null || l < 1L) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Send message"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.sendMessage(email, l, bl);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't send message!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(DbMailMessage dbMailMessage, long l) throws MessagingException, SQLException, IOException {
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.sendNotification(immoToolProject, connection, dbMailMessage, l);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void sendNotification(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, long l) throws MessagingException, SQLException, IOException {
        Comparable<DbMailAccount> comparable;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        DbMailPart dbMailPart = dbMailMessageHandler.getPartOnRoot(connection, dbMailMessage.id);
        if (dbMailPart == null) {
            throw new MessagingException("Can't find root part of message #" + dbMailMessage.id + "!");
        }
        dbMailMessageHandler.loadPartHeaders(connection, dbMailPart, false);
        Object[] objectArray = MailNotification.readFromHeader(dbMailPart);
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            LOGGER.warn("Message #" + dbMailMessage.id + " does not contain a 'Disposition-Notification-To' header!");
            return;
        }
        if (l < 1L) {
            comparable = this.getFolder(dbMailMessage.folderId);
            if (comparable != null && this.remoteAccountTransports.containsKey(((DbMailFolder)comparable).accountId)) {
                l = ((DbMailFolder)comparable).accountId;
            } else if (!this.remoteAccountTransports.isEmpty()) {
                l = this.remoteAccountTransports.keySet().iterator().next();
            } else {
                throw new MessagingException("Can't find an account for mail transport!");
            }
        }
        if ((comparable = this.getAccount(l)) == null) {
            throw new MessagingException("Can't find account #" + l + " for mail transport!");
        }
        String string = "Empfangsbest\u00e4tigung - " + dbMailMessage.subject;
        String string2 = "Dies ist eine Empfangsbest\u00e4tigung f\u00fcr eine Nachricht, die Sie an folgenden Empf\u00e4nger gesendet haben: " + dbMailMessage.to + System.lineSeparator() + "Beachten Sie: Diese Empfangsbest\u00e4tigung sagt nur aus, dass die Nachricht am Computer des Empf\u00e4ngers angezeigt wurde. Es gibt keine Garantie, dass der Empf\u00e4nger die Nachrichteninhalte gelesen hat." + System.lineSeparator() + System.lineSeparator() + "---------------------------------------------------------" + System.lineSeparator() + System.lineSeparator() + "This is a Return Receipt for the mail that you sent to: " + dbMailMessage.to + System.lineSeparator() + "Note: This Return Receipt only acknowledges that the message was displayed on the recipient's computer. There is no guarantee that the recipient has read the message contents.";
        MdnMail mdnMail = null;
        try {
            mdnMail = new MdnMail();
            mdnMail.setMsg(string2);
            mdnMail.setSubject(string);
            mdnMail.setLocalMessage(dbMailMessage);
            mdnMail.setFrom(((DbMailAccount)comparable).getSenderFromMail(), ((DbMailAccount)comparable).getSenderFromName());
            mdnMail.setDispositionActionMode(new ActionModeAutomatic());
            mdnMail.setDispositionSendingMode(new SendingModeAutomatic());
            mdnMail.setDispositionType(new TypeDisplayed());
            mdnMail.setMailSession(((DbMailAccount)comparable).buildWriterSession());
            for (Object object : objectArray) {
                String string3 = object.getPersonal();
                String string4 = object.getAddress();
                if (StringUtils.isBlank((CharSequence)string4)) continue;
                if (!StringUtils.isBlank((CharSequence)string3)) {
                    mdnMail.addTo(string4, string3);
                    continue;
                }
                mdnMail.addTo(string4);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("Can't create MDN message!", exception);
        }
        this.sendMessage(immoToolProject, connection, mdnMail, l, false);
        this.setMessageMdn(immoToolProject, connection, dbMailMessage, DbMailMessage.MdnStatus.SENT);
    }

    public void sendNotificationInBackground(final DbMailMessage dbMailMessage, final long l) {
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Send notification"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.sendNotification(dbMailMessage, l);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't send notification!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderAutoRetrieval(DbMailFolder dbMailFolder, boolean bl) throws SQLException {
        if (dbMailFolder == null || dbMailFolder.isAutoRetrieval == bl) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.setFolderAutoRetrieval(immoToolProject, connection, dbMailFolder, bl);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void setFolderAutoRetrieval(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder, boolean bl) throws SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder.isAutoRetrieval == bl) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        dbMailFolder.isAutoRetrieval = bl;
        dbMailMessageHandler.saveFolder(connection, dbMailFolder);
        this.fireFolderWasUpdated(immoToolProject, dbMailFolder);
        this.initRemoteIdleFolder(dbMailFolder);
    }

    public void setFolderAutoRetrievalInBackground(final DbMailFolder dbMailFolder, final boolean bl) {
        if (dbMailFolder == null || dbMailFolder.isAutoRetrieval == bl) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Update folder #" + dbMailFolder.id){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.setFolderAutoRetrieval(dbMailFolder, bl);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't update folder!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderSpecialType(DbMailFolder dbMailFolder, DbMailFolder.SpecialType specialType) throws SQLException {
        if (dbMailFolder == null || dbMailFolder.specialType == specialType) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.setFolderSpecialType(immoToolProject, connection, dbMailFolder, specialType);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void setFolderSpecialType(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder, DbMailFolder.SpecialType specialType) throws SQLException {
        DbMailFolder dbMailFolder2;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailFolder == null || dbMailFolder.specialType == specialType) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        if (specialType != null && (dbMailFolder2 = dbMailMessageHandler.getSpecialFolder(connection, dbMailFolder.accountId, specialType)) != null) {
            if (dbMailFolder2.id == dbMailFolder.id) {
                return;
            }
            DbMailFolder dbMailFolder3 = this.getFolder(dbMailFolder2.id);
            if (dbMailFolder3 == null) {
                dbMailFolder3 = dbMailFolder2;
            }
            dbMailFolder3.specialType = null;
            if (DbMailFolder.SpecialType.INBOX.equals((Object)dbMailFolder3.specialType)) {
                dbMailFolder3.isAutoRetrieval = false;
            }
            dbMailMessageHandler.saveFolder(connection, dbMailFolder3);
            this.fireFolderWasUpdated(immoToolProject, dbMailFolder3);
            this.initRemoteIdleFolder(dbMailFolder3);
        }
        dbMailFolder.specialType = specialType;
        if (DbMailFolder.SpecialType.INBOX.equals((Object)dbMailFolder.specialType)) {
            dbMailFolder.isAutoRetrieval = true;
        }
        dbMailMessageHandler.saveFolder(connection, dbMailFolder);
        this.fireFolderWasUpdated(immoToolProject, dbMailFolder);
        this.initRemoteIdleFolder(dbMailFolder);
    }

    public void setFolderSpecialTypeInBackground(final DbMailFolder dbMailFolder, final DbMailFolder.SpecialType specialType) {
        if (dbMailFolder == null || dbMailFolder.specialType == specialType) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Update folder #" + dbMailFolder.id){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.setFolderSpecialType(dbMailFolder, specialType);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't update folder!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageMdn(DbMailMessage dbMailMessage, DbMailMessage.MdnStatus mdnStatus) throws SQLException {
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.setMessageMdn(immoToolProject, connection, dbMailMessage, mdnStatus);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void setMessageMdn(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailMessage.MdnStatus mdnStatus) throws SQLException {
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return;
        }
        dbMailMessage.mdnStatus = mdnStatus;
        dbMailMessageHandler.setMessageMdn(connection, dbMailMessage.id, mdnStatus);
        this.fireMessageWasUpdated(immoToolProject, dbMailMessage);
    }

    public void setMessageMdnInBackground(final DbMailMessage dbMailMessage, final DbMailMessage.MdnStatus mdnStatus) {
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Set MDN status for message #" + dbMailMessage.id){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.setMessageMdn(dbMailMessage, mdnStatus);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't set MDN status!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    public synchronized void unloadRemoteAccounts() {
        for (Store object : this.remoteAccountStores.values()) {
            MailPluginUtils.closeQuietly(object);
        }
        this.remoteAccountStores.clear();
        for (Transport transport : this.remoteAccountTransports.values()) {
            MailPluginUtils.closeQuietly(transport);
        }
        this.remoteAccountTransports.clear();
        for (ImapIdleStore imapIdleStore : this.remoteAccountIdleStores.values()) {
            imapIdleStore.disconnect();
        }
        this.remoteAccountIdleStores.clear();
    }

    public void unloadRemoteAccountsInBackground() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MailHandler.this.unloadRemoteAccounts();
            }
        };
        Thread thread = new Thread(runnable, "Unload remote accounts");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMailMessage updateMessage(MimeMessage mimeMessage, DbMailMessage dbMailMessage) throws MessagingException, SQLException, IOException {
        if (dbMailMessage == null || dbMailMessage.id < 1L || mimeMessage == null) {
            return null;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            DbMailMessage dbMailMessage2 = this.updateMessage(immoToolProject, connection, mimeMessage, dbMailMessage);
            return dbMailMessage2;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMailMessage updateMessage(ImmoToolProject immoToolProject, Connection connection, MimeMessage mimeMessage, DbMailMessage dbMailMessage) throws MessagingException, SQLException, IOException {
        Object object;
        Object object2;
        DbMailMessage dbMailMessage2;
        DbMailMessageHandler dbMailMessageHandler;
        if (dbMailMessage == null || dbMailMessage.id < 1L || mimeMessage == null) {
            return null;
        }
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
        if (dbMailExtension == null || dbMailMessageHandler == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        DbMailFolder dbMailFolder = this.getFolder(dbMailMessage.folderId);
        if (dbMailFolder == null) {
            throw new MessagingException("Can't find folder #" + dbMailMessage.folderId + "!");
        }
        DbMailMessage dbMailMessage3 = dbMailMessageHandler.getMessage(connection, dbMailMessage.id);
        if (dbMailMessage3 == null) {
            return this.addMessage(immoToolProject, connection, mimeMessage, dbMailFolder);
        }
        String string = null;
        Long l = null;
        Long l2 = null;
        DbMailAccount dbMailAccount = this.getRemoteAccount(dbMailFolder.accountId);
        if (dbMailAccount != null && AbstractMailReader.Type.IMAP.equals((Object)dbMailAccount.getReaderType())) {
            dbMailMessage2 = this.getRemoteFolder(dbMailFolder);
            if (dbMailMessage2 == null || !dbMailMessage2.exists()) {
                throw new MessagingException("Can't find remote folder!");
            }
            try {
                Object[] objectArray;
                dbMailMessage2.open(2);
                object2 = (IMAPFolder)dbMailMessage2;
                object = object2.getMessagesByUID(new long[]{dbMailMessage.uid});
                if (!ArrayUtils.isEmpty((Object[])object)) {
                    object2.setFlags((Message[])object, new Flags(Flags.Flag.DELETED), true);
                    object2.expunge();
                }
                if (ArrayUtils.isEmpty((Object[])(objectArray = object2.appendUIDMessages(new Message[]{mimeMessage = new ExtendedMimeMessage(mimeMessage, null, false)})))) {
                    throw new MessagingException("Mail server did not send an UID response for the appended message!");
                }
                l = ((AppendUID)objectArray[0]).uid;
                l2 = ((AppendUID)objectArray[0]).uidvalidity;
                MimeMessage mimeMessage2 = (MimeMessage)object2.getMessageByUID(l.longValue());
                string = mimeMessage2.getMessageID();
            }
            finally {
                MailPluginUtils.closeQuietly((Folder)dbMailMessage2, true);
            }
        }
        dbMailMessage2 = DbMailMessage.createMessage(mimeMessage);
        dbMailMessage2.id = dbMailMessage.id;
        dbMailMessage2.folderId = dbMailMessage.folderId;
        dbMailMessage2.mdnStatus = dbMailMessage.mdnStatus;
        if (l != null) {
            dbMailMessage2.uid = l;
        }
        if (l2 != null) {
            dbMailMessage2.uidValidity = l2;
        }
        if (!StringUtils.isEmpty(string)) {
            dbMailMessage2.mimeId = string;
        }
        dbMailMessage2.isDownloaded = false;
        dbMailMessageHandler.saveMessage(connection, dbMailMessage2);
        object2 = dbMailMessageHandler.getPartOnRoot(connection, dbMailMessage.id);
        if (object2 != null) {
            dbMailMessageHandler.removePart(connection, object2.id);
        }
        object = DbMailPart.createPart(mimeMessage);
        ((DbMailPart)object).setMessageId(dbMailMessage2.id);
        dbMailMessageHandler.savePart(connection, (DbMailPart)object, true);
        dbMailMessage2.isDownloaded = true;
        dbMailMessage2.hasAttachments = ((DbMailPart)object).hasAttachment();
        dbMailMessageHandler.saveMessage(connection, dbMailMessage2);
        if (dbMailMessage.isSeen && !dbMailMessage2.isSeen) {
            int n = this.getUnseenMessageCount(dbMailMessage2.folderId);
            if (++n > 0) {
                this.folderUnseenMessageCount.put(dbMailMessage2.folderId, n);
            } else {
                this.folderUnseenMessageCount.remove(dbMailMessage2.folderId);
            }
        } else if (!dbMailMessage.isSeen && dbMailMessage2.isSeen) {
            int n = this.getUnseenMessageCount(dbMailMessage2.folderId);
            if (--n > 0) {
                this.folderUnseenMessageCount.put(dbMailMessage2.folderId, n);
            } else {
                this.folderUnseenMessageCount.remove(dbMailMessage2.folderId);
            }
        }
        this.fireMessageWasUpdated(immoToolProject, dbMailMessage2);
        return dbMailMessage2;
    }

    public void updateMessageInBackground(final MimeMessage mimeMessage, final DbMailMessage dbMailMessage) {
        if (dbMailMessage == null || dbMailMessage.id < 1L || mimeMessage == null) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Update message"){

            protected Boolean doInBackground() throws Exception {
                MailHandler.this.updateMessage(mimeMessage, dbMailMessage);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't update message!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        });
    }

    private static class MailStoreListener
    implements StoreListener {
        private String prefix;

        public MailStoreListener(DbMailAccount dbMailAccount) {
            this(dbMailAccount.name, dbMailAccount.id);
        }

        public MailStoreListener(String string, long l) {
            this.prefix = "MAILBOX #" + l + " (" + string + ")";
        }

        public void notification(StoreEvent storeEvent) {
            if (1 == storeEvent.getMessageType()) {
                LOGGER.warn(this.prefix + ": " + storeEvent.getMessage());
            } else {
                LOGGER.debug(this.prefix + ": " + storeEvent.getMessage());
            }
        }
    }

    private static class MailIdleListener
    implements ImapIdleStore.IdleListener {
        private MailIdleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void idleNotSupported(long l, long l2) {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailAccount dbMailAccount = mailHandler.getAccount(l2);
            if (dbMailAccount == null) {
                return;
            }
            LOGGER.warn("[IMAP-IDLE #" + l2 + " #" + l + "] IDLE is not supported for '" + dbMailAccount.name + "' (#" + dbMailAccount.id + ")!");
            if (mailHandler.remoteAccountIdleStores.containsKey(l2)) {
                MailHandler mailHandler2 = mailHandler;
                synchronized (mailHandler2) {
                    ((ImapIdleStore)mailHandler.remoteAccountIdleStores.get(l2)).disconnect();
                    mailHandler.remoteAccountIdleStores.remove(l2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageFlagsChanged(Message message, long l, long l2) {
            DbMailMessageHandler dbMailMessageHandler;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
            if (dbMailExtension == null || dbMailMessageHandler == null) {
                LOGGER.warn("The mail addon is not properly initialized.");
                return;
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                DbMailMessage dbMailMessage = mailHandler.getLocalMessage(connection, message, l);
                if (dbMailMessage == null) {
                    LOGGER.warn("Can't find local message!");
                    return;
                }
                boolean bl = dbMailMessage.isSeen;
                dbMailMessage.updateFlags(message.getFlags());
                dbMailMessageHandler.saveMessage(connection, dbMailMessage);
                if (!bl && dbMailMessage.isSeen) {
                    int n = mailHandler.getUnseenMessageCount(l);
                    if (--n > 0) {
                        mailHandler.folderUnseenMessageCount.put(l, n);
                    } else {
                        mailHandler.folderUnseenMessageCount.remove(l);
                    }
                } else if (bl && !dbMailMessage.isSeen) {
                    int n = mailHandler.getUnseenMessageCount(l);
                    mailHandler.folderUnseenMessageCount.put(l, ++n);
                }
                mailHandler.fireMessageWasUpdated(immoToolProject, dbMailMessage);
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove messages!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageHeadersChanged(Message message, long l, long l2) {
            DbMailMessageHandler dbMailMessageHandler;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
            if (dbMailExtension == null || dbMailMessageHandler == null) {
                LOGGER.warn("The mail addon is not properly initialized.");
                return;
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                if (!MimeMessage.class.isInstance(message)) {
                    LOGGER.warn("Message is not a MIME message!");
                    return;
                }
                DbMailMessage dbMailMessage = mailHandler.getLocalMessage(connection, message, l);
                if (dbMailMessage == null) {
                    LOGGER.warn("Can't find local message!");
                    return;
                }
                DbMailMessage dbMailMessage2 = DbMailMessage.createMessage((MimeMessage)message);
                dbMailMessage2.id = dbMailMessage.id;
                dbMailMessage2.folderId = dbMailMessage.folderId;
                dbMailMessage2.mdnStatus = dbMailMessage.mdnStatus;
                dbMailMessageHandler.saveMessage(connection, dbMailMessage2);
                mailHandler.fireMessageWasUpdated(immoToolProject, dbMailMessage);
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove messages!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messagesAdded(Message[] messageArray, long l, long l2) {
            DbMailMessageHandler dbMailMessageHandler;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
            if (dbMailExtension == null || dbMailMessageHandler == null) {
                LOGGER.warn("The mail addon is not properly initialized.");
                return;
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (Message message : messageArray) {
                    if (!MimeMessage.class.isInstance(message)) {
                        LOGGER.warn("Message is not a MIME message!");
                        continue;
                    }
                    try {
                        DbMailMessage dbMailMessage = DbMailMessage.createMessage((MimeMessage)message);
                        dbMailMessage.folderId = l;
                        dbMailMessage.isDownloaded = false;
                        dbMailMessageHandler.saveMessage(connection, dbMailMessage);
                        if (!dbMailMessage.isSeen) {
                            int n = mailHandler.getUnseenMessageCount(l);
                            mailHandler.folderUnseenMessageCount.put(l, n + 1);
                        }
                        mailHandler.fireMessageWasFound(immoToolProject, dbMailMessage);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't add message!");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't add messages!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messagesRemoved(Message[] messageArray, long l, long l2) {
            DbMailMessageHandler dbMailMessageHandler;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            DbMailMessageHandler dbMailMessageHandler2 = dbMailMessageHandler = dbMailExtension != null ? dbMailExtension.getMessageHandler() : null;
            if (dbMailExtension == null || dbMailMessageHandler == null) {
                LOGGER.warn("The mail addon is not properly initialized.");
                return;
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (Message message : messageArray) {
                    DbMailMessage dbMailMessage = mailHandler.getLocalMessage(connection, message, l);
                    if (dbMailMessage == null) {
                        LOGGER.warn("Can't find local message!");
                        continue;
                    }
                    long l3 = dbMailMessage.id;
                    dbMailMessageHandler.removeMessage(connection, dbMailMessage.id);
                    if (!dbMailMessage.isSeen) {
                        int n = mailHandler.getUnseenMessageCount(l);
                        if (--n > 0) {
                            mailHandler.folderUnseenMessageCount.put(l, n);
                        } else {
                            mailHandler.folderUnseenMessageCount.remove(l);
                        }
                    }
                    mailHandler.fireMessageWasRemoved(immoToolProject, l3, l);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove messages!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }
}

