/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.mail.db.DbMailHeader;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import java.util.Locale;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public enum MailPriority implements Translatable
{
    HIGH(I18n.marktr((String)"high")),
    NORMAL(I18n.marktr((String)"normal")),
    LOW(I18n.marktr((String)"low"));

    private static final Logger LOGGER;
    private static final I18n I18N;
    private static final String HEADER_X_PRIORITY = "X-Priority";
    private static final String HEADER_X_MSMAIL_PRIORITY = "X-MSMail-Priority";
    private static final String HEADER_IMPORTANCE = "Importance";
    private final String i18nKey;

    private MailPriority(String string2) {
        this.i18nKey = string2;
    }

    private String getImportanceValue() {
        return this.name().toLowerCase();
    }

    private String getXMsMailPriorityValue() {
        return this.name().toLowerCase();
    }

    public String getTranslation() {
        return ImmoToolUtils.getI18nString(MailPriority.class, (String)this.i18nKey);
    }

    public String getTranslation(Locale locale) {
        return ImmoToolUtils.getI18nString(MailPriority.class, (String)this.i18nKey, (Locale)locale);
    }

    private String getXPriorityValue() {
        switch (this) {
            case HIGH: {
                return "1 (Highest)";
            }
            case LOW: {
                return "5 (Lowest)";
            }
        }
        return "3 (Normal)";
    }

    public static MailPriority readFromHeader(DbMailPart dbMailPart) {
        if (dbMailPart == null || dbMailPart.headers == null || dbMailPart.headers.isEmpty()) {
            return null;
        }
        Object[] objectArray = dbMailPart.getHeader(HEADER_X_PRIORITY);
        Object[] objectArray2 = dbMailPart.getHeader(HEADER_X_MSMAIL_PRIORITY);
        Object[] objectArray3 = dbMailPart.getHeader(HEADER_IMPORTANCE);
        return MailPriority.readFromHeader(!ArrayUtils.isEmpty((Object[])objectArray) ? ((DbMailHeader)objectArray[0]).value.trim() : null, !ArrayUtils.isEmpty((Object[])objectArray2) ? ((DbMailHeader)objectArray2[0]).value.trim() : null, !ArrayUtils.isEmpty((Object[])objectArray3) ? ((DbMailHeader)objectArray3[0]).value.trim() : null);
    }

    public static MailPriority readFromHeader(Message message) throws MessagingException {
        if (message == null) {
            return null;
        }
        Object[] objectArray = message.getHeader(HEADER_X_PRIORITY);
        Object[] objectArray2 = message.getHeader(HEADER_X_MSMAIL_PRIORITY);
        Object[] objectArray3 = message.getHeader(HEADER_IMPORTANCE);
        return MailPriority.readFromHeader(!ArrayUtils.isEmpty((Object[])objectArray) ? ((String)objectArray[0]).trim() : null, !ArrayUtils.isEmpty((Object[])objectArray2) ? ((String)objectArray2[0]).trim() : null, !ArrayUtils.isEmpty((Object[])objectArray3) ? ((String)objectArray3[0]).trim() : null);
    }

    private static MailPriority readFromHeader(String string, String string2, String string3) {
        if (!StringUtils.isBlank((CharSequence)string)) {
            if (string.startsWith("1") || string.startsWith("2")) {
                return HIGH;
            }
            if (string.startsWith("3")) {
                return NORMAL;
            }
            if (string.startsWith("4") || string.startsWith("5")) {
                return LOW;
            }
        }
        if (!StringUtils.isBlank((CharSequence)string2)) {
            if ("high".equalsIgnoreCase(string2)) {
                return HIGH;
            }
            if ("normal".equalsIgnoreCase(string2)) {
                return NORMAL;
            }
            if ("low".equalsIgnoreCase(string2)) {
                return LOW;
            }
        }
        if (!StringUtils.isBlank((CharSequence)string3)) {
            if ("high".equalsIgnoreCase(string3)) {
                return HIGH;
            }
            if ("normal".equalsIgnoreCase(string3)) {
                return NORMAL;
            }
            if ("low".equalsIgnoreCase(string3)) {
                return LOW;
            }
        }
        return null;
    }

    public void writeToHeader(Email email) {
        MailPriority.writeToHeader(this, email);
    }

    public static void writeToHeader(MailPriority mailPriority, Email email) {
        if (mailPriority == null || email == null) {
            return;
        }
        email.addHeader(HEADER_X_PRIORITY, mailPriority.getXPriorityValue());
        email.addHeader(HEADER_X_MSMAIL_PRIORITY, mailPriority.getXMsMailPriorityValue());
        email.addHeader(HEADER_IMPORTANCE, mailPriority.getImportanceValue());
    }

    public void writeToHeader(Message message) throws MessagingException {
        MailPriority.writeToHeader(this, message);
    }

    public static void writeToHeader(MailPriority mailPriority, Message message) throws MessagingException {
        if (mailPriority == null || message == null) {
            return;
        }
        message.setHeader(HEADER_X_PRIORITY, mailPriority.getXPriorityValue());
        message.setHeader(HEADER_X_MSMAIL_PRIORITY, mailPriority.getXMsMailPriorityValue());
        message.setHeader(HEADER_IMPORTANCE, mailPriority.getImportanceValue());
    }

    static {
        LOGGER = LoggerFactory.getLogger(MailPriority.class);
        I18N = I18nFactory.getI18n(MailPriority.class);
    }
}

