/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAccountHandler;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.mail.io.AbstractMailWriter;
import com.openindex.openestate.tool.mail.io.ImapReader;
import com.openindex.openestate.tool.mail.io.Pop3Reader;
import com.openindex.openestate.tool.mail.io.SmtpWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailUpgradeExtension.class);

    private static DbMailAccount createAccount(Properties properties) {
        String string;
        String string2;
        Object object;
        Object object2;
        DbMailAccount dbMailAccount = new DbMailAccount();
        dbMailAccount.name = properties.getProperty("account.name", null);
        dbMailAccount.type = DbMailAccount.Type.REMOTE;
        dbMailAccount.enabled = ImmoToolUtils.getPropertyAsBoolean((String)"account.enabled", (Boolean)false, (Properties)properties);
        dbMailAccount.settings = new HashMap<String, String>();
        dbMailAccount.setSenderFromMail(properties.getProperty("sender.fromMail"));
        dbMailAccount.setSenderFromName(properties.getProperty("sender.fromName"));
        dbMailAccount.setSenderReplyTo(properties.getProperty("sender.replyTo"));
        dbMailAccount.setSenderSignatureHtml(properties.getProperty("sender.signature"));
        dbMailAccount.setSenderSignatureText(properties.getProperty("sender.signature"));
        String string3 = properties.getProperty("account.writer");
        if ("SMTP".equalsIgnoreCase(string3)) {
            object2 = new SmtpWriter();
            ((SmtpWriter)object2).setHost(properties.getProperty("smtp.host", "localhost "));
            ((SmtpWriter)object2).setPort(ImmoToolUtils.getPropertyAsInteger((String)"smtp.port", (Integer)25, (Properties)properties));
            ((SmtpWriter)object2).setAuthUser(properties.getProperty("smtp.auth.user"));
            ((SmtpWriter)object2).setAuthPass(properties.getProperty("smtp.auth.pass", "").toCharArray());
            object = properties.getProperty("smtp.auth.method");
            if ("PLAIN".equalsIgnoreCase((String)object)) {
                ((SmtpWriter)object2).setAuthMethod(SmtpWriter.AuthMethod.PLAIN);
            } else if ("LOGIN".equalsIgnoreCase((String)object)) {
                ((SmtpWriter)object2).setAuthMethod(SmtpWriter.AuthMethod.LOGIN);
            } else if ("CRAM_MD5".equalsIgnoreCase((String)object)) {
                ((SmtpWriter)object2).setAuthMethod(SmtpWriter.AuthMethod.CRAM_MD5);
            } else if ("DIGEST_MD5".equalsIgnoreCase((String)object)) {
                ((SmtpWriter)object2).setAuthMethod(SmtpWriter.AuthMethod.DIGEST_MD5);
            } else if ("POP_BEFORE_SMTP".equalsIgnoreCase((String)object)) {
                ((SmtpWriter)object2).setAuthMethod(SmtpWriter.AuthMethod.POP_BEFORE_SMTP);
            } else {
                ((SmtpWriter)object2).setAuthMethod(SmtpWriter.AuthMethod.ANONYMOUS);
            }
            string2 = properties.getProperty("smtp.crypt.method");
            if ("STARTTLS".equalsIgnoreCase(string2)) {
                ((SmtpWriter)object2).setCryptMethod(SmtpWriter.CryptMethod.STARTTLS);
            } else if ("SMTPS".equalsIgnoreCase(string2)) {
                ((SmtpWriter)object2).setCryptMethod(SmtpWriter.CryptMethod.SMTPS);
            } else {
                ((SmtpWriter)object2).setCryptMethod(SmtpWriter.CryptMethod.NO_ENCRYPTION);
            }
            dbMailAccount.setWriter((AbstractMailWriter)object2);
        }
        if ("IMAP".equals(object2 = properties.getProperty("account.reader"))) {
            object = new ImapReader();
            ((ImapReader)object).setHost(properties.getProperty("imap.host", "localhost"));
            ((ImapReader)object).setPort(ImmoToolUtils.getPropertyAsInteger((String)"imap.port", (Integer)143, (Properties)properties));
            ((ImapReader)object).setAuthUser(properties.getProperty("imap.auth.user"));
            ((ImapReader)object).setAuthPass(properties.getProperty("imap.auth.pass", "").toCharArray());
            string2 = properties.getProperty("imap.auth.method");
            if ("PLAIN".equalsIgnoreCase(string2)) {
                ((ImapReader)object).setAuthMethod(ImapReader.AuthMethod.PLAIN);
            } else if ("LOGIN".equalsIgnoreCase(string2)) {
                ((ImapReader)object).setAuthMethod(ImapReader.AuthMethod.LOGIN);
            } else if ("CRAM_MD5".equalsIgnoreCase(string2)) {
                ((ImapReader)object).setAuthMethod(ImapReader.AuthMethod.CRAM_MD5);
            } else if ("DIGEST_MD5".equalsIgnoreCase(string2)) {
                ((ImapReader)object).setAuthMethod(ImapReader.AuthMethod.DIGEST_MD5);
            } else {
                ((ImapReader)object).setAuthMethod(ImapReader.AuthMethod.ANONYMOUS);
            }
            string = properties.getProperty("imap.crypt.method");
            if ("STARTTLS".equalsIgnoreCase(string)) {
                ((ImapReader)object).setCryptMethod(ImapReader.CryptMethod.STARTTLS);
            } else if ("IMAPS".equalsIgnoreCase(string)) {
                ((ImapReader)object).setCryptMethod(ImapReader.CryptMethod.IMAPS);
            } else {
                ((ImapReader)object).setCryptMethod(ImapReader.CryptMethod.NO_ENCRYPTION);
            }
            dbMailAccount.setReader((AbstractMailReader)object);
        } else if ("POP3".equals(object2)) {
            object = new Pop3Reader();
            ((Pop3Reader)object).setHost(properties.getProperty("pop3.host"));
            ((Pop3Reader)object).setPort(ImmoToolUtils.getPropertyAsInteger((String)"pop3.port", (Integer)110, (Properties)properties));
            ((Pop3Reader)object).setAuthUser(properties.getProperty("pop3.auth.user"));
            ((Pop3Reader)object).setAuthPass(properties.getProperty("pop3.auth.pass", "").toCharArray());
            string2 = properties.getProperty("pop3.auth.method");
            if ("LOGIN".equalsIgnoreCase(string2)) {
                ((Pop3Reader)object).setAuthMethod(Pop3Reader.AuthMethod.LOGIN);
            } else if ("APOP".equalsIgnoreCase(string2)) {
                ((Pop3Reader)object).setAuthMethod(Pop3Reader.AuthMethod.APOP);
            } else {
                ((Pop3Reader)object).setAuthMethod(Pop3Reader.AuthMethod.ANONYMOUS);
            }
            string = properties.getProperty("pop3.crypt.method");
            if ("STARTTLS".equalsIgnoreCase(string)) {
                ((Pop3Reader)object).setCryptMethod(Pop3Reader.CryptMethod.STARTTLS);
            } else if ("POP3S".equalsIgnoreCase(string)) {
                ((Pop3Reader)object).setCryptMethod(Pop3Reader.CryptMethod.POP3S);
            } else {
                ((Pop3Reader)object).setCryptMethod(Pop3Reader.CryptMethod.NO_ENCRYPTION);
            }
            dbMailAccount.setReader((AbstractMailReader)object);
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string2 = object.nextElement().toString();
            if (!string2.startsWith("custom.")) continue;
            dbMailAccount.setCustomProperty(string2.substring("custom.".length()), properties.getProperty(string2));
        }
        return dbMailAccount;
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Mail"};
    }

    public void upgrade(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, Properties properties, ImmoToolTask.Callback callback) throws SQLException, IOException {
        this.setMessage("Upgrade mails...", callback);
        DbMailExtension dbMailExtension = MailPluginUtils.getDbMailExtension(abstractDbDriver);
        DbMailAccountHandler dbMailAccountHandler = dbMailExtension.getAccountHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        TreeMap<Long, Object> treeMap = new TreeMap<Long, Object>();
        Object[] objectArray = file.listFiles((FileFilter)suffixFileFilter);
        if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                try {
                    treeMap.put(Long.valueOf(((File)object).getName().split("\\.")[0]), object);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read account-id!");
                    LOGGER.warn("> from " + ((File)object).getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read account-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            File file2 = (File)entry.getValue();
            try {
                Object object;
                object = new FileInputStream(file2);
                Throwable throwable = null;
                try {
                    Properties properties2 = new Properties();
                    properties2.loadFromXML((InputStream)object);
                    DbMailAccount dbMailAccount = MailUpgradeExtension.createAccount(properties2);
                    this.setMessage("> Import mail-account '" + dbMailAccount.name + "'", callback);
                    dbMailAccountHandler.saveAccount(connection, dbMailAccount);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)object).close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't import mail-account!");
                LOGGER.warn("> from " + file2.getAbsolutePath());
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.setMessage("WARNING: Can't import mail-account!", callback);
                this.setMessage("> " + exception.getLocalizedMessage(), callback);
            }
        }
    }
}

