/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.mail.db.DbMailAddress;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailHeader;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandlerImpl;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbMailMessageHandler
extends DbMailMessageHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbMailMessageHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbMailMessageHandler.class);
    public static final String PROC_REMOVE_ADDRESSES = "remove_immotool_mails_addresses";
    public static final String PROC_REMOVE_FOLDERS = "remove_immotool_mails_folders";
    public static final String PROC_REMOVE_HEADERS = "remove_immotool_mails_headers";
    public static final String PROC_REMOVE_MESSAGES = "remove_immotool_mails_messages";
    public static final String PROC_REMOVE_PARTS = "remove_immotool_mails_parts";
    public static final String PROC_SAVE_ADDRESSES = "save_immotool_mails_addresses";
    public static final String PROC_SAVE_FOLDERS = "save_immotool_mails_folders";
    public static final String PROC_SAVE_HEADERS = "save_immotool_mails_headers";
    public static final String PROC_SAVE_MESSAGES = "save_immotool_mails_messages";
    public static final String PROC_SAVE_PARTS = "save_immotool_mails_parts";
    public static final String PROC_SET_MESSAGES_ANSWERED = "set_immotool_mails_messages_answered";
    public static final String PROC_SET_MESSAGES_ARCHIVED = "set_immotool_mails_messages_archived";
    public static final String PROC_SET_MESSAGES_FORWARDED = "set_immotool_mails_messages_forwarded";
    public static final String PROC_SET_MESSAGES_MDN = "set_immotool_mails_messages_mdn";
    public static final String PROC_SET_MESSAGES_SEEN = "set_immotool_mails_messages_seen";
    public static final String VIEW_FOLDERS = "view_immotool_mails_folders";
    public static final String VIEW_MESSAGES = "view_immotool_mails_messages";
    public static final String VIEW_PARTS = "view_immotool_mails_parts";
    public static final String VIEW_PARTS_CONTENT = "view_immotool_mails_parts_content";
    public static final String VIEW_HEADERS = "view_immotool_mails_headers";
    public static final String VIEW_ADDRESSES = "view_immotool_mails_addresses";
    public static final String TABLE_FOLDERS = "immotool_mails_folders";
    public static final String FIELD_FOLDER_ID = "folder_id";
    public static final String FIELD_FOLDER_PARENT_ID = "folder_parent_id";
    public static final String FIELD_FOLDER_NAME = "folder_name";
    public static final String FIELD_FOLDER_HOLDS_MESSAGES = "folder_holds_messages";
    public static final String FIELD_FOLDER_HOLDS_FOLDERS = "folder_holds_folders";
    public static final String FIELD_FOLDER_AUTO_RETRIEVAL = "folder_auto_retrieval";
    public static final String FIELD_FOLDER_SPECIAL_TYPE = "folder_special_type";
    public static final String TABLE_MESSAGES = "immotool_mails_messages";
    public static final String FIELD_MESSAGE_ID = "message_id";
    public static final String FIELD_MESSAGE_SUBJECT = "message_subject";
    public static final String FIELD_MESSAGE_FROM = "message_from";
    public static final String FIELD_MESSAGE_TO = "message_to";
    public static final String FIELD_MESSAGE_SIZE = "message_size";
    public static final String FIELD_MESSAGE_UID = "message_uid";
    public static final String FIELD_MESSAGE_UID_VALIDITY = "message_uid_validity";
    public static final String FIELD_MESSAGE_MIME_ID = "message_mime_id";
    public static final String FIELD_MESSAGE_HASH = "message_hash";
    public static final String FIELD_MESSAGE_IN_REPLY_TO = "message_in_reply_to";
    public static final String FIELD_MESSAGE_IS_ANSWERED = "message_is_answered";
    public static final String FIELD_MESSAGE_IS_ARCHIVED = "message_is_archived";
    public static final String FIELD_MESSAGE_IS_DOWNLOADED = "message_is_downloaded";
    public static final String FIELD_MESSAGE_IS_DRAFT = "message_is_draft";
    public static final String FIELD_MESSAGE_IS_FLAGGED = "message_is_flagged";
    public static final String FIELD_MESSAGE_IS_FORWARDED = "message_is_forwarded";
    public static final String FIELD_MESSAGE_IS_SEEN = "message_is_seen";
    public static final String FIELD_MESSAGE_IS_RECEIVED = "message_is_received";
    public static final String FIELD_MESSAGE_HAS_ATTACHMENTS = "message_has_attachments";
    public static final String FIELD_MESSAGE_MDN_STATUS = "message_mdn_status";
    public static final String FIELD_MESSAGE_RECEIVED_AT = "message_received_at";
    public static final String FIELD_MESSAGE_SENT_AT = "message_sent_at";
    public static final String TABLE_PARTS = "immotool_mails_parts";
    public static final String FIELD_PART_ID = "part_id";
    public static final String FIELD_PART_PARENT_ID = "part_parent_id";
    public static final String FIELD_PART_TYPE = "part_type";
    public static final String FIELD_PART_DESCRIPTION = "part_description";
    public static final String FIELD_PART_DISPOSITION = "part_disposition";
    public static final String FIELD_PART_TEXT = "part_text";
    public static final String FIELD_PART_FILE_NAME = "part_file_name";
    public static final String FIELD_PART_FILE_SIZE = "part_file_size";
    public static final String FIELD_PART_FILE_CONTENT = "part_file_content";
    public static final String TABLE_HEADERS = "immotool_mails_headers";
    public static final String FIELD_HEADER_KEY = "header_key";
    public static final String FIELD_HEADER_VALUE = "header_value";
    public static final String TABLE_ADDRESSES = "immotool_mails_addresses";
    public static final String FIELD_ADDRESS_TYPE = "address_type";
    public static final String FIELD_ADDRESS_VALUE = "address_value";
    public static final String FIELD_ADDRESS_PERSON = "address_person";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCOUNT_ID = "account_id";

    private static DbMailAddress createAddress(ResultSet resultSet) throws SQLException {
        DbMailAddress dbMailAddress = new DbMailAddress();
        dbMailAddress.messageId = resultSet.getLong(FIELD_MESSAGE_ID);
        dbMailAddress.value = resultSet.getString(FIELD_ADDRESS_VALUE);
        dbMailAddress.person = resultSet.getString(FIELD_ADDRESS_PERSON);
        String string = resultSet.getString(FIELD_ADDRESS_TYPE);
        dbMailAddress.type = string != null ? DbMailAddress.Type.valueOf(string) : null;
        return dbMailAddress;
    }

    private static DbMailFolder createFolder(ResultSet resultSet) throws SQLException {
        DbMailFolder dbMailFolder = new DbMailFolder();
        dbMailFolder.id = resultSet.getLong(FIELD_FOLDER_ID);
        dbMailFolder.parentFolderId = resultSet.getLong(FIELD_FOLDER_PARENT_ID);
        dbMailFolder.accountId = resultSet.getLong(FIELD_ACCOUNT_ID);
        dbMailFolder.name = resultSet.getString(FIELD_FOLDER_NAME);
        dbMailFolder.holdsMessages = resultSet.getBoolean(FIELD_FOLDER_HOLDS_MESSAGES);
        dbMailFolder.holdsFolders = resultSet.getBoolean(FIELD_FOLDER_HOLDS_FOLDERS);
        dbMailFolder.isAutoRetrieval = resultSet.getBoolean(FIELD_FOLDER_AUTO_RETRIEVAL);
        dbMailFolder.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbMailFolder.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        String string = resultSet.getString(FIELD_FOLDER_SPECIAL_TYPE);
        if (StringUtils.isBlank((CharSequence)string)) {
            dbMailFolder.specialType = null;
        } else {
            try {
                dbMailFolder.specialType = DbMailFolder.SpecialType.valueOf(string);
            }
            catch (Exception exception) {
                dbMailFolder.specialType = null;
                LOGGER.warn("Can't load type of folder #" + dbMailFolder.id + "!");
                LOGGER.warn("> fallback to null");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return dbMailFolder;
    }

    private static DbMailHeader createHeader(ResultSet resultSet) throws SQLException {
        DbMailHeader dbMailHeader = new DbMailHeader();
        dbMailHeader.partId = resultSet.getLong(FIELD_PART_ID);
        dbMailHeader.key = resultSet.getString(FIELD_HEADER_KEY);
        dbMailHeader.value = resultSet.getString(FIELD_HEADER_VALUE);
        return dbMailHeader;
    }

    private static DbMailMessage createMessage(ResultSet resultSet) throws SQLException {
        DbMailMessage dbMailMessage = new DbMailMessage();
        dbMailMessage.id = resultSet.getLong(FIELD_MESSAGE_ID);
        dbMailMessage.folderId = resultSet.getLong(FIELD_FOLDER_ID);
        dbMailMessage.mimeId = resultSet.getString(FIELD_MESSAGE_MIME_ID);
        dbMailMessage.hash = resultSet.getString(FIELD_MESSAGE_HASH);
        dbMailMessage.inReplyTo = resultSet.getString(FIELD_MESSAGE_IN_REPLY_TO);
        dbMailMessage.subject = resultSet.getString(FIELD_MESSAGE_SUBJECT);
        dbMailMessage.from = resultSet.getString(FIELD_MESSAGE_FROM);
        dbMailMessage.to = resultSet.getString(FIELD_MESSAGE_TO);
        dbMailMessage.size = resultSet.getLong(FIELD_MESSAGE_SIZE);
        dbMailMessage.isAnswered = resultSet.getBoolean(FIELD_MESSAGE_IS_ANSWERED);
        dbMailMessage.isArchived = resultSet.getBoolean(FIELD_MESSAGE_IS_ARCHIVED);
        dbMailMessage.isDownloaded = resultSet.getBoolean(FIELD_MESSAGE_IS_DOWNLOADED);
        dbMailMessage.isDraft = resultSet.getBoolean(FIELD_MESSAGE_IS_DRAFT);
        dbMailMessage.isFlagged = resultSet.getBoolean(FIELD_MESSAGE_IS_FLAGGED);
        dbMailMessage.isForwarded = resultSet.getBoolean(FIELD_MESSAGE_IS_FORWARDED);
        dbMailMessage.isSeen = resultSet.getBoolean(FIELD_MESSAGE_IS_SEEN);
        dbMailMessage.isReceived = resultSet.getBoolean(FIELD_MESSAGE_IS_RECEIVED);
        dbMailMessage.hasAttachments = resultSet.getBoolean(FIELD_MESSAGE_HAS_ATTACHMENTS);
        dbMailMessage.receivedAt = resultSet.getTimestamp(FIELD_MESSAGE_RECEIVED_AT);
        dbMailMessage.sentAt = resultSet.getTimestamp(FIELD_MESSAGE_SENT_AT);
        dbMailMessage.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbMailMessage.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        Object object = resultSet.getObject(FIELD_MESSAGE_UID);
        dbMailMessage.uid = object != null ? Long.valueOf(resultSet.getLong(FIELD_MESSAGE_UID)) : null;
        object = resultSet.getObject(FIELD_MESSAGE_UID_VALIDITY);
        dbMailMessage.uidValidity = object != null ? Long.valueOf(resultSet.getLong(FIELD_MESSAGE_UID_VALIDITY)) : null;
        String string = resultSet.getString(FIELD_MESSAGE_MDN_STATUS);
        if (StringUtils.isBlank((CharSequence)string)) {
            dbMailMessage.mdnStatus = null;
        } else {
            try {
                dbMailMessage.mdnStatus = DbMailMessage.MdnStatus.valueOf(string);
            }
            catch (Exception exception) {
                dbMailMessage.mdnStatus = null;
                LOGGER.warn("Can't load MDN status of message #" + dbMailMessage.id + "!");
                LOGGER.warn("> fallback to null");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return dbMailMessage;
    }

    private static DbMailPart createPart(ResultSet resultSet) throws SQLException {
        DbMailPart dbMailPart = new DbMailPart();
        dbMailPart.id = resultSet.getLong(FIELD_PART_ID);
        dbMailPart.parentPartId = resultSet.getLong(FIELD_PART_PARENT_ID);
        dbMailPart.description = resultSet.getString(FIELD_PART_DESCRIPTION);
        dbMailPart.disposition = resultSet.getString(FIELD_PART_DISPOSITION);
        dbMailPart.type = resultSet.getString(FIELD_PART_TYPE);
        dbMailPart.text = resultSet.getString(FIELD_PART_TEXT);
        dbMailPart.fileName = resultSet.getString(FIELD_PART_FILE_NAME);
        dbMailPart.fileSize = resultSet.getLong(FIELD_PART_FILE_SIZE);
        dbMailPart.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbMailPart.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbMailPart;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean downloadPart(Connection var1_1, long var2_2, OutputStream var4_3) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailMessage[] getArchivedMessages(Connection connection, long[] lArray) throws SQLException {
        DbMailMessage[] dbMailMessageArray;
        if (lArray != null && lArray.length == 0) {
            return new DbMailMessage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages WHERE message_is_archived = ? ORDER BY message_id ASC;");
                preparedStatement.setBoolean(1, true);
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages WHERE message_is_archived = ? AND folder_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_MESSAGE_ID + " ASC;");
                preparedStatement.setBoolean(1, true);
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 2, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailMessage> arrayList = new ArrayList<DbMailMessage>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createMessage(resultSet));
            }
            dbMailMessageArray = arrayList.toArray(new DbMailMessage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailFolder[] getFolders(Connection connection, long[] lArray) throws SQLException {
        DbMailFolder[] dbMailFolderArray;
        if (lArray != null && lArray.length == 0) {
            return new DbMailFolder[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_folders ORDER BY folder_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE folder_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_FOLDER_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailFolder> arrayList = new ArrayList<DbMailFolder>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createFolder(resultSet));
            }
            dbMailFolderArray = arrayList.toArray(new DbMailFolder[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailFolderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbMailFolder[] getFoldersForAutoRetrieval(Connection connection, long[] lArray) throws SQLException {
        DbMailFolder[] dbMailFolderArray;
        if (lArray != null && lArray.length == 0) {
            return new DbMailFolder[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            preparedStatement = lArray == null ? connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE (folder_auto_retrieval = ? OR folder_special_type = ?) ORDER BY folder_id ASC;") : connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE (folder_auto_retrieval = ? OR folder_special_type = ?) AND account_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ACCOUNT_ID + " ASC, " + FIELD_FOLDER_ID + " ASC;");
            int n = 0;
            preparedStatement.setBoolean(++n, true);
            preparedStatement.setString(++n, DbMailFolder.SpecialType.INBOX.name());
            if (lArray != null) {
                object = lArray;
                int n2 = ((long[])object).length;
                for (int i = 0; i < n2; ++i) {
                    Long l = object[i];
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            object = new ArrayList();
            while (resultSet.next()) {
                object.add(HSqlDbMailMessageHandler.createFolder(resultSet));
            }
            dbMailFolderArray = object.toArray(new DbMailFolder[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailFolderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailFolder[] getFolderChildren(Connection connection, long l) throws SQLException {
        DbMailFolder[] dbMailFolderArray;
        if (l < 1L) {
            return new DbMailFolder[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE folder_parent_id = ? ORDER BY folder_id ASC;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailFolder> arrayList = new ArrayList<DbMailFolder>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createFolder(resultSet));
            }
            dbMailFolderArray = arrayList.toArray(new DbMailFolder[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailFolderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailFolder getFolderOnRoot(Connection connection, long l) throws SQLException {
        DbMailFolder dbMailFolder;
        if (l < 1L) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE account_id = ? AND folder_parent_id IS NULL AND folder_name IS NULL LIMIT 1;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            dbMailFolder = resultSet.next() ? HSqlDbMailMessageHandler.createFolder(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailMessage getMessageFromFolder(Connection connection, long l, String string, String string2) throws SQLException {
        DbMailMessage dbMailMessage;
        if (l < 1L || StringUtils.isBlank((CharSequence)string) && StringUtils.isBlank((CharSequence)string2)) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)string)) {
                arrayList.add("message_hash = ?");
            }
            if (!StringUtils.isBlank((CharSequence)string2)) {
                arrayList.add("message_hash IS NULL AND message_mime_id = ?");
            }
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages WHERE folder_id = ? AND ((" + StringUtils.join(arrayList, (String)") OR (") + ")) LIMIT 1;");
            int n = 0;
            preparedStatement.setLong(++n, l);
            if (!StringUtils.isBlank((CharSequence)string)) {
                preparedStatement.setString(++n, string);
            }
            if (!StringUtils.isBlank((CharSequence)string2)) {
                preparedStatement.setString(++n, string2);
            }
            dbMailMessage = (resultSet = preparedStatement.executeQuery()).next() ? HSqlDbMailMessageHandler.createMessage(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailMessage getMessageFromFolder(Connection connection, long l, long l2, long l3) throws SQLException {
        DbMailMessage dbMailMessage;
        if (l < 1L) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages WHERE folder_id = ? AND message_uid = ? AND message_uid_validity = ? LIMIT 1;");
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setLong(++n, l2);
            preparedStatement.setLong(++n, l3);
            resultSet = preparedStatement.executeQuery();
            dbMailMessage = resultSet.next() ? HSqlDbMailMessageHandler.createMessage(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailMessage[] getMessages(Connection connection, long[] lArray) throws SQLException {
        DbMailMessage[] dbMailMessageArray;
        if (lArray != null && lArray.length == 0) {
            return new DbMailMessage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages ORDER BY message_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages WHERE message_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_MESSAGE_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailMessage> arrayList = new ArrayList<DbMailMessage>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createMessage(resultSet));
            }
            dbMailMessageArray = arrayList.toArray(new DbMailMessage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMessageIdsFromFolder(Connection connection, long l) throws SQLException {
        long[] lArray;
        if (l < 1L) {
            return new long[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT message_id FROM view_immotool_mails_messages WHERE folder_id = ? ORDER BY message_id ASC;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_MESSAGE_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailMessage[] getMessagesFromFolder(Connection connection, long l) throws SQLException {
        DbMailMessage[] dbMailMessageArray;
        if (l < 1L) {
            return new DbMailMessage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_messages WHERE folder_id = ? ORDER BY message_id ASC;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailMessage> arrayList = new ArrayList<DbMailMessage>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createMessage(resultSet));
            }
            dbMailMessageArray = arrayList.toArray(new DbMailMessage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbMailPart[] getParts(Connection connection, long[] lArray) throws SQLException {
        DbMailPart[] dbMailPartArray;
        if (lArray != null && lArray.length == 0) {
            return new DbMailPart[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_parts ORDER BY message_id ASC, part_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_parts WHERE part_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_MESSAGE_ID + " ASC, " + FIELD_PART_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailPart> arrayList = new ArrayList<DbMailPart>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createPart(resultSet));
            }
            dbMailPartArray = arrayList.toArray(new DbMailPart[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailPartArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailPart[] getPartChildren(Connection connection, long l) throws SQLException {
        DbMailPart[] dbMailPartArray;
        if (l < 1L) {
            return new DbMailPart[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_parts WHERE part_parent_id = ? ORDER BY part_id ASC;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailPart> arrayList = new ArrayList<DbMailPart>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createPart(resultSet));
            }
            dbMailPartArray = arrayList.toArray(new DbMailPart[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailPartArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailPart getPartOnRoot(Connection connection, long l) throws SQLException {
        DbMailPart dbMailPart;
        if (l < 1L) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_parts WHERE message_id = ? AND part_parent_id IS NULL LIMIT 1;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            dbMailPart = resultSet.next() ? HSqlDbMailMessageHandler.createPart(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailFolder[] getSpecialFolders(Connection connection, long l, DbMailFolder.SpecialType[] specialTypeArray) throws SQLException {
        DbMailFolder[] dbMailFolderArray;
        if (l < 1L) {
            return new DbMailFolder[0];
        }
        if (specialTypeArray != null && specialTypeArray.length == 0) {
            return new DbMailFolder[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = specialTypeArray == null ? connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE account_id = ? AND folder_special_type IS NOT NULL ORDER BY folder_id ASC;") : connection.prepareStatement("SELECT * FROM view_immotool_mails_folders WHERE account_id = ? AND folder_special_type IN (" + JdbcUtils.writeQuestionMarkList((int)specialTypeArray.length) + ") ORDER BY " + FIELD_FOLDER_ID + " ASC;");
            int n = 0;
            preparedStatement.setLong(++n, l);
            if (specialTypeArray != null) {
                for (DbMailFolder.SpecialType specialType : specialTypeArray) {
                    preparedStatement.setString(++n, specialType.name());
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList = new ArrayList();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailMessageHandler.createFolder(resultSet));
            }
            dbMailFolderArray = arrayList.toArray(new DbMailFolder[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailFolderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Integer> getUnseenMessagesCount(Connection connection, long[] lArray) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = null;
            if (lArray != null) {
                string = "AND folder_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ";
            }
            preparedStatement = connection.prepareStatement("SELECT folder_id, count(message_id) AS message_count FROM view_immotool_mails_messages WHERE message_is_seen = ? " + (string != null ? string : "") + "GROUP BY " + FIELD_FOLDER_ID + " ORDER BY " + FIELD_FOLDER_ID + " ASC;");
            int n = 0;
            preparedStatement.setBoolean(++n, false);
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object2 = new LinkedHashMap();
            while (resultSet.next()) {
                object2.put(resultSet.getLong(FIELD_FOLDER_ID), resultSet.getInt("message_count"));
            }
            object = object2;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadAddresses(Connection connection, DbMailMessage[] dbMailMessageArray) throws SQLException {
        HashMap<Long, DbMailMessage> hashMap = new HashMap<Long, DbMailMessage>();
        for (DbMailMessage dbMailMessage : dbMailMessageArray) {
            if (dbMailMessage.id <= 0L || hashMap.containsKey(dbMailMessage.id)) continue;
            hashMap.put(dbMailMessage.id, dbMailMessage);
            if (dbMailMessage.addresses != null) {
                dbMailMessage.addresses.clear();
                continue;
            }
            dbMailMessage.addresses = new ArrayList<DbMailAddress>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_addresses WHERE message_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_MESSAGE_ID + " ASC, " + FIELD_ADDRESS_TYPE + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_MESSAGE_ID);
                if (!hashMap.containsKey(l)) continue;
                ((DbMailMessage)hashMap.get((Object)Long.valueOf((long)l))).addresses.add(HSqlDbMailMessageHandler.createAddress(resultSet));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadPartHeaders(Connection connection, DbMailPart[] dbMailPartArray) throws SQLException {
        HashMap<Long, DbMailPart> hashMap = new HashMap<Long, DbMailPart>();
        for (DbMailPart dbMailPart : dbMailPartArray) {
            if (dbMailPart.id <= 0L || hashMap.containsKey(dbMailPart.id)) continue;
            hashMap.put(dbMailPart.id, dbMailPart);
            if (dbMailPart.headers != null) {
                dbMailPart.headers.clear();
                continue;
            }
            dbMailPart.headers = new ArrayList<DbMailHeader>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_headers WHERE part_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_PART_ID + " ASC, " + FIELD_HEADER_KEY + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_PART_ID);
                if (!hashMap.containsKey(l)) continue;
                ((DbMailPart)hashMap.get((Object)Long.valueOf((long)l))).headers.add(HSqlDbMailMessageHandler.createHeader(resultSet));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeFolders(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_mails_folders(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeMessages(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_mails_messages(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeParts(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_mails_parts(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveFolder(Connection connection, DbMailFolder dbMailFolder) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_mails_folders(:folder_id, :account_id, :folder_parent_id, :folder_name, :folder_holds_messages, :folder_holds_folders, :folder_auto_retrieval, :folder_special_type);");
            namedCallableStatement.setLong(FIELD_FOLDER_ID, dbMailFolder.id);
            namedCallableStatement.setLong(FIELD_ACCOUNT_ID, dbMailFolder.accountId);
            namedCallableStatement.setString(FIELD_FOLDER_NAME, StringUtils.abbreviate((String)dbMailFolder.name, (int)255));
            namedCallableStatement.setBoolean(FIELD_FOLDER_HOLDS_MESSAGES, dbMailFolder.holdsMessages);
            namedCallableStatement.setBoolean(FIELD_FOLDER_HOLDS_FOLDERS, dbMailFolder.holdsFolders);
            namedCallableStatement.setBoolean(FIELD_FOLDER_AUTO_RETRIEVAL, dbMailFolder.isAutoRetrieval);
            if (dbMailFolder.parentFolderId > 0L) {
                namedCallableStatement.setLong(FIELD_FOLDER_PARENT_ID, dbMailFolder.parentFolderId);
            } else {
                namedCallableStatement.setNull(FIELD_FOLDER_PARENT_ID, -5);
            }
            if (dbMailFolder.specialType != null) {
                namedCallableStatement.setString(FIELD_FOLDER_SPECIAL_TYPE, dbMailFolder.specialType.name());
            } else {
                namedCallableStatement.setNull(FIELD_FOLDER_SPECIAL_TYPE, 12);
            }
            namedCallableStatement.execute();
            long l2 = l = dbMailFolder.id < 1L ? namedCallableStatement.getLong(FIELD_FOLDER_ID) : dbMailFolder.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbMailFolder.id < 1L) {
                dbMailFolder.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveMessage(Connection connection, DbMailMessage dbMailMessage) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block15: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_mails_messages(:message_id, :folder_id, :message_subject, :message_from, :message_to, :message_size, :message_uid, :message_uid_validity, :message_mime_id, :message_hash, :message_in_reply_to, :message_is_answered, :message_is_archived, :message_is_downloaded, :message_is_draft, :message_is_flagged, :message_is_forwarded, :message_is_seen, :message_is_received, :message_has_attachments, :message_mdn_status, :message_sent_at, :message_received_at);");
                namedCallableStatement.setLong(FIELD_MESSAGE_ID, dbMailMessage.id);
                namedCallableStatement.setLong(FIELD_FOLDER_ID, dbMailMessage.folderId);
                namedCallableStatement.setLong(FIELD_MESSAGE_SIZE, dbMailMessage.size);
                namedCallableStatement.setString(FIELD_MESSAGE_SUBJECT, dbMailMessage.subject != null ? StringUtils.abbreviate((String)dbMailMessage.subject, (int)255) : "");
                namedCallableStatement.setString(FIELD_MESSAGE_FROM, StringUtils.abbreviate((String)dbMailMessage.from, (int)255));
                namedCallableStatement.setString(FIELD_MESSAGE_TO, StringUtils.abbreviate((String)dbMailMessage.to, (int)255));
                namedCallableStatement.setString(FIELD_MESSAGE_MIME_ID, StringUtils.abbreviate((String)dbMailMessage.mimeId, (int)255));
                namedCallableStatement.setString(FIELD_MESSAGE_HASH, StringUtils.abbreviate((String)dbMailMessage.hash, (int)255));
                namedCallableStatement.setString(FIELD_MESSAGE_IN_REPLY_TO, StringUtils.abbreviate((String)dbMailMessage.inReplyTo, (int)255));
                namedCallableStatement.setString(FIELD_MESSAGE_MDN_STATUS, StringUtils.abbreviate((String)(dbMailMessage.mdnStatus != null ? dbMailMessage.mdnStatus.name() : null), (int)25));
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_ANSWERED, dbMailMessage.isAnswered);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_ARCHIVED, dbMailMessage.isArchived);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_DOWNLOADED, dbMailMessage.isDownloaded);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_DRAFT, dbMailMessage.isDraft);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_FLAGGED, dbMailMessage.isFlagged);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_FORWARDED, dbMailMessage.isForwarded);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_SEEN, dbMailMessage.isSeen);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_RECEIVED, dbMailMessage.isReceived);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_HAS_ATTACHMENTS, dbMailMessage.hasAttachments);
                namedCallableStatement.setTimestamp(FIELD_MESSAGE_SENT_AT, dbMailMessage.sentAt != null ? new Timestamp(dbMailMessage.sentAt.getTime()) : null);
                namedCallableStatement.setTimestamp(FIELD_MESSAGE_RECEIVED_AT, dbMailMessage.receivedAt != null ? new Timestamp(dbMailMessage.receivedAt.getTime()) : null);
                if (dbMailMessage.uid != null) {
                    namedCallableStatement.setLong(FIELD_MESSAGE_UID, dbMailMessage.uid.longValue());
                } else {
                    namedCallableStatement.setNull(FIELD_MESSAGE_UID, -5);
                }
                if (dbMailMessage.uidValidity != null) {
                    namedCallableStatement.setLong(FIELD_MESSAGE_UID_VALIDITY, dbMailMessage.uidValidity.longValue());
                } else {
                    namedCallableStatement.setNull(FIELD_MESSAGE_UID_VALIDITY, -5);
                }
                namedCallableStatement.execute();
                long l2 = l = dbMailMessage.id < 1L ? namedCallableStatement.getLong(FIELD_MESSAGE_ID) : dbMailMessage.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbMailMessage.addresses != null) {
                    Object object;
                    if (dbMailMessage.id > 0L) {
                        object = new NamedCallableStatement(connection, "CALL remove_immotool_mails_addresses(:message_id);");
                        object.setLong(FIELD_MESSAGE_ID, dbMailMessage.id);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                    object = new NamedCallableStatement(connection, "CALL save_immotool_mails_addresses(:message_id, :address_type, :address_value, :address_person);");
                    for (DbMailAddress dbMailAddress : dbMailMessage.addresses) {
                        object.clearParameters();
                        object.setLong(FIELD_MESSAGE_ID, l);
                        object.setString(FIELD_ADDRESS_TYPE, dbMailAddress.type != null ? StringUtils.abbreviate((String)dbMailAddress.type.name(), (int)8) : null);
                        object.setString(FIELD_ADDRESS_VALUE, StringUtils.abbreviate((String)dbMailAddress.value, (int)255));
                        object.setString(FIELD_ADDRESS_PERSON, StringUtils.abbreviate((String)dbMailAddress.person, (int)255));
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                }
                connection.commit();
                if (dbMailMessage.id >= 1L) break block15;
                dbMailMessage.id = l;
                if (dbMailMessage.addresses == null) break block15;
                for (DbMailAddress dbMailAddress : dbMailMessage.addresses) {
                    dbMailAddress.messageId = dbMailMessage.id;
                }
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    @Override
    public void savePart(Connection connection, DbMailPart dbMailPart, boolean bl) throws SQLException, IOException {
        boolean bl2 = connection.getAutoCommit();
        FileInputStream fileInputStream = null;
        NamedCallableStatement namedCallableStatement = null;
        ArrayList<CallableStatement> arrayList = new ArrayList<CallableStatement>();
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_mails_parts(:part_id, :message_id, :part_parent_id, :part_type, :part_description, :part_disposition, :part_text, :part_file_name, :part_file_size, :part_file_content);");
            namedCallableStatement.setLong(FIELD_PART_ID, dbMailPart.id);
            namedCallableStatement.setLong(FIELD_MESSAGE_ID, dbMailPart.messageId);
            if (dbMailPart.parentPartId > 0L) {
                namedCallableStatement.setLong(FIELD_PART_PARENT_ID, dbMailPart.parentPartId);
            } else {
                namedCallableStatement.setNull(FIELD_PART_PARENT_ID, -5);
            }
            namedCallableStatement.setString(FIELD_PART_TEXT, dbMailPart.text);
            namedCallableStatement.setString(FIELD_PART_TYPE, StringUtils.abbreviate((String)dbMailPart.type, (int)255));
            namedCallableStatement.setString(FIELD_PART_DESCRIPTION, StringUtils.abbreviate((String)dbMailPart.description, (int)255));
            namedCallableStatement.setString(FIELD_PART_DISPOSITION, StringUtils.abbreviate((String)dbMailPart.disposition, (int)255));
            namedCallableStatement.setString(FIELD_PART_FILE_NAME, StringUtils.abbreviate((String)dbMailPart.fileName, (int)255));
            if (dbMailPart.tempFileContent != null && dbMailPart.tempFileContent.isFile()) {
                fileInputStream = new FileInputStream(dbMailPart.tempFileContent);
                namedCallableStatement.setBinaryStream(FIELD_PART_FILE_CONTENT, (InputStream)fileInputStream, (int)dbMailPart.tempFileContent.length());
                namedCallableStatement.setLong(FIELD_PART_FILE_SIZE, dbMailPart.tempFileContent.length());
            } else {
                namedCallableStatement.setNull(FIELD_PART_FILE_CONTENT, 2004);
                namedCallableStatement.setLong(FIELD_PART_FILE_SIZE, dbMailPart.fileSize);
            }
            namedCallableStatement.execute();
            long l2 = l = dbMailPart.id < 1L ? namedCallableStatement.getLong(FIELD_PART_ID) : dbMailPart.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            if (dbMailPart.headers != null) {
                Object object;
                if (dbMailPart.id > 0L) {
                    object = new NamedCallableStatement(connection, "CALL remove_immotool_mails_headers(:part_id);");
                    object.setLong(FIELD_PART_ID, dbMailPart.id);
                    object.execute();
                    arrayList.add(object.getStatement());
                }
                object = new NamedCallableStatement(connection, "CALL save_immotool_mails_headers(:part_id, :header_key, :header_value);");
                for (DbMailHeader dbMailHeader : dbMailPart.headers) {
                    object.clearParameters();
                    object.setLong(FIELD_PART_ID, l);
                    object.setString(FIELD_HEADER_KEY, StringUtils.abbreviate((String)dbMailHeader.key, (int)255));
                    object.setString(FIELD_HEADER_VALUE, dbMailHeader.value);
                    object.execute();
                    arrayList.add(object.getStatement());
                }
            }
            connection.commit();
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (dbMailPart.id < 1L) {
                dbMailPart.id = l;
                if (dbMailPart.headers != null) {
                    for (DbMailHeader dbMailHeader : dbMailPart.headers) {
                        dbMailHeader.partId = dbMailPart.id;
                    }
                }
                if (dbMailPart.subParts != null) {
                    for (DbMailPart dbMailPart2 : dbMailPart.subParts) {
                        dbMailPart2.parentPartId = dbMailPart.id;
                    }
                }
            }
            if (bl && dbMailPart.subParts != null) {
                for (DbMailPart dbMailPart3 : dbMailPart.subParts) {
                    dbMailPart3.parentPartId = dbMailPart.id;
                    this.savePart(connection, dbMailPart3, true);
                }
            }
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            FileUtils.deleteQuietly((File)dbMailPart.tempFileContent);
            JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
            for (Statement statement : arrayList) {
                JdbcUtils.closeQuietly((Statement)statement);
            }
            connection.setAutoCommit(bl2);
        }
    }

    @Override
    public void setMessagesAnswered(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_mails_messages_answered(:message_id, :message_is_answered);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MESSAGE_ID, l);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_ANSWERED, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }

    @Override
    public void setMessagesArchived(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_mails_messages_archived(:message_id, :message_is_archived);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MESSAGE_ID, l);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_ARCHIVED, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }

    @Override
    public void setMessagesForwarded(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_mails_messages_forwarded(:message_id, :message_is_forwarded);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MESSAGE_ID, l);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_FORWARDED, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }

    @Override
    public void setMessagesMdn(Connection connection, long[] lArray, DbMailMessage.MdnStatus mdnStatus) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_mails_messages_mdn(:message_id, :message_mdn_status);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MESSAGE_ID, l);
                namedCallableStatement.setString(FIELD_MESSAGE_MDN_STATUS, StringUtils.abbreviate((String)(mdnStatus != null ? mdnStatus.name() : null), (int)25));
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void setMessagesSeen(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_mails_messages_seen(:message_id, :message_is_seen);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_MESSAGE_ID, l);
                namedCallableStatement.setBoolean(FIELD_MESSAGE_IS_SEEN, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }
}

