/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.io;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.EnumRenderer;
import com.openindex.openestate.tool.gui.PortNrField;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.MailAccountPropertiesTab;
import com.openindex.openestate.tool.mail.MailAccountSenderTab;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.io.AbstractMailWriter;
import com.openindex.openestate.tool.mail.io.SmtpWriter;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.SimpleEmail;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SmtpPanel
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(SmtpPanel.class);
    private SmtpWriter currentWriter = null;
    private ValidationHandler validationHandler;
    private JXTitledSeparator formTitle;
    private JLabel hostLabel;
    private JTextField hostField;
    private JLabel portLabel;
    private PortNrField portField;
    private JLabel authMethodLabel;
    private JComboBox<SmtpWriter.AuthMethod> authMethodField;
    private JLabel authUserLabel;
    private JTextField authUserField;
    private JLabel authPassLabel;
    private JPasswordField authPassField;
    private JLabel cryptMethodLabel;
    private JComboBox<SmtpWriter.CryptMethod> cryptMethodField;
    private JXTitledSeparator testTitle;
    private JLabel testMailLabel;
    private JTextField testMailField;
    private JXBusyLabel testBusyLabel;
    private TestAction testAction;

    public SmtpPanel(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.testTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new PortNrField();
        this.authUserLabel = new JLabel();
        this.authUserField = new JTextField();
        this.authPassLabel = new JLabel();
        this.authPassField = new JPasswordField();
        this.authMethodLabel = new JLabel();
        this.authMethodField = new JComboBox();
        this.authMethodField.setRenderer((ListCellRenderer<SmtpWriter.AuthMethod>)new DefaultListCellRenderer((Renderer)new EnumRenderer()));
        this.authMethodField.addItem(null);
        for (SmtpWriter.AuthMethod enum_ : SmtpWriter.AuthMethod.values()) {
            this.authMethodField.addItem(enum_);
        }
        this.authMethodField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SmtpPanel.this.authMethodField.isEnabled()) {
                    return;
                }
                SmtpPanel.this.updateAuthFields();
            }
        });
        this.cryptMethodLabel = new JLabel();
        this.cryptMethodField = new JComboBox();
        this.cryptMethodField.setRenderer((ListCellRenderer<SmtpWriter.CryptMethod>)new DefaultListCellRenderer((Renderer)new EnumRenderer()));
        this.cryptMethodField.addItem(null);
        for (Enum enum_ : SmtpWriter.CryptMethod.values()) {
            this.cryptMethodField.addItem((SmtpWriter.CryptMethod)enum_);
        }
        this.testAction = new TestAction();
        this.testMailLabel = new JLabel();
        this.testMailField = new JTextField();
        this.testMailField.setName("testMailField");
        this.testBusyLabel = new JXBusyLabel();
        this.testBusyLabel.setName("testBusyLabel");
        this.testBusyLabel.setVisible(false);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.validationHandler.putRule((JComponent)this.hostField, ValidationHandler.HOSTNAME);
        this.validationHandler.putRule((JComponent)this.portField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.authMethodField, ValidationHandler.NOT_NULL);
        this.validationHandler.putRule((JComponent)this.authUserField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.authPassField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.cryptMethodField, ValidationHandler.NOT_NULL);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.hostLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.hostField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.authMethodLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.authMethodField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.authUserLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.authUserField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.authPassLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.authPassField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.cryptMethodLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.cryptMethodField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.testTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.testAction))).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.testMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.testMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.testBusyLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        this.setBorder(Paddings.EMPTY);
        this.updateLocalization();
        this.load(null);
        this.loadDefaults();
    }

    private SmtpWriter createSmtpWriter() {
        SmtpWriter smtpWriter = new SmtpWriter();
        smtpWriter.setHost(this.hostField.getText().trim());
        smtpWriter.setPort(this.portField.getPortNr());
        smtpWriter.setAuthMethod((SmtpWriter.AuthMethod)((Object)this.authMethodField.getSelectedItem()));
        smtpWriter.setAuthUser(this.authUserField.getText().trim());
        smtpWriter.setAuthPass(this.authPassField.getPassword());
        smtpWriter.setCryptMethod((SmtpWriter.CryptMethod)((Object)this.cryptMethodField.getSelectedItem()));
        return smtpWriter;
    }

    private void doTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            String string = "<html><b>" + I18N.tr("Can't test connection to the mail server!") + "</b><br>" + I18N.tr("The provided settings are incorrect.") + "</html>";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Component)((Object)this.getDialog()));
            return;
        }
        if (!ImmoToolUtils.isValidMailAddress((String)this.testMailField.getText())) {
            String string = "<html><b>" + I18N.tr("Can't test connection to the mail server!") + "</b><br>" + I18N.tr("The provided recipient is invalid.") + "</html>";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Component)((Object)this.getDialog()));
            return;
        }
        this.testAction.setEnabled(false);
        this.testMailField.setEnabled(false);
        this.testBusyLabel.setBusy(true);
        this.testBusyLabel.setText(I18N.tr("Connecting to mail server."));
        this.testBusyLabel.setVisible(true);
        ImmoToolUtils.executeTask((ImmoToolTask)new TestTask());
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("delivery"));
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        this.authMethodField.setEnabled(false);
        this.currentWriter = dbMailAccount != null && AbstractMailWriter.Type.SMTP.equals((Object)dbMailAccount.getWriterType()) ? (SmtpWriter)dbMailAccount.buildWriter() : new SmtpWriter();
        this.hostField.setText(this.currentWriter.getHost());
        this.portField.setPortNr(this.currentWriter.getPort());
        this.authMethodField.setSelectedItem((Object)this.currentWriter.getAuthMethod());
        this.authUserField.setText(this.currentWriter.getAuthUser());
        this.authPassField.setText(this.currentWriter.getAuthPass() != null ? String.valueOf(this.currentWriter.getAuthPass()) : "");
        this.cryptMethodField.setSelectedItem((Object)this.currentWriter.getCryptMethod());
        this.authMethodField.setEnabled(this.isEnabled());
        this.updateAuthFields();
        this.validationHandler.init();
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.portField.setPortNr(25);
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            throw new NullPointerException("No account provided!");
        }
        dbMailAccount.setWriter(this.createSmtpWriter());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.hostField.setEnabled(bl);
        this.portField.setEnabled(bl);
        this.cryptMethodField.setEnabled(bl);
        this.testMailField.setEnabled(bl);
        this.testAction.setEnabled(bl);
        this.updateAuthFields(bl);
    }

    private void updateAuthFields() {
        this.updateAuthFields(this.isEnabled());
    }

    private void updateAuthFields(boolean bl) {
        SmtpWriter.AuthMethod authMethod = (SmtpWriter.AuthMethod)((Object)this.authMethodField.getSelectedItem());
        this.authMethodField.setEnabled(bl);
        this.authUserField.setEnabled(bl && authMethod != null && !SmtpWriter.AuthMethod.ANONYMOUS.equals((Object)authMethod));
        this.authPassField.setEnabled(bl && authMethod != null && !SmtpWriter.AuthMethod.ANONYMOUS.equals((Object)authMethod));
        this.validationHandler.validate((JComponent)this.authUserField);
        this.validationHandler.validate((JComponent)this.authPassField);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("mail delivery via SMTP")));
        this.hostLabel.setText(StringUtils.capitalize((String)I18N.tr("hostname")) + ":");
        this.hostField.setToolTipText(I18N.tr("Enter the hostname / IP-address of the mail server."));
        this.portLabel.setText(StringUtils.capitalize((String)I18N.tr("port nr")) + ":");
        this.portField.setToolTipText(I18N.tr("Enter the port-nr of the mail server."));
        this.authMethodLabel.setText(StringUtils.capitalize((String)I18N.tr("authentication")) + ":");
        this.authMethodField.setToolTipText(I18N.tr("Use this field to specify, how authentication is handled by the mail server."));
        this.authUserLabel.setText(StringUtils.capitalize((String)I18N.tr("username")) + ":");
        this.authUserField.setToolTipText(I18N.tr("Enter the username for authentication at the mail server."));
        this.authPassLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
        this.authPassField.setToolTipText(I18N.tr("Enter the password for authentication at the mail server."));
        this.cryptMethodLabel.setText(StringUtils.capitalize((String)I18N.tr("encryption")) + ":");
        this.cryptMethodField.setToolTipText(I18N.tr("Use this field to specify, how encryption is handled by the mail server."));
        this.testTitle.setTitle(StringUtils.capitalize((String)I18N.tr("test SMTP connection")));
        this.testMailLabel.setText(StringUtils.capitalize((String)I18N.tr("recipient")) + ":");
        this.testMailField.setToolTipText(I18N.tr("The test message is delivered to the provided e-mail address."));
    }

    private class TestTask
    extends ImmoToolTask<Boolean, Void> {
        private TestTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            MailAccountSenderTab mailAccountSenderTab;
            MailAccountDialogForm mailAccountDialogForm;
            MailAccountDialog.Node node;
            Object object;
            Object object2;
            MailAccountDialog mailAccountDialog = SmtpPanel.this.getDialog();
            this.setMessage("Create reader");
            SmtpWriter smtpWriter = SmtpPanel.this.createSmtpWriter();
            if (smtpWriter == null) {
                throw new NullPointerException("Can't create reader!");
            }
            String string = ImmoToolUtils.toIdnMailAddress((String)SmtpPanel.this.testMailField.getText().trim());
            if (StringUtils.isBlank((CharSequence)string)) {
                throw new Exception("Invalid recipient address!");
            }
            this.setMessage("Create session");
            Session session = null;
            if (mailAccountDialog == null) {
                LOGGER.warn("Can't find mail account dialog.");
            } else {
                object2 = mailAccountDialog.getCurrentAccountNode();
                object = (MailAccountPropertiesTab)((MailAccountDialog.Node)object2).getChildForm(MailAccountPropertiesTab.class);
                if (object == null) {
                    LOGGER.warn("Can't find mail account properties.");
                } else {
                    session = smtpWriter.createSession(object.getProperties());
                }
            }
            if (session == null) {
                LOGGER.warn("Create session without extended properties!");
                session = smtpWriter.createSession();
            }
            if (session == null) {
                throw new NullPointerException("Can't create session!");
            }
            object2 = null;
            object = null;
            if (mailAccountDialog != null) {
                node = mailAccountDialog.getCurrentAccountNode();
                MailAccountDialogForm mailAccountDialogForm2 = mailAccountDialogForm = node != null ? node.getForm() : null;
                if (mailAccountDialogForm != null && mailAccountDialogForm instanceof MailAccountSenderTab) {
                    mailAccountSenderTab = (MailAccountSenderTab)mailAccountDialogForm;
                    object = mailAccountSenderTab.getFromMail();
                    object2 = mailAccountSenderTab.getFromName();
                }
            }
            if (!ValidationHandler.EMAIL.isValid(object)) {
                object = SmtpPanel.this.authUserField.getText().trim();
            }
            if (!ValidationHandler.EMAIL.isValid(object)) {
                object = "noreply@openestate.org";
            }
            if (StringUtils.isBlank((CharSequence)object2)) {
                object2 = ImmoToolEnvironment.getApplicationTitle();
            }
            this.setMessage("Create mail");
            node = new SimpleEmail();
            node.setMailSession(session);
            node.setCharset(Charset.defaultCharset().name());
            node.setFrom(StringUtils.trimToEmpty((String)object), StringUtils.trimToEmpty((String)object2));
            node.setSubject("A test mail from " + ImmoToolEnvironment.getApplicationTitle());
            node.setMsg("If you can read this mail, your SMTP settings are corectly configured!");
            node.addTo(string);
            node.buildMimeMessage();
            mailAccountDialogForm = node.getMimeMessage();
            this.setMessage("Transport mail");
            mailAccountSenderTab = null;
            try {
                mailAccountSenderTab = smtpWriter.createTransport(session);
                mailAccountSenderTab.sendMessage((Message)mailAccountDialogForm, mailAccountDialogForm.getAllRecipients());
            }
            finally {
                MailPluginUtils.closeQuietly((Transport)mailAccountSenderTab);
            }
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            String string = null;
            if (throwable instanceof SendFailedException && throwable.getCause() != null) {
                Throwable throwable2 = throwable.getCause();
                string = UnknownHostException.class.isInstance(throwable2) ? I18N.tr("No mail server found at the provided address!") + "<br>" + StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage()) : (ConnectException.class.isInstance(throwable2) ? I18N.tr("Can't establish a connection to the mail server!") + "<br>" + StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage()) : (AuthenticationFailedException.class.isInstance(throwable2) ? I18N.tr("Can't login to the mail server!") + "<br>" + StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage()) : StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage())));
            }
            if (StringUtils.isBlank(string)) {
                string = StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage());
            }
            SmtpPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test failed!") + "</b><br>" + string + "</html>");
        }

        protected void finished() {
            super.finished();
            SmtpPanel.this.testAction.setEnabled(true);
            SmtpPanel.this.testMailField.setEnabled(true);
            SmtpPanel.this.testBusyLabel.setBusy(false);
        }

        protected void setMessage(String string) {
            super.setMessage(string);
            SmtpPanel.this.testBusyLabel.setText(string);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            SmtpPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The message was delivered successfully.") + "</b><br>" + I18N.tr("to") + ": " + StringEscapeUtils.escapeXml11((String)SmtpPanel.this.testMailField.getText().trim()) + "</html>");
        }
    }

    private class TestAction
    extends AbstractI18nAction {
        private TestAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SmtpPanel.this.doTest();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test")));
            this.setShortDescription(I18N.tr("Establish a test connection to check the server settings."));
        }
    }
}

