/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultTree;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailFolderDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailFolderDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(MailFolderDialog.class);
    private String dialogTitle = null;
    private String dialogInfo = null;
    private boolean submitted = false;
    private DefaultTree folderTree;
    private CancelAction cancelAction;
    private SubmitAction submitAction;

    private MailFolderDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private MailFolderDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void addAccount(DbMailAccount dbMailAccount, DbMailFolder dbMailFolder) {
        Node node = (Node)this.folderTree.getModel().getRoot();
        Node node2 = new Node(dbMailAccount);
        TreeSet<DbMailFolder> treeSet = new TreeSet<DbMailFolder>();
        treeSet.addAll(dbMailFolder.subFolders);
        for (DbMailFolder dbMailFolder2 : treeSet) {
            Node node3 = new Node(dbMailAccount, dbMailFolder2);
            node3.load();
            node2.add(node3);
        }
        if (node2.getChildCount() > 0) {
            node.add(node2);
        }
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.cancelAction = new CancelAction();
        this.submitAction = new SubmitAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.cancelAction});
    }

    protected JComponent buildMainComponent() {
        this.folderTree = new DefaultTree();
        this.folderTree.setName("folderTree");
        this.folderTree.setCellRenderer((TreeCellRenderer)((Object)new NodeRenderer()));
        this.folderTree.setModel((TreeModel)new DefaultTreeModel(new Node(null, null)));
        this.folderTree.setRootVisible(false);
        this.folderTree.setToggleClickCount(1);
        this.folderTree.getSelectionModel().setSelectionMode(1);
        this.folderTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!MailFolderDialog.this.folderTree.isEnabled()) {
                    return;
                }
                TreePath treePath = MailFolderDialog.this.folderTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Node node = (Node)treePath.getLastPathComponent();
                MailFolderDialog.this.submitAction.setEnabled(node.getFolder() != null);
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.folderTree);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        return jScrollPane;
    }

    private void doSubmit() {
        this.submitted = true;
        this.setVisible(false);
    }

    private void expandDefault() {
        Node node = (Node)this.folderTree.getModel().getRoot();
        this.folderTree.collapseAll();
        this.folderTree.expandPath(new TreePath(node));
    }

    protected String getDialogTitle() {
        if (!StringUtils.isBlank((CharSequence)this.dialogTitle)) {
            return this.dialogTitle.trim();
        }
        return StringUtils.capitalize((String)I18N.tr("select mail folder"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"configure.png", (int)32);
    }

    protected String getHeaderInfo() {
        if (!StringUtils.isBlank((CharSequence)this.dialogInfo)) {
            return this.dialogInfo.trim();
        }
        return I18N.tr("Please select an e-mail folder.");
    }

    protected String getHeaderTitle() {
        if (!StringUtils.isBlank((CharSequence)this.dialogTitle)) {
            return this.dialogTitle.trim();
        }
        return StringUtils.capitalize((String)I18N.tr("select mail folder"));
    }

    private DbMailFolder getSelectedFolder() {
        TreePath treePath = this.folderTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Node node = (Node)treePath.getLastPathComponent();
        return node != null ? node.getFolder() : null;
    }

    private List<Object> getSelectionPath(Node node, long l) {
        DbMailFolder dbMailFolder;
        DbMailFolder dbMailFolder2 = dbMailFolder = node != null ? node.getFolder() : null;
        if (dbMailFolder != null && dbMailFolder.id == l) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(node);
            return arrayList;
        }
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                List<Object> list = this.getSelectionPath((Node)node.getChildAt(i), l);
                if (list == null || list.isEmpty()) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(node);
                arrayList.addAll(list);
                return arrayList;
            }
        }
        return null;
    }

    private void init(MailHandler mailHandler) {
        Node node = new Node(null, null);
        this.folderTree.setModel((TreeModel)new DefaultTreeModel(node));
        for (DbMailAccount dbMailAccount : mailHandler.getRemoteAccounts()) {
            AbstractMailReader.Type type = dbMailAccount.getReaderType();
            if (!AbstractMailReader.Type.IMAP.equals((Object)type)) continue;
            this.addAccount(dbMailAccount, mailHandler.getRootFolder(dbMailAccount.id));
        }
        DbMailAccount dbMailAccount = mailHandler.getLocalPrivateAccount();
        this.addAccount(dbMailAccount, mailHandler.getRootFolder(dbMailAccount.id));
        for (DbMailAccount dbMailAccount2 : mailHandler.getLocalSharedAccounts()) {
            this.addAccount(dbMailAccount2, mailHandler.getRootFolder(dbMailAccount2.id));
        }
        this.folderTree.revalidate();
        this.folderTree.repaint();
        this.expandDefault();
    }

    private void setDialogInfo(String string) {
        this.dialogInfo = string;
    }

    private void setDialogTitle(String string) {
        this.dialogTitle = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedFolder(long l) {
        Node node = (Node)this.folderTree.getModel().getRoot();
        this.folderTree.setEnabled(false);
        try {
            this.folderTree.clearSelection();
            if (l < 1L) {
                this.expandDefault();
                return;
            }
            List<Object> list = this.getSelectionPath(node, l);
            if (list == null || list.isEmpty()) {
                this.expandDefault();
                return;
            }
            TreePath treePath = new TreePath(list.toArray(new Object[0]));
            this.folderTree.expandPath(treePath);
            this.folderTree.addSelectionPath(treePath);
        }
        finally {
            this.folderTree.setEnabled(true);
        }
    }

    public static DbMailFolder showDialog(MailHandler mailHandler, Window window) {
        return MailFolderDialog.showDialog(0L, null, null, mailHandler, window);
    }

    public static DbMailFolder showDialog(long l, MailHandler mailHandler, Window window) {
        return MailFolderDialog.showDialog(l, null, null, mailHandler, window);
    }

    public static DbMailFolder showDialog(String string, String string2, MailHandler mailHandler, Window window) {
        return MailFolderDialog.showDialog(0L, string, string2, mailHandler, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbMailFolder showDialog(long l, String string, String string2, MailHandler mailHandler, Window window) {
        DbMailFolder dbMailFolder;
        MailFolderDialog mailFolderDialog = null;
        try {
            mailFolderDialog = window instanceof Dialog ? new MailFolderDialog((Dialog)window) : (window instanceof Frame ? new MailFolderDialog((Frame)window) : new MailFolderDialog((Frame)null));
            mailFolderDialog.init(mailHandler);
            mailFolderDialog.setSelectedFolder(l);
            if (!StringUtils.isBlank((CharSequence)string) || !StringUtils.isBlank((CharSequence)string2)) {
                mailFolderDialog.setDialogInfo(string2);
                mailFolderDialog.setDialogTitle(string);
                mailFolderDialog.updateLocalization();
                mailFolderDialog.pack();
            }
            mailFolderDialog.setVisible(true);
            dbMailFolder = mailFolderDialog.submitted ? mailFolderDialog.getSelectedFolder() : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(mailFolderDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)mailFolderDialog));
        return dbMailFolder;
    }

    private static class NodeRenderer
    extends DefaultXTreeCellRenderer {
        private NodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof Node) {
                Node node = (Node)object;
                jLabel.setText("<html>" + node.getNodeText() + "</html>");
                Icon icon = node.getNodeIcon();
                if (icon != null) {
                    jLabel.setIcon(icon);
                }
            }
            return jLabel;
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        private final DbMailAccount account;
        private final DbMailFolder folder;

        private Node(DbMailAccount dbMailAccount) {
            this.account = dbMailAccount;
            this.folder = null;
        }

        private Node(DbMailAccount dbMailAccount, DbMailFolder dbMailFolder) {
            this.account = dbMailAccount;
            this.folder = dbMailFolder;
        }

        public DbMailAccount getAccount() {
            return this.account;
        }

        public DbMailFolder getFolder() {
            return this.folder;
        }

        public Icon getNodeIcon() {
            if (this.folder != null) {
                return this.folder.specialType != null ? this.folder.specialType.getSmallIcon() : MailPlugin.getResourceIcon("folder.png", 16);
            }
            if (this.account != null) {
                return this.account.type != null ? this.account.type.getSmallIcon() : null;
            }
            return null;
        }

        public String getNodeText() {
            if (this.folder != null) {
                return this.folder.specialType != null ? this.folder.specialType.getTranslation() : this.folder.name;
            }
            if (this.account != null) {
                return "<html><b>" + StringEscapeUtils.escapeXml11((String)this.account.writeName()) + "</b></html>";
            }
            return "???";
        }

        public void load() {
            if (this.folder == null) {
                return;
            }
            if (!this.folder.subFolders.isEmpty()) {
                TreeSet<DbMailFolder> treeSet = new TreeSet<DbMailFolder>();
                treeSet.addAll(this.folder.subFolders);
                for (DbMailFolder dbMailFolder : treeSet) {
                    Node node = new Node(this.account, dbMailFolder);
                    node.load();
                    this.add(node);
                }
            }
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        public SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailFolderDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        public CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailFolderDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }
}

