/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.utils.MailFolderDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailFolderDialogButton
extends JButton {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailFolderDialogButton.class);
    private static final I18n I18N = I18nFactory.getI18n(MailFolderDialogButton.class);
    private final Window parentWindow;
    private DbMailFolder selectedFolder;
    private DbMailAccount selectedAccount;
    private String dialogTitle = null;
    private String dialogInfo = null;

    public MailFolderDialogButton(Frame frame) {
        this.parentWindow = frame;
        this.build();
    }

    public MailFolderDialogButton(Dialog dialog) {
        this.parentWindow = dialog;
        this.build();
    }

    private void build() {
        this.selectedFolder = null;
        this.updateText();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MailFolderDialogButton.this.showDialog();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load mail-folder dialog!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog((String)"Can't load mail-folder dialog!", (Throwable)exception, (Window)MailFolderDialogButton.this.parentWindow);
                }
            }
        });
    }

    public DbMailAccount getSelectedAccount() {
        return this.selectedAccount;
    }

    public DbMailFolder getSelectedFolder() {
        return this.selectedFolder;
    }

    public void setDialogInfo(String string) {
        this.dialogInfo = string;
    }

    public void setDialogTitle(String string) {
        this.dialogTitle = string;
    }

    public void setSelectedFolder(DbMailFolder dbMailFolder) {
        this.selectedFolder = dbMailFolder;
        this.selectedAccount = this.selectedFolder == null || this.selectedFolder.accountId < 1L ? null : MailPlugin.getMailHandler().getAccount(this.selectedFolder.accountId);
        this.updateText();
    }

    public void showDialog() throws SQLException {
        Object object = this.parentWindow != null ? this.parentWindow : ImmoToolEnvironment.getFrame();
        DbMailFolder dbMailFolder = MailFolderDialog.showDialog(this.selectedFolder != null ? this.selectedFolder.id : 0L, this.dialogTitle, this.dialogInfo, MailPlugin.getMailHandler(), (Window)object);
        if (dbMailFolder == null) {
            return;
        }
        this.setSelectedFolder(dbMailFolder);
    }

    public void updateText() {
        if (this.selectedFolder == null) {
            this.setText("<html><i>keine Auswahl</i></html>");
            return;
        }
        String string = this.selectedFolder.name;
        if (this.selectedAccount != null) {
            string = string + " (" + this.selectedAccount.writeName() + ")";
        }
        this.setText(string);
    }
}

