/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAccountLocalTab
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountLocalTab.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountLocalTab.class);
    private ValidationHandler validationHandler;
    private JXTitledSeparator formTitle;
    private JLabel nameLabel;
    private JTextField nameField;
    private JCheckBox enabledField;

    public MailAccountLocalTab(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.enabledField = new JCheckBox();
        this.validationHandler.putRule((JComponent)this.nameField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.opaque(true);
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.nameLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.nameField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.enabledField).xy(3, defaultFormBuilder.nextRow());
        this.updateLocalization();
        this.load(null);
        this.loadDefaults();
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("local mail account"));
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        this.nameField.setText(dbMailAccount != null ? StringUtils.trimToEmpty((String)dbMailAccount.name) : "");
        this.enabledField.setSelected(dbMailAccount != null ? dbMailAccount.enabled : true);
        this.validationHandler.init();
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            throw new NullPointerException("No account provided!");
        }
        dbMailAccount.name = this.nameField.getText().trim();
        dbMailAccount.enabled = this.enabledField.isSelected();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.nameField.setEnabled(bl);
        this.enabledField.setEnabled(bl);
        this.validationHandler.init();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("mail account")));
        this.nameLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        this.nameField.setToolTipText(I18N.tr("Enter a name for the mail account, that you can easily remember afterwards."));
        this.enabledField.setText(I18N.tr("Enable mail account."));
        this.enabledField.setToolTipText(I18N.tr("Disabled mail accounts are not used within the application."));
    }
}

