/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.extensions.MailTableExtension;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailTable.class);
    private static final I18n I18N = I18nFactory.getI18n(MailTable.class);
    private List<MailTableExtension> addons;
    private Icon statusArchivedIcon;
    private Icon statusAttachmentIcon;
    private Icon statusDraftIcon;
    private Icon statusUnseenIcon;

    public MailTable(String string) {
        super(string);
    }

    public MailTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public MailTableExtension[] getAddons() {
        return this.addons.toArray(new MailTableExtension[0]);
    }

    public DbMailMessage getMessageAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getMessage() : null;
    }

    public Long getMessageIdAt(int n) {
        DbMailMessage dbMailMessage = this.getMessageAt(n);
        return dbMailMessage != null ? dbMailMessage.id : 0L;
    }

    public int getRowForMessageId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getMessageIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    public Long getSizeAt(int n) {
        DbMailMessage dbMailMessage = this.getMessageAt(n);
        return dbMailMessage != null ? dbMailMessage.size : 0L;
    }

    public String getSubjectAt(int n) {
        DbMailMessage dbMailMessage = this.getMessageAt(n);
        return dbMailMessage != null ? dbMailMessage.subject : null;
    }

    public boolean hasAttachmentsAt(int n) {
        DbMailMessage dbMailMessage = this.getMessageAt(n);
        return dbMailMessage != null && dbMailMessage.hasAttachments;
    }

    protected void init() {
        MailTableExtension mailTableExtension2;
        this.setSortable(true);
        this.setColumnControlVisible(true);
        this.setMultipleIntervalSelection();
        super.init();
        this.setAutoCreateColumnsFromModel(false);
        this.setSortOrder(Column.DATE.getColumnId(), SortOrder.DESCENDING);
        this.addons = new ArrayList<MailTableExtension>();
        try {
            for (MailTableExtension mailTableExtension2 : MailPluginUtils.getMailTableExtensions()) {
                this.addons.add(mailTableExtension2);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load table extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.statusArchivedIcon = ImmoToolEnvironment.getResourceIcon((String)"db.png", (int)16);
        this.statusAttachmentIcon = MailPlugin.getResourceIcon("attachment.png", 16);
        this.statusDraftIcon = MailPlugin.getResourceIcon("draft.png", 16);
        this.statusUnseenIcon = MailPlugin.getResourceIcon("mail_is_unseen.png", 16);
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        mailTableExtension2 = this.getColumn(Column.STATUS_NEW);
        if (mailTableExtension2 != null) {
            mailTableExtension2.setCellRenderer((TableCellRenderer)((Object)new StatusRenderer(this.statusUnseenIcon)));
            mailTableExtension2.setHeaderRenderer(new HeaderIconRenderer(this.statusUnseenIcon, tableCellRenderer));
            mailTableExtension2.setMaxWidth(25);
            mailTableExtension2.setMinWidth(25);
        }
        if ((mailTableExtension2 = this.getColumn(Column.STATUS_DRAFT)) != null) {
            mailTableExtension2.setCellRenderer((TableCellRenderer)((Object)new StatusRenderer(this.statusDraftIcon)));
            mailTableExtension2.setHeaderRenderer(new HeaderIconRenderer(this.statusDraftIcon, tableCellRenderer));
            mailTableExtension2.setMaxWidth(25);
            mailTableExtension2.setMinWidth(25);
        }
        if ((mailTableExtension2 = this.getColumn(Column.STATUS_ARCHIVED)) != null) {
            mailTableExtension2.setCellRenderer((TableCellRenderer)((Object)new StatusRenderer(this.statusArchivedIcon)));
            mailTableExtension2.setHeaderRenderer(new HeaderIconRenderer(this.statusArchivedIcon, tableCellRenderer));
            mailTableExtension2.setMaxWidth(25);
            mailTableExtension2.setMinWidth(25);
        }
        if ((mailTableExtension2 = this.getColumn(Column.STATUS_ATTACHMENT)) != null) {
            mailTableExtension2.setCellRenderer((TableCellRenderer)((Object)new StatusRenderer(this.statusAttachmentIcon)));
            mailTableExtension2.setHeaderRenderer(new HeaderIconRenderer(this.statusAttachmentIcon, tableCellRenderer));
            mailTableExtension2.setMaxWidth(25);
            mailTableExtension2.setMinWidth(25);
        }
    }

    public boolean isArchivedAt(int n) {
        DbMailMessage dbMailMessage = this.getMessageAt(n);
        return dbMailMessage != null && dbMailMessage.isArchived;
    }

    public boolean isDraftAt(int n) {
        DbMailMessage dbMailMessage = this.getMessageAt(n);
        return dbMailMessage != null && dbMailMessage.isDraft;
    }

    public boolean isUnreadAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null && row.isUnread();
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public void setUnreadAt(int n, boolean bl) {
        Row row = (Row)this.getRow(n);
        if (row != null) {
            row.setUnread(bl);
        }
    }

    private static class SubjectRenderer
    extends StringRenderer {
        private final Icon statusForwardedIcon = MailPlugin.getResourceIcon("mail_is_forwarded.png", 16);
        private final Icon statusRepliedIcon = MailPlugin.getResourceIcon("mail_is_replied.png", 16);
        private final Icon statusRepliedAndForwardedIcon = MailPlugin.getResourceIcon("mail_is_replied_and_forwarded.png", 16);
        private final Icon emptyIcon = new ImageIcon(new BufferedImage(16, 16, 2));

        private SubjectRenderer() {
        }

        @Override
        public Component getRenderedComponent(JTable jTable, String string, boolean bl, boolean bl2, int n, int n2) {
            DbMailMessage dbMailMessage = ((MailTable)((Object)jTable)).getMessageAt(jTable.convertRowIndexToModel(n));
            if (dbMailMessage == null) {
                this.setIcon(null);
            } else if (dbMailMessage.isForwarded && dbMailMessage.isAnswered) {
                this.setIcon(this.statusRepliedAndForwardedIcon);
            } else if (dbMailMessage.isForwarded) {
                this.setIcon(this.statusForwardedIcon);
            } else if (dbMailMessage.isAnswered) {
                this.setIcon(this.statusRepliedIcon);
            } else {
                this.setIcon(this.emptyIcon);
            }
            return super.getRenderedComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    private static class StringRenderer
    extends AbstractCellRenderer<String> {
        private StringRenderer() {
        }

        protected void initValue(String string) {
            this.setText(string != null ? string : "");
        }
    }

    private static class StatusRenderer
    extends AbstractCellRenderer<Boolean> {
        private final Icon icon;

        private StatusRenderer(Icon icon) {
            this.icon = icon;
            this.setHorizontalAlignment(0);
        }

        protected void initValue(Boolean bl) {
            this.setText("");
            this.setIcon(Boolean.TRUE.equals(bl) ? this.icon : null);
        }
    }

    private static class SizeRenderer
    extends AbstractCellRenderer<Long> {
        private SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        protected void initValue(Long l) {
            this.setText(l != null ? ImmoToolUtils.getHumanReadableByteCount((long)l) : "");
        }
    }

    private static class LongRenderer
    extends AbstractCellRenderer<Long> {
        private final NumberFormat numberFormat = NumberFormat.getIntegerInstance();

        private LongRenderer() {
        }

        protected void initValue(Long l) {
            this.setText(l != null ? this.numberFormat.format(l) : "");
        }
    }

    private static class HeaderIconRenderer
    implements TableCellRenderer {
        private final Icon icon;
        private final TableCellRenderer defaultHeaderRenderer;

        private HeaderIconRenderer(Icon icon, TableCellRenderer tableCellRenderer) {
            this.icon = icon;
            this.defaultHeaderRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.defaultHeaderRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(this.icon);
                jLabel.setText("");
            }
            return component;
        }
    }

    private static class DateRenderer
    extends AbstractCellRenderer<Date> {
        private final DateFormat shortDateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
        private final DateFormat shortTimeFormat = DateFormat.getTimeInstance(3);
        private final Calendar cal = Calendar.getInstance();

        private DateRenderer() {
        }

        protected void initValue(Date date) {
            if (date == null) {
                this.setText("");
                return;
            }
            this.cal.setTimeInMillis(System.currentTimeMillis());
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            Calendar calendar = (Calendar)this.cal.clone();
            calendar.add(14, -1);
            DateFormat dateFormat = this.shortDateTimeFormat;
            if (date.after(calendar.getTime())) {
                Calendar calendar2 = (Calendar)this.cal.clone();
                calendar2.add(6, 1);
                if (date.before(calendar2.getTime())) {
                    dateFormat = this.shortTimeFormat;
                }
            }
            this.setText(dateFormat.format(date));
        }
    }

    private static abstract class AbstractCellRenderer<T>
    extends DefaultTableCellRenderer<T> {
        private AbstractCellRenderer() {
        }

        public Component getRenderedComponent(JTable jTable, T t, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getRenderedComponent(jTable, t, bl, bl2, n, n2);
            int n3 = jTable.convertRowIndexToModel(n);
            if (((MailTable)((Object)jTable)).isUnreadAt(n3)) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            } else {
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }
            return jLabel;
        }
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbMailMessage message;
        private boolean unread;

        public Row(DbMailMessage dbMailMessage) {
            this.message = dbMailMessage;
            this.unread = !this.message.isSeen;
        }

        public DbMailMessage getMessage() {
            return this.message;
        }

        public String getToolTipText(AbstractTable.Column column) {
            if (this.message == null) {
                return null;
            }
            String string = StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)StringEscapeUtils.unescapeHtml4((String)this.message.subject)), (int)100);
            Date date = this.message.isReceived && this.message.receivedAt != null ? this.message.receivedAt : this.message.sentAt;
            String string2 = "<b>" + StringEscapeUtils.escapeXml11((String)string) + "</b>";
            string2 = string2 + "<br>" + DateFormat.getDateTimeInstance(1, 2).format(date);
            string2 = string2 + "<hr>\u2022 " + I18N.tr("The message has a size of {0}.", (Object)ImmoToolUtils.getHumanReadableByteCount((long)this.message.size));
            if (this.isUnread()) {
                string2 = string2 + "<br>\u2022 " + I18N.tr("The message is unseen.");
            }
            if (this.message.isArchived) {
                string2 = string2 + "<br>\u2022 " + I18N.tr("The message is archived.");
            }
            if (this.message.isDraft) {
                string2 = string2 + "<br>\u2022 " + I18N.tr("The message is marked as draft.");
            }
            if (this.message.hasAttachments) {
                string2 = string2 + "<br>\u2022 " + I18N.tr("The message contains attachments.");
            }
            return "<html><div style=\"padding:3px;\">" + string2 + "</div></html>";
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForMail((Column)column);
            }
            return null;
        }

        public Object getValueForMail(Column column) {
            if (this.message == null) {
                return null;
            }
            switch (column) {
                case ID: {
                    return this.message.id;
                }
                case STATUS_NEW: {
                    return this.unread;
                }
                case STATUS_DRAFT: {
                    return this.message.isDraft;
                }
                case STATUS_ARCHIVED: {
                    return this.message.isArchived;
                }
                case STATUS_ATTACHMENT: {
                    return this.message.hasAttachments;
                }
                case SUBJECT: {
                    return StringUtils.trimToEmpty((String)this.message.subject);
                }
                case DATE: {
                    return this.message.isReceived && this.message.receivedAt != null ? this.message.receivedAt : this.message.sentAt;
                }
                case SIZE: {
                    return this.message.size;
                }
                case FROM: {
                    String string = null;
                    try {
                        InternetAddress[] internetAddressArray;
                        InternetAddress[] internetAddressArray2 = internetAddressArray = StringUtils.isNotBlank((CharSequence)this.message.from) ? InternetAddress.parse((String)this.message.from) : null;
                        if (internetAddressArray != null && internetAddressArray.length > 0 && (string = StringUtils.trimToNull((String)internetAddressArray[0].getPersonal())) != null) {
                            string = StringUtils.trimToNull((String)internetAddressArray[0].getAddress());
                        }
                    }
                    catch (AddressException addressException) {
                        LOGGER.warn("Can't read FROM address of message #" + this.message.id + "!");
                        LOGGER.warn("> " + this.message.from);
                        LOGGER.warn("> " + addressException.getLocalizedMessage(), (Throwable)addressException);
                    }
                    return StringUtils.defaultIfBlank(string, (CharSequence)this.message.from);
                }
                case RECIPIENT: {
                    String string = null;
                    try {
                        InternetAddress[] internetAddressArray;
                        InternetAddress[] internetAddressArray3 = internetAddressArray = StringUtils.isNotBlank((CharSequence)this.message.to) ? InternetAddress.parse((String)this.message.to) : null;
                        if (internetAddressArray != null && internetAddressArray.length > 0 && (string = StringUtils.trimToNull((String)internetAddressArray[0].getPersonal())) != null) {
                            string = StringUtils.trimToNull((String)internetAddressArray[0].getAddress());
                        }
                    }
                    catch (AddressException addressException) {
                        LOGGER.warn("Can't read TO address of message #" + this.message.id + "!");
                        LOGGER.warn("> " + this.message.to);
                        LOGGER.warn("> " + addressException.getLocalizedMessage(), (Throwable)addressException);
                    }
                    return StringUtils.defaultIfBlank(string, (CharSequence)this.message.to);
                }
            }
            return null;
        }

        public boolean isUnread() {
            return this.unread;
        }

        public void setUnread(boolean bl) {
            this.unread = bl;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        STATUS_NEW,
        STATUS_ARCHIVED,
        STATUS_DRAFT,
        STATUS_ATTACHMENT,
        SUBJECT,
        FROM,
        RECIPIENT,
        DATE,
        SIZE;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case ID: {
                    return new LongRenderer();
                }
                case SUBJECT: {
                    return new SubjectRenderer();
                }
                case FROM: 
                case RECIPIENT: {
                    return new StringRenderer();
                }
                case DATE: {
                    return new DateRenderer();
                }
                case SIZE: {
                    return new SizeRenderer();
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case STATUS_NEW: 
                case STATUS_DRAFT: 
                case STATUS_ATTACHMENT: 
                case STATUS_ARCHIVED: {
                    return Boolean.class;
                }
                case SUBJECT: 
                case FROM: 
                case RECIPIENT: {
                    return String.class;
                }
                case DATE: {
                    return Date.class;
                }
                case SIZE: {
                    return Long.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return StringUtils.capitalize((String)I18N.tr("ID"));
                }
                case STATUS_NEW: {
                    return I18N.tr("unread");
                }
                case STATUS_DRAFT: {
                    return I18N.tr("marked as draft");
                }
                case STATUS_ATTACHMENT: {
                    return I18N.tr("has attachments");
                }
                case STATUS_ARCHIVED: {
                    return I18N.tr("archived");
                }
                case SUBJECT: {
                    return StringUtils.capitalize((String)I18N.tr("subject"));
                }
                case FROM: {
                    return StringUtils.capitalize((String)I18N.tr("sender"));
                }
                case RECIPIENT: {
                    return StringUtils.capitalize((String)I18N.tr("recipient"));
                }
                case DATE: {
                    return StringUtils.capitalize((String)I18N.tr("date"));
                }
                case SIZE: {
                    return StringUtils.capitalize((String)I18N.tr("size"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: 
                case STATUS_NEW: {
                    return false;
                }
            }
            return true;
        }
    }
}

