/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db;

import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class DbMailMessageHandlerImpl
implements DbMailMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMailMessageHandlerImpl.class);
    private static final I18n I18N = I18nFactory.getI18n(DbMailMessageHandlerImpl.class);

    @Override
    public abstract boolean downloadPart(Connection var1, long var2, OutputStream var4) throws SQLException, IOException;

    @Override
    public final DbMailMessage[] getArchivedMessages(Connection connection, long l) throws SQLException {
        long[] lArray;
        if (l > 0L) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = l;
        } else {
            lArray = null;
        }
        return this.getArchivedMessages(connection, lArray);
    }

    @Override
    public abstract DbMailMessage[] getArchivedMessages(Connection var1, long[] var2) throws SQLException;

    @Override
    public final DbMailFolder getFolder(Connection connection, long l) throws SQLException {
        DbMailFolder[] dbMailFolderArray = this.getFolders(connection, new long[]{l});
        return dbMailFolderArray != null && dbMailFolderArray.length > 0 ? dbMailFolderArray[0] : null;
    }

    @Override
    public final DbMailFolder[] getFolders(Connection connection) throws SQLException {
        return this.getFolders(connection, null);
    }

    @Override
    public abstract DbMailFolder[] getFolders(Connection var1, long[] var2) throws SQLException;

    @Override
    public final DbMailFolder[] getFoldersForAutoRetrieval(Connection connection, long l) throws SQLException {
        long[] lArray;
        if (l > 0L) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = l;
        } else {
            lArray = null;
        }
        return this.getFoldersForAutoRetrieval(connection, lArray);
    }

    @Override
    public abstract DbMailFolder[] getFoldersForAutoRetrieval(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbMailFolder[] getFolderChildren(Connection var1, long var2) throws SQLException;

    @Override
    public abstract DbMailFolder getFolderOnRoot(Connection var1, long var2) throws SQLException;

    @Override
    public final DbMailMessage getMessage(Connection connection, long l) throws SQLException {
        DbMailMessage[] dbMailMessageArray = this.getMessages(connection, new long[]{l});
        return dbMailMessageArray != null && dbMailMessageArray.length > 0 ? dbMailMessageArray[0] : null;
    }

    @Override
    public abstract DbMailMessage getMessageFromFolder(Connection var1, long var2, String var4, String var5) throws SQLException;

    @Override
    public abstract DbMailMessage getMessageFromFolder(Connection var1, long var2, long var4, long var6) throws SQLException;

    @Override
    public abstract long[] getMessageIdsFromFolder(Connection var1, long var2) throws SQLException;

    @Override
    public abstract DbMailMessage[] getMessages(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbMailMessage[] getMessagesFromFolder(Connection var1, long var2) throws SQLException;

    @Override
    public final DbMailPart getPart(Connection connection, long l) throws SQLException {
        DbMailPart[] dbMailPartArray = this.getParts(connection, new long[]{l});
        return dbMailPartArray != null && dbMailPartArray.length > 0 ? dbMailPartArray[0] : null;
    }

    @Override
    public abstract DbMailPart[] getParts(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbMailPart[] getPartChildren(Connection var1, long var2) throws SQLException;

    @Override
    public abstract DbMailPart getPartOnRoot(Connection var1, long var2) throws SQLException;

    @Override
    public final DbMailFolder getSpecialFolder(Connection connection, long l, DbMailFolder.SpecialType specialType) throws SQLException {
        if (l < 1L || specialType == null) {
            return null;
        }
        DbMailFolder[] dbMailFolderArray = this.getSpecialFolders(connection, l, new DbMailFolder.SpecialType[]{specialType});
        return dbMailFolderArray != null && dbMailFolderArray.length > 0 ? dbMailFolderArray[0] : null;
    }

    @Override
    public final DbMailFolder[] getSpecialFolders(Connection connection, long l) throws SQLException {
        return l > 0L ? this.getSpecialFolders(connection, l, null) : new DbMailFolder[]{};
    }

    @Override
    public abstract DbMailFolder[] getSpecialFolders(Connection var1, long var2, DbMailFolder.SpecialType[] var4) throws SQLException;

    @Override
    public final Map<Long, Integer> getUnseenMessagesCount(Connection connection) throws SQLException {
        return this.getUnseenMessagesCount(connection, null);
    }

    @Override
    public abstract Map<Long, Integer> getUnseenMessagesCount(Connection var1, long[] var2) throws SQLException;

    @Override
    public final int getUnseenMessagesCount(Connection connection, long l) throws SQLException {
        Map<Long, Integer> map = this.getUnseenMessagesCount(connection, new long[]{l});
        return map != null && map.containsKey(l) ? map.get(l) : 0;
    }

    @Override
    public final void loadAddresses(Connection connection, DbMailMessage dbMailMessage) throws SQLException {
        this.loadAddresses(connection, new DbMailMessage[]{dbMailMessage});
    }

    @Override
    public abstract void loadAddresses(Connection var1, DbMailMessage[] var2) throws SQLException;

    @Override
    public void loadFolderChildren(Connection connection, DbMailFolder dbMailFolder, boolean bl) throws SQLException {
        if (dbMailFolder.subFolders == null) {
            dbMailFolder.subFolders = new ArrayList<DbMailFolder>();
        } else {
            dbMailFolder.subFolders.clear();
        }
        if (dbMailFolder.holdsFolders) {
            DbMailFolder[] dbMailFolderArray;
            for (DbMailFolder dbMailFolder2 : dbMailFolderArray = this.getFolderChildren(connection, dbMailFolder.id)) {
                dbMailFolder2.parentFolder = dbMailFolder;
                dbMailFolder.subFolders.add(dbMailFolder2);
                if (!bl) continue;
                this.loadFolderChildren(connection, dbMailFolder2, true);
            }
        }
    }

    @Override
    public void loadFolderParents(Connection connection, DbMailFolder dbMailFolder, boolean bl) throws SQLException {
        DbMailFolder dbMailFolder2;
        DbMailFolder dbMailFolder3 = dbMailFolder2 = dbMailFolder.parentFolderId > 0L ? this.getFolder(connection, dbMailFolder.parentFolderId) : null;
        if (dbMailFolder2 != null) {
            dbMailFolder.parentFolder = dbMailFolder2;
            if (bl) {
                this.loadFolderParents(connection, dbMailFolder.parentFolder, true);
            }
        }
    }

    @Override
    public void loadPartChildren(Connection connection, DbMailPart dbMailPart, boolean bl) throws SQLException {
        DbMailPart[] dbMailPartArray;
        if (dbMailPart.subParts == null) {
            dbMailPart.subParts = new ArrayList<DbMailPart>();
        } else {
            dbMailPart.subParts.clear();
        }
        for (DbMailPart dbMailPart2 : dbMailPartArray = this.getPartChildren(connection, dbMailPart.id)) {
            dbMailPart2.parentPart = dbMailPart;
            dbMailPart.subParts.add(dbMailPart2);
            if (!bl) continue;
            this.loadPartChildren(connection, dbMailPart2, true);
        }
    }

    @Override
    public final void loadPartHeaders(Connection connection, DbMailPart dbMailPart) throws SQLException {
        this.loadPartHeaders(connection, new DbMailPart[]{dbMailPart});
    }

    @Override
    public final void loadPartHeaders(Connection connection, DbMailPart dbMailPart, boolean bl) throws SQLException {
        if (!bl) {
            this.loadPartHeaders(connection, new DbMailPart[]{dbMailPart});
        } else {
            ArrayList<DbMailPart> arrayList = new ArrayList<DbMailPart>();
            arrayList.add(dbMailPart);
            arrayList.addAll(Arrays.asList(dbMailPart.getAllSubParts()));
            this.loadPartHeaders(connection, arrayList.toArray(new DbMailPart[0]));
        }
    }

    @Override
    public abstract void loadPartHeaders(Connection var1, DbMailPart[] var2) throws SQLException;

    @Override
    public final void removeFolder(Connection connection, long l) throws SQLException {
        this.removeFolders(connection, new long[]{l});
    }

    @Override
    public abstract void removeFolders(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removeMessage(Connection connection, long l) throws SQLException {
        this.removeMessages(connection, new long[]{l});
    }

    @Override
    public abstract void removeMessages(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removePart(Connection connection, long l) throws SQLException {
        this.removeParts(connection, new long[]{l});
    }

    @Override
    public abstract void removeParts(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract void saveFolder(Connection var1, DbMailFolder var2) throws SQLException;

    @Override
    public abstract void saveMessage(Connection var1, DbMailMessage var2) throws SQLException;

    @Override
    public abstract void savePart(Connection var1, DbMailPart var2, boolean var3) throws SQLException, IOException;

    @Override
    public final void setMessageAnswered(Connection connection, long l, boolean bl) throws SQLException {
        if (l > 0L) {
            this.setMessagesAnswered(connection, new long[]{l}, bl);
        }
    }

    @Override
    public final void setMessageArchived(Connection connection, long l, boolean bl) throws SQLException {
        if (l > 0L) {
            this.setMessagesArchived(connection, new long[]{l}, bl);
        }
    }

    @Override
    public final void setMessageForwarded(Connection connection, long l, boolean bl) throws SQLException {
        if (l > 0L) {
            this.setMessagesForwarded(connection, new long[]{l}, bl);
        }
    }

    @Override
    public final void setMessageMdn(Connection connection, long l, DbMailMessage.MdnStatus mdnStatus) throws SQLException {
        if (l > 0L) {
            this.setMessagesMdn(connection, new long[]{l}, mdnStatus);
        }
    }

    @Override
    public final void setMessageSeen(Connection connection, long l, boolean bl) throws SQLException {
        if (l > 0L) {
            this.setMessagesSeen(connection, new long[]{l}, bl);
        }
    }

    @Override
    public abstract void setMessagesAnswered(Connection var1, long[] var2, boolean var3) throws SQLException;

    @Override
    public abstract void setMessagesArchived(Connection var1, long[] var2, boolean var3) throws SQLException;

    @Override
    public abstract void setMessagesForwarded(Connection var1, long[] var2, boolean var3) throws SQLException;

    @Override
    public abstract void setMessagesMdn(Connection var1, long[] var2, DbMailMessage.MdnStatus var3) throws SQLException;

    @Override
    public abstract void setMessagesSeen(Connection var1, long[] var2, boolean var3) throws SQLException;
}

