/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailExportTask
extends ImmoToolTask<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailExportTask.class);
    private static final I18n I18N = I18nFactory.getI18n(MailExportTask.class);
    protected Connection dbConnection;
    protected AbstractDbDriver dbDriver;
    protected DbMailMessageHandler messageHandler;
    protected long messageId;
    protected File destinationFile;

    public MailExportTask(AbstractDbDriver abstractDbDriver, DbMailMessageHandler dbMailMessageHandler, long l, File file) {
        super("Export mails");
        this.dbConnection = null;
        this.dbDriver = abstractDbDriver;
        this.messageHandler = dbMailMessageHandler;
        this.destinationFile = file;
        this.messageId = l;
    }

    public MailExportTask(Connection connection, DbMailMessageHandler dbMailMessageHandler, long l, File file) {
        super("Export mails");
        this.dbDriver = null;
        this.dbConnection = connection;
        this.messageHandler = dbMailMessageHandler;
        this.destinationFile = file;
        this.messageId = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground() throws Exception {
        Connection connection = this.dbConnection;
        Map<Long, File> map = null;
        try {
            DbMailMessage dbMailMessage;
            if (connection == null) {
                connection = this.dbDriver.getConnection();
            }
            if ((dbMailMessage = this.messageHandler.getMessage(connection, this.messageId)) == null) {
                throw new Exception("Can't find mail message #" + this.messageId + "!");
            }
            DbMailPart dbMailPart = this.messageHandler.getPartOnRoot(connection, this.messageId);
            if (dbMailPart == null) {
                throw new Exception("Can't find part of mail message #" + this.messageId + "!");
            }
            this.messageHandler.loadAddresses(connection, dbMailMessage);
            this.messageHandler.loadPartChildren(connection, dbMailPart, true);
            this.messageHandler.loadPartHeaders(connection, dbMailPart, true);
            map = MailPluginUtils.downloadAttachments(connection, this.messageHandler, dbMailPart, true);
            MimeMessage mimeMessage = MailPluginUtils.createMimeMessage(dbMailMessage, dbMailPart, null, true, map);
            if (mimeMessage == null) {
                throw new Exception("Can't build MimeMessage!");
            }
            Object object = new FileOutputStream(this.destinationFile);
            Object object2 = null;
            try {
                mimeMessage.writeTo((OutputStream)object);
                ((OutputStream)object).flush();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object).close();
                    }
                }
            }
            object = true;
            return object;
        }
        finally {
            if (this.dbConnection == null) {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            if (map != null) {
                for (File file : map.values()) {
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }
    }
}

