/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultTree;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailTemplateDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailTemplateDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(MailTemplateDialog.class);
    private String dialogTitle = null;
    private String dialogInfo = null;
    private boolean submitted = false;
    private DefaultTree templateTree;
    private CancelAction cancelAction;
    private SubmitAction submitAction;

    private MailTemplateDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private MailTemplateDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void addAccount(Connection connection, DbMailMessageHandler dbMailMessageHandler, DbMailAccount dbMailAccount, DbMailFolder dbMailFolder) throws SQLException {
        Node node = (Node)this.templateTree.getModel().getRoot();
        Node node2 = new Node(dbMailAccount);
        TreeSet<DbMailFolder> treeSet = new TreeSet<DbMailFolder>();
        treeSet.addAll(dbMailFolder.subFolders);
        for (DbMailFolder dbMailFolder2 : treeSet) {
            if (!DbMailFolder.SpecialType.TEMPLATES.equals((Object)dbMailFolder2.specialType)) continue;
            Node node3 = new Node(dbMailAccount, dbMailFolder2);
            node3.load(connection, dbMailMessageHandler);
            node2.add(node3);
        }
        if (node2.getChildCount() > 0) {
            node.add(node2);
        }
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.cancelAction = new CancelAction();
        this.submitAction = new SubmitAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.cancelAction});
    }

    protected JComponent buildMainComponent() {
        this.templateTree = new DefaultTree();
        this.templateTree.setCellRenderer((TreeCellRenderer)((Object)new NodeRenderer()));
        this.templateTree.setModel((TreeModel)new DefaultTreeModel(new Node(null, null)));
        this.templateTree.setRootVisible(false);
        this.templateTree.setToggleClickCount(1);
        this.templateTree.getSelectionModel().setSelectionMode(1);
        this.templateTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!MailTemplateDialog.this.templateTree.isEnabled()) {
                    return;
                }
                TreePath treePath = MailTemplateDialog.this.templateTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Node node = (Node)treePath.getLastPathComponent();
                MailTemplateDialog.this.submitAction.setEnabled(node.getMessage() != null);
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.templateTree);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        return jScrollPane;
    }

    private void doSubmit() {
        this.submitted = true;
        this.setVisible(false);
    }

    private void expandDefault() {
        Node node = (Node)this.templateTree.getModel().getRoot();
        this.templateTree.collapseAll();
        this.templateTree.expandPath(new TreePath(node));
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            this.templateTree.expandPath(new TreePath(new Object[]{node, node2}));
        }
    }

    protected String getDialogTitle() {
        if (!StringUtils.isBlank((CharSequence)this.dialogTitle)) {
            return this.dialogTitle.trim();
        }
        return StringUtils.capitalize((String)I18N.tr("select mail template"));
    }

    protected Icon getHeaderIcon() {
        return MailPlugin.getResourceIcon("folder_templates.png", 32);
    }

    protected String getHeaderInfo() {
        if (!StringUtils.isBlank((CharSequence)this.dialogInfo)) {
            return this.dialogInfo.trim();
        }
        return I18N.tr("Please select an e-mail template.");
    }

    protected String getHeaderTitle() {
        if (!StringUtils.isBlank((CharSequence)this.dialogTitle)) {
            return this.dialogTitle.trim();
        }
        return StringUtils.capitalize((String)I18N.tr("select mail template"));
    }

    private DbMailMessage getSelectedMessage() {
        TreePath treePath = this.templateTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Node node = (Node)treePath.getLastPathComponent();
        return node != null ? node.getMessage() : null;
    }

    private List<Object> getSelectionPath(Node node, long l) {
        DbMailMessage dbMailMessage;
        DbMailMessage dbMailMessage2 = dbMailMessage = node != null ? node.getMessage() : null;
        if (dbMailMessage != null && dbMailMessage.id == l) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(node);
            return arrayList;
        }
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                List<Object> list = this.getSelectionPath((Node)node.getChildAt(i), l);
                if (list == null || list.isEmpty()) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(node);
                arrayList.addAll(list);
                return arrayList;
            }
        }
        return null;
    }

    private void init(Connection connection, DbMailMessageHandler dbMailMessageHandler, MailHandler mailHandler) throws SQLException {
        Node node = new Node(null, null);
        this.templateTree.setModel((TreeModel)new DefaultTreeModel(node));
        for (DbMailAccount dbMailAccount : mailHandler.getRemoteAccounts()) {
            AbstractMailReader.Type type = dbMailAccount.getReaderType();
            if (!AbstractMailReader.Type.IMAP.equals((Object)type)) continue;
            this.addAccount(connection, dbMailMessageHandler, dbMailAccount, mailHandler.getRootFolder(dbMailAccount.id));
        }
        DbMailAccount dbMailAccount = mailHandler.getLocalPrivateAccount();
        this.addAccount(connection, dbMailMessageHandler, dbMailAccount, mailHandler.getRootFolder(dbMailAccount.id));
        for (DbMailAccount dbMailAccount2 : mailHandler.getLocalSharedAccounts()) {
            this.addAccount(connection, dbMailMessageHandler, dbMailAccount2, mailHandler.getRootFolder(dbMailAccount2.id));
        }
        this.templateTree.revalidate();
        this.templateTree.repaint();
        this.expandDefault();
    }

    private void setDialogInfo(String string) {
        this.dialogInfo = string;
    }

    private void setDialogTitle(String string) {
        this.dialogTitle = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedMessage(long l) {
        Node node = (Node)this.templateTree.getModel().getRoot();
        this.templateTree.setEnabled(false);
        try {
            this.templateTree.clearSelection();
            if (l < 1L) {
                this.expandDefault();
                return;
            }
            List<Object> list = this.getSelectionPath(node, l);
            if (list == null || list.isEmpty()) {
                this.expandDefault();
                return;
            }
            TreePath treePath = new TreePath(list.toArray(new Object[0]));
            this.templateTree.expandPath(treePath);
            this.templateTree.addSelectionPath(treePath);
        }
        finally {
            this.templateTree.setEnabled(true);
        }
    }

    public static DbMailMessage showDialog(ImmoToolProject immoToolProject, Window window) throws SQLException {
        return MailTemplateDialog.showDialog(0L, null, null, immoToolProject, window);
    }

    public static DbMailMessage showDialog(long l, ImmoToolProject immoToolProject, Window window) throws SQLException {
        return MailTemplateDialog.showDialog(l, null, null, immoToolProject, window);
    }

    public static DbMailMessage showDialog(String string, String string2, ImmoToolProject immoToolProject, Window window) throws SQLException {
        return MailTemplateDialog.showDialog(0L, string, string2, immoToolProject, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbMailMessage showDialog(long l, String string, String string2, ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbMailMessage dbMailMessage;
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
        MailTemplateDialog mailTemplateDialog = null;
        try {
            mailTemplateDialog = window instanceof Dialog ? new MailTemplateDialog((Dialog)window) : (window instanceof Frame ? new MailTemplateDialog((Frame)window) : new MailTemplateDialog((Frame)null));
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                mailTemplateDialog.init(connection, dbMailMessageHandler, mailHandler);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            mailTemplateDialog.setSelectedMessage(l);
            if (!StringUtils.isBlank((CharSequence)string) || !StringUtils.isBlank((CharSequence)string2)) {
                mailTemplateDialog.setDialogInfo(string2);
                mailTemplateDialog.setDialogTitle(string);
                mailTemplateDialog.updateLocalization();
                mailTemplateDialog.pack();
            }
            mailTemplateDialog.setVisible(true);
            dbMailMessage = mailTemplateDialog.submitted ? mailTemplateDialog.getSelectedMessage() : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(mailTemplateDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)mailTemplateDialog));
        return dbMailMessage;
    }

    private static class NodeRenderer
    extends DefaultXTreeCellRenderer {
        private NodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof Node) {
                Node node = (Node)object;
                jLabel.setText("<html>" + node.getNodeText() + "</html>");
                Icon icon = node.getNodeIcon();
                if (icon != null) {
                    jLabel.setIcon(icon);
                }
            }
            return jLabel;
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        private final DbMailAccount account;
        private final DbMailFolder folder;
        private final DbMailMessage message;

        private Node(DbMailAccount dbMailAccount) {
            this.account = dbMailAccount;
            this.folder = null;
            this.message = null;
        }

        private Node(DbMailAccount dbMailAccount, DbMailFolder dbMailFolder) {
            this.account = dbMailAccount;
            this.folder = dbMailFolder;
            this.message = null;
        }

        private Node(DbMailAccount dbMailAccount, DbMailFolder dbMailFolder, DbMailMessage dbMailMessage) {
            this.account = dbMailAccount;
            this.folder = dbMailFolder;
            this.message = dbMailMessage;
        }

        public DbMailAccount getAccount() {
            return this.account;
        }

        public DbMailFolder getFolder() {
            return this.folder;
        }

        public DbMailMessage getMessage() {
            return this.message;
        }

        public Icon getNodeIcon() {
            if (this.message != null) {
                return MailPlugin.getResourceIcon("mail_new.png", 16);
            }
            if (this.folder != null) {
                return this.folder.specialType != null ? this.folder.specialType.getSmallIcon() : MailPlugin.getResourceIcon("folder.png", 16);
            }
            if (this.account != null) {
                return this.account.type != null ? this.account.type.getSmallIcon() : null;
            }
            return null;
        }

        public String getNodeText() {
            if (this.message != null) {
                return !StringUtils.isBlank((CharSequence)this.message.subject) ? this.message.subject.trim() : "???";
            }
            if (this.folder != null) {
                return this.folder.specialType != null ? this.folder.specialType.getTranslation() : this.folder.name;
            }
            if (this.account != null) {
                return "<html><b>" + StringEscapeUtils.escapeXml11((String)this.account.writeName()) + "</b></html>";
            }
            return "???";
        }

        public void load(Connection connection, DbMailMessageHandler dbMailMessageHandler) throws SQLException {
            DbMailMessage[] dbMailMessageArray;
            if (this.folder == null || this.message != null) {
                return;
            }
            if (!this.folder.subFolders.isEmpty()) {
                dbMailMessageArray = new TreeSet();
                dbMailMessageArray.addAll(this.folder.subFolders);
                for (DbMailMessage dbMailMessage : dbMailMessageArray) {
                    Node node = new Node(this.account, (DbMailFolder)((Object)dbMailMessage));
                    node.load(connection, dbMailMessageHandler);
                    if (node.getChildCount() <= 0) continue;
                    this.add(node);
                }
            }
            dbMailMessageArray = dbMailMessageHandler.getMessagesFromFolder(connection, this.folder.id);
            TreeMap treeMap = new TreeMap();
            for (DbMailMessage dbMailMessage : dbMailMessageArray) {
                String string = dbMailMessage.subject.trim().toLowerCase();
                int n = 0;
                while (treeMap.containsKey(string)) {
                    string = dbMailMessage.subject.trim().toLowerCase() + "_" + ++n;
                }
                treeMap.put(string, dbMailMessage);
            }
            for (DbMailMessage dbMailMessage : treeMap.values()) {
                Node node = new Node(this.account, this.folder, dbMailMessage);
                this.add(node);
            }
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        public SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTemplateDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        public CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTemplateDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }
}

