/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import javax.mail.MessagingException;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.jsieve.mailet.mdn.Disposition;
import org.apache.jsieve.mailet.mdn.DispositionActionMode;
import org.apache.jsieve.mailet.mdn.DispositionSendingMode;
import org.apache.jsieve.mailet.mdn.DispositionType;
import org.apache.jsieve.mailet.mdn.MDNFactory;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MdnMail
extends Email {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdnMail.class);
    private static final I18n I18N = I18nFactory.getI18n(MdnMail.class);
    private boolean initialized = false;
    private String msgText = null;
    private DbMailMessage localMessage = null;
    private DispositionActionMode dispositionActionMode = null;
    private DispositionSendingMode dispositionSendingMode = null;
    private DispositionType dispositionType = null;

    public void buildMimeMessage() throws EmailException {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (MessagingException messagingException) {
                throw new EmailException("Can't create MDN multipart!", (Throwable)messagingException);
            }
        }
        super.buildMimeMessage();
    }

    protected void init() throws MessagingException {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        MimeMultipartReport mimeMultipartReport = MDNFactory.create(this.msgText, ImmoToolEnvironment.getApplicationTitle(), ImmoToolEnvironment.getApplicationTitle() + " " + ImmoToolEnvironment.getApplicationVersion(), null, this.localMessage.to, this.localMessage.mimeId, new Disposition(this.dispositionActionMode, this.dispositionSendingMode, this.dispositionType));
        this.setContent(mimeMultipartReport);
        this.initialized = true;
    }

    public void setDispositionActionMode(DispositionActionMode dispositionActionMode) {
        this.dispositionActionMode = dispositionActionMode;
    }

    public void setDispositionSendingMode(DispositionSendingMode dispositionSendingMode) {
        this.dispositionSendingMode = dispositionSendingMode;
    }

    public void setDispositionType(DispositionType dispositionType) {
        this.dispositionType = dispositionType;
    }

    public void setLocalMessage(DbMailMessage dbMailMessage) {
        this.localMessage = dbMailMessage;
    }

    public Email setMsg(String string) throws EmailException {
        this.msgText = string;
        return this;
    }
}

