-- -----------------------------------------------------
-- Mail-Addon for OpenEstate-ImmoTool
-- update 4 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Remove plugin relation 'OpenEstate-Agency-Mails'
-- Remove plugin relation 'OpenEstate-Mail-Calendar'
-- Remove plugin relation 'OpenEstate-Mail-Contacts'
-- Set special mail folders
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Remove plugin relation 'OpenEstate-Agency-Mails'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS remove_immotool_agency_objects_mails_messages CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_agency_objects_mails_messages CASCADE;
DROP VIEW IF EXISTS view_immotool_agency_objects_mails_messages CASCADE;
DROP TABLE IF EXISTS immotool_agency_objects_mails_messages CASCADE;
DELETE FROM immotool_plugins_relations WHERE relation_name = 'OpenEstate-Agency-Mails';

-- -----------------------------------------------------
-- Remove plugin relation 'OpenEstate-Mail-Calendar'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS remove_immotool_mails_messages_calendar_entries CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_mails_messages_calendar_entries CASCADE;
DROP VIEW IF EXISTS view_immotool_mails_messages_calendar_entries CASCADE;
DROP TABLE IF EXISTS immotool_mails_messages_calendar_entries CASCADE;
DELETE FROM immotool_plugins_relations WHERE relation_name = 'OpenEstate-Mail-Calendar';

-- -----------------------------------------------------
-- Remove plugin relation 'OpenEstate-Mail-Contacts'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS remove_immotool_mails_messages_contacts_entries CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_mails_messages_contacts_entries CASCADE;
DROP VIEW IF EXISTS view_immotool_mails_messages_contacts_entries CASCADE;
DROP TABLE IF EXISTS immotool_mails_messages_contacts_entries CASCADE;
DELETE FROM immotool_plugins_relations WHERE relation_name = 'OpenEstate-Mail-Contacts';

-- -----------------------------------------------------
-- Set special mail folders
-- -----------------------------------------------------
UPDATE immotool_mails_folders
  SET folder_special_type='INBOX'
  WHERE folder_special_type IS NULL
  AND folder_parent_id IN (SELECT folder_id FROM immotool_mails_folders WHERE folder_parent_id IS NULL)
  AND LCASE(folder_name) LIKE 'inbox';
UPDATE immotool_mails_folders
  SET folder_special_type='OUTBOX'
  WHERE folder_special_type IS NULL
  AND folder_parent_id IN (SELECT folder_id FROM immotool_mails_folders WHERE folder_parent_id IS NULL)
  AND (LCASE(folder_name) LIKE 'outbox' OR LCASE(folder_name) LIKE 'sent');
UPDATE immotool_mails_folders
  SET folder_special_type='DRAFTS'
  WHERE folder_special_type IS NULL
  AND folder_parent_id IN (SELECT folder_id FROM immotool_mails_folders WHERE folder_parent_id IS NULL)
  AND (LCASE(folder_name) LIKE 'drafts' OR LCASE(folder_name) LIKE 'draft');
UPDATE immotool_mails_folders
  SET folder_special_type='TEMPLATES'
  WHERE folder_special_type IS NULL
  AND folder_parent_id IN (SELECT folder_id FROM immotool_mails_folders WHERE folder_parent_id IS NULL)
  AND (LCASE(folder_name) LIKE 'templates' OR LCASE(folder_name) LIKE 'template');
UPDATE immotool_mails_folders
  SET folder_special_type='SPAM'
  WHERE folder_special_type IS NULL
  AND folder_parent_id IN (SELECT folder_id FROM immotool_mails_folders WHERE folder_parent_id IS NULL)
  AND LCASE(folder_name) LIKE 'spam';
UPDATE immotool_mails_folders
  SET folder_special_type='TRASH'
  WHERE folder_special_type IS NULL
  AND folder_parent_id IN (SELECT folder_id FROM immotool_mails_folders WHERE folder_parent_id IS NULL)
  AND (LCASE(folder_name) LIKE 'trash' OR LCASE(folder_name) LIKE 'junk');
