-- -----------------------------------------------------
-- Mail-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'message_is_received' to 'immotool_mails_messages'
-- Rebuild 'view_immotool_mails_messages'
-- Rebuild 'save_immotool_mails_messages'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add field 'message_is_received' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ADD COLUMN message_is_received BOOLEAN DEFAULT false NOT NULL
  BEFORE message_has_attachments;

-- -----------------------------------------------------
-- Rebuild 'view_immotool_mails_messages'
-- -----------------------------------------------------
ALTER VIEW view_immotool_mails_messages AS
  SELECT * FROM immotool_mails_messages
  WHERE folder_id IN (SELECT folder_id FROM view_immotool_mails_folders);

-- -----------------------------------------------------
-- Rebuild 'save_immotool_mails_messages'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_mails_messages;
\.
CREATE PROCEDURE save_immotool_mails_messages(
    INOUT val_message_id BIGINT,
    val_folder_id BIGINT,
    val_message_subject VARCHAR(255),
    val_message_from VARCHAR(255),
    val_message_to VARCHAR(255),
    val_message_size BIGINT,
    val_message_uid BIGINT,
    val_message_uid_validity BIGINT,
    val_message_mime_id VARCHAR(255),
    val_message_hash VARCHAR(255),
    val_message_in_reply_to VARCHAR(255),
    val_message_is_answered BOOLEAN,
    val_message_is_archived BOOLEAN,
    val_message_is_downloaded BOOLEAN,
    val_message_is_draft BOOLEAN,
    val_message_is_flagged BOOLEAN,
    val_message_is_forwarded BOOLEAN,
    val_message_is_seen BOOLEAN,
    val_message_is_received BOOLEAN,
    val_message_has_attachments BOOLEAN,
    val_message_mdn_status VARCHAR(25),
    val_message_sent_at TIMESTAMP WITH TIME ZONE,
    val_message_received_at TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_immotool_mails_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_folder_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id = val_folder_id;
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neue Mail erzeugen
    IF val_message_id < 1 THEN
      -- Mail speichern
      INSERT INTO immotool_mails_messages (
        folder_id,
        message_subject,
        message_from,
        message_to,
        message_size,
        message_uid,
        message_uid_validity,
        message_mime_id,
        message_hash,
        message_in_reply_to,
        message_is_answered,
        message_is_archived,
        message_is_downloaded,
        message_is_draft,
        message_is_flagged,
        message_is_forwarded,
        message_is_seen,
        message_is_received,
        message_has_attachments,
        message_mdn_status,
        message_sent_at,
        message_received_at )
      VALUES (
        val_folder_id,
        val_message_subject,
        val_message_from,
        val_message_to,
        val_message_size,
        val_message_uid,
        val_message_uid_validity,
        val_message_mime_id,
        val_message_hash,
        val_message_in_reply_to,
        val_message_is_answered,
        val_message_is_archived,
        val_message_is_downloaded,
        val_message_is_draft,
        val_message_is_flagged,
        val_message_is_forwarded,
        val_message_is_seen,
        val_message_is_received,
        val_message_has_attachments,
        val_message_mdn_status,
        val_message_sent_at,
        val_message_received_at );

      -- ID zurückliefern
      SET val_message_id = IDENTITY();

    -- Bestehende Mail bearbeiten
    ELSE
      -- Mail bearbeiten
      UPDATE immotool_mails_messages
        SET
          folder_id = val_folder_id,
          message_subject = val_message_subject,
          message_from = val_message_from,
          message_to = val_message_to,
          message_size = val_message_size,
          message_uid = val_message_uid,
          message_uid_validity = val_message_uid_validity,
          message_mime_id = val_message_mime_id,
          message_hash = val_message_hash,
          message_in_reply_to = val_message_in_reply_to,
          message_is_answered = val_message_is_answered,
          message_is_archived = val_message_is_archived,
          message_is_downloaded = val_message_is_downloaded,
          message_is_draft = val_message_is_draft,
          message_is_flagged = val_message_is_flagged,
          message_is_forwarded = val_message_is_forwarded,
          message_is_seen = val_message_is_seen,
          message_is_received = val_message_is_received,
          message_has_attachments = val_message_has_attachments,
          message_mdn_status = val_message_mdn_status,
          message_sent_at = val_message_sent_at,
          message_received_at = val_message_received_at,
          modified_at = NOW()
        WHERE
          message_id = val_message_id;

    END IF;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_immotool_mails_messages
  TO "IMMOTOOL";
