-- -----------------------------------------------------
-- Mail-Addon for OpenEstate-ImmoTool
-- update 8 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Call temporary procedure 'immotool_mail_update_permissions'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Call temporary procedure 'immotool_mail_update_permissions'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS immotool_mail_update_permissions;

\.
CREATE PROCEDURE immotool_mail_update_permissions()
  SPECIFIC immotool_mail_update_permissions
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE pluginId BIGINT;
    DECLARE permissionId BIGINT;
    DECLARE groupId BIGINT;

    -- ID des Plugins ermitteln
    SELECT plugin_id
      INTO pluginId
      FROM immotool_plugins
      WHERE plugin_name = 'OpenEstate-Tool-Mail';

    -- USE_PLUGIN-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'USE_PLUGIN' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ID der IMMOTOOL-Gruppe ermitteln
    SELECT group_id
      INTO groupId
      FROM immotool_groups
      WHERE group_name = 'IMMOTOOL';

    -- USE_PLUGIN-Berechtigung zur IMMOTOOL-Gruppe zuweisen
    INSERT INTO immotool_groups_permissions (
      group_id,
      permission_id )
    VALUES (
      groupId,
      permissionId );


    -- ACCOUNTS_EDIT-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ACCOUNTS_EDIT' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ACCOUNTS_EDIT-Berechtigung allen Benutzern mit USE_PLUGIN-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='USE_PLUGIN')
      );

    -- ACCOUNTS_EDIT-Berechtigung allen Gruppen mit USE_PLUGIN-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='USE_PLUGIN')
      );


    -- ACCOUNTS_REMOVE-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ACCOUNTS_REMOVE' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ACCOUNTS_REMOVE-Berechtigung allen Benutzern mit USE_PLUGIN-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='USE_PLUGIN')
      );

    -- ACCOUNTS_REMOVE-Berechtigung allen Gruppen mit USE_PLUGIN-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='USE_PLUGIN')
      );


    -- ACCOUNTS_EXPORT-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ACCOUNTS_EXPORT' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ACCOUNTS_EXPORT-Berechtigung allen Benutzern mit USE_PLUGIN-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='USE_PLUGIN')
      );

    -- ACCOUNTS_EXPORT-Berechtigung allen Gruppen mit USE_PLUGIN-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='USE_PLUGIN')
      );

  END;
.;

CALL immotool_mail_update_permissions();

DROP PROCEDURE
  IF EXISTS immotool_mail_update_permissions;
