-- -----------------------------------------------------
-- Mail-Addon for OpenEstate-ImmoTool
-- update 10 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'can_read_immotool_mails_accounts'
-- Add function 'can_delete_immotool_mails_folders'
-- Add function 'can_read_immotool_mails_folders'
-- Add function 'can_write_immotool_mails_folders'
-- Add function 'can_delete_immotool_mails_messages'
-- Add function 'can_read_immotool_mails_messages'
-- Add function 'can_write_immotool_mails_messages'
-- Add function 'can_delete_immotool_mails_parts'
-- Add function 'can_read_immotool_mails_parts'
-- Add function 'can_write_immotool_mails_parts'
-- Update procedure 'remove_immotool_mails_addresses'
-- Update procedure 'remove_immotool_mails_folders'
-- Update procedure 'remove_immotool_mails_headers'
-- Update procedure 'remove_immotool_mails_messages'
-- Update procedure 'remove_immotool_mails_parts'
-- Update procedure 'save_immotool_mails_accounts_settings'
-- Update procedure 'save_immotool_mails_addresses'
-- Update procedure 'save_immotool_mails_folders'
-- Update procedure 'save_immotool_mails_headers'
-- Update procedure 'save_immotool_mails_messages'
-- Update procedure 'save_immotool_mails_parts'
-- Update procedure 'set_immotool_mails_messages_answered'
-- Update procedure 'set_immotool_mails_messages_archived'
-- Update procedure 'set_immotool_mails_messages_forwarded'
-- Update procedure 'set_immotool_mails_messages_mdn'
-- Update procedure 'set_immotool_mails_messages_seen'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Function can_read_immotool_mails_accounts
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_mails_accounts( val_account_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_mails_accounts
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_mails_accounts
      WHERE account_id = val_account_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_mails_folders
-- -----------------------------------------------------
CREATE FUNCTION can_delete_immotool_mails_folders( val_folder_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_mails_folders
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Konto ermitteln
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id = val_folder_id;

    -- Zum Löschen eines Mail-Ordners müssen Schreibrechte auf dem Mail-Konto vorliegen
    RETURN can_write_immotool_mails_accounts( val_account_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_mails_folders
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_mails_folders( val_folder_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_mails_folders
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Konto ermitteln
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id = val_folder_id;

    -- Zum Lesen eines Mail-Ordners müssen Leserechte auf dem Mail-Konto vorliegen
    RETURN can_read_immotool_mails_accounts( val_account_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_mails_folders
-- -----------------------------------------------------
CREATE FUNCTION can_write_immotool_mails_folders( val_folder_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_mails_folders
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Konto ermitteln
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id = val_folder_id;

    -- Zum Schreiben eines Mail-Ordners müssen Schreibrechte auf dem Mail-Konto vorliegen
    RETURN can_write_immotool_mails_accounts( val_account_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_mails_messages
-- -----------------------------------------------------
CREATE FUNCTION can_delete_immotool_mails_messages( val_message_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_mails_messages
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_folder_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Ordner ermitteln
    SELECT folder_id
      INTO val_folder_id
      FROM immotool_mails_messages
      WHERE message_id = val_message_id;

    -- Zum Löschen einer Mail-Mitteilung müssen Schreibrechte auf dem Mail-Ordner vorliegen
    RETURN can_write_immotool_mails_folders( val_folder_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_mails_messages
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_mails_messages( val_message_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_mails_messages
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_folder_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Ordner ermitteln
    SELECT folder_id
      INTO val_folder_id
      FROM immotool_mails_messages
      WHERE message_id = val_message_id;

    -- Zum Lesen einer Mail-Mitteilung müssen Leserechte auf dem Mail-Ordner vorliegen
    RETURN can_read_immotool_mails_folders( val_folder_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_mails_messages
-- -----------------------------------------------------
CREATE FUNCTION can_write_immotool_mails_messages( val_message_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_mails_messages
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_folder_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Ordner ermitteln
    SELECT folder_id
      INTO val_folder_id
      FROM immotool_mails_messages
      WHERE message_id = val_message_id;

    -- Zum Löschen einer Mail-Mitteilung müssen Schreibrechte auf dem Mail-Ordner vorliegen
    RETURN can_write_immotool_mails_folders( val_folder_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_mails_parts
-- -----------------------------------------------------
CREATE FUNCTION can_delete_immotool_mails_parts( val_part_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_mails_parts
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_message_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Mitteilung ermitteln
    SELECT message_id
      INTO val_message_id
      FROM immotool_mails_parts
      WHERE part_id = val_part_id;

    -- Zum Löschen eines Mail-Parts müssen Schreibrechte auf der Mail-Mitteilung vorliegen
    RETURN can_write_immotool_mails_messages( val_message_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_mails_parts
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_mails_parts( val_part_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_mails_parts
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_message_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Mitteilung ermitteln
    SELECT message_id
      INTO val_message_id
      FROM immotool_mails_parts
      WHERE part_id = val_part_id;

    -- Zum Lesen eines Mail-Parts müssen Leserechte auf der Mail-Mitteilung vorliegen
    RETURN can_read_immotool_mails_messages( val_message_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_mails_parts
-- -----------------------------------------------------
CREATE FUNCTION can_write_immotool_mails_parts( val_part_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_mails_parts
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_message_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Mail-Mitteilung ermitteln
    SELECT message_id
      INTO val_message_id
      FROM immotool_mails_parts
      WHERE part_id = val_part_id;

    -- Zum Löschen eines Mail-Parts müssen Schreibrechte auf der Mail-Mitteilung vorliegen
    RETURN can_write_immotool_mails_messages( val_message_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_mails_addresses
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_mails_addresses
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Adressen entfernen
    DELETE
      FROM immotool_mails_addresses
      WHERE message_id = val_message_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_mails_folders
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_mails_folders
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_folder_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_delete_immotool_mails_folders( val_folder_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Ordner entfernen
    DELETE
      FROM immotool_mails_folders
      WHERE folder_id = val_folder_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_mails_headers
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_mails_headers
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_part_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_parts( val_part_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Header entfernen
    DELETE
      FROM immotool_mails_headers
      WHERE part_id = val_part_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_mails_messages
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_mails_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_delete_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail entfernen
    DELETE
      FROM immotool_mails_messages
      WHERE message_id = val_message_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_mails_parts
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_mails_parts
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_part_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_delete_immotool_mails_parts( val_part_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Part entfernen
    DELETE
      FROM immotool_mails_parts
      WHERE part_id = val_part_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure save_immotool_mails_accounts_settings
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE save_immotool_mails_accounts_settings
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_account_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_accounts( val_account_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Existierenden Eintrag entfernen, wenn vorhanden
    DELETE
      FROM immotool_mails_accounts_settings
      WHERE account_id = val_account_id
      AND setting_key = val_setting_key;

    -- Eintrag speichern, wenn ein Wert angegeben wurde
    IF (val_setting_value IS NOT NULL) THEN

      INSERT INTO immotool_mails_accounts_settings (
        account_id,
        setting_key,
        setting_value )
      VALUES (
        val_account_id,
        val_setting_key,
        val_setting_value );

  	END IF;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure save_immotool_mails_addresses
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE save_immotool_mails_addresses
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Adresse speichern
    INSERT INTO immotool_mails_addresses (
      message_id,
      address_type,
      address_value,
      address_person )
    VALUES (
      val_message_id,
      val_address_type,
      val_address_value,
      val_address_person );

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure save_immotool_mails_folders
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE save_immotool_mails_folders
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_account_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_accounts( val_account_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Ordner erzeugen
    IF val_folder_id < 1 THEN
      -- Ordner speichern
      INSERT INTO immotool_mails_folders (
        account_id,
        folder_parent_id,
        folder_name,
        folder_holds_messages,
        folder_holds_folders,
        folder_auto_retrieval,
        folder_special_type )
      VALUES (
        val_account_id,
        val_folder_parent_id,
        val_folder_name,
        val_folder_holds_messages,
        val_folder_holds_folders,
        val_folder_auto_retrieval,
        val_folder_special_type );

      -- ID zurückliefern
      SET val_folder_id = IDENTITY();

    -- Bestehenden Ordner bearbeiten
    ELSE
      -- Ordner bearbeiten
      UPDATE immotool_mails_folders
        SET
          account_id = val_account_id,
          folder_parent_id = val_folder_parent_id,
          folder_name = val_folder_name,
          folder_holds_messages = val_folder_holds_messages,
          folder_holds_folders = val_folder_holds_folders,
          folder_auto_retrieval = val_folder_auto_retrieval,
          folder_special_type = val_folder_special_type,
          modified_at = NOW()
        WHERE
          folder_id = val_folder_id;

    END IF;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure save_immotool_mails_headers
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE save_immotool_mails_headers
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_part_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_parts( val_part_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Header speichern
    INSERT INTO immotool_mails_headers (
      part_id,
      header_key,
      header_value )
    VALUES (
      val_part_id,
      val_header_key,
      val_header_value );

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure save_immotool_mails_messages
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE save_immotool_mails_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_folder_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_folders( val_folder_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neue Mail erzeugen
    IF val_message_id < 1 THEN
      -- Mail speichern
      INSERT INTO immotool_mails_messages (
        folder_id,
        message_subject,
        message_from,
        message_to,
        message_size,
        message_uid,
        message_uid_validity,
        message_mime_id,
        message_hash,
        message_in_reply_to,
        message_is_answered,
        message_is_archived,
        message_is_downloaded,
        message_is_draft,
        message_is_flagged,
        message_is_forwarded,
        message_is_seen,
        message_is_received,
        message_has_attachments,
        message_mdn_status,
        message_sent_at,
        message_received_at )
      VALUES (
        val_folder_id,
        val_message_subject,
        val_message_from,
        val_message_to,
        val_message_size,
        val_message_uid,
        val_message_uid_validity,
        val_message_mime_id,
        val_message_hash,
        val_message_in_reply_to,
        val_message_is_answered,
        val_message_is_archived,
        val_message_is_downloaded,
        val_message_is_draft,
        val_message_is_flagged,
        val_message_is_forwarded,
        val_message_is_seen,
        val_message_is_received,
        val_message_has_attachments,
        val_message_mdn_status,
        val_message_sent_at,
        val_message_received_at );

      -- ID zurückliefern
      SET val_message_id = IDENTITY();

    -- Bestehende Mail bearbeiten
    ELSE
      -- Mail bearbeiten
      UPDATE immotool_mails_messages
        SET
          folder_id = val_folder_id,
          message_subject = val_message_subject,
          message_from = val_message_from,
          message_to = val_message_to,
          message_size = val_message_size,
          message_uid = val_message_uid,
          message_uid_validity = val_message_uid_validity,
          message_mime_id = val_message_mime_id,
          message_hash = val_message_hash,
          message_in_reply_to = val_message_in_reply_to,
          message_is_answered = val_message_is_answered,
          message_is_archived = val_message_is_archived,
          message_is_downloaded = val_message_is_downloaded,
          message_is_draft = val_message_is_draft,
          message_is_flagged = val_message_is_flagged,
          message_is_forwarded = val_message_is_forwarded,
          message_is_seen = val_message_is_seen,
          message_is_received = val_message_is_received,
          message_has_attachments = val_message_has_attachments,
          message_mdn_status = val_message_mdn_status,
          message_sent_at = val_message_sent_at,
          message_received_at = val_message_received_at,
          modified_at = NOW()
        WHERE
          message_id = val_message_id;

    END IF;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure save_immotool_mails_parts
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE save_immotool_mails_parts
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Part erzeugen
    IF val_part_id < 1 THEN
      -- Part speichern
      INSERT INTO immotool_mails_parts (
        message_id,
        part_parent_id,
        part_type,
        part_description,
        part_disposition,
        part_text,
        part_file_name,
        part_file_size )
      VALUES (
        val_message_id,
        val_part_parent_id,
        val_part_type,
        val_part_description,
        val_part_disposition,
        val_part_text,
        val_part_file_name,
        val_part_file_size );

      -- ID zurückliefern
      SET val_part_id = IDENTITY();

    -- Bestehenden Part bearbeiten
    ELSE
      -- Part bearbeiten
      UPDATE immotool_mails_parts
        SET
          message_id = val_message_id,
          part_parent_id = val_part_parent_id,
          part_type = val_part_type,
          part_description = val_part_description,
          part_disposition = val_part_disposition,
          part_text = val_part_text,
          part_file_name = val_part_file_name,
          part_file_size = val_part_file_size,
          modified_at = NOW()
        WHERE
          part_id = val_part_id;

    END IF;

    -- Datei ggf. aktualisieren
    IF val_part_file_content IS NOT NULL THEN

      UPDATE immotool_mails_parts
        SET
          part_file_content = val_part_file_content,
          modified_at = NOW()
        WHERE
          part_id = val_part_id;

    END IF;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure set_immotool_mails_messages_answered
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE set_immotool_mails_messages_answered
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_answered = val_message_is_answered,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure set_immotool_mails_messages_archived
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE set_immotool_mails_messages_archived
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_archived = val_message_is_archived,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure set_immotool_mails_messages_forwarded
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE set_immotool_mails_messages_forwarded
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_forwarded = val_message_is_forwarded,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure set_immotool_mails_messages_mdn
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE set_immotool_mails_messages_mdn
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_mdn_status = val_message_mdn_status,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
\.
-- -----------------------------------------------------
-- Procedure set_immotool_mails_messages_seen
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE set_immotool_mails_messages_seen
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_write_immotool_mails_messages( val_message_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_seen = val_message_is_seen,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
